/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.lexicon;

import java.util.Stack;
import net.sourceforge.chaperon.model.lexicon.Lexeme;
import net.sourceforge.chaperon.model.lexicon.Lexicon;
import net.sourceforge.chaperon.model.pattern.Alternation;
import net.sourceforge.chaperon.model.pattern.BeginOfLine;
import net.sourceforge.chaperon.model.pattern.CharacterClass;
import net.sourceforge.chaperon.model.pattern.CharacterClassElement;
import net.sourceforge.chaperon.model.pattern.CharacterInterval;
import net.sourceforge.chaperon.model.pattern.CharacterSet;
import net.sourceforge.chaperon.model.pattern.CharacterString;
import net.sourceforge.chaperon.model.pattern.Concatenation;
import net.sourceforge.chaperon.model.pattern.EndOfLine;
import net.sourceforge.chaperon.model.pattern.Pattern;
import net.sourceforge.chaperon.model.pattern.PatternGroup;
import net.sourceforge.chaperon.model.pattern.UniversalCharacter;
import net.sourceforge.chaperon.model.symbol.Terminal;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LexiconFactory
extends DefaultHandler {
    public static final String NS = "http://chaperon.sourceforge.net/schema/lexicon/1.0";
    public static final String LEXEME_ELEMENT = "lexeme";
    public static final String SYMBOL_ATTRIBUTE = "symbol";
    public static final String LEXICON_ELEMENT = "lexicon";
    public static final String ALTERNATION_ELEMENT = "alt";
    public static final String BEGINOFLINE_ELEMENT = "bol";
    public static final String CHARACTERCLASS_ELEMENT = "cclass";
    public static final String EXCLUSIVE_ATTRIBUTE = "exclusive";
    public static final String CHARACTERINTERVAL_ELEMENT = "cinterval";
    public static final String CHARACTERINTERVAL_MIN_ATTRIBUTE = "min";
    public static final String CHARACTERINTERVAL_MAX_ATTRIBUTE = "max";
    public static final String CHARACTERSTRING_ELEMENT = "cstring";
    public static final String CHARACTERSTRING_SEQUENCE_ATTRIBUTE = "content";
    public static final String CHARACTERSET_ELEMENT = "cset";
    public static final String CHARACTERSET_CHARACTERS_ATTRIBUTE = "content";
    public static final String CODE_ATTRIBUTE = "code";
    public static final String CONCATENATION_ELEMENT = "concat";
    public static final String GROUP_ELEMENT = "group";
    public static final String UNIVERSALCHARACTER_ELEMENT = "cuniversal";
    public static final String ENDOFLINE_ELEMENT = "eol";
    public static final String MINOCCURS_ATTRIBUTE = "minOccurs";
    public static final String MAXOCCURS_ATTRIBUTE = "maxOccurs";
    private static final int STATE_OUTER = 0;
    private static final int STATE_LEXICON = 1;
    private static final int STATE_LEXEME = 2;
    private static final int STATE_CHARACTERCLASS = 3;
    private static final int STATE_CHARACTERCLASSELEMENT = 4;
    private int state = 0;
    private Lexicon lexicon;
    private Locator locator = null;
    private Stack stack;

    public Lexicon getLexicon() {
        return this.lexicon;
    }

    private String getLocation() {
        if (this.locator == null) {
            return "unknown";
        }
        return this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() {
        this.stack = new Stack();
    }

    private int getMinOccursFromAttributes(Attributes atts) {
        int minOccurs = 1;
        String attribute = atts.getValue(MINOCCURS_ATTRIBUTE);
        if (attribute != null && attribute.length() > 0) {
            try {
                minOccurs = Integer.parseInt(attribute);
            }
            catch (NumberFormatException e) {
                minOccurs = 1;
            }
            if (minOccurs < 0) {
                minOccurs = 0;
            }
        }
        return minOccurs;
    }

    private int getMaxOccursFromAttributes(Attributes atts) {
        int maxOccurs = 1;
        String attribute = atts.getValue(MAXOCCURS_ATTRIBUTE);
        if (attribute != null && attribute.length() > 0) {
            if (attribute.equals("*")) {
                maxOccurs = Integer.MAX_VALUE;
            } else {
                try {
                    maxOccurs = Integer.parseInt(attribute);
                }
                catch (NumberFormatException e) {
                    maxOccurs = 1;
                }
                if (maxOccurs < 1) {
                    maxOccurs = 1;
                }
            }
        }
        return maxOccurs;
    }

    private boolean getExclusiveFromAttributes(Attributes atts) {
        String attribute = atts.getValue(EXCLUSIVE_ATTRIBUTE);
        if (attribute != null && attribute.length() > 0) {
            boolean value = false;
            try {
                value = Boolean.valueOf(attribute);
                return value;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!namespaceURI.equals(NS)) throw new SAXException("Unexpected element " + qName + " with namespace " + namespaceURI + " at " + this.getLocation());
        if (localName.equals(LEXICON_ELEMENT) && this.state == 0) {
            Lexicon lexicon = new Lexicon();
            lexicon.setLocation(this.getLocation());
            this.stack.push(lexicon);
            this.state = 1;
            return;
        } else if (localName.equals(LEXEME_ELEMENT) && this.state == 1) {
            Lexeme lexeme = new Lexeme();
            lexeme.setLocation(this.getLocation());
            if (atts.getValue(SYMBOL_ATTRIBUTE) != null) {
                lexeme.setSymbol(new Terminal(atts.getValue(SYMBOL_ATTRIBUTE)));
            }
            this.stack.push(lexeme);
            this.state = 2;
            return;
        } else if (localName.equals(ALTERNATION_ELEMENT) && this.state == 2) {
            Alternation alternation = new Alternation();
            alternation.setLocation(this.getLocation());
            alternation.setMinOccurs(this.getMinOccursFromAttributes(atts));
            alternation.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
            this.stack.push(alternation);
            return;
        } else if (localName.equals(CONCATENATION_ELEMENT) && this.state == 2) {
            Concatenation concatenation = new Concatenation();
            concatenation.setLocation(this.getLocation());
            concatenation.setMinOccurs(this.getMinOccursFromAttributes(atts));
            concatenation.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
            this.stack.push(concatenation);
            return;
        } else if (localName.equals(CHARACTERSTRING_ELEMENT) && this.state == 2) {
            CharacterString characterstring = new CharacterString();
            characterstring.setLocation(this.getLocation());
            characterstring.setMinOccurs(this.getMinOccursFromAttributes(atts));
            characterstring.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
            if (atts.getValue(CODE_ATTRIBUTE) != null) {
                char character = (char)Integer.parseInt(atts.getValue(CODE_ATTRIBUTE));
                characterstring.setString(String.valueOf(character));
            } else {
                characterstring.setString(atts.getValue("content"));
            }
            this.stack.push(characterstring);
            return;
        } else if (localName.equals(GROUP_ELEMENT) && this.state == 2) {
            PatternGroup group = new PatternGroup();
            group.setLocation(this.getLocation());
            group.setMinOccurs(this.getMinOccursFromAttributes(atts));
            group.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
            this.stack.push(group);
            return;
        } else if (localName.equals(UNIVERSALCHARACTER_ELEMENT) && this.state == 2) {
            UniversalCharacter uni = new UniversalCharacter();
            uni.setLocation(this.getLocation());
            uni.setMinOccurs(this.getMinOccursFromAttributes(atts));
            uni.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
            this.stack.push(uni);
            return;
        } else if (localName.equals(BEGINOFLINE_ELEMENT) && this.state == 2) {
            BeginOfLine bol = new BeginOfLine();
            bol.setLocation(this.getLocation());
            this.stack.push(bol);
            return;
        } else if (localName.equals(ENDOFLINE_ELEMENT) && this.state == 2) {
            EndOfLine eol = new EndOfLine();
            this.stack.push(eol);
            return;
        } else if (localName.equals(CHARACTERCLASS_ELEMENT) && this.state == 2) {
            CharacterClass characterclass = new CharacterClass();
            characterclass.setLocation(this.getLocation());
            characterclass.setExclusive(this.getExclusiveFromAttributes(atts));
            characterclass.setMinOccurs(this.getMinOccursFromAttributes(atts));
            characterclass.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
            this.stack.push(characterclass);
            this.state = 3;
            return;
        } else if (localName.equals(CHARACTERSET_ELEMENT) && this.state == 3) {
            CharacterSet characterset = new CharacterSet();
            characterset.setLocation(this.getLocation());
            if (atts.getValue(CODE_ATTRIBUTE) != null) {
                char character = (char)Integer.decode(atts.getValue(CODE_ATTRIBUTE)).intValue();
                characterset.setCharacters(String.valueOf(character));
            } else {
                characterset.setCharacters(atts.getValue("content"));
            }
            this.stack.push(characterset);
            this.state = 4;
            return;
        } else {
            if (!localName.equals(CHARACTERINTERVAL_ELEMENT) || this.state != 3) throw new SAXException("Unexpected element " + qName + " with namespace " + namespaceURI + " at " + this.getLocation());
            CharacterInterval characterinterval = new CharacterInterval();
            characterinterval.setLocation(this.getLocation());
            characterinterval.setMinimum(atts.getValue(CHARACTERINTERVAL_MIN_ATTRIBUTE).charAt(0));
            characterinterval.setMaximum(atts.getValue(CHARACTERINTERVAL_MAX_ATTRIBUTE).charAt(0));
            this.stack.push(characterinterval);
            this.state = 4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!namespaceURI.equals(NS)) throw new SAXException("Unexpected element " + qName + " with namespace " + namespaceURI + " at " + this.getLocation());
        if (localName.equals(LEXICON_ELEMENT) && this.state == 1) {
            this.lexicon = (Lexicon)this.stack.pop();
            this.state = 0;
            return;
        } else if (localName.equals(LEXEME_ELEMENT) && this.state == 2) {
            Lexeme lexeme = (Lexeme)this.stack.pop();
            Lexicon lexicon = (Lexicon)this.stack.peek();
            lexicon.addLexeme(lexeme);
            this.state = 1;
            return;
        } else if ((localName.equals(ALTERNATION_ELEMENT) || localName.equals(CONCATENATION_ELEMENT) || localName.equals(CHARACTERSTRING_ELEMENT) || localName.equals(GROUP_ELEMENT) || localName.equals(UNIVERSALCHARACTER_ELEMENT) || localName.equals(BEGINOFLINE_ELEMENT) || localName.equals(ENDOFLINE_ELEMENT)) && this.state == 2) {
            Pattern patternelement = (Pattern)this.stack.pop();
            if (this.stack.peek() instanceof Alternation) {
                Alternation alternation = (Alternation)this.stack.peek();
                alternation.addPattern(patternelement);
                return;
            } else if (this.stack.peek() instanceof Concatenation) {
                Concatenation concatenation = (Concatenation)this.stack.peek();
                concatenation.addPattern(patternelement);
                return;
            } else if (this.stack.peek() instanceof PatternGroup) {
                PatternGroup group = (PatternGroup)this.stack.peek();
                group.addPattern(patternelement);
                return;
            } else {
                if (!(this.stack.peek() instanceof Lexeme)) return;
                Lexeme lexeme = (Lexeme)this.stack.peek();
                lexeme.setDefinition(patternelement);
            }
            return;
        } else if (localName.equals(CHARACTERCLASS_ELEMENT) && this.state == 3) {
            Pattern patternelement = (Pattern)this.stack.pop();
            if (this.stack.peek() instanceof Alternation) {
                Alternation alternation = (Alternation)this.stack.peek();
                alternation.addPattern(patternelement);
            } else if (this.stack.peek() instanceof Concatenation) {
                Concatenation concatenation = (Concatenation)this.stack.peek();
                concatenation.addPattern(patternelement);
            } else if (this.stack.peek() instanceof PatternGroup) {
                PatternGroup group = (PatternGroup)this.stack.peek();
                group.addPattern(patternelement);
            } else if (this.stack.peek() instanceof Lexeme) {
                Lexeme lexeme = (Lexeme)this.stack.peek();
                lexeme.setDefinition(patternelement);
            }
            this.state = 2;
            return;
        } else {
            if (!localName.equals(CHARACTERSET_ELEMENT) && !localName.equals(CHARACTERINTERVAL_ELEMENT) || this.state != 4) throw new SAXException("Unexpected element " + qName + " with namespace " + namespaceURI + " at " + this.getLocation());
            CharacterClassElement characterclasselement = (CharacterClassElement)this.stack.pop();
            CharacterClass characterclass = (CharacterClass)this.stack.peek();
            characterclass.addCharacterClassElement(characterclasselement);
            this.state = 3;
        }
    }
}

