/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.MessagesDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.StringMessage;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Messages
extends AbstractWidget {
    private ArrayList messages = new ArrayList();
    private final MessagesDefinition definition;
    private static final String MESSAGES_EL = "messages";
    private static final String MESSAGE_EL = "message";

    protected Messages(MessagesDefinition definition) {
        this.definition = definition;
    }

    protected WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void readFromRequest(FormContext formContext) {
        this.messages.clear();
    }

    public boolean validate() {
        return this.messages.size() == 0;
    }

    public void addMessage(String message) {
        this.messages.add(new StringMessage(message));
    }

    public void addMessage(XMLizable message) {
        this.messages.add(message);
    }

    public String getXMLElementName() {
        return MESSAGES_EL;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        Iterator messagesIt = this.messages.iterator();
        while (messagesIt.hasNext()) {
            XMLizable message = (XMLizable)messagesIt.next();
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", MESSAGE_EL, "fi:message", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            message.toSAX(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", MESSAGE_EL, "fi:message");
        }
    }
}

