/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.pipeline;

import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TagFilter extends AbstractNodeBasedTransformation {
    /**Variable indicating wheter elements specified as in the transParameters object should be sent*/
    public static final String PARAM_NAME_SEND_MODE = "transform:send-mode";
    protected boolean _send = false;//defaulted
    //the below instance variables need to be reset at each pass
    protected String _lastPrefixRemoved = null;

    protected void setSendMode(Parameters params) {
        if (params != null)
            this._send = params.getParameterAsBoolean(PARAM_NAME_SEND_MODE, this._send);
    }


    public void startElement(String uri, String loc, String raw, Attributes a)
            throws SAXException {
        setCurrentElementProperties(uri, loc, raw, a);
        if (shouldSendElementEvent(uri, loc, raw, a))
            super.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String raw)
            throws SAXException {
        if (shouldSendElementEvent(uri, loc, raw, super.peekCurrentAttributes()))
            super.endElement(uri, loc, raw);
        resetCurrentElementProperties(uri, loc, raw);
    }

    protected boolean shouldSendElementEvent(String uri, String loc, String raw, Attributes atts) {
        boolean send = !this._send;
        if (nodeIsParameter(uri, loc, raw, atts))
            send = this._send;
        return send;
    }


    public void startPrefixMapping(String prefix, String uri)
            throws SAXException {
        if (shouldSendElementEvent(uri, null, prefix, null))
            super.startPrefixMapping(prefix, uri);
        else
            _lastPrefixRemoved = prefix;
    }

    public void endPrefixMapping(String prefix)
            throws SAXException {
        if (!prefix.equals(_lastPrefixRemoved))
            super.endPrefixMapping(prefix);
        else
            _lastPrefixRemoved = null;

    }

    protected void setInternalParameters(Parameters params) {
        super.setInternalParameters(params);
        setSendMode(params);
    }

    protected void resetFields() {
        super.resetFields();
        _lastPrefixRemoved = null;
    }

    public void recycle() {
        super.recycle();
        this.resetFields();
    }



    /*
      public void setDocumentLocator(Locator locator) {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.setDocumentLocator(locator);
      }



      public void startPrefixMapping(String prefix, String uri)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.startPrefixMapping(prefix, uri);
      }

         public void endPrefixMapping(String prefix)
              throws SAXException {
              if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
                super.endPrefixMapping(prefix);
      }

      public void endPrefixMapping(String prefix)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.endPrefixMapping(prefix);
      }

      public void characters(char c[], int start, int len)
              throws SAXException {
          //always sending characters as this is a tag stripper
          super.characters(c, start, len);
      }

      public void ignorableWhitespace(char c[], int start, int len)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.ignorableWhitespace(c, start, len);
      }

      public void processingInstruction(String target, String data)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.processingInstruction(target, data);
      }

      public void skippedEntity(String name)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.skippedEntity(name);
      }

      public void startDTD(String name, String publicId, String systemId)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.startDTD(name, publicId, systemId);
      }

      public void endDTD()
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
              super.endDTD();
      }

      public void startEntity(String name)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
          super.startEntity(name);
      }

      public void endEntity(String name)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))

          super.endEntity(name);
      }

      public void startCDATA()
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
          super.startCDATA();
      }

      public void endCDATA()
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))
          super.endCDATA();
      }

      public void comment(char ch[], int start, int len)
              throws SAXException {
          if (shouldSendElementEvent(c_uri, c_loc, c_raw, c_atts))

          super.comment(ch, start, len);
      }
      */


}
