/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.utils.SdxObject;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.xml.XMLPipe;

/**
 * An SDX transformation in an SDX pipeline.
 *
 * <p>
 * A transformation is a generic operation that receives and throws SAX
 * events. It can be a SAX filter, an XSLT transformation, or other complex
 * mechanism.
 * <p>
 * The only difference with a Cocoon XMLPipe is that it can be parameterized, which
 * can be useful for XSLT transformations.
 */
public interface Transformation extends XMLPipe, SdxObject {

    /**String representation of the "transformation" attribute name "src". */
    String ATTRIBUTE_SRC = "src";

    /**String representation of the "transformation" attribute name "keep". */
    String ATTRIBUTE_KEEP = "keep";

    /**String representation of the "transformation" attribute name "th". */
    String ATTRIBUTE_TH = "th";

    /**String representation of the transformation package name (including trailing separator "."). */
    String PACKAGE_QUALNAME = "fr.gouv.culture.sdx.pipeline.";
    /**String representation of the transformation class name suffix. */
    String CLASS_NAME_SUFFIX = "Transformation";


    /** Sets some parameters for this transformation. */
    public void setParameters(Parameters p);

    /** The parameters for this transformation. */
    public Parameters getParameters();

    /**Recycles the contentHandler, lexicalHandler, and xmlConsumer for the transformation*/
    public void recycle();

    /**Indicates wheter the results of this transfomation should be retained*/
    public boolean shouldKeepResult();

}
