<?xml version="1.0" encoding="UTF-8"?>
<!--
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="sdx">
    <xsl:import href="skin.xsl"/>
    <xsl:template match="sdx:results">
        <h2>Résultats de recherche (bases sdx:world et sdx:doc)</h2>
        <table width="100%" cellpadding="0" cellspacing="0" border="0">
            <tr>
                <td class="highlight">
                    <div>
                        <xsl:apply-templates select="." mode="sdx:head">
                            <xsl:with-param name="bqidParam" select="'bqid'"/>
                        </xsl:apply-templates>
                    </div>
                </td>
            </tr>
        </table>
        <br/>
        <xsl:apply-templates>
            <xsl:with-param name="action" select="'document.xsp'"/>
        </xsl:apply-templates>
        <br/>
        <div class="highlight">
            <xsl:apply-templates select="." mode="sdx:foot"/>
        </div>
    </xsl:template>
    <!--
    <xsl:template match="sdx:result">
        <div style="white-space:nowrap">
            <b>
                <xsl:value-of select="@no"/>
            </b>
            <xsl:text>&#160;</xsl:text>
            <a href="document.xsp?app={sdx:field[@name='sdxappid']}&amp;base={sdx:field[@name='sdxdbid']}&amp;id={sdx:field[@name='sdxdocid']}&amp;qid={../@id}&amp;n={@no}&amp;q={/sdx:document/sdx:parameters/sdx:parameter[@name='q']/@value}">
                <xsl:text>&#160;</xsl:text>
                <xsl:value-of select="sdx:field[@name='titre']"/>
            </a>
            <xsl:text>&#160;</xsl:text>
            <small>base=<b>
                    <xsl:value-of select="sdx:field[@name='sdxdbid']"/>
                </b>
            </small>
            <xsl:text>&#160;</xsl:text>
            <small>id=<xsl:value-of select="sdx:field[@name='sdxdocid']"/>
            </small>
        </div>
    </xsl:template>
-->
    <xsl:template match="sdx:field"/>
    <xsl:template match="sdx:field[@name='titre']">
        <a href="document.xsp?app={../sdx:field[@name='sdxappid']/@value}&amp;base={../sdx:field[@name='sdxdbid']/@value}&amp;id={../sdx:field[@name='sdxdocid']/@value}&amp;qid={../../@qid}&amp;n={../@no}&amp;q={/../../@escapedText}">
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select="."/>
        </a>
    </xsl:template>
</xsl:stylesheet>
