<?xml version="1.0" encoding="UTF-8"?>
<!--
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="sdx">
    <xsl:import href="skin.xsl"/>
    <!-- list of terms -->
    <xsl:template match="sdx:terms">
        <br/>
        <h2>Liste des titres</h2>
        <table width="100%" cellpadding="0" cellspacing="0" border="0">
            <tr>
                <td class="highlight">
                    <div>
                        <xsl:call-template name="sdx:results-head">
                            <xsl:with-param name="search"/>
                        </xsl:call-template>
                    </div>
                </td>
            </tr>
        </table>
        <br/>
        <xsl:apply-templates/>
        <xsl:if test="not(sdx:term)">
			Aucun document document indexé.
			</xsl:if>
        <br/>
        <div class="highlight">
            <xsl:call-template name="sdx:results-foot">
                <xsl:with-param name="search"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    <!-- generic term matching -->
    <xsl:template match="sdx:term">
        <div>
            <b>
                <xsl:value-of select="@no"/>
            </b>
            <xsl:text>&#160;</xsl:text>
            <xsl:choose>
                <xsl:when test="@id">
                    <a href="document.xsp?id={@id}&amp;base={@base}&amp;app={@app}">
                        &#160;<xsl:value-of select="@value"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="results.xsp?v={@escapedValue}&amp;f=titre">
                        &#160;<xsl:value-of select="@value"/>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@dbId='apps'"> (notice)</xsl:when>
                <xsl:when test="@dbId='sites'"> (site)</xsl:when>
            </xsl:choose>
        </div>
    </xsl:template>
</xsl:stylesheet>
