
#ifndef _JAVA_CONTROL_H
#define _JAVA_CONTROL_H

#import <swarmgraph/JavaObject.h>

typedef enum {
 ControlStateRunning = 0, 
 ControlStateStopped,
 ControlStateStepping, 
 ControlStateNextTime, 
 ControlStateQuit
} CtlState;


@interface JavaControl : JavaObject {
  jmethodID _getState;
  jmethodID _setState;
  jmethodID _waitRun;
  jmethodID _addAction;
}

+ new;

- init: (id) _classid;

// tell the control panel what actioncache to direct its signals to
- setActionCache: (id) actionCache;
- addAction:  (char *) actName : (id)actId;

//  set the control panel into a new state
- (int) getState;
//  query the control panel state
- (void) setState: (int)state;

// wait for the control panel to signal non-stopped state
- (void) waitRun;

@end

#endif
