// Market application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <swarmobject.h>
#import <simtools/GUISwarm.h>
#import "MarketModelSwarm.h"

// Sample graphical interface swarm for models.
@interface MarketObserverSwarm : GUISwarm {
  int displayFrequency;

  id displayActions;
  id displaySchedule;

  MarketModelSwarm * marketModelSwarm;

  BLTGraph *priceGraph;
  GraphElement *priceElement, *dividendElement, *fundamentalElement;
  ActiveGraph *priceGrapher, *dividendGrapher, *fundamentalGrapher;
  Histo *useHisto;
}

+createBegin: (id) aZone;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end
