
import java.awt.*;

class JavaJBar extends Frame {

  int cnt;
  int idx;
  double dval[];
  String labels[];
  String colors[];

  JavaJMemCanvas canvas;

  private final static int CHUNK = 128;
  private final static int BARWIDTH = 30;
  private final static int GAP = 5;
  private final static int MARGIN = 40;

  
  public JavaJBar() {
    System.out.println("JavaJBar... CONSTRUCT");
    cnt = CHUNK;
    idx = 0;
    dval = new double[cnt];
    labels = new String[cnt];

    // give us a canvas to stretch over the whole thing
    canvas = new JavaJMemCanvas();
    add("Center", canvas);

    setSize(400, 300);

    setBackground(Color.white);
    setVisible(true);
  }

  private void setLength(int len) {
    if (len > cnt) {
      double ndval[] = new double[cnt+CHUNK];
      for (int i=0; i<cnt; i++)
	ndval[i] = dval[i];
      cnt += CHUNK;
      dval = ndval;
    }
    idx = len;
  }

  public void addBar(String label, String color, double value) {
    System.out.println("adding bar!  "+label+" "+value);
    int cur = idx;
    setLength(idx+1);
    labels[cur] = label;
    dval[cur] = value;
    colors[cur] = color;
  }

  public void addBar(String label, String color, int value) {
    addBar(label, color, (double)value);
  }

  public void reset() {
    idx = 0;
  }

  public void update () {
    // figure out how many can fit on the screen
    // use a standard bar size

    Graphics ig = canvas.getGraphics();

    int width = ((BARWIDTH+GAP) * idx) + (2*MARGIN);
    int height = getSize().height;
    if (width > getSize().width) {
      setSize(width, height);
      canvas.componentResized();
    }

    if (idx > 0) {
      double max = dval[0];
      for (int i=0; i<idx; i++) {
	max = Math.max(max, dval[i]);
      }

      double maxRange = (double)(height-(2*GAP)-MARGIN) / max;

      int x=GAP;
      int y=height-MARGIN;

      for (int i=0; i<=idx; i++) {
	int h = (int)(maxRange * dval[i]);
	ig.fillRect(x, y, x+BARWIDTH, y-h);

	x += BARWIDTH+GAP;
      }
    }
  }

  public void paint(Graphics g) {
    canvas.repaint();
    g.dispose();
  }
}

