/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Target;
import gnu.expr.Undefined;
import gnu.mapping.Environment;
import gnu.mapping.SFormat;
import gnu.mapping.Values;
import java.io.PrintWriter;

public class QuoteExp
extends Expression {
    Object value;
    public static QuoteExp undefined_exp = new QuoteExp(Undefined.getInstance());
    public static QuoteExp voidExp = new QuoteExp(Values.empty);
    public static QuoteExp trueExp = new QuoteExp(Boolean.TRUE);
    public static QuoteExp falseExp = new QuoteExp(Boolean.FALSE);
    public static QuoteExp nullExp = new QuoteExp(null);

    public QuoteExp(Object object2) {
        this.value = object2;
    }

    public void compile(Compilation compilation, Target target) {
        compilation.compileConstant(this.value, target);
    }

    public Object eval(Environment environment) {
        return this.value;
    }

    public final Type getType() {
        if (this.value == Values.empty) {
            return Type.void_type;
        }
        if (this.value == null) {
            return Type.nullType;
        }
        return Type.make(this.value.getClass());
    }

    public final Object getValue() {
        return this.value;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(#%quote ");
        SFormat.print(this.value, printWriter);
        printWriter.print(")");
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkQuoteExp(this);
    }
}

