/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.buffer;

import simtools.data.DataException;
import simtools.data.ValueProvider;
import simtools.data.buffer.Buffer;
import simtools.data.buffer.ResizeableBuffer;

public class DelayedBuffer
extends ResizeableBuffer {
    static final long serialVersionUID = 3924396396711504226L;
    protected int delay;

    public int getDelay() {
        return this.delay;
    }

    public DelayedBuffer() {
        this(null);
    }

    public DelayedBuffer(int n) {
        this(7, n);
    }

    public DelayedBuffer(int n, int n2) {
        this(n, null, n2);
    }

    public DelayedBuffer(ValueProvider valueProvider) {
        this(7, valueProvider);
    }

    public DelayedBuffer(int n, ValueProvider valueProvider) {
        super(n, valueProvider);
        this.delay = this.valid.length / 2;
    }

    public DelayedBuffer(int n, ValueProvider valueProvider, int n2) {
        super(n, valueProvider, n2 * 2);
        this.delay = n2;
    }

    public long getStartIndex() {
        long l = this.endIndex - (long)this.delay;
        return Math.max(l, this.startIndex);
    }

    protected Buffer.Manipulator createManipulator(int n) {
        switch (n) {
            case 1: {
                return new DelayedByteManipulator();
            }
            case 2: {
                return new DelayedShortManipulator();
            }
            case 3: {
                return new DelayedIntegerManipulator();
            }
            case 4: {
                return new DelayedLongManipulator();
            }
            case 5: {
                return new DelayedFloatManipulator();
            }
            case 6: {
                return new DelayedDoubleManipulator();
            }
            case 7: {
                return new DelayedObjectManipulator();
            }
        }
        return null;
    }

    public class DelayedObjectManipulator
    extends ResizeableBuffer.ResizeableObjectManipulator {
        public DelayedObjectManipulator() {
            super(DelayedBuffer.this);
        }

        public boolean setValue(long l, Object object) throws DataException {
            if (l >= DelayedBuffer.this.startIndex + (long)DelayedBuffer.this.maxSize) {
                Object[] objectArray = null;
                boolean[] blArray = null;
                if (this.buffer.length == DelayedBuffer.this.maxSize) {
                    objectArray = this.buffer;
                    blArray = DelayedBuffer.this.valid;
                } else {
                    objectArray = new Object[DelayedBuffer.this.maxSize];
                    blArray = new boolean[DelayedBuffer.this.maxSize];
                }
                int n = DelayedBuffer.this.maxSize / 2;
                int n2 = (int)(DelayedBuffer.this.endIndex - DelayedBuffer.this.startIndex + 1L) - n;
                if (n2 > 0) {
                    System.arraycopy(this.buffer, n, objectArray, 0, n2);
                    System.arraycopy(DelayedBuffer.this.valid, n, blArray, 0, n2);
                    DelayedBuffer.this.startIndex += (long)n;
                    this.buffer = objectArray;
                    DelayedBuffer.this.valid = blArray;
                } else {
                    this.buffer = objectArray;
                    DelayedBuffer.this.valid = blArray;
                    DelayedBuffer.this.startIndex = DelayedBuffer.this.endIndex = l;
                    this.buffer[0] = object;
                    DelayedBuffer.this.valid[0] = true;
                    return true;
                }
            }
            return super.setValue(l, object);
        }

        public void setSlice(long l, long l2) {
        }
    }

    public class DelayedDoubleManipulator
    extends ResizeableBuffer.ResizeableDoubleManipulator {
        public DelayedDoubleManipulator() {
            super(DelayedBuffer.this);
        }

        public boolean setValue(long l, double d) throws DataException {
            if (l >= DelayedBuffer.this.startIndex + (long)DelayedBuffer.this.maxSize) {
                double[] dArray = null;
                boolean[] blArray = null;
                if (this.buffer.length == DelayedBuffer.this.maxSize) {
                    dArray = this.buffer;
                    blArray = DelayedBuffer.this.valid;
                } else {
                    dArray = new double[DelayedBuffer.this.maxSize];
                    blArray = new boolean[DelayedBuffer.this.maxSize];
                }
                int n = DelayedBuffer.this.maxSize / 2;
                int n2 = (int)(DelayedBuffer.this.endIndex - DelayedBuffer.this.startIndex + 1L) - n;
                if (n2 > 0) {
                    System.arraycopy(this.buffer, n, dArray, 0, n2);
                    System.arraycopy(DelayedBuffer.this.valid, n, blArray, 0, n2);
                    DelayedBuffer.this.startIndex += (long)n;
                    this.buffer = dArray;
                    DelayedBuffer.this.valid = blArray;
                } else {
                    this.buffer = dArray;
                    DelayedBuffer.this.valid = blArray;
                    DelayedBuffer.this.startIndex = DelayedBuffer.this.endIndex = l;
                    this.buffer[0] = d;
                    DelayedBuffer.this.valid[0] = true;
                    return true;
                }
            }
            return super.setValue(l, d);
        }

        public void setSlice(long l, long l2) {
        }
    }

    public class DelayedFloatManipulator
    extends ResizeableBuffer.ResizeableFloatManipulator {
        public DelayedFloatManipulator() {
            super(DelayedBuffer.this);
        }

        public boolean setValue(long l, float f) throws DataException {
            if (l >= DelayedBuffer.this.startIndex + (long)DelayedBuffer.this.maxSize) {
                float[] fArray = null;
                boolean[] blArray = null;
                if (this.buffer.length == DelayedBuffer.this.maxSize) {
                    fArray = this.buffer;
                    blArray = DelayedBuffer.this.valid;
                } else {
                    fArray = new float[DelayedBuffer.this.maxSize];
                    blArray = new boolean[DelayedBuffer.this.maxSize];
                }
                int n = DelayedBuffer.this.maxSize / 2;
                int n2 = (int)(DelayedBuffer.this.endIndex - DelayedBuffer.this.startIndex + 1L) - n;
                if (n2 > 0) {
                    System.arraycopy(this.buffer, n, fArray, 0, n2);
                    System.arraycopy(DelayedBuffer.this.valid, n, blArray, 0, n2);
                    DelayedBuffer.this.startIndex += (long)n;
                    this.buffer = fArray;
                    DelayedBuffer.this.valid = blArray;
                } else {
                    this.buffer = fArray;
                    DelayedBuffer.this.valid = blArray;
                    DelayedBuffer.this.startIndex = DelayedBuffer.this.endIndex = l;
                    this.buffer[0] = f;
                    DelayedBuffer.this.valid[0] = true;
                    return true;
                }
            }
            return super.setValue(l, f);
        }

        public void setSlice(long l, long l2) {
        }
    }

    public class DelayedLongManipulator
    extends ResizeableBuffer.ResizeableLongManipulator {
        public DelayedLongManipulator() {
            super(DelayedBuffer.this);
        }

        public boolean setValue(long l, long l2) throws DataException {
            if (l >= DelayedBuffer.this.startIndex + (long)DelayedBuffer.this.maxSize) {
                long[] lArray = null;
                boolean[] blArray = null;
                if (this.buffer.length == DelayedBuffer.this.maxSize) {
                    lArray = this.buffer;
                    blArray = DelayedBuffer.this.valid;
                } else {
                    lArray = new long[DelayedBuffer.this.maxSize];
                    blArray = new boolean[DelayedBuffer.this.maxSize];
                }
                int n = DelayedBuffer.this.maxSize / 2;
                int n2 = (int)(DelayedBuffer.this.endIndex - DelayedBuffer.this.startIndex + 1L) - n;
                if (n2 > 0) {
                    System.arraycopy(this.buffer, n, lArray, 0, n2);
                    System.arraycopy(DelayedBuffer.this.valid, n, blArray, 0, n2);
                    DelayedBuffer.this.startIndex += (long)n;
                    this.buffer = lArray;
                    DelayedBuffer.this.valid = blArray;
                } else {
                    this.buffer = lArray;
                    DelayedBuffer.this.valid = blArray;
                    DelayedBuffer.this.startIndex = DelayedBuffer.this.endIndex = l;
                    this.buffer[0] = l2;
                    DelayedBuffer.this.valid[0] = true;
                    return true;
                }
            }
            return super.setValue(l, l2);
        }

        public void setSlice(long l, long l2) {
        }
    }

    public class DelayedIntegerManipulator
    extends ResizeableBuffer.ResizeableIntegerManipulator {
        public DelayedIntegerManipulator() {
            super(DelayedBuffer.this);
        }

        public boolean setValue(long l, int n) throws DataException {
            if (l >= DelayedBuffer.this.startIndex + (long)DelayedBuffer.this.maxSize) {
                int[] nArray = null;
                boolean[] blArray = null;
                if (this.buffer.length == DelayedBuffer.this.maxSize) {
                    nArray = this.buffer;
                    blArray = DelayedBuffer.this.valid;
                } else {
                    nArray = new int[DelayedBuffer.this.maxSize];
                    blArray = new boolean[DelayedBuffer.this.maxSize];
                }
                int n2 = DelayedBuffer.this.maxSize / 2;
                int n3 = (int)(DelayedBuffer.this.endIndex - DelayedBuffer.this.startIndex + 1L) - n2;
                if (n3 > 0) {
                    System.arraycopy(this.buffer, n2, nArray, 0, n3);
                    System.arraycopy(DelayedBuffer.this.valid, n2, blArray, 0, n3);
                    DelayedBuffer.this.startIndex += (long)n2;
                    this.buffer = nArray;
                    DelayedBuffer.this.valid = blArray;
                } else {
                    this.buffer = nArray;
                    DelayedBuffer.this.valid = blArray;
                    DelayedBuffer.this.startIndex = DelayedBuffer.this.endIndex = l;
                    this.buffer[0] = n;
                    DelayedBuffer.this.valid[0] = true;
                    return true;
                }
            }
            return super.setValue(l, n);
        }

        public void setSlice(long l, long l2) {
        }
    }

    public class DelayedShortManipulator
    extends ResizeableBuffer.ResizeableShortManipulator {
        public DelayedShortManipulator() {
            super(DelayedBuffer.this);
        }

        public boolean setValue(long l, short s) throws DataException {
            if (l >= DelayedBuffer.this.startIndex + (long)DelayedBuffer.this.maxSize) {
                short[] sArray = null;
                boolean[] blArray = null;
                if (this.buffer.length == DelayedBuffer.this.maxSize) {
                    sArray = this.buffer;
                    blArray = DelayedBuffer.this.valid;
                } else {
                    sArray = new short[DelayedBuffer.this.maxSize];
                    blArray = new boolean[DelayedBuffer.this.maxSize];
                }
                int n = DelayedBuffer.this.maxSize / 2;
                int n2 = (int)(DelayedBuffer.this.endIndex - DelayedBuffer.this.startIndex + 1L) - n;
                if (n2 > 0) {
                    System.arraycopy(this.buffer, n, sArray, 0, n2);
                    System.arraycopy(DelayedBuffer.this.valid, n, blArray, 0, n2);
                    DelayedBuffer.this.startIndex += (long)n;
                    this.buffer = sArray;
                    DelayedBuffer.this.valid = blArray;
                } else {
                    this.buffer = sArray;
                    DelayedBuffer.this.valid = blArray;
                    DelayedBuffer.this.startIndex = DelayedBuffer.this.endIndex = l;
                    this.buffer[0] = s;
                    DelayedBuffer.this.valid[0] = true;
                    return true;
                }
            }
            return super.setValue(l, s);
        }

        public void setSlice(long l, long l2) {
        }
    }

    public class DelayedByteManipulator
    extends ResizeableBuffer.ResizeableByteManipulator {
        public DelayedByteManipulator() {
            super(DelayedBuffer.this);
        }

        public boolean setValue(long l, byte by) throws DataException {
            if (l >= DelayedBuffer.this.startIndex + (long)DelayedBuffer.this.maxSize) {
                byte[] byArray = null;
                boolean[] blArray = null;
                if (this.buffer.length == DelayedBuffer.this.maxSize) {
                    byArray = this.buffer;
                    blArray = DelayedBuffer.this.valid;
                } else {
                    byArray = new byte[DelayedBuffer.this.maxSize];
                    blArray = new boolean[DelayedBuffer.this.maxSize];
                }
                int n = DelayedBuffer.this.maxSize / 2;
                int n2 = (int)(DelayedBuffer.this.endIndex - DelayedBuffer.this.startIndex + 1L) - n;
                if (n2 > 0) {
                    System.arraycopy(this.buffer, n, byArray, 0, n2);
                    System.arraycopy(DelayedBuffer.this.valid, n, blArray, 0, n2);
                    DelayedBuffer.this.startIndex += (long)n;
                    this.buffer = byArray;
                    DelayedBuffer.this.valid = blArray;
                } else {
                    this.buffer = byArray;
                    DelayedBuffer.this.valid = blArray;
                    DelayedBuffer.this.startIndex = DelayedBuffer.this.endIndex = l;
                    this.buffer[0] = by;
                    DelayedBuffer.this.valid[0] = true;
                    return true;
                }
            }
            return super.setValue(l, by);
        }

        public void setSlice(long l, long l2) {
        }
    }
}

