/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simtools.ui.CardMode;
import simtools.ui.CustomizedLocale;
import simtools.ui.DesktopCardPanelListener;
import simtools.ui.DesktopCardPanelMode;
import simtools.ui.DesktopMode;
import simtools.ui.ExternalMode;
import simtools.ui.MenuResourceBundle;
import simtools.util.ListenerManager;

public class DesktopCardPanel
extends JPanel
implements ChangeListener,
MouseListener,
ActionListener {
    protected static MenuResourceBundle _resources;
    public static final int CARD_MODE = 0;
    public static final int DESKTOP_MODE = 1;
    public static final int EXTERNAL_MODE = 2;
    private int _currentMode = -1;
    private JTabbedPane _namesPane;
    protected Vector _components;
    private boolean _scrollable;
    private boolean _closable;
    private JMenu _menu;
    private JMenuItem _miNext;
    private JMenuItem _miPrevious;
    private JMenuItem _miCascade;
    private JMenuItem _miCloseAll;
    private JMenuItem _miMaximize;
    private JMenuItem _miExternal;
    private ButtonGroup _bgComponents;
    protected JPopupMenu _cardPopup;
    private ListenerManager _listeners = new ListenerManager();
    protected DesktopCardPanelMode _desktopCardPanelMode;

    public DesktopCardPanel(boolean bl) {
        this(bl, true);
    }

    public DesktopCardPanel(boolean bl, boolean bl2) {
        super(new BorderLayout());
        this._scrollable = bl;
        this._closable = bl2;
        this.createCardPopupMenu();
        this._namesPane = new JTabbedPane();
        this._namesPane.addChangeListener(this);
        this._namesPane.addMouseListener(this);
        this.add("North", this._namesPane);
        this._components = new Vector();
        this._miNext = null;
        this._miPrevious = null;
        this._miCascade = null;
        this._miCloseAll = null;
        this._miMaximize = null;
        this._bgComponents = null;
        this.setMode(0);
    }

    public boolean is_closable() {
        return this._closable;
    }

    public boolean is_scrollable() {
        return this._scrollable;
    }

    protected void createCardPopupMenu() {
        this._cardPopup = new CardPopupMenu();
    }

    public void setDesktopState(boolean bl) {
        this.setMode(bl ? 1 : 0);
    }

    public void setMode(int n) {
        if (this._currentMode == n) {
            return;
        }
        this._currentMode = n;
        switch (n) {
            case 0: {
                this.setDesktopCardPanelMode(new CardMode(this));
                break;
            }
            case 1: {
                this.setDesktopCardPanelMode(new DesktopMode(this));
                break;
            }
            case 2: {
                this.setDesktopCardPanelMode(new ExternalMode(this));
            }
        }
    }

    protected void setDesktopCardPanelMode(DesktopCardPanelMode desktopCardPanelMode) {
        Container container;
        if (this._desktopCardPanelMode != null && (container = this._desktopCardPanelMode.getContentPane()) != null) {
            this.remove(container);
        }
        if ((container = desktopCardPanelMode.getContentPane()) != null) {
            this.add("Center", container);
        }
        this.validate();
        for (int i = 0; i < this._components.size(); ++i) {
            JComponent jComponent = (JComponent)this._components.elementAt(i);
            this._desktopCardPanelMode.removeComponent(jComponent);
            desktopCardPanelMode.addComponent(jComponent);
        }
        this._desktopCardPanelMode = desktopCardPanelMode;
        this.selectComponent(this.getSelectedComponent());
        if (this._miCascade != null) {
            this._miCascade.setEnabled(this._currentMode != 1);
        }
        if (this._miMaximize != null) {
            this._miMaximize.setEnabled(this._currentMode != 0);
        }
        if (this._miExternal != null) {
            this._miExternal.setEnabled(this._currentMode != 2);
        }
        this.validate();
        this.repaint();
    }

    public int getMode() {
        return this._currentMode;
    }

    public boolean getDesktopState() {
        return this._currentMode == 1;
    }

    public int indexOfComponent(JComponent jComponent) {
        for (int i = 0; i < this._components.size(); ++i) {
            JComponent jComponent2 = (JComponent)this._components.elementAt(i);
            if (jComponent2 != jComponent) continue;
            return i;
        }
        return -1;
    }

    public Iterator getComponentIterator() {
        return this._components.iterator();
    }

    public JComponent getComponentAt(int n) {
        return (JComponent)this._components.elementAt(n);
    }

    public Container getContainer(JComponent jComponent) {
        return this._desktopCardPanelMode.getContainer(jComponent);
    }

    public void addComponent(JComponent jComponent) {
        this._components.addElement(jComponent);
        JPanel jPanel = new JPanel(new PanelsPaneLayout(this));
        this._namesPane.addTab(jComponent.getName(), jPanel);
        this._desktopCardPanelMode.addComponent(jComponent);
        this.setComponentsMenuItems();
        this.selectComponent(jComponent);
        this.repaint();
    }

    public void updateComponentName(JComponent jComponent) {
        int n = this._components.indexOf(jComponent);
        if (n < 0) {
            return;
        }
        this._namesPane.setTitleAt(n, jComponent.getName());
        this._desktopCardPanelMode.updateComponentName(jComponent);
        this.setComponentsMenuItems();
        if (this._bgComponents != null) {
            Enumeration<AbstractButton> enumeration = this._bgComponents.getElements();
            while (enumeration.hasMoreElements()) {
                ComponentRadioButton componentRadioButton = (ComponentRadioButton)enumeration.nextElement();
                if (jComponent != componentRadioButton._component) continue;
                if (componentRadioButton.isSelected()) break;
                componentRadioButton.setSelected(true);
                break;
            }
        }
        this.repaint();
    }

    public void removeComponent(JComponent jComponent) {
        int n = this._components.indexOf(jComponent);
        if (n < 0) {
            return;
        }
        this._namesPane.removeTabAt(n);
        this._components.removeElementAt(n);
        this._desktopCardPanelMode.removeComponent(jComponent);
        this.setComponentsMenuItems();
        if (this._components.isEmpty()) {
            this.selectComponent(null);
        } else if (n >= this._components.size()) {
            this.selectComponent((JComponent)this._components.lastElement());
        } else {
            this.selectComponent((JComponent)this._components.elementAt(n));
        }
        this.repaint();
    }

    public void removeAllComponents() {
        for (int i = 0; i < this._components.size(); ++i) {
            JComponent jComponent = (JComponent)this._components.elementAt(i);
            this._desktopCardPanelMode.removeComponent(jComponent);
        }
        this._namesPane.removeAll();
        this._components.clear();
        this.setComponentsMenuItems();
        this.selectComponent(null);
        this.repaint();
    }

    public JComponent getSelectedComponent() {
        int n = this._namesPane.getSelectedIndex();
        if (n < 0 || n > this._components.size()) {
            return null;
        }
        return (JComponent)this._components.elementAt(n);
    }

    public int getSelectedIndex() {
        int n = this._namesPane.getSelectedIndex();
        if (n < 0 || n > this._components.size()) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectComponent(JComponent jComponent) {
        this._desktopCardPanelMode.selectComponent(jComponent);
        for (int i = 0; i < this._components.size(); ++i) {
            if (jComponent != this._components.elementAt(i)) continue;
            if (this._namesPane.getSelectedIndex() == i) break;
            this._namesPane.setSelectedIndex(i);
            break;
        }
        if (this._bgComponents != null) {
            Enumeration<AbstractButton> enumeration = this._bgComponents.getElements();
            while (enumeration.hasMoreElements()) {
                ComponentRadioButton componentRadioButton = (ComponentRadioButton)enumeration.nextElement();
                if (jComponent != componentRadioButton._component) continue;
                if (componentRadioButton.isSelected()) break;
                componentRadioButton.setSelected(true);
                break;
            }
        }
        ListenerManager listenerManager = this._listeners;
        synchronized (listenerManager) {
            int n = this._listeners.size();
            for (int i = 0; i < n; ++i) {
                DesktopCardPanelListener desktopCardPanelListener = (DesktopCardPanelListener)this._listeners.get(i);
                if (desktopCardPanelListener == null) continue;
                desktopCardPanelListener.componentSelected(jComponent);
            }
        }
        this.repaint();
    }

    public void addListener(DesktopCardPanelListener desktopCardPanelListener) {
        this._listeners.add(desktopCardPanelListener);
    }

    public void removeListener(DesktopCardPanelListener desktopCardPanelListener) {
        this._listeners.remove(desktopCardPanelListener);
    }

    public void removeAllListeners() {
        this._listeners.clear();
    }

    public JMenu createMenu(String string) {
        return this.createMenu(string, true);
    }

    public JMenu createMenu(String string, boolean bl) {
        if (this._menu != null) {
            return null;
        }
        if (string != null) {
            this._menu = new JMenu(string);
            this._menu.setMnemonic(string.charAt(0));
        } else {
            this._menu = _resources.getMenu("windows");
        }
        this._miNext = _resources.getItem("next", this);
        this._menu.add(this._miNext);
        this._miPrevious = _resources.getItem("previous", this);
        this._menu.add(this._miPrevious);
        this._menu.add(new JSeparator());
        this._miMaximize = _resources.getItem("maximize", this);
        this._menu.add(this._miMaximize);
        if (this._currentMode == 0) {
            this._miMaximize.setEnabled(false);
        }
        this._miCascade = _resources.getItem("cascade", this);
        this._menu.add(this._miCascade);
        if (this._currentMode == 1) {
            this._miCascade.setEnabled(false);
        }
        this._miExternal = _resources.getItem("external", this);
        this._menu.add(this._miExternal);
        if (this._currentMode == 2) {
            this._miCascade.setEnabled(false);
        }
        this._menu.add(new JSeparator());
        if (bl) {
            this._miCloseAll = _resources.getItem("closeAll", this);
            this._menu.add(this._miCloseAll);
            this._menu.add(new JSeparator());
        }
        this._bgComponents = new ButtonGroup();
        this.setComponentsMenuItems();
        return this._menu;
    }

    private void setComponentsMenuItems() {
        if (this._bgComponents == null) {
            return;
        }
        Enumeration<AbstractButton> enumeration = this._bgComponents.getElements();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
            this._menu.remove(jMenuItem);
        }
        this._bgComponents = new ButtonGroup();
        for (int i = 0; i < this._components.size(); ++i) {
            ComponentRadioButton componentRadioButton = new ComponentRadioButton((JComponent)this._components.elementAt(i));
            this._menu.add(componentRadioButton);
            this._bgComponents.add(componentRadioButton);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) == 4 && this._cardPopup != null) {
            this._cardPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._miNext || actionEvent.getSource() == this._miPrevious) {
            int n = this._namesPane.getSelectedIndex();
            int n2 = this._components.size();
            if (n2 == 0) {
                return;
            }
            if (actionEvent.getSource() == this._miNext) {
                if (++n >= n2) {
                    n = 0;
                }
            } else if (--n < 0) {
                n = n2 - 1;
            }
            this.selectComponent((JComponent)this._components.elementAt(n));
        } else if (actionEvent.getSource() == this._miCascade) {
            this.setMode(1);
        } else if (actionEvent.getSource() == this._miCloseAll) {
            this.removeAllComponents();
        } else if (actionEvent.getSource() == this._miMaximize) {
            this.setMode(0);
        } else if (actionEvent.getSource() == this._miExternal) {
            this.setMode(2);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this._namesPane.getSelectedIndex();
        if (n < 0 || n > this._components.size()) {
            return;
        }
        JComponent jComponent = (JComponent)this._components.elementAt(n);
        this.selectComponent(jComponent);
    }

    static {
        try {
            _resources = (MenuResourceBundle)ResourceBundle.getBundle("simtools.ui.resources.DesktopCardPanelResource", CustomizedLocale.get());
        }
        catch (Exception exception) {
            System.err.println("Can't load DesktopCardPanel resources");
            System.exit(0);
        }
    }

    public class CardPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private JMenuItem _miClose = _resources.getItem("closeCard", this);

        public CardPopupMenu() {
            this.add(this._miClose);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._miClose) {
                DesktopCardPanel.this.removeComponent(DesktopCardPanel.this.getSelectedComponent());
            }
        }
    }

    public class PanelsPaneLayout
    implements LayoutManager {
        private JComponent _mirrored;

        PanelsPaneLayout(JComponent jComponent) {
            this._mirrored = jComponent;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            if (this._mirrored != null) {
                int n = this._mirrored.getSize().width;
                return new Dimension(n, 0);
            }
            if (container.getComponentCount() == 0) {
                return new Dimension(0, 0);
            }
            return container.getSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            if (container.getComponentCount() == 0) {
                return new Dimension(0, 0);
            }
            return container.getComponent(0).getMinimumSize();
        }

        public void layoutContainer(Container container) {
            if (container.getComponentCount() == 0) {
                return;
            }
            Component component = container.getComponent(0);
            Dimension dimension = container.getSize();
            component.setSize(dimension.width, dimension.height);
            component.setLocation(0, 0);
        }
    }

    public class ComponentRadioButton
    extends JRadioButtonMenuItem
    implements ActionListener {
        JComponent _component;

        public ComponentRadioButton(JComponent jComponent) {
            this._component = jComponent;
            this.setText(this._component.toString());
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                DesktopCardPanel.this.selectComponent(this._component);
            }
        }
    }
}

