/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class XYPointerAnnotation
extends XYTextAnnotation
implements XYAnnotation,
Cloneable,
Serializable {
    public static final double DEFAULT_TIP_RADIUS = 10.0;
    public static final double DEFAULT_BASE_RADIUS = 30.0;
    public static final double DEFAULT_LABEL_OFFSET = 3.0;
    public static final double DEFAULT_ARROW_LENGTH = 5.0;
    public static final double DEFAULT_ARROW_WIDTH = 3.0;
    private double angle;
    private double tipRadius;
    private double baseRadius;
    private double arrowLength;
    private double arrowWidth;
    private transient Stroke arrowStroke;
    private transient Paint arrowPaint;
    private double labelOffset;

    public XYPointerAnnotation(String string, double d, double d2, double d3) {
        super(string, d, d2);
        this.angle = d3;
        this.tipRadius = 10.0;
        this.baseRadius = 30.0;
        this.arrowLength = 5.0;
        this.arrowWidth = 3.0;
        this.labelOffset = 3.0;
        this.arrowStroke = new BasicStroke(1.0f);
        this.arrowPaint = Color.black;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getTipRadius() {
        return this.tipRadius;
    }

    public void setTipRadius(double d) {
        this.tipRadius = d;
    }

    public double getBaseRadius() {
        return this.baseRadius;
    }

    public void setBaseRadius(double d) {
        this.baseRadius = d;
    }

    public double getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(double d) {
        this.labelOffset = d;
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double d) {
        this.arrowLength = d;
    }

    public double getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowWidth(double d) {
        this.arrowWidth = d;
    }

    public Stroke getArrowStroke() {
        return this.arrowStroke;
    }

    public void setArrowStroke(Stroke stroke) {
        this.arrowStroke = stroke;
    }

    public Paint getArrowPaint() {
        return this.arrowPaint;
    }

    public void setArrowPaint(Paint paint) {
        this.arrowPaint = paint;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        double d = valueAxis.translateValueToJava2D(this.getX(), rectangle2D, rectangleEdge);
        double d2 = valueAxis2.translateValueToJava2D(this.getY(), rectangle2D, rectangleEdge2);
        double d3 = d + Math.cos(this.angle) * this.baseRadius;
        double d4 = d2 + Math.sin(this.angle) * this.baseRadius;
        double d5 = d + Math.cos(this.angle) * this.tipRadius;
        double d6 = d2 + Math.sin(this.angle) * this.tipRadius;
        double d7 = d5 + Math.cos(this.angle) * this.arrowLength;
        double d8 = d6 + Math.sin(this.angle) * this.arrowLength;
        double d9 = d7 + Math.cos(this.angle + 1.5707963267948966) * this.arrowWidth;
        double d10 = d8 + Math.sin(this.angle + 1.5707963267948966) * this.arrowWidth;
        double d11 = d7 - Math.cos(this.angle + 1.5707963267948966) * this.arrowWidth;
        double d12 = d8 - Math.sin(this.angle + 1.5707963267948966) * this.arrowWidth;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)d5, (float)d6);
        generalPath.lineTo((float)d9, (float)d10);
        generalPath.lineTo((float)d11, (float)d12);
        generalPath.closePath();
        graphics2D.setStroke(this.arrowStroke);
        graphics2D.setPaint(this.arrowPaint);
        Line2D.Double double_ = new Line2D.Double(d3, d4, d5, d6);
        graphics2D.draw(double_);
        graphics2D.fill(generalPath);
        graphics2D.setFont(this.getFont());
        graphics2D.setPaint(this.getPaint());
        double d13 = d + Math.cos(this.angle) * (this.baseRadius + this.labelOffset);
        double d14 = d2 + Math.sin(this.angle) * (this.baseRadius + this.labelOffset);
        RefineryUtilities.drawAlignedString((String)this.getText(), (Graphics2D)graphics2D, (float)((float)d13), (float)((float)d14), (TextAnchor)this.getTextAnchor());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof XYPointerAnnotation) {
            XYPointerAnnotation xYPointerAnnotation = (XYPointerAnnotation)object;
            boolean bl = this.angle == xYPointerAnnotation.angle;
            boolean bl2 = this.tipRadius == xYPointerAnnotation.tipRadius;
            boolean bl3 = this.baseRadius == xYPointerAnnotation.baseRadius;
            boolean bl4 = this.arrowLength == xYPointerAnnotation.arrowLength;
            boolean bl5 = this.arrowWidth == xYPointerAnnotation.arrowWidth;
            boolean bl6 = this.arrowPaint.equals(xYPointerAnnotation.arrowPaint);
            boolean bl7 = this.arrowStroke.equals(xYPointerAnnotation.arrowStroke);
            boolean bl8 = this.labelOffset == xYPointerAnnotation.labelOffset;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.arrowPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.arrowStroke, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.arrowPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.arrowStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
    }
}

