/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.buffer;

import simtools.data.CollectiveDataSource;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;
import simtools.data.buffer.Buffer;
import simtools.data.buffer.SimpleBuffer;

public class BufferedDataSource
extends DataSource {
    protected Buffer buffer;
    public DataSource dataSource;

    public boolean equals(Object object) {
        return this.dataSource.equals(object) || super.equals(object);
    }

    public BufferedDataSource(DataSource dataSource) {
        this(new SimpleBuffer(dataSource));
    }

    public BufferedDataSource(DataSource dataSource, int n) {
        this(new SimpleBuffer(dataSource, n));
    }

    public BufferedDataSource(Buffer buffer) {
        this.dataSource = (DataSource)buffer.provider;
        if (this.dataSource instanceof CollectiveDataSource) {
            CollectiveDataSource collectiveDataSource = (CollectiveDataSource)this.dataSource;
            collectiveDataSource.getCollection().attachBuffer(collectiveDataSource.getPosition(), buffer);
        }
        this.buffer = buffer;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Object getValue(long l) throws DataException {
        return this.buffer.getValue(l);
    }

    public byte getByteValue(long l) throws DataException {
        return this.buffer.getByteValue(l);
    }

    public short getShortValue(long l) throws DataException {
        return this.buffer.getShortValue(l);
    }

    public int getIntegerValue(long l) throws DataException {
        return this.buffer.getIntegerValue(l);
    }

    public long getLongValue(long l) throws DataException {
        return this.buffer.getLongValue(l);
    }

    public float getFloatValue(long l) throws DataException {
        return this.buffer.getFloatValue(l);
    }

    public double getDoubleValue(long l) throws DataException {
        return this.buffer.getDoubleValue(l);
    }

    public void setSlice(long l, long l2) {
        this.buffer.setSlice(l, l2);
        this.dataSource.setSlice(l, l2);
    }

    public DataInfo getInformation() {
        return this.dataSource.getInformation();
    }

    public Object getMin() throws UnsupportedOperation {
        return this.dataSource.getMin();
    }

    public Object getMax() throws UnsupportedOperation {
        return this.dataSource.getMax();
    }

    public byte getByteMin() throws DataException {
        return this.dataSource.getByteMin();
    }

    public byte getByteMax() throws DataException {
        return this.dataSource.getByteMax();
    }

    public short getShortMin() throws DataException {
        return this.dataSource.getShortMin();
    }

    public short getShortMax() throws DataException {
        return this.dataSource.getShortMax();
    }

    public int getIntegerMin() throws DataException {
        return this.dataSource.getIntegerMin();
    }

    public int getIntegerMax() throws DataException {
        return this.dataSource.getIntegerMax();
    }

    public long getLongMin() throws DataException {
        return this.dataSource.getLongMin();
    }

    public long getLongMax() throws DataException {
        return this.dataSource.getLongMax();
    }

    public float getFloatMin() throws DataException {
        return this.dataSource.getFloatMin();
    }

    public float getFloatMax() throws DataException {
        return this.dataSource.getFloatMax();
    }

    public double getDoubleMin() throws DataException {
        return this.dataSource.getDoubleMin();
    }

    public double getDoubleMax() throws DataException {
        return this.dataSource.getDoubleMax();
    }

    public long getStartIndex() throws UnsupportedOperation {
        return this.dataSource.getStartIndex();
    }

    public long getLastIndex() throws UnsupportedOperation {
        return this.dataSource.getLastIndex();
    }

    public Object computeMin() throws UnsupportedOperation {
        return this.dataSource.computeMin();
    }

    public Object computeMax() throws UnsupportedOperation {
        return this.dataSource.computeMax();
    }

    public long computeStartIndex() throws UnsupportedOperation {
        return this.dataSource.computeStartIndex();
    }

    public long computeLastIndex() throws UnsupportedOperation {
        return this.dataSource.computeLastIndex();
    }

    public int sortedOrder() {
        return this.dataSource.sortedOrder();
    }

    public boolean isComparable() {
        return this.dataSource.isComparable();
    }

    public void addListener(DataSourceListener dataSourceListener) {
        this.dataSource.addListener(dataSourceListener);
    }

    public void notifyListenersForIndexRangeChange(long l, long l2) {
        this.dataSource.notifyListenersForIndexRangeChange(l, l2);
    }

    public void notifyListenersForInfoChange(DataInfo dataInfo) {
        this.dataSource.notifyListenersForInfoChange(dataInfo);
    }

    public void notifyListenersForOrderChange(int n) {
        this.dataSource.notifyListenersForOrderChange(n);
    }

    public void notifyListenersForValueChange(long l, long l2) {
        this.dataSource.notifyListenersForValueChange(l, l2);
    }

    public void notifyListenersForValueRangeChange() {
        this.dataSource.notifyListenersForValueRangeChange();
    }

    public void removeListener(DataSourceListener dataSourceListener) {
        this.dataSource.removeListener(dataSourceListener);
    }

    public void addEndNotificationListener(EndNotificationListener endNotificationListener) {
        this.dataSource.addEndNotificationListener(endNotificationListener);
    }

    public void notifyEndNotificationListeners() {
        this.dataSource.notifyEndNotificationListeners();
    }

    public void removeEndNotificationListener(EndNotificationListener endNotificationListener) {
        this.dataSource.removeEndNotificationListener(endNotificationListener);
    }
}

