/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import simtools.ui.CustomizedLocale;
import simtools.ui.DesktopCardPanelListener;
import simtools.ui.MenuResourceBundle;
import simtools.util.ListenerManager;

public class DesktopCardPanel
extends JPanel
implements ChangeListener,
MouseListener,
ActionListener {
    private static final int DEFAULT_HEIGHT = 200;
    private static final int MIN_WIDTH = 40;
    private static final int MIN_HEIGHT = 40;
    protected static MenuResourceBundle _resources;
    private JDesktopPane _framesPane;
    private boolean _desktop;
    protected FramesListener _framesListener;
    private int _frameX;
    private int _frameY;
    private int _frameMaxWidth;
    private int _frameMaxHeight;
    private Vector _panelPanes;
    private JPanel _panelsPane;
    private JTabbedPane _namesPane;
    protected Vector _components;
    private boolean _scrollable;
    private boolean _closable;
    private JMenu _menu;
    private JMenuItem _miNext;
    private JMenuItem _miPrevious;
    private JMenuItem _miCascade;
    private JMenuItem _miCloseAll;
    private JMenuItem _miMaximize;
    private ButtonGroup _bgComponents;
    protected JPopupMenu _cardPopup;
    private ListenerManager _listeners = new ListenerManager();

    public DesktopCardPanel(boolean bl) {
        this(bl, true);
    }

    public DesktopCardPanel(boolean bl, boolean bl2) {
        super(new BorderLayout());
        this._scrollable = bl;
        this._closable = bl2;
        this.createCardPopupMenu();
        this._namesPane = new JTabbedPane();
        this._namesPane.addChangeListener(this);
        this._namesPane.addMouseListener(this);
        this.add("North", this._namesPane);
        this._framesPane = new JDesktopPane();
        this._framesListener = new FramesListener();
        this._desktop = false;
        this._panelsPane = new JPanel(new PanelsPaneLayout(null));
        this._panelPanes = new Vector();
        this.add("Center", this._panelsPane);
        this.resetDesktop();
        this._components = new Vector();
        this._miNext = null;
        this._miPrevious = null;
        this._miCascade = null;
        this._miCloseAll = null;
        this._miMaximize = null;
        this._bgComponents = null;
    }

    protected void createCardPopupMenu() {
        this._cardPopup = new CardPopupMenu();
    }

    public void setDesktopState(boolean bl) {
        if (this._desktop == bl) {
            return;
        }
        if (bl) {
            JComponent jComponent;
            int n;
            this.remove(this._panelsPane);
            for (n = 0; n < this._panelPanes.size(); ++n) {
                jComponent = (ComponentPanel)this._panelPanes.elementAt(n);
                jComponent.removeAll();
            }
            this._panelPanes.removeAllElements();
            this.resetDesktop();
            for (n = 0; n < this._components.size(); ++n) {
                jComponent = (JComponent)this._components.elementAt(n);
                this.addDesktopComponent(jComponent);
            }
            this.add("Center", this._framesPane);
            this._desktop = true;
            this.selectComponent(this.getSelectedComponent());
        } else {
            this.remove(this._framesPane);
            this._framesPane.removeAll();
            for (int i = 0; i < this._components.size(); ++i) {
                JComponent jComponent = (JComponent)this._components.elementAt(i);
                this.addPanelComponent(jComponent);
            }
            this.add("Center", this._panelsPane);
            this._desktop = false;
            this.selectComponent(this.getSelectedComponent());
        }
        if (this._miCascade != null) {
            this._miCascade.setEnabled(!this._desktop);
        }
        if (this._miMaximize != null) {
            this._miMaximize.setEnabled(this._desktop);
        }
        this.validate();
        this.repaint();
    }

    public boolean getDesktopState() {
        return this._desktop;
    }

    public int indexOfComponent(JComponent jComponent) {
        for (int i = 0; i < this._components.size(); ++i) {
            JComponent jComponent2 = (JComponent)this._components.elementAt(i);
            if (jComponent2 != jComponent) continue;
            return i;
        }
        return -1;
    }

    public Iterator getComponentIterator() {
        return this._components.iterator();
    }

    public JComponent getComponentAt(int n) {
        return (JComponent)this._components.elementAt(n);
    }

    public void addComponent(JComponent jComponent) {
        this._components.addElement(jComponent);
        JPanel jPanel = new JPanel(new PanelsPaneLayout(this));
        this._namesPane.addTab(jComponent.getName(), jPanel);
        if (this._desktop) {
            this.addDesktopComponent(jComponent);
        } else {
            this.addPanelComponent(jComponent);
        }
        this.setComponentsMenuItems();
        this.selectComponent(jComponent);
        this.repaint();
    }

    public void updateComponentName(JComponent jComponent) {
        int n = this._components.indexOf(jComponent);
        if (n < 0) {
            return;
        }
        this._namesPane.setTitleAt(n, jComponent.getName());
        if (this._desktop) {
            this.updateDesktopComponent(jComponent);
        }
        this.setComponentsMenuItems();
        if (this._bgComponents != null) {
            Enumeration<AbstractButton> enumeration = this._bgComponents.getElements();
            while (enumeration.hasMoreElements()) {
                ComponentRadioButton componentRadioButton = (ComponentRadioButton)enumeration.nextElement();
                if (jComponent != componentRadioButton._component) continue;
                if (componentRadioButton.isSelected()) break;
                componentRadioButton.setSelected(true);
                break;
            }
        }
        this.repaint();
    }

    public void removeComponent(JComponent jComponent) {
        int n = this._components.indexOf(jComponent);
        if (n < 0) {
            return;
        }
        this._namesPane.removeTabAt(n);
        this._components.removeElementAt(n);
        if (this._desktop) {
            this.removeDesktopComponent(jComponent);
        } else {
            this.removePanelComponent(jComponent);
        }
        this.setComponentsMenuItems();
        if (this._components.isEmpty()) {
            this.selectComponent(null);
        } else if (n >= this._components.size()) {
            this.selectComponent((JComponent)this._components.lastElement());
        } else {
            this.selectComponent((JComponent)this._components.elementAt(n));
        }
        this.repaint();
    }

    public void removeAllComponents() {
        for (int i = 0; i < this._components.size(); ++i) {
            JComponent jComponent = (JComponent)this._components.elementAt(i);
            if (this._desktop) {
                this.removeDesktopComponent(jComponent);
                continue;
            }
            this.removePanelComponent(jComponent);
        }
        this._namesPane.removeAll();
        this._components.clear();
        this.setComponentsMenuItems();
        this.selectComponent(null);
        this.repaint();
    }

    public JComponent getSelectedComponent() {
        int n = this._namesPane.getSelectedIndex();
        if (n < 0 || n > this._components.size()) {
            return null;
        }
        return (JComponent)this._components.elementAt(n);
    }

    public int getSelectedIndex() {
        int n = this._namesPane.getSelectedIndex();
        if (n < 0 || n > this._components.size()) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectComponent(JComponent jComponent) {
        int n;
        if (this._desktop) {
            JInternalFrame[] jInternalFrameArray = this._framesPane.getAllFrames();
            if (jInternalFrameArray != null) {
                for (n = 0; n < jInternalFrameArray.length; ++n) {
                    ComponentFrame componentFrame = (ComponentFrame)jInternalFrameArray[n];
                    if (componentFrame.getComponent() != jComponent) continue;
                    try {
                        componentFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
            }
        } else {
            this._panelsPane.removeAll();
            for (int i = 0; i < this._panelPanes.size(); ++i) {
                ComponentPanel componentPanel = (ComponentPanel)this._panelPanes.elementAt(i);
                if (componentPanel.getComponent() != jComponent) continue;
                this._panelsPane.add((Component)componentPanel, "Center");
                break;
            }
        }
        for (int i = 0; i < this._components.size(); ++i) {
            if (jComponent != this._components.elementAt(i)) continue;
            if (this._namesPane.getSelectedIndex() == i) break;
            this._namesPane.setSelectedIndex(i);
            break;
        }
        if (this._bgComponents != null) {
            Enumeration<AbstractButton> enumeration = this._bgComponents.getElements();
            while (enumeration.hasMoreElements()) {
                ComponentRadioButton componentRadioButton = (ComponentRadioButton)enumeration.nextElement();
                if (jComponent != componentRadioButton._component) continue;
                if (componentRadioButton.isSelected()) break;
                componentRadioButton.setSelected(true);
                break;
            }
        }
        ListenerManager listenerManager = this._listeners;
        synchronized (listenerManager) {
            n = this._listeners.size();
            for (int i = 0; i < n; ++i) {
                DesktopCardPanelListener desktopCardPanelListener = (DesktopCardPanelListener)this._listeners.get(i);
                if (desktopCardPanelListener == null) continue;
                desktopCardPanelListener.componentSelected(jComponent);
            }
        }
        this.repaint();
    }

    public void addListener(DesktopCardPanelListener desktopCardPanelListener) {
        this._listeners.add(desktopCardPanelListener);
    }

    public void removeListener(DesktopCardPanelListener desktopCardPanelListener) {
        this._listeners.remove(desktopCardPanelListener);
    }

    public void removeAllListeners() {
        this._listeners.clear();
    }

    public JMenu createMenu(String string) {
        return this.createMenu(string, true);
    }

    public JMenu createMenu(String string, boolean bl) {
        if (this._menu != null) {
            return null;
        }
        if (string != null) {
            this._menu = new JMenu(string);
            this._menu.setMnemonic(string.charAt(0));
        } else {
            this._menu = _resources.getMenu("windows");
        }
        this._miNext = _resources.getItem("next", this);
        this._menu.add(this._miNext);
        this._miPrevious = _resources.getItem("previous", this);
        this._menu.add(this._miPrevious);
        this._menu.add(new JSeparator());
        this._miMaximize = _resources.getItem("maximize", this);
        this._menu.add(this._miMaximize);
        if (!this._desktop) {
            this._miMaximize.setEnabled(false);
        }
        this._miCascade = _resources.getItem("cascade", this);
        this._menu.add(this._miCascade);
        if (this._desktop) {
            this._miCascade.setEnabled(false);
        }
        this._menu.add(new JSeparator());
        if (bl) {
            this._miCloseAll = _resources.getItem("closeAll", this);
            this._menu.add(this._miCloseAll);
            this._menu.add(new JSeparator());
        }
        this._bgComponents = new ButtonGroup();
        this.setComponentsMenuItems();
        return this._menu;
    }

    private void resetDesktop() {
        this._frameX = 0;
        this._frameY = 0;
        Dimension dimension = this._framesPane.getSize();
        Dimension dimension2 = this._panelsPane.getSize();
        if (dimension == null) {
            dimension = dimension2 != null ? dimension2 : new Dimension(0, 0);
        } else if ((dimension.width == 0 || dimension.height == 0) && dimension2 != null) {
            dimension = dimension2;
        }
        this._frameMaxWidth = dimension.width < 40 ? 40 : dimension.width;
        this._frameMaxHeight = dimension.height < 40 ? 40 : dimension.height;
    }

    private void computeNextFramePosition() {
        this._frameX += 40;
        this._frameY += 40;
        if (this._frameY + 200 >= this._frameMaxHeight) {
            this._frameY = 0;
        }
        if (this._frameX >= this._frameMaxWidth) {
            this._frameX = 0;
        }
    }

    private void addDesktopComponent(JComponent jComponent) {
        ComponentFrame componentFrame = new ComponentFrame(jComponent, this._scrollable, this._closable);
        if (this._framesListener != null) {
            componentFrame.addPropertyChangeListener(this._framesListener);
            componentFrame.addInternalFrameListener(this._framesListener);
        }
        this._framesPane.add(componentFrame);
        componentFrame.reshape(this._frameX, this._frameY, this._frameMaxWidth, 200);
        this.computeNextFramePosition();
        try {
            componentFrame.setSelected(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void removeDesktopComponent(JComponent jComponent) {
        JInternalFrame[] jInternalFrameArray = this._framesPane.getAllFrames();
        if (jInternalFrameArray == null) {
            return;
        }
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            ComponentFrame componentFrame = (ComponentFrame)jInternalFrameArray[i];
            if (componentFrame.getComponent() != jComponent) continue;
            this._framesPane.remove(componentFrame);
            this.repaint();
            return;
        }
    }

    private void updateDesktopComponent(JComponent jComponent) {
        JInternalFrame[] jInternalFrameArray = this._framesPane.getAllFrames();
        if (jInternalFrameArray == null) {
            return;
        }
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            ComponentFrame componentFrame = (ComponentFrame)jInternalFrameArray[i];
            if (componentFrame.getComponent() != jComponent) continue;
            componentFrame.setTitle(jComponent.getName());
            this.repaint();
            return;
        }
    }

    private void addPanelComponent(JComponent jComponent) {
        ComponentPanel componentPanel = new ComponentPanel(jComponent, this._scrollable);
        this._panelPanes.addElement(componentPanel);
    }

    private void removePanelComponent(JComponent jComponent) {
        for (int i = 0; i < this._panelPanes.size(); ++i) {
            ComponentPanel componentPanel = (ComponentPanel)this._panelPanes.elementAt(i);
            if (componentPanel.getComponent() != jComponent) continue;
            componentPanel.remove(jComponent);
            this._panelPanes.removeElement(componentPanel);
            break;
        }
    }

    private void setComponentsMenuItems() {
        if (this._bgComponents == null) {
            return;
        }
        Enumeration<AbstractButton> enumeration = this._bgComponents.getElements();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
            this._menu.remove(jMenuItem);
        }
        this._bgComponents = new ButtonGroup();
        for (int i = 0; i < this._components.size(); ++i) {
            ComponentRadioButton componentRadioButton = new ComponentRadioButton((JComponent)this._components.elementAt(i));
            this._menu.add(componentRadioButton);
            this._bgComponents.add(componentRadioButton);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) == 4 && this._cardPopup != null) {
            this._cardPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._miNext || actionEvent.getSource() == this._miPrevious) {
            int n = this._namesPane.getSelectedIndex();
            int n2 = this._components.size();
            if (n2 == 0) {
                return;
            }
            if (actionEvent.getSource() == this._miNext) {
                if (++n >= n2) {
                    n = 0;
                }
            } else if (--n < 0) {
                n = n2 - 1;
            }
            this.selectComponent((JComponent)this._components.elementAt(n));
        } else if (actionEvent.getSource() == this._miCascade) {
            this.setDesktopState(true);
        } else if (actionEvent.getSource() == this._miCloseAll) {
            this.removeAllComponents();
        } else if (actionEvent.getSource() == this._miMaximize) {
            this.setDesktopState(false);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this._namesPane.getSelectedIndex();
        if (n < 0 || n > this._components.size()) {
            return;
        }
        JComponent jComponent = (JComponent)this._components.elementAt(n);
        this.selectComponent(jComponent);
    }

    static {
        try {
            _resources = (MenuResourceBundle)ResourceBundle.getBundle("simtools.ui.resources.DesktopCardPanelResource", CustomizedLocale.get());
        }
        catch (Exception exception) {
            System.err.println("Can't load DesktopCardPanel resources");
            System.exit(0);
        }
    }

    public class CardPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private JMenuItem _miClose = _resources.getItem("closeCard", this);

        public CardPopupMenu() {
            this.add(this._miClose);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._miClose) {
                DesktopCardPanel.this.removeComponent(DesktopCardPanel.this.getSelectedComponent());
            }
        }
    }

    public class ComponentRadioButton
    extends JRadioButtonMenuItem
    implements ActionListener {
        JComponent _component;

        public ComponentRadioButton(JComponent jComponent) {
            this._component = jComponent;
            this.setText(this._component.toString());
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                DesktopCardPanel.this.selectComponent(this._component);
            }
        }
    }

    public class FramesListener
    implements PropertyChangeListener,
    InternalFrameListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean bl;
            ComponentFrame componentFrame = (ComponentFrame)propertyChangeEvent.getSource();
            JComponent jComponent = componentFrame.getComponent();
            if (propertyChangeEvent.getPropertyName().equals("maximum") && (bl = (Boolean)propertyChangeEvent.getNewValue()).equals(Boolean.TRUE)) {
                DesktopCardPanel.this.setDesktopState(false);
                DesktopCardPanel.this.selectComponent(jComponent);
            }
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            ComponentFrame componentFrame = (ComponentFrame)internalFrameEvent.getSource();
            componentFrame.setVisible(false);
            if (componentFrame.isSelected()) {
                try {
                    componentFrame.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            DesktopCardPanel.this.removeComponent(componentFrame.getComponent());
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            ComponentFrame componentFrame = (ComponentFrame)internalFrameEvent.getSource();
            DesktopCardPanel.this.selectComponent(componentFrame.getComponent());
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }
    }

    public class ComponentFrame
    extends JInternalFrame {
        private JComponent _component;
        private JScrollPane _scrollPane;

        public ComponentFrame(JComponent jComponent, boolean bl) {
            this(jComponent, bl, true);
        }

        public ComponentFrame(JComponent jComponent, boolean bl, boolean bl2) {
            super("", true, bl2, true, true);
            this._component = jComponent;
            this.setDefaultCloseOperation(0);
            if (bl) {
                this._scrollPane = new JScrollPane(this._component, 22, 32);
                this.getContentPane().add("Center", this._scrollPane);
            } else {
                this.getContentPane().add("Center", this._component);
            }
            if (jComponent.getName() != null) {
                this.setTitle(jComponent.getName());
            }
            this.pack();
            this.show();
        }

        public JComponent getComponent() {
            return this._component;
        }

        public boolean isScrollable() {
            return this._scrollPane != null;
        }
    }

    public class PanelsPaneLayout
    implements LayoutManager {
        private JComponent _mirrored;

        PanelsPaneLayout(JComponent jComponent) {
            this._mirrored = jComponent;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            if (this._mirrored != null) {
                int n = this._mirrored.getSize().width;
                return new Dimension(n, 0);
            }
            if (container.getComponentCount() == 0) {
                return new Dimension(0, 0);
            }
            return container.getSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            if (container.getComponentCount() == 0) {
                return new Dimension(0, 0);
            }
            return container.getComponent(0).getMinimumSize();
        }

        public void layoutContainer(Container container) {
            if (container.getComponentCount() == 0) {
                return;
            }
            Component component = container.getComponent(0);
            Dimension dimension = container.getSize();
            component.setSize(dimension.width, dimension.height);
            component.setLocation(0, 0);
        }
    }

    public class ComponentPanel
    extends JPanel {
        private JComponent _component;
        private JScrollPane _scrollPane;

        public ComponentPanel(JComponent jComponent, boolean bl) {
            super(new BorderLayout());
            this._component = jComponent;
            if (bl) {
                this._scrollPane = new JScrollPane(this._component, 22, 32);
                this.add("Center", this._scrollPane);
            } else {
                this.add("Center", this._component);
            }
        }

        public JComponent getComponent() {
            return this._component;
        }

        public boolean isScrollable() {
            return this._scrollPane != null;
        }
    }
}

