/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.plugins.jfreechart.ChartShape;
import jsynoptic.plugins.jfreechart.SourcePieDataset;
import jsynoptic.plugins.jfreechart.StandardPlotShape;
import jsynoptic.ui.DynamicColorChooser;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.LongAction;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Pie3DPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.ui.ChartPropertyEditPanel;
import org.jfree.data.PieDataset;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.shapes.AbstractShape;
import simtools.ui.ColorMapper;
import simtools.ui.GenericMapper;
import simtools.ui.MapperListener;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;
import simtools.ui.TextMapper;

public class PieChartShape
extends ChartShape
implements ContextualActionProvider,
DataSourceListener,
MapperListener {
    static final long serialVersionUID = 7031896621461605415L;
    public static ResourceBundle resources = ResourceFinder.get((Class)(class$jsynoptic$plugins$jfreechart$PieChartShape == null ? (class$jsynoptic$plugins$jfreechart$PieChartShape = PieChartShape.class$("jsynoptic.plugins.jfreechart.PieChartShape")) : class$jsynoptic$plugins$jfreechart$PieChartShape), (ResourceBundle)StandardPlotShape.resources);
    protected Vector mappers;
    protected transient Vector mapperSources;
    static /* synthetic */ Class class$jsynoptic$plugins$jfreechart$PieChartShape;

    public PieChartShape(JFreeChart jFreeChart) {
        this(jFreeChart, 0, 0, 300, 300);
    }

    public PieChartShape(JFreeChart jFreeChart, int n, int n2, int n3, int n4) {
        super(jFreeChart, n, n2, n3, n4);
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        this.mapperSources = new Vector();
        this.mappers = new Vector();
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("Properties..."));
        if (object instanceof DataSource) {
            vector.add(resources.getString("AddSource"));
        } else if (object instanceof DataSourceCollection) {
            vector.add(resources.getString("SetSources"));
            vector.add(resources.getString("AddSources"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        int n;
        SourcePieDataset sourcePieDataset;
        PiePlot piePlot;
        if (string.equals(resources.getString("Properties..."))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    int n;
                    ChartPropertyEditPanel chartPropertyEditPanel = new ChartPropertyEditPanel(PieChartShape.this.chart);
                    JTabbedPane jTabbedPane = PieChartShape.this.findTab((Container)chartPropertyEditPanel);
                    PlotPanel plotPanel = null;
                    if (jTabbedPane != null) {
                        plotPanel = new PlotPanel();
                        jTabbedPane.add((Component)plotPanel, 0);
                    }
                    if ((n = JOptionPane.showConfirmDialog(null, chartPropertyEditPanel, resources.getString("ChartProperties"), 2, -1)) == 0) {
                        chartPropertyEditPanel.updateChartProperties(PieChartShape.this.chart);
                        if (plotPanel != null) {
                            plotPanel.updateChartProperties();
                        }
                    }
                    PieChartShape.this.notifyChange();
                }
            }.start();
            return true;
        }
        if (string.equals(resources.getString("AddSource"))) {
            try {
                piePlot = (PiePlot)this.chart.getPlot();
                sourcePieDataset = (SourcePieDataset)piePlot.getDataset();
                sourcePieDataset.addSource((DataSource)object);
                this.mappers.add(null);
                this.mapperSources.add(null);
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingDataSource"));
            }
        }
        if (string.equals(resources.getString("AddSources"))) {
            try {
                piePlot = (PiePlot)this.chart.getPlot();
                sourcePieDataset = (SourcePieDataset)piePlot.getDataset();
                sourcePieDataset.addDataSourceCollection((DataSourceCollection)object);
                for (n = 0; n < ((DataSourceCollection)object).size(); ++n) {
                    this.mappers.add(null);
                    this.mapperSources.add(null);
                }
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingDataSourceCollection"));
            }
        }
        if (string.equals(resources.getString("SetSources"))) {
            try {
                piePlot = (PiePlot)this.chart.getPlot();
                sourcePieDataset = (SourcePieDataset)piePlot.getDataset();
                sourcePieDataset.setDataSourceCollection((DataSourceCollection)object);
                this.chart.setTitle(sourcePieDataset.getName());
                for (n = 0; n < this.mappers.size(); ++n) {
                    ColorMapper colorMapper;
                    DataSource dataSource = (DataSource)this.mapperSources.get(n);
                    if (dataSource != null) {
                        dataSource.removeListener((DataSourceListener)this);
                    }
                    if ((colorMapper = (ColorMapper)this.mappers.get(n)) == null) continue;
                    colorMapper.removeListener((MapperListener)this);
                }
                for (n = 0; n < ((DataSourceCollection)object).size(); ++n) {
                    this.mappers.add(null);
                    this.mapperSources.add(null);
                }
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingDataSourceCollection"));
            }
        }
        return true;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    public void mappingChanged(GenericMapper genericMapper) {
        this.notifyChange();
    }

    public void checkMapperChange(DataSource dataSource, long l) {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        SourcePieDataset sourcePieDataset = (SourcePieDataset)piePlot.getDataset();
        boolean bl = false;
        for (int i = 0; i < this.mapperSources.size(); ++i) {
            Paint paint;
            ColorMapper colorMapper;
            if (!dataSource.equals(this.mapperSources.get(i)) || (colorMapper = (ColorMapper)this.mappers.get(i)) == null) continue;
            Paint paint2 = bl ? null : piePlot.getSectionPaint(i);
            piePlot.setSectionPaint(i, colorMapper.getPaint(dataSource, l));
            if (bl || paint2.equals(paint = piePlot.getSectionPaint(i))) continue;
            bl = true;
        }
        if (bl) {
            this.notifyChange();
        }
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        this.checkMapperChange(dataSource, l2);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        this.checkMapperChange(dataSource, l2);
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.mapperSources.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            DataSourcePool.global.writeDataSource(objectOutputStream, (DataSource)this.mapperSources.get(i));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.mapperSources = new Vector();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.mapperSources.add(DataSourcePool.global.readDataSource(objectInputStream));
        }
    }

    protected AbstractShape cloneShape() {
        ChartShape chartShape = (ChartShape)super.cloneShape();
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        SourcePieDataset sourcePieDataset = (SourcePieDataset)piePlot.getDataset();
        ((PiePlot)chartShape.chart.getPlot()).setDataset((PieDataset)sourcePieDataset.cloneSet());
        return chartShape;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PlotPanel
    extends JPanel {
        protected JTextField tfTitle;
        protected JComboBox pcbxcurves;
        protected JComboBox cbxmapper;
        protected JButton pcurvecolor;
        protected JButton pcurvedelete;
        protected JButton editCategories;
        protected JButton beditmapper;
        protected JButton bnewmapper;
        protected JButton bdelmapper;
        protected JTextField pcbxeditortf;
        protected boolean peditLocked;
        protected CbxEntry pactiveEntry;
        protected NumberField tfRatio;
        protected TextMapper mapper;

        public PlotPanel() {
            this.setLayout(new BorderLayout());
            Box box = Box.createVerticalBox();
            this.setName(resources.getString("PlotProperties"));
            PiePlot piePlot = (PiePlot)PieChartShape.this.chart.getPlot();
            SourcePieDataset sourcePieDataset = (SourcePieDataset)piePlot.getDataset();
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel(resources.getString("PlotTitle:")));
            this.tfTitle = new JTextField();
            box2.add(this.tfTitle);
            this.tfTitle.setText(PieChartShape.this.chart.getTitle().getText());
            box.add(box2);
            box2 = Box.createVerticalBox();
            box2.setBorder(BorderFactory.createTitledBorder(resources.getString("Series")));
            Box box3 = Box.createHorizontalBox();
            this.pcbxcurves = new JComboBox();
            box3.add(this.pcbxcurves);
            this.pcurvecolor = new JButton("    ");
            box3.add(this.pcurvecolor);
            this.pcurvedelete = new JButton(resources.getString("Delete"));
            box3.add(this.pcurvedelete);
            box2.add(box3);
            box3 = Box.createHorizontalBox();
            box3.add(new JLabel(resources.getString("ExplodedRatio(>=1)")));
            this.tfRatio = new NumberField(1.0);
            box3.add((Component)this.tfRatio);
            if (!(piePlot instanceof Pie3DPlot)) {
                box2.add(box3);
            }
            box.add(box2);
            this.pcbxcurves.setEditable(true);
            Color color = this.pcurvecolor.getBackground();
            this.pcurvecolor.setFocusPainted(false);
            int n = sourcePieDataset.getItemCount();
            double d = 1.0 / piePlot.getRadius() - 1.0;
            for (int i = 0; i < n; ++i) {
                DataSource dataSource = (DataSource)PieChartShape.this.mapperSources.get(i);
                if (dataSource == null) {
                    dataSource = sourcePieDataset.getSource(i);
                }
                this.pcbxcurves.addItem(new CbxEntry(i, sourcePieDataset.getName(i), (Color)piePlot.getSectionPaint(i), dataSource, (ColorMapper)PieChartShape.this.mappers.get(i), piePlot.getExplodePercent(i) * d + 1.0));
            }
            this.pcbxeditortf = (JTextField)this.pcbxcurves.getEditor().getEditorComponent();
            this.pupdateForEntry(this.pcbxcurves.getSelectedItem());
            this.pcbxcurves.addPopupMenuListener(new PopupMenuListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = true;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = false;
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = false;
                }
            });
            this.pcbxcurves.addItemListener(new ItemListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        this.this$1.pactiveEntry = null;
                    } else {
                        this.this$1.pupdateForEntry(itemEvent.getItem());
                    }
                }
            });
            this.pcbxeditortf.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void updateName() {
                    if (this.this$1.peditLocked || this.this$1.pactiveEntry == null) {
                        return;
                    }
                    this.this$1.pactiveEntry.name = this.this$1.pcbxeditortf.getText();
                }
            });
            this.tfRatio.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateValue();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateValue();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateValue();
                }

                public void updateValue() {
                    if (this.this$1.peditLocked || this.this$1.pactiveEntry == null) {
                        return;
                    }
                    try {
                        this.this$1.pactiveEntry.ratio = Double.parseDouble(this.this$1.tfRatio.getText());
                        if (this.this$1.pactiveEntry.ratio < 1.0) {
                            this.this$1.pactiveEntry.ratio = 1.0;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.this$1.pactiveEntry.ratio = 1.0;
                    }
                }
            });
            this.pcurvecolor.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.pactiveEntry == null) {
                        return;
                    }
                    Color color = DynamicColorChooser.showDialog(null, (String)resources.getString("ChooseAColor"), null, (Color)this.this$1.pactiveEntry.color, (DataSource)this.this$1.pactiveEntry.source, (ColorMapper)this.this$1.pactiveEntry.mapper);
                    if (color == null) {
                        return;
                    }
                    this.this$1.pactiveEntry.color = color;
                    this.this$1.pactiveEntry.source = DynamicColorChooser.getSource();
                    this.this$1.pactiveEntry.mapper = DynamicColorChooser.getMapper();
                    this.this$1.pupdateForEntry(this.this$1.pactiveEntry);
                }
            });
            this.pcurvedelete.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.pactiveEntry == null) {
                        return;
                    }
                    this.this$1.pcbxcurves.removeItem(this.this$1.pactiveEntry);
                }
            });
            this.add((Component)box, "North");
        }

        protected void pupdateForEntry(Object object) {
            this.pactiveEntry = object instanceof CbxEntry ? (CbxEntry)object : null;
            if (this.pactiveEntry == null) {
                return;
            }
            this.tfRatio.setValue(this.pactiveEntry.ratio);
            this.pcurvecolor.setBackground(this.pactiveEntry.color);
        }

        protected void updateChartProperties() {
            PieChartShape.this.chart.setTitle(this.tfTitle.getText());
            PiePlot piePlot = (PiePlot)PieChartShape.this.chart.getPlot();
            SourcePieDataset sourcePieDataset = (SourcePieDataset)piePlot.getDataset();
            int n = sourcePieDataset.getItemCount();
            if (n != this.pcbxcurves.getItemCount()) {
                int n2;
                boolean[] blArray = new boolean[n];
                for (n2 = 0; n2 < this.pcbxcurves.getItemCount(); ++n2) {
                    blArray[((CbxEntry)this.pcbxcurves.getItemAt((int)n2)).datasetIndex] = true;
                }
                for (n2 = n - 1; n2 >= 0; --n2) {
                    DataSource dataSource;
                    if (blArray[n2]) continue;
                    GenericMapper genericMapper = (GenericMapper)PieChartShape.this.mappers.remove(n2);
                    if (genericMapper != null) {
                        genericMapper.removeListener((MapperListener)PieChartShape.this);
                    }
                    if ((dataSource = (DataSource)PieChartShape.this.mapperSources.remove(n2)) != null) {
                        dataSource.removeListener((DataSourceListener)PieChartShape.this);
                    }
                    sourcePieDataset.removeSource(n2);
                }
            }
            int n3 = this.pcbxcurves.getItemCount();
            double d = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < n3; ++i) {
                CbxEntry cbxEntry = (CbxEntry)this.pcbxcurves.getItemAt(i);
                d = Math.max(cbxEntry.ratio, d);
            }
            double d2 = d - 1.0;
            for (int i = 0; i < n3; ++i) {
                CbxEntry cbxEntry = (CbxEntry)this.pcbxcurves.getItemAt(i);
                sourcePieDataset.setName(i, cbxEntry.name);
                DataSource dataSource = (DataSource)PieChartShape.this.mapperSources.get(i);
                if (cbxEntry.source == null && dataSource != null) {
                    dataSource.removeListener((DataSourceListener)PieChartShape.this);
                }
                PieChartShape.this.mapperSources.set(i, cbxEntry.source);
                if (cbxEntry.source != null) {
                    cbxEntry.source.addListener((DataSourceListener)PieChartShape.this);
                }
                ColorMapper colorMapper = (ColorMapper)PieChartShape.this.mappers.get(i);
                if (cbxEntry.mapper == null && colorMapper != null) {
                    colorMapper.removeListener((MapperListener)PieChartShape.this);
                }
                PieChartShape.this.mappers.set(i, cbxEntry.mapper);
                if (cbxEntry.mapper != null) {
                    cbxEntry.mapper.addListener((MapperListener)PieChartShape.this);
                }
                if (cbxEntry.mapper != null && cbxEntry.source != null) {
                    cbxEntry.mapper.setDefaultPaint((Paint)cbxEntry.color);
                    piePlot.setSectionPaint(i, cbxEntry.mapper.getPaint(cbxEntry.source));
                } else {
                    piePlot.setSectionPaint(i, (Paint)cbxEntry.color);
                }
                piePlot.setExplodePercent(i, d2 == 0.0 ? 0.0 : (cbxEntry.ratio - 1.0) / d2);
            }
            piePlot.setRadius(1.0 / d);
        }
    }

    protected static class CbxEntry {
        public int datasetIndex;
        public String name;
        public Color color;
        public DataSource source;
        public ColorMapper mapper;
        public double ratio;

        public CbxEntry(int n, String string, Color color, DataSource dataSource, ColorMapper colorMapper, double d) {
            this.name = string;
            this.datasetIndex = n;
            this.color = color;
            this.source = dataSource;
            this.mapper = colorMapper;
            this.ratio = d;
        }

        public String toString() {
            return this.name;
        }
    }
}

