/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.plugins.jfreechart.ChartShape;
import jsynoptic.plugins.jfreechart.JSynopticStandardXYItemRenderer;
import jsynoptic.plugins.jfreechart.JSynopticXYItemRenderer;
import jsynoptic.plugins.jfreechart.SourceXYDataset;
import jsynoptic.ui.DynamicColorChooser;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.LongAction;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.ui.ChartPropertyEditPanel;
import org.jfree.data.XYDataset;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.shapes.AbstractShape;
import simtools.shapes.AxisLabelFormatter;
import simtools.ui.ActionCheckBox;
import simtools.ui.ColorMapper;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;

public class StandardPlotShape
extends ChartShape
implements ContextualActionProvider {
    static final long serialVersionUID = 4663313906061456914L;
    public static ResourceBundle resources = ResourceFinder.get((Class)(class$jsynoptic$plugins$jfreechart$StandardPlotShape == null ? (class$jsynoptic$plugins$jfreechart$StandardPlotShape = StandardPlotShape.class$("jsynoptic.plugins.jfreechart.StandardPlotShape")) : class$jsynoptic$plugins$jfreechart$StandardPlotShape));
    static /* synthetic */ Class class$jsynoptic$plugins$jfreechart$StandardPlotShape;

    public StandardPlotShape(JFreeChart jFreeChart) {
        this(jFreeChart, 0, 0, 400, 300);
    }

    public StandardPlotShape(JFreeChart jFreeChart, int n, int n2, int n3, int n4) {
        super(jFreeChart, n, n2, n3, n4);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        NumberAxis numberAxis = new NumberAxis();
        xYPlot.setDomainAxis((ValueAxis)numberAxis);
        numberAxis.setAutoRange(true);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        numberAxis.setAutoRange(true);
        if (valueAxis instanceof NumberAxis) {
            ((NumberAxis)valueAxis).setAutoRangeIncludesZero(false);
        }
        xYPlot.setRenderer((XYItemRenderer)new JSynopticStandardXYItemRenderer());
        xYPlot.setRangeCrosshairLockedOnData(false);
        xYPlot.setDomainCrosshairLockedOnData(false);
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return new String[]{"mouseover"};
        }
        if (n == 4) {
            return new String[]{"mouseout"};
        }
        if (n == 5) {
            return null;
        }
        if (n == 1) {
            // empty if block
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("Properties..."));
        XYPlot xYPlot = this.chart.getXYPlot();
        SourceXYDataset sourceXYDataset = (SourceXYDataset)xYPlot.getDataset();
        if (object instanceof DataSource) {
            vector.add(resources.getString("setX"));
            if (sourceXYDataset.getSeriesCount() != 0) {
                vector.add(resources.getString("addY"));
                if (sourceXYDataset.getSeriesCount() >= 1 && sourceXYDataset.getYSource(0) != null) {
                    vector.add(resources.getString("addSecY"));
                }
            }
        } else if (object instanceof DataSourceCollection) {
            vector.add(resources.getString("setXY1Yn"));
            if (sourceXYDataset.getSeriesCount() != 0) {
                vector.add(resources.getString("addY1Yn"));
            }
        }
        if (vector.size() == 0) {
            JSynoptic.setStatus((String)resources.getString("noSource"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        String string2;
        Object object2;
        Object object3;
        XYPlot xYPlot;
        if (string.equals("mouseover")) {
            if (this.chartRenderingInfo == null) {
                return false;
            }
            xYPlot = this.chart.getXYPlot();
            object3 = this.chartRenderingInfo.getPlotInfo();
            object2 = object3.getDataArea();
            if (((Rectangle2D)object2).contains(d, d2)) {
                ValueAxis valueAxis;
                xYPlot.setRangeCrosshairVisible(true);
                xYPlot.setDomainCrosshairVisible(true);
                string2 = "";
                ValueAxis valueAxis2 = xYPlot.getDomainAxis();
                if (valueAxis2 != null) {
                    double d3 = valueAxis2.translateJava2DToValue(d, object3.getDataArea(), xYPlot.getDomainAxisEdge());
                    xYPlot.setDomainCrosshairValue(d3, false);
                    String string3 = valueAxis2.getLabel();
                    string2 = string3 != null && !string3.equals("") ? string2 + string3 : string2 + resources.getString("X");
                    string2 = string2 + "=" + AxisLabelFormatter.labelFormat((double)d3);
                }
                if ((valueAxis = xYPlot.getRangeAxis()) != null) {
                    String string4;
                    double d4 = valueAxis.translateJava2DToValue(d2, object3.getDataArea(), xYPlot.getRangeAxisEdge());
                    xYPlot.setRangeCrosshairValue(d4, false);
                    if (!string2.equals("")) {
                        string2 = string2 + "   ";
                    }
                    string2 = (string4 = valueAxis.getLabel()) != null && !string4.equals("") ? string2 + string4 : string2 + resources.getString("Y");
                    string2 = string2 + "=" + AxisLabelFormatter.labelFormat((double)d4);
                }
                this.notifyChange(((RectangularShape)object2).getBounds());
                if (!string2.equals("")) {
                    JSynoptic.setStatus((String)string2);
                }
            } else {
                xYPlot.setRangeCrosshairVisible(false);
                xYPlot.setDomainCrosshairVisible(false);
            }
        }
        if (string.equals("mouseout")) {
            xYPlot = this.chart.getXYPlot();
            xYPlot.setRangeCrosshairVisible(false);
            xYPlot.setDomainCrosshairVisible(false);
            JSynoptic.setStatus((String)"");
        }
        if (string.equals(resources.getString("Properties..."))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    int n;
                    ChartPropertyEditPanel chartPropertyEditPanel = new ChartPropertyEditPanel(StandardPlotShape.this.chart);
                    JTabbedPane jTabbedPane = StandardPlotShape.this.findTab((Container)chartPropertyEditPanel);
                    PlotPanel plotPanel = null;
                    if (jTabbedPane != null) {
                        plotPanel = new PlotPanel();
                        jTabbedPane.add((Component)plotPanel, 0);
                    }
                    if ((n = JOptionPane.showConfirmDialog(null, chartPropertyEditPanel, resources.getString("ChartProperties"), 2, -1)) == 0) {
                        chartPropertyEditPanel.updateChartProperties(StandardPlotShape.this.chart);
                        if (plotPanel != null) {
                            plotPanel.updateChartProperties();
                        }
                    }
                    StandardPlotShape.this.notifyChange();
                }
            }.start();
            return true;
        }
        if (string.equals(resources.getString("setXY1Yn"))) {
            try {
                xYPlot = this.chart.getXYPlot();
                object3 = (SourceXYDataset)xYPlot.getDataset();
                ((SourceXYDataset)((Object)object3)).setDataSourceCollection((DataSourceCollection)object);
                this.chart.setTitle(((SourceXYDataset)((Object)object3)).getName());
                xYPlot.getDomainAxis().setLabel(((SourceXYDataset)((Object)object3)).getXLabel(0));
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingDataSourceCollection"));
            }
        }
        if (string.equals(resources.getString("addY1Yn"))) {
            try {
                xYPlot = this.chart.getXYPlot();
                object3 = (SourceXYDataset)xYPlot.getDataset();
                ((SourceXYDataset)((Object)object3)).addDataSourceCollection((DataSourceCollection)object);
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingDataSourceCollection"));
            }
        }
        if (string.equals(resources.getString("setX"))) {
            try {
                xYPlot = this.chart.getXYPlot();
                object3 = (SourceXYDataset)xYPlot.getDataset();
                ((SourceXYDataset)((Object)object3)).setXSource((DataSource)object);
                xYPlot.getDomainAxis().setLabel(((SourceXYDataset)((Object)object3)).getXLabel(0));
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingXDataSource"));
            }
        }
        if (string.equals(resources.getString("addY"))) {
            try {
                xYPlot = this.chart.getXYPlot();
                object3 = (SourceXYDataset)xYPlot.getDataset();
                ((SourceXYDataset)((Object)object3)).addYSource((DataSource)object);
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileAddingYDataSource"));
            }
        }
        if (string.equals(resources.getString("addSecY"))) {
            try {
                xYPlot = this.chart.getXYPlot();
                object3 = (SourceXYDataset)xYPlot.getDataset();
                object2 = (SourceXYDataset)xYPlot.getSecondaryDataset(0);
                if (object2 == null) {
                    object2 = new SourceXYDataset();
                    ((SourceXYDataset)((Object)object2)).setXSource(((SourceXYDataset)((Object)object3)).getXSource(0));
                    ((SourceXYDataset)((Object)object2)).addYSource((DataSource)object);
                    xYPlot.setSecondaryDataset(0, (XYDataset)object2);
                    if (xYPlot.getSecondaryRangeAxis(0) == null) {
                        string2 = new NumberAxis();
                        string2.setAutoRange(true);
                        xYPlot.setSecondaryRangeAxis(0, (ValueAxis)string2);
                    }
                    xYPlot.mapSecondaryDatasetToRangeAxis(0, new Integer(0));
                    xYPlot.mapSecondaryDatasetToDomainAxis(0, null);
                    if (xYPlot.getSecondaryRenderer(0) == null) {
                        xYPlot.setSecondaryRenderer(0, (XYItemRenderer)new JSynopticStandardXYItemRenderer(2));
                    }
                } else {
                    ((SourceXYDataset)((Object)object2)).addYSource((DataSource)object);
                }
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileAddingYDataSource"));
            }
        }
        return true;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    protected AbstractShape cloneShape() {
        ChartShape chartShape = (ChartShape)super.cloneShape();
        SourceXYDataset sourceXYDataset = (SourceXYDataset)this.chart.getXYPlot().getDataset();
        chartShape.chart.getXYPlot().setDataset((XYDataset)sourceXYDataset.cloneSet());
        return chartShape;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PlotPanel
    extends JPanel {
        ActionCheckBox cbautox;
        ActionCheckBox cbfixedautox;
        NumberField nffixedautox;
        NumberField tfpxmin;
        NumberField tfpxmax;
        JLabel lpxmin;
        JLabel lpxmax;
        JTextField tfTitle;
        Color noCurveColor;
        ActionCheckBox pcbautoy;
        ActionCheckBox pcbfixedautoy;
        NumberField pnffixedautoy;
        NumberField ptfpymin;
        NumberField ptfpymax;
        JLabel plpymin;
        JLabel plpymax;
        JComboBox pcbxcurves;
        JButton pcurvecolor;
        JButton pcurvedelete;
        CbxEntry pactiveEntry;
        JTextField pcbxeditortf;
        boolean peditLocked;
        ActionCheckBox scbautoy;
        ActionCheckBox scbfixedautoy;
        NumberField snffixedautoy;
        NumberField stfpymin;
        NumberField stfpymax;
        JLabel slpymin;
        JLabel slpymax;
        JComboBox scbxcurves;
        JButton scurvecolor;
        JButton scurvedelete;
        CbxEntry sactiveEntry;
        JTextField scbxeditortf;
        boolean seditLocked;

        public PlotPanel() {
            DataSource dataSource;
            DataSource dataSource2;
            int n;
            this.setLayout(new BorderLayout());
            Box box = Box.createVerticalBox();
            this.setName(resources.getString("PlotProperties"));
            XYPlot xYPlot = StandardPlotShape.this.chart.getXYPlot();
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel(resources.getString("PlotTitle:")));
            this.tfTitle = new JTextField();
            box2.add(this.tfTitle);
            this.tfTitle.setText(StandardPlotShape.this.chart.getTitle().getText());
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("XAxis")));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.cbautox = new ActionCheckBox(this, resources.getString("Auto-update"), xYPlot.getDomainAxis().isAutoRange()){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cbfixedautox.setEnabled(this.isSelected());
                    this.this$1.cbfixedautox.apply();
                    this.this$1.lpxmin.setEnabled(!this.isSelected());
                    this.this$1.lpxmax.setEnabled(!this.isSelected());
                    this.this$1.tfpxmin.setEnabled(!this.isSelected());
                    this.this$1.tfpxmax.setEnabled(!this.isSelected());
                }
            };
            jPanel.add((Component)this.cbautox);
            double d = xYPlot.getDomainAxis().getFixedAutoRange();
            this.cbfixedautox = new ActionCheckBox(this, resources.getString("FixedRange"), d != 0.0){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.nffixedautox.setEnabled(this.isSelected() && this.isEnabled());
                }
            };
            jPanel.add((Component)this.cbfixedautox);
            this.nffixedautox = new NumberField(d, 10);
            jPanel.add((Component)this.nffixedautox);
            box2.add(jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.lpxmin = new JLabel(resources.getString("minLabel"));
            jPanel.add(this.lpxmin);
            this.tfpxmin = new NumberField(10);
            jPanel.add((Component)this.tfpxmin);
            this.tfpxmin.setValue(xYPlot.getDomainAxis().getLowerBound());
            this.lpxmax = new JLabel(resources.getString("maxLabel"));
            jPanel.add(this.lpxmax);
            this.tfpxmax = new NumberField(10);
            jPanel.add((Component)this.tfpxmax);
            this.tfpxmax.setValue(xYPlot.getDomainAxis().getUpperBound());
            box2.add(jPanel);
            this.cbautox.apply();
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("YAxis")));
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.pcbautoy = new ActionCheckBox(this, resources.getString("Auto-update"), xYPlot.getRangeAxis().isAutoRange()){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.pcbfixedautoy.setEnabled(this.isSelected());
                    this.this$1.pcbfixedautoy.apply();
                    this.this$1.plpymin.setEnabled(!this.isSelected());
                    this.this$1.plpymax.setEnabled(!this.isSelected());
                    this.this$1.ptfpymin.setEnabled(!this.isSelected());
                    this.this$1.ptfpymax.setEnabled(!this.isSelected());
                }
            };
            jPanel.add((Component)this.pcbautoy);
            d = xYPlot.getRangeAxis().getFixedAutoRange();
            this.pcbfixedautoy = new ActionCheckBox(this, resources.getString("FixedRange"), d != 0.0){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.pnffixedautoy.setEnabled(this.isSelected() && this.isEnabled());
                }
            };
            jPanel.add((Component)this.pcbfixedautoy);
            this.pnffixedautoy = new NumberField(d, 8);
            jPanel.add((Component)this.pnffixedautoy);
            this.plpymin = new JLabel(resources.getString("minLabel"));
            jPanel.add(this.plpymin);
            this.ptfpymin = new NumberField(8);
            jPanel.add((Component)this.ptfpymin);
            this.ptfpymin.setValue(xYPlot.getRangeAxis().getLowerBound());
            this.plpymax = new JLabel(resources.getString("maxLabel"));
            jPanel.add(this.plpymax);
            this.ptfpymax = new NumberField(8);
            jPanel.add((Component)this.ptfpymax);
            this.ptfpymax.setValue(xYPlot.getRangeAxis().getUpperBound());
            box2.add(jPanel);
            this.pcbautoy.apply();
            box2.add(jPanel);
            Box box3 = Box.createHorizontalBox();
            box3.add(new JLabel(resources.getString("Curves:")));
            this.pcbxcurves = new JComboBox();
            box3.add(this.pcbxcurves);
            this.pcurvecolor = new JButton("    ");
            box3.add(this.pcurvecolor);
            this.pcurvedelete = new JButton(resources.getString("Delete"));
            box3.add(this.pcurvedelete);
            box2.add(box3);
            box.add(box2);
            this.pcbxcurves.setEditable(true);
            this.noCurveColor = this.pcurvecolor.getBackground();
            this.pcurvecolor.setFocusPainted(false);
            SourceXYDataset sourceXYDataset = (SourceXYDataset)xYPlot.getDataset();
            int n2 = sourceXYDataset.getSeriesCount();
            JSynopticXYItemRenderer jSynopticXYItemRenderer = (JSynopticXYItemRenderer)xYPlot.getRenderer();
            for (n = 0; n < n2; ++n) {
                dataSource2 = jSynopticXYItemRenderer.getDataSource(n);
                if (dataSource2 == null && (dataSource = DataInfo.getLinkedSource((Object)(dataSource2 = sourceXYDataset.getYSource(n)))) != null) {
                    dataSource2 = dataSource;
                }
                this.pcbxcurves.addItem(new CbxEntry(n, sourceXYDataset.getSeriesName(n), (Color)jSynopticXYItemRenderer.getSeriesPaint(n), dataSource2, jSynopticXYItemRenderer.getColorMapper(n)));
            }
            this.pcbxeditortf = (JTextField)this.pcbxcurves.getEditor().getEditorComponent();
            this.pupdateForEntry(this.pcbxcurves.getSelectedItem());
            this.pcbxcurves.addPopupMenuListener(new PopupMenuListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = true;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = false;
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = false;
                }
            });
            this.pcbxcurves.addItemListener(new ItemListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        this.this$1.pactiveEntry = null;
                    } else {
                        this.this$1.pupdateForEntry(itemEvent.getItem());
                    }
                }
            });
            this.pcbxeditortf.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void updateName() {
                    if (this.this$1.peditLocked || this.this$1.pactiveEntry == null) {
                        return;
                    }
                    this.this$1.pactiveEntry.name = this.this$1.pcbxeditortf.getText();
                }
            });
            this.pcurvecolor.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.pactiveEntry == null) {
                        return;
                    }
                    Color color = DynamicColorChooser.showDialog(null, (String)resources.getString("ChooseAColor"), null, (Color)this.this$1.pactiveEntry.color, (DataSource)this.this$1.pactiveEntry.source, (ColorMapper)this.this$1.pactiveEntry.mapper);
                    if (color == null) {
                        return;
                    }
                    this.this$1.pactiveEntry.color = color;
                    this.this$1.pactiveEntry.source = DynamicColorChooser.getSource();
                    this.this$1.pactiveEntry.mapper = DynamicColorChooser.getMapper();
                    this.this$1.pupdateForEntry(this.this$1.pactiveEntry);
                }
            });
            this.pcurvedelete.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.pactiveEntry == null) {
                        return;
                    }
                    this.this$1.pcbxcurves.removeItem(this.this$1.pactiveEntry);
                }
            });
            if (xYPlot.getSecondaryRangeAxis(0) != null) {
                box2 = new Box(1);
                box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("SecondaryYAxis")));
                jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout(0));
                this.scbautoy = new ActionCheckBox(this, resources.getString("Auto-update"), xYPlot.getSecondaryRangeAxis(0).isAutoRange()){
                    private final /* synthetic */ PlotPanel this$1;
                    {
                        this.this$1 = plotPanel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$1.scbfixedautoy.setEnabled(this.isSelected());
                        this.this$1.scbfixedautoy.apply();
                        this.this$1.slpymin.setEnabled(!this.isSelected());
                        this.this$1.slpymax.setEnabled(!this.isSelected());
                        this.this$1.stfpymin.setEnabled(!this.isSelected());
                        this.this$1.stfpymax.setEnabled(!this.isSelected());
                    }
                };
                jPanel.add((Component)this.scbautoy);
                d = xYPlot.getSecondaryRangeAxis(0).getFixedAutoRange();
                this.scbfixedautoy = new ActionCheckBox(this, resources.getString("FixedRange"), d != 0.0){
                    private final /* synthetic */ PlotPanel this$1;
                    {
                        this.this$1 = plotPanel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$1.snffixedautoy.setEnabled(this.isSelected() && this.isEnabled());
                    }
                };
                jPanel.add((Component)this.scbfixedautoy);
                this.snffixedautoy = new NumberField(d, 8);
                jPanel.add((Component)this.snffixedautoy);
                this.slpymin = new JLabel(resources.getString("minLabel"));
                jPanel.add(this.slpymin);
                this.stfpymin = new NumberField(8);
                jPanel.add((Component)this.stfpymin);
                this.stfpymin.setValue(xYPlot.getSecondaryRangeAxis(0).getLowerBound());
                this.slpymax = new JLabel(resources.getString("maxLabel"));
                jPanel.add(this.slpymax);
                this.stfpymax = new NumberField(8);
                jPanel.add((Component)this.stfpymax);
                this.stfpymax.setValue(xYPlot.getSecondaryRangeAxis(0).getUpperBound());
                box2.add(jPanel);
                this.scbautoy.apply();
                box2.add(jPanel);
                box3 = Box.createHorizontalBox();
                box3.add(new JLabel(resources.getString("Curves:")));
                this.scbxcurves = new JComboBox();
                box3.add(this.scbxcurves);
                this.scurvecolor = new JButton("    ");
                box3.add(this.scurvecolor);
                this.scurvedelete = new JButton(resources.getString("Delete"));
                box3.add(this.scurvedelete);
                box2.add(box3);
                box.add(box2);
                this.scbxcurves.setEditable(true);
                this.scurvecolor.setFocusPainted(false);
                sourceXYDataset = (SourceXYDataset)xYPlot.getSecondaryDataset(0);
                n2 = sourceXYDataset.getSeriesCount();
                jSynopticXYItemRenderer = (JSynopticXYItemRenderer)xYPlot.getSecondaryRenderer(0);
                for (n = 0; n < n2; ++n) {
                    dataSource2 = jSynopticXYItemRenderer.getDataSource(n);
                    if (dataSource2 == null && (dataSource = DataInfo.getLinkedSource((Object)(dataSource2 = sourceXYDataset.getYSource(n)))) != null) {
                        dataSource2 = dataSource;
                    }
                    this.scbxcurves.addItem(new CbxEntry(n, sourceXYDataset.getSeriesName(n), (Color)jSynopticXYItemRenderer.getSeriesPaint(n), dataSource2, jSynopticXYItemRenderer.getColorMapper(n)));
                }
                this.scbxeditortf = (JTextField)this.scbxcurves.getEditor().getEditorComponent();
                this.supdateForEntry(this.scbxcurves.getSelectedItem());
                this.scbxcurves.addPopupMenuListener(new PopupMenuListener(this){
                    private final /* synthetic */ PlotPanel this$1;
                    {
                        this.this$1 = plotPanel;
                    }

                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                        this.this$1.seditLocked = true;
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        this.this$1.seditLocked = false;
                    }

                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        this.this$1.seditLocked = false;
                    }
                });
                this.scbxcurves.addItemListener(new ItemListener(this){
                    private final /* synthetic */ PlotPanel this$1;
                    {
                        this.this$1 = plotPanel;
                    }

                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 2) {
                            this.this$1.sactiveEntry = null;
                        } else {
                            this.this$1.supdateForEntry(itemEvent.getItem());
                        }
                    }
                });
                this.scbxeditortf.getDocument().addDocumentListener(new DocumentListener(this){
                    private final /* synthetic */ PlotPanel this$1;
                    {
                        this.this$1 = plotPanel;
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.updateName();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.updateName();
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.updateName();
                    }

                    public void updateName() {
                        if (this.this$1.seditLocked || this.this$1.sactiveEntry == null) {
                            return;
                        }
                        this.this$1.sactiveEntry.name = this.this$1.scbxeditortf.getText();
                    }
                });
                this.scurvecolor.addActionListener(new ActionListener(this){
                    private final /* synthetic */ PlotPanel this$1;
                    {
                        this.this$1 = plotPanel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.this$1.sactiveEntry == null) {
                            return;
                        }
                        Color color = DynamicColorChooser.showDialog(null, (String)resources.getString("ChooseAColor"), null, (Color)this.this$1.sactiveEntry.color, (DataSource)this.this$1.sactiveEntry.source, (ColorMapper)this.this$1.sactiveEntry.mapper);
                        if (color == null) {
                            return;
                        }
                        this.this$1.sactiveEntry.color = color;
                        this.this$1.sactiveEntry.source = DynamicColorChooser.getSource();
                        this.this$1.sactiveEntry.mapper = DynamicColorChooser.getMapper();
                        this.this$1.supdateForEntry(this.this$1.sactiveEntry);
                    }
                });
                this.scurvedelete.addActionListener(new ActionListener(this){
                    private final /* synthetic */ PlotPanel this$1;
                    {
                        this.this$1 = plotPanel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.this$1.sactiveEntry == null) {
                            return;
                        }
                        this.this$1.scbxcurves.removeItem(this.this$1.sactiveEntry);
                    }
                });
            }
            this.add((Component)box, "North");
        }

        protected void pupdateForEntry(Object object) {
            this.pactiveEntry = object instanceof CbxEntry ? (CbxEntry)object : null;
            if (this.pactiveEntry == null) {
                return;
            }
            this.pcurvecolor.setBackground(this.pactiveEntry.color);
        }

        protected void supdateForEntry(Object object) {
            this.sactiveEntry = object instanceof CbxEntry ? (CbxEntry)object : null;
            if (this.sactiveEntry == null) {
                return;
            }
            this.scurvecolor.setBackground(this.sactiveEntry.color);
        }

        protected void updateChartProperties() {
            int n;
            Object object;
            ValueAxis valueAxis = StandardPlotShape.this.chart.getXYPlot().getDomainAxis();
            valueAxis.setAutoRange(this.cbautox.isSelected());
            if (this.nffixedautox.isEnabled()) {
                valueAxis.setFixedAutoRange(this.nffixedautox.getDoubleValue());
            }
            if (this.tfpxmin.isEnabled() && this.tfpxmax.isEnabled()) {
                valueAxis.setRange(this.tfpxmin.getDoubleValue(), this.tfpxmax.getDoubleValue());
            }
            ValueAxis valueAxis2 = StandardPlotShape.this.chart.getXYPlot().getRangeAxis();
            valueAxis2.setAutoRange(this.pcbautoy.isSelected());
            if (this.pnffixedautoy.isEnabled()) {
                valueAxis2.setFixedAutoRange(this.pnffixedautoy.getDoubleValue());
            }
            if (this.ptfpymin.isEnabled() && this.ptfpymax.isEnabled()) {
                valueAxis2.setRange(this.ptfpymin.getDoubleValue(), this.ptfpymax.getDoubleValue());
            }
            StandardPlotShape.this.chart.setTitle(this.tfTitle.getText());
            XYPlot xYPlot = StandardPlotShape.this.chart.getXYPlot();
            SourceXYDataset sourceXYDataset = (SourceXYDataset)xYPlot.getDataset();
            int n2 = sourceXYDataset.getSeriesCount();
            if (n2 != this.pcbxcurves.getItemCount()) {
                boolean[] blArray = new boolean[n2];
                for (int i = 0; i < this.pcbxcurves.getItemCount(); ++i) {
                    blArray[((CbxEntry)this.pcbxcurves.getItemAt((int)i)).datasetIndex] = true;
                }
                object = (JSynopticXYItemRenderer)xYPlot.getRenderer();
                for (n = n2 - 1; n >= 0; --n) {
                    if (blArray[n]) continue;
                    sourceXYDataset.removeXSource(n);
                    object.removeColorMapper(n);
                    object.removeDataSource(n);
                }
            }
            for (int i = 0; i < this.pcbxcurves.getItemCount(); ++i) {
                object = (CbxEntry)this.pcbxcurves.getItemAt(i);
                sourceXYDataset.setName(i, ((CbxEntry)object).name);
                JSynopticXYItemRenderer jSynopticXYItemRenderer = (JSynopticXYItemRenderer)xYPlot.getRenderer();
                jSynopticXYItemRenderer.setSeriesPaint(i, ((CbxEntry)object).color);
                jSynopticXYItemRenderer.setDataSource(i, ((CbxEntry)object).source);
                jSynopticXYItemRenderer.setColorMapper(i, ((CbxEntry)object).mapper);
            }
            if (xYPlot.getSecondaryRangeAxis(0) != null) {
                sourceXYDataset = (SourceXYDataset)xYPlot.getSecondaryDataset(0);
                n2 = sourceXYDataset.getSeriesCount();
                if (n2 != this.scbxcurves.getItemCount()) {
                    boolean[] blArray = new boolean[n2];
                    for (int i = 0; i < this.scbxcurves.getItemCount(); ++i) {
                        blArray[((CbxEntry)this.scbxcurves.getItemAt((int)i)).datasetIndex] = true;
                    }
                    object = (JSynopticXYItemRenderer)xYPlot.getSecondaryRenderer(0);
                    for (n = n2 - 1; n >= 0; --n) {
                        if (blArray[n]) continue;
                        sourceXYDataset.removeXSource(n);
                        object.removeColorMapper(n);
                        object.removeDataSource(n);
                    }
                }
                for (int i = 0; i < this.scbxcurves.getItemCount(); ++i) {
                    object = (CbxEntry)this.scbxcurves.getItemAt(i);
                    sourceXYDataset.setName(i, ((CbxEntry)object).name);
                    JSynopticXYItemRenderer jSynopticXYItemRenderer = (JSynopticXYItemRenderer)xYPlot.getSecondaryRenderer(0);
                    jSynopticXYItemRenderer.setSeriesPaint(i, ((CbxEntry)object).color);
                    jSynopticXYItemRenderer.setDataSource(i, ((CbxEntry)object).source);
                    jSynopticXYItemRenderer.setColorMapper(i, ((CbxEntry)object).mapper);
                }
            }
        }
    }

    protected static class CbxEntry {
        public int datasetIndex;
        public String name;
        public Color color;
        public DataSource source;
        public ColorMapper mapper;

        public CbxEntry(int n, String string, Color color, DataSource dataSource, ColorMapper colorMapper) {
            this.name = string;
            this.datasetIndex = n;
            this.color = color;
            this.source = dataSource;
            this.mapper = colorMapper;
        }

        public String toString() {
            return this.name;
        }
    }
}

