/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Panel;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.Packager;
import com.izforge.izpack.compiler.PackagerListener;
import com.izforge.izpack.event.CompilerListener;
import com.izforge.izpack.installer.VariableSubstitutor;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import org.apache.tools.ant.DirectoryScanner;

public class Compiler
extends Thread {
    public static final String VERSION = "1.0";
    public static final String IZPACK_VERSION = "3.7.2 (build 2005.04.22)";
    public static final String STANDARD = "standard";
    public static final String WEB = "web";
    public static String IZPACK_HOME = ".";
    private static boolean YES = true;
    private static boolean NO = false;
    private static File home = new File(IZPACK_HOME);
    protected String filename;
    protected String basedir;
    protected String kind;
    protected String output;
    protected PackagerListener packagerListener;
    protected List compilerListeners;
    private Packager packager = null;
    private boolean compileFailed = true;

    public Compiler(String filename, String basedir, String kind, String output) {
        this.filename = filename;
        this.basedir = basedir;
        this.kind = kind;
        this.output = output;
    }

    public void setPackagerListener(PackagerListener listener) {
        this.packagerListener = listener;
    }

    public void compile() {
        this.start();
    }

    public void run() {
        try {
            this.executeCompiler();
        }
        catch (CompilerException ce) {
            System.out.println(ce.getMessage() + "\n");
        }
        catch (Exception e) {
            if (Debug.stackTracing()) {
                e.printStackTrace();
            }
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    public void executeCompiler() throws Exception {
        File base = new File(this.basedir).getAbsoluteFile();
        if (!base.canRead() || !base.isDirectory()) {
            throw new CompilerException("Invalid base directory: " + base);
        }
        XMLElement data = this.getXMLTree();
        this.packager = new Packager();
        this.packager.setPackagerListener(this.packagerListener);
        this.addCustomListeners(data);
        this.addVariables(data);
        this.addInfo(data);
        this.addGUIPrefs(data);
        this.addLangpacks(data);
        this.addResources(data);
        this.addNativeLibraries(data);
        this.addJars(data);
        this.addPanels(data);
        this.addPacks(data);
        this.packager.createInstaller(new File(this.output));
        this.compileFailed = false;
    }

    public boolean wasSuccessful() {
        return !this.compileFailed;
    }

    protected void addGUIPrefs(XMLElement data) throws CompilerException {
        this.notifyCompilerListener("addGUIPrefs", 1, data);
        XMLElement gp = data.getFirstChildNamed("guiprefs");
        GUIPrefs prefs = new GUIPrefs();
        if (gp != null) {
            prefs.resizable = this.requireYesNoAttribute(gp, "resizable");
            prefs.width = this.requireIntAttribute(gp, "width");
            prefs.height = this.requireIntAttribute(gp, "height");
            Iterator it = gp.getChildrenNamed("laf").iterator();
            while (it.hasNext()) {
                XMLElement laf = (XMLElement)it.next();
                String lafName = this.requireAttribute(laf, "name");
                this.requireChildNamed(laf, "os");
                Iterator oit = laf.getChildrenNamed("os").iterator();
                while (oit.hasNext()) {
                    XMLElement os = (XMLElement)oit.next();
                    String osName = this.requireAttribute(os, "family");
                    prefs.lookAndFeelMapping.put(osName, lafName);
                }
                Iterator pit = laf.getChildrenNamed("param").iterator();
                TreeMap<String, String> params = new TreeMap<String, String>();
                while (pit.hasNext()) {
                    XMLElement param = (XMLElement)pit.next();
                    String name = this.requireAttribute(param, "name");
                    String value = this.requireAttribute(param, "value");
                    params.put(name, value);
                }
                prefs.lookAndFeelParams.put(lafName, params);
            }
            it = gp.getChildrenNamed("modifier").iterator();
            while (it.hasNext()) {
                XMLElement curentModifier = (XMLElement)it.next();
                String key = this.requireAttribute(curentModifier, "key");
                String value = this.requireAttribute(curentModifier, "value");
                prefs.modifier.put(key, value);
            }
            HashMap<String, String> lafMap = new HashMap<String, String>();
            lafMap.put("liquid", "liquidlnf.jar");
            lafMap.put("kunststoff", "kunststoff.jar");
            lafMap.put("metouia", "metouia.jar");
            lafMap.put("looks", "looks.jar");
            Iterator kit = prefs.lookAndFeelMapping.keySet().iterator();
            while (kit.hasNext()) {
                String lafName = (String)prefs.lookAndFeelMapping.get(kit.next());
                String lafJarName = (String)lafMap.get(lafName);
                if (lafJarName == null) {
                    this.parseError(gp, "Unrecognized Look and Feel: " + lafName);
                }
                URL lafJarURL = this.findIzPackResource("lib/" + lafJarName, "Look and Feel Jar file", gp);
                this.packager.addJarContent(lafJarURL);
            }
        }
        this.packager.setGUIPrefs(prefs);
        this.notifyCompilerListener("addGUIPrefs", 2, data);
    }

    protected void addJars(XMLElement data) throws Exception {
        this.notifyCompilerListener("addJars", 1, data);
        Iterator iter = data.getChildrenNamed("jar").iterator();
        while (iter.hasNext()) {
            XMLElement el = (XMLElement)iter.next();
            String src = this.requireAttribute(el, "src");
            URL url = this.findProjectResource(src, "Jar file", el);
            this.packager.addJarContent(url);
            String stage = el.getAttribute("stage");
            if (stage == null || !stage.equalsIgnoreCase("both") && !stage.equalsIgnoreCase("uninstall")) continue;
            CustomData ca = new CustomData(null, this.getContainedFilePaths(url), null, 3);
            this.packager.addCustomJar(ca, url);
        }
        this.notifyCompilerListener("addJars", 2, data);
    }

    protected void addNativeLibraries(XMLElement data) throws Exception {
        XMLElement root;
        XMLElement uninstallInfo;
        boolean needAddOns = false;
        this.notifyCompilerListener("addNativeLibraries", 1, data);
        Iterator iter = data.getChildrenNamed("native").iterator();
        while (iter.hasNext()) {
            XMLElement el = (XMLElement)iter.next();
            String type = this.requireAttribute(el, "type");
            String name = this.requireAttribute(el, "name");
            String path = "bin/native/" + type + "/" + name;
            URL url = this.findIzPackResource(path, "Native Library", el);
            this.packager.addNativeLibrary(name, url);
            String stage = el.getAttribute("stage");
            List constraints = OsConstraint.getOsList(el);
            if (stage == null || !stage.equalsIgnoreCase("both") && !stage.equalsIgnoreCase("uninstall")) continue;
            ArrayList<String> al = new ArrayList<String>();
            al.add(name);
            CustomData cad = new CustomData(null, al, constraints, 2);
            this.packager.addNativeUninstallerLibrary(cad);
            needAddOns = true;
        }
        if (needAddOns && this.validateYesNoAttribute(uninstallInfo = (root = this.requireChildNamed(data, "info")).getFirstChildNamed("uninstaller"), "write", YES)) {
            URL url = this.findIzPackResource("lib/uninstaller-ext.jar", "Uninstaller extensions", root);
            this.packager.addResource("IzPack.uninstaller-ext", url);
        }
        this.notifyCompilerListener("addNativeLibraries", 2, data);
    }

    protected void addPacks(XMLElement data) throws CompilerException {
        this.notifyCompilerListener("addPacks", 1, data);
        XMLElement root = this.requireChildNamed(data, "packs");
        Vector packElements = root.getChildrenNamed("pack");
        if (packElements.isEmpty()) {
            this.parseError(root, "<packs> requires a <pack>");
        }
        Iterator packIter = packElements.iterator();
        while (packIter.hasNext()) {
            File file;
            Map additionals;
            List osList;
            String src;
            XMLElement f;
            XMLElement el = (XMLElement)packIter.next();
            String name = this.requireAttribute(el, "name");
            String id = el.getAttribute("id");
            boolean loose = "true".equalsIgnoreCase(el.getAttribute("loose", "false"));
            String description = this.requireChildNamed(el, "description").getContent();
            boolean required = this.requireYesNoAttribute(el, "required");
            PackInfo pack = new PackInfo(name, id, description, required, loose);
            pack.setOsConstraints(OsConstraint.getOsList(el));
            pack.setPreselected(this.validateYesNoAttribute(el, "preselected", YES));
            Iterator iter = el.getChildrenNamed("parsable").iterator();
            while (iter.hasNext()) {
                XMLElement p = (XMLElement)iter.next();
                String target = this.requireAttribute(p, "targetfile");
                String type = p.getAttribute("type", "plain");
                String encoding = p.getAttribute("encoding", null);
                List osList2 = OsConstraint.getOsList(p);
                pack.addParsable(new ParsableFile(target, type, encoding, osList2));
            }
            iter = el.getChildrenNamed("executable").iterator();
            while (iter.hasNext()) {
                XMLElement e = (XMLElement)iter.next();
                ExecutableFile executable = new ExecutableFile();
                executable.path = this.requireAttribute(e, "targetfile");
                String val = e.getAttribute("stage", "never");
                if ("postinstall".equalsIgnoreCase(val)) {
                    executable.executionStage = 0;
                } else if ("uninstall".equalsIgnoreCase(val)) {
                    executable.executionStage = 2;
                }
                val = e.getAttribute("type", "bin");
                if ("jar".equalsIgnoreCase(val)) {
                    executable.type = 1;
                    executable.mainClass = e.getAttribute("class");
                }
                if ("abort".equalsIgnoreCase(val = e.getAttribute("failure", "ask"))) {
                    executable.onFailure = 0;
                } else if ("warn".equalsIgnoreCase(val)) {
                    executable.onFailure = 1;
                }
                val = e.getAttribute("keep");
                executable.keepFile = "true".equalsIgnoreCase(val);
                XMLElement args = e.getFirstChildNamed("args");
                if (null != args) {
                    Iterator argIterator = args.getChildrenNamed("arg").iterator();
                    while (argIterator.hasNext()) {
                        XMLElement arg = (XMLElement)argIterator.next();
                        executable.argList.add(this.requireAttribute(arg, "value"));
                    }
                }
                executable.osList = OsConstraint.getOsList(e);
                pack.addExecutable(executable);
            }
            iter = el.getChildrenNamed("file").iterator();
            while (iter.hasNext()) {
                f = (XMLElement)iter.next();
                src = this.requireAttribute(f, "src");
                String targetdir = this.requireAttribute(f, "targetdir");
                osList = OsConstraint.getOsList(f);
                int override = this.getOverrideValue(f);
                additionals = this.getAdditionals(f);
                file = new File(src);
                if (!file.isAbsolute()) {
                    file = new File(this.basedir, src);
                }
                try {
                    this.addRecursively(file, targetdir, osList, override, pack, additionals);
                }
                catch (Exception x) {
                    this.parseError(f, x.getMessage(), x);
                }
            }
            iter = el.getChildrenNamed("singlefile").iterator();
            while (iter.hasNext()) {
                f = (XMLElement)iter.next();
                src = this.requireAttribute(f, "src");
                String target = this.requireAttribute(f, "target");
                osList = OsConstraint.getOsList(f);
                int override = this.getOverrideValue(f);
                additionals = this.getAdditionals(f);
                file = new File(src);
                if (!file.isAbsolute()) {
                    file = new File(this.basedir, src);
                }
                try {
                    pack.addFile(file, target, osList, override, additionals);
                }
                catch (FileNotFoundException x) {
                    this.parseError(f, x.getMessage(), x);
                }
            }
            iter = el.getChildrenNamed("fileset").iterator();
            while (iter.hasNext()) {
                int i;
                f = (XMLElement)iter.next();
                String dir_attr = this.requireAttribute(f, "dir");
                File dir = new File(dir_attr);
                if (!dir.isAbsolute()) {
                    dir = new File(this.basedir, dir_attr);
                }
                if (!dir.isDirectory()) {
                    this.parseError(f, "Invalid directory 'dir': " + dir_attr);
                }
                boolean casesensitive = this.validateYesNoAttribute(f, "casesensitive", YES);
                boolean defexcludes = this.validateYesNoAttribute(f, "defaultexcludes", YES);
                String targetdir = this.requireAttribute(f, "targetdir");
                List osList3 = OsConstraint.getOsList(f);
                int override = this.getOverrideValue(f);
                Map additionals2 = this.getAdditionals(f);
                Vector xcludesList = null;
                String[] includes = null;
                xcludesList = f.getChildrenNamed("include");
                if (!xcludesList.isEmpty()) {
                    includes = new String[xcludesList.size()];
                    for (int j = 0; j < xcludesList.size(); ++j) {
                        XMLElement xclude = (XMLElement)xcludesList.get(j);
                        includes[j] = this.requireAttribute(xclude, "name");
                    }
                }
                String[] excludes = null;
                xcludesList = f.getChildrenNamed("exclude");
                if (!xcludesList.isEmpty()) {
                    excludes = new String[xcludesList.size()];
                    for (int j = 0; j < xcludesList.size(); ++j) {
                        XMLElement xclude = (XMLElement)xcludesList.get(j);
                        excludes[j] = this.requireAttribute(xclude, "name");
                    }
                }
                String[] toDo = new String[]{"includes", "excludes"};
                String[][] containers = new String[][]{includes, excludes};
                for (int j = 0; j < toDo.length; ++j) {
                    int k;
                    String inex = f.getAttribute(toDo[j]);
                    if (inex == null || inex.length() <= 0) continue;
                    StringTokenizer tok = new StringTokenizer(inex, ", ", false);
                    int newSize = tok.countTokens();
                    String[] nCont = null;
                    if (containers[j] != null && containers[j].length > 0) {
                        nCont = new String[newSize += containers[j].length];
                        for (k = 0; k < containers[j].length; ++k) {
                            nCont[k] = containers[j][k];
                        }
                    }
                    if (nCont == null) {
                        nCont = new String[newSize];
                    }
                    while (k < newSize) {
                        nCont[k] = tok.nextToken();
                        ++k;
                    }
                    containers[j] = nCont;
                }
                includes = containers[0];
                excludes = containers[1];
                DirectoryScanner ds = new DirectoryScanner();
                ds.setIncludes(includes);
                ds.setExcludes(excludes);
                if (defexcludes) {
                    ds.addDefaultExcludes();
                }
                ds.setBasedir(dir);
                ds.setCaseSensitive(casesensitive);
                ds.scan();
                String[] files = ds.getIncludedFiles();
                String[] dirs = ds.getIncludedDirectories();
                for (i = 0; i < files.length; ++i) {
                    try {
                        String target = new File(targetdir, files[i]).getPath();
                        pack.addFile(new File(dir, files[i]), target, osList3, override, additionals2);
                        continue;
                    }
                    catch (FileNotFoundException x) {
                        this.parseError(f, x.getMessage(), x);
                    }
                }
                for (i = 0; i < dirs.length; ++i) {
                    try {
                        String target = new File(targetdir, dirs[i]).getPath();
                        pack.addFile(new File(dir, dirs[i]), target, osList3, override, additionals2);
                        continue;
                    }
                    catch (FileNotFoundException x) {
                        this.parseError(f, x.getMessage(), x);
                    }
                }
            }
            iter = el.getChildrenNamed("updatecheck").iterator();
            while (iter.hasNext()) {
                f = (XMLElement)iter.next();
                String casesensitive = f.getAttribute("casesensitive");
                ArrayList<String> includesList = new ArrayList<String>();
                ArrayList<String> excludesList = new ArrayList<String>();
                Iterator include_it = f.getChildrenNamed("include").iterator();
                while (include_it.hasNext()) {
                    XMLElement inc_el = (XMLElement)include_it.next();
                    includesList.add(this.requireAttribute(inc_el, "name"));
                }
                Iterator exclude_it = f.getChildrenNamed("exclude").iterator();
                while (exclude_it.hasNext()) {
                    XMLElement excl_el = (XMLElement)exclude_it.next();
                    excludesList.add(this.requireAttribute(excl_el, "name"));
                }
                pack.addUpdateCheck(new UpdateCheck(includesList, excludesList, casesensitive));
            }
            iter = el.getChildrenNamed("depends").iterator();
            while (iter.hasNext()) {
                XMLElement dep = (XMLElement)iter.next();
                String depName = this.requireAttribute(dep, "packname");
                pack.addDependency(depName);
            }
            this.packager.addPack(pack);
        }
        this.checkDependencies(this.packager.getPacksList());
        this.notifyCompilerListener("addPacks", 2, data);
    }

    public void checkDependencies(List packs) throws CompilerException {
        HashMap<String, PackInfo> names = new HashMap<String, PackInfo>();
        for (int i = 0; i < packs.size(); ++i) {
            PackInfo pack = (PackInfo)packs.get(i);
            names.put(pack.getPack().name, pack);
        }
        int result = this.dfs(packs, names);
        if (result == -2) {
            this.parseError("Circular dependency detected");
        } else if (result == -1) {
            this.parseError("A dependency doesn't exist");
        }
    }

    private int dfs(List packs, Map names) {
        HashMap edges = new HashMap();
        for (int i = 0; i < packs.size(); ++i) {
            PackInfo pack = (PackInfo)packs.get(i);
            if (pack.colour != 0 || this.dfsVisit(pack, names, edges) == 0) continue;
            return -1;
        }
        return this.checkBackEdges(edges);
    }

    private int checkBackEdges(Map edges) {
        Set keys = edges.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            int color = (Integer)edges.get(key);
            if (color != 1) continue;
            return -2;
        }
        return 0;
    }

    private int dfsVisit(PackInfo u, Map names, Map edges) {
        u.colour = 1;
        List deps = u.getDependencies();
        if (deps != null) {
            for (int i = 0; i < deps.size(); ++i) {
                int result;
                String name = (String)deps.get(i);
                PackInfo v = (PackInfo)names.get(name);
                if (v == null) {
                    return -1;
                }
                Edge edge = new Edge(u, v);
                if (edges.get(edge) == null) {
                    edges.put(edge, new Integer(v.colour));
                }
                if (v.colour != 0 || (result = this.dfsVisit(v, names, edges)) == 0) continue;
                return result;
            }
        }
        u.colour = 2;
        return 0;
    }

    protected void addRecursively(File file, String targetdir, List osList, int override, PackInfo pack, Map additionals) throws IOException {
        String targetfile = targetdir + "/" + file.getName();
        if (!file.isDirectory()) {
            pack.addFile(file, targetfile, osList, override, additionals);
        } else {
            File[] files = file.listFiles();
            if (files.length == 0) {
                pack.addFile(file, targetfile, osList, override, additionals);
            } else {
                for (int i = 0; i < files.length; ++i) {
                    this.addRecursively(files[i], targetfile, osList, override, pack, additionals);
                }
            }
        }
    }

    protected void addPanels(XMLElement data) throws CompilerException {
        this.notifyCompilerListener("addPanels", 1, data);
        XMLElement root = this.requireChildNamed(data, "panels");
        Vector panels = root.getChildrenNamed("panel");
        if (panels.isEmpty()) {
            this.parseError(root, "<panels> requires a <panel>");
        }
        Iterator iter = panels.iterator();
        while (iter.hasNext()) {
            XMLElement xmlPanel = (XMLElement)iter.next();
            Panel panel = new Panel();
            panel.osConstraints = OsConstraint.getOsList(xmlPanel);
            String className = xmlPanel.getAttribute("classname");
            String jarPath = "bin/panels/" + className + ".jar";
            URL url = this.findIzPackResource(jarPath, "Panel jar file", xmlPanel);
            String fullClassName = null;
            try {
                fullClassName = this.getFullClassName(url, className);
            }
            catch (Exception e) {
                // empty catch block
            }
            panel.className = fullClassName != null ? fullClassName : className;
            this.packager.addPanelJar(panel, url);
        }
        this.notifyCompilerListener("addPanels", 2, data);
    }

    protected void addResources(XMLElement data) throws CompilerException {
        this.notifyCompilerListener("addResources", 1, data);
        XMLElement root = data.getFirstChildNamed("resources");
        if (root == null) {
            return;
        }
        Iterator iter = root.getChildrenNamed("res").iterator();
        while (iter.hasNext()) {
            XMLElement res = (XMLElement)iter.next();
            String id = this.requireAttribute(res, "id");
            String src = this.requireAttribute(res, "src");
            boolean parse = this.validateYesNoAttribute(res, "parse", NO);
            URL url = this.findProjectResource(src, "Resource", res);
            if (parse) {
                if (this.packager.getVariables().isEmpty()) {
                    this.parseWarn(res, "No variables defined. " + url.getPath() + " not parsed.");
                } else {
                    String type = res.getAttribute("type");
                    String encoding = res.getAttribute("encoding");
                    File parsedFile = null;
                    try {
                        BufferedInputStream bin = new BufferedInputStream(url.openStream());
                        parsedFile = File.createTempFile("izpp", null);
                        parsedFile.deleteOnExit();
                        FileOutputStream outFile = new FileOutputStream(parsedFile);
                        BufferedOutputStream bout = new BufferedOutputStream(outFile);
                        VariableSubstitutor vs = new VariableSubstitutor(this.packager.getVariables());
                        vs.substitute(bin, bout, type, encoding);
                        ((InputStream)bin).close();
                        bout.close();
                        url = parsedFile.toURL();
                    }
                    catch (IOException x) {
                        this.parseError(res, x.getMessage(), x);
                    }
                }
            }
            this.packager.addResource(id, url);
        }
        this.notifyCompilerListener("addResources", 2, data);
    }

    protected void addLangpacks(XMLElement data) throws CompilerException {
        this.notifyCompilerListener("addLangpacks", 1, data);
        XMLElement root = this.requireChildNamed(data, "locale");
        Vector locals = root.getChildrenNamed("langpack");
        if (locals.isEmpty()) {
            this.parseError(root, "<locale> requires a <langpack>");
        }
        Iterator iter = locals.iterator();
        while (iter.hasNext()) {
            XMLElement el = (XMLElement)iter.next();
            String iso3 = this.requireAttribute(el, "iso3");
            String path = "bin/langpacks/installer/" + iso3 + ".xml";
            URL iso3xmlURL = this.findIzPackResource(path, "ISO3 file", el);
            path = "bin/langpacks/flags/" + iso3 + ".gif";
            URL iso3FlagURL = this.findIzPackResource(path, "ISO3 flag image", el);
            this.packager.addLangPack(iso3, iso3xmlURL, iso3FlagURL);
        }
        this.notifyCompilerListener("addLangpacks", 2, data);
    }

    protected void addInfo(XMLElement data) throws Exception {
        XMLElement uninstallInfo;
        XMLElement webDirURL;
        XMLElement javaVersion;
        XMLElement authors;
        XMLElement URLElem;
        this.notifyCompilerListener("addInfo", 1, data);
        XMLElement root = this.requireChildNamed(data, "info");
        Info info = new Info();
        Object temp = null;
        info.setAppName(this.requireContent(this.requireChildNamed(root, "appname")));
        info.setAppVersion(this.requireContent(this.requireChildNamed(root, "appversion")));
        XMLElement subpath = root.getFirstChildNamed("appsubpath");
        if (subpath != null) {
            info.setInstallationSubPath(this.requireContent(subpath));
        }
        if ((URLElem = root.getFirstChildNamed("url")) != null) {
            URL appURL = this.requireURLContent(URLElem);
            info.setAppURL(appURL.toString());
        }
        if ((authors = root.getFirstChildNamed("authors")) != null) {
            Iterator iter = authors.getChildrenNamed("author").iterator();
            while (iter.hasNext()) {
                XMLElement author = (XMLElement)iter.next();
                String name = this.requireAttribute(author, "name");
                String email = this.requireAttribute(author, "email");
                info.addAuthor(new Info.Author(name, email));
            }
        }
        if ((javaVersion = root.getFirstChildNamed("javaversion")) != null) {
            info.setJavaVersion(this.requireContent(javaVersion));
        }
        if ((webDirURL = root.getFirstChildNamed("webdir")) != null) {
            info.setWebDirURL(this.requireURLContent(webDirURL).toString());
        }
        if (this.kind != null) {
            if (this.kind.equalsIgnoreCase(WEB) && webDirURL == null) {
                this.parseError(root, "<webdir> required when \"WEB\" installer requested");
            } else if (this.kind.equalsIgnoreCase(STANDARD) && webDirURL != null) {
                info.setWebDirURL(null);
            }
        }
        if (this.validateYesNoAttribute(uninstallInfo = root.getFirstChildNamed("uninstaller"), "write", YES)) {
            URL url = this.findIzPackResource("lib/uninstaller.jar", "Uninstaller", root);
            this.packager.addResource("IzPack.uninstaller", url);
        }
        this.packager.setInfo(info);
        this.notifyCompilerListener("addInfo", 2, data);
    }

    protected void addVariables(XMLElement data) throws CompilerException {
        this.notifyCompilerListener("addVariables", 1, data);
        XMLElement root = data.getFirstChildNamed("variables");
        if (root == null) {
            return;
        }
        Properties variables = this.packager.getVariables();
        Iterator iter = root.getChildrenNamed("variable").iterator();
        while (iter.hasNext()) {
            XMLElement var = (XMLElement)iter.next();
            String name = this.requireAttribute(var, "name");
            String value = this.requireAttribute(var, "value");
            if (variables.contains(name)) {
                this.parseWarn(var, "Variable '" + name + "' being overwritten");
            }
            variables.setProperty(name, value);
        }
        this.notifyCompilerListener("addVariables", 2, data);
    }

    protected XMLElement getXMLTree() throws CompilerException, IOException {
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setReader(new StdXMLReader(new FileInputStream(this.filename)));
        parser.setValidator(new NonValidator());
        XMLElement data = null;
        try {
            data = (XMLElement)parser.parse();
        }
        catch (Exception x) {
            throw new CompilerException("Error parsing installation file", x);
        }
        if (!"installation".equalsIgnoreCase(data.getName())) {
            this.parseError(data, "this is not an IzPack XML installation file");
        }
        if (!this.requireAttribute(data, "version").equalsIgnoreCase(VERSION)) {
            this.parseError(data, "the file version is different from the compiler version");
        }
        return data;
    }

    protected int getOverrideValue(XMLElement f) throws CompilerException {
        int override = 4;
        String override_val = f.getAttribute("override");
        if (override_val != null) {
            if (override_val.equalsIgnoreCase("true")) {
                override = 1;
            } else if (override_val.equalsIgnoreCase("false")) {
                override = 0;
            } else if (override_val.equalsIgnoreCase("asktrue")) {
                override = 3;
            } else if (override_val.equalsIgnoreCase("askfalse")) {
                override = 2;
            } else if (override_val.equalsIgnoreCase("update")) {
                override = 4;
            } else {
                this.parseError(f, "invalid value for attribute \"override\"");
            }
        }
        return override;
    }

    private URL findProjectResource(String path, String desc, XMLElement parent) throws CompilerException {
        URL url = null;
        File resource = new File(path);
        if (!resource.isAbsolute()) {
            resource = new File(this.basedir, path);
        }
        if (!resource.exists()) {
            this.parseError(parent, desc + " not found: " + resource);
        }
        try {
            url = resource.toURL();
        }
        catch (MalformedURLException how) {
            this.parseError(parent, desc + "(" + resource + ")", how);
        }
        return url;
    }

    private URL findIzPackResource(String path, String desc, XMLElement parent) throws CompilerException {
        URL url = this.getClass().getResource("/" + path);
        if (url == null) {
            File resource = new File(path);
            if (!resource.isAbsolute()) {
                resource = new File(IZPACK_HOME, path);
            }
            if (!resource.exists()) {
                this.parseError(parent, desc + " not found: " + resource);
            }
            try {
                url = resource.toURL();
            }
            catch (MalformedURLException how) {
                this.parseError(parent, desc + "(" + resource + ")", how);
            }
        }
        return url;
    }

    protected void parseError(String message) throws CompilerException {
        this.compileFailed = true;
        throw new CompilerException(this.filename + ":" + message);
    }

    protected void parseError(XMLElement parent, String message) throws CompilerException {
        this.compileFailed = true;
        throw new CompilerException(this.filename + ":" + parent.getLineNr() + ": " + message);
    }

    protected void parseError(XMLElement parent, String message, Throwable cause) throws CompilerException {
        this.compileFailed = true;
        throw new CompilerException(this.filename + ":" + parent.getLineNr() + ": " + message, cause);
    }

    protected void parseWarn(XMLElement parent, String message) {
        System.out.println(this.filename + ":" + parent.getLineNr() + ": " + message);
    }

    protected XMLElement requireChildNamed(XMLElement parent, String name) throws CompilerException {
        XMLElement child = parent.getFirstChildNamed(name);
        if (child == null) {
            this.parseError(parent, "<" + parent.getName() + "> requires child <" + name + ">");
        }
        return child;
    }

    protected URL requireURLContent(XMLElement element) throws CompilerException {
        URL url = null;
        try {
            url = new URL(this.requireContent(element));
        }
        catch (MalformedURLException x) {
            this.parseError(element, "<" + element.getName() + "> requires valid URL", x);
        }
        return url;
    }

    protected String requireContent(XMLElement element) throws CompilerException {
        String content = element.getContent();
        if (content == null || content.length() == 0) {
            this.parseError(element, "<" + element.getName() + "> requires content");
        }
        return content;
    }

    protected String requireAttribute(XMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        return value;
    }

    protected int requireIntAttribute(XMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null || value.length() == 0) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException x) {
            this.parseError(element, "'" + attribute + "' must be an integer");
            return 0;
        }
    }

    protected boolean requireYesNoAttribute(XMLElement element, String attribute) throws CompilerException {
        String value = this.requireAttribute(element, attribute);
        if (value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("no")) {
            return false;
        }
        this.parseError(element, "<" + element.getName() + "> invalid attribute '" + attribute + "': Expected (yes|no)");
        return false;
    }

    protected boolean validateYesNoAttribute(XMLElement element, String attribute, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String value = element.getAttribute(attribute, defaultValue ? "yes" : "no");
        if (value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("no")) {
            return false;
        }
        this.parseWarn(element, "<" + element.getName() + "> invalid attribute '" + attribute + "': Expected (yes|no) if present");
        return defaultValue;
    }

    public static void main(String[] args) {
        System.out.println("");
        System.out.println(".::  IzPack - Version 3.7.2 (build 2005.04.22) ::.");
        System.out.println("");
        System.out.println("< compiler specifications version : 1.0 >");
        System.out.println("");
        System.out.println("- Copyright (C) 2001-2004 Julien Ponge");
        System.out.println("- Visit http://www.izforge.com/ for the latests releases");
        System.out.println("- Released under the terms of the GNU GPL either version 2");
        System.out.println("  of the licence, or any later version.");
        System.out.println("");
        int exitCode = 1;
        try {
            int stdArgsIndex;
            String base = ".";
            String kind = STANDARD;
            int nArgs = args.length;
            if (nArgs < 3) {
                throw new Exception("no arguments given");
            }
            if (args[0].equalsIgnoreCase("-HOME")) {
                stdArgsIndex = 2;
                IZPACK_HOME = args[1];
            } else {
                stdArgsIndex = 0;
                String izHome = System.getProperty("IZPACK_HOME");
                if (izHome != null) {
                    IZPACK_HOME = izHome;
                }
            }
            home = new File(IZPACK_HOME);
            if (!home.exists() && home.isDirectory()) {
                System.err.println("IZPACK_HOME (" + IZPACK_HOME + ") doesn't exist");
                System.exit(-1);
            }
            if (args[stdArgsIndex].equalsIgnoreCase("-?")) {
                System.out.println("-> Command line parameters are : (xml file) [args]");
                System.out.println("   (xml file): the xml file describing the installation");
                System.out.println("   -b (base) : indicates the base path that the compiler will use for filenames");
                System.out.println("               default is the current path");
                System.out.println("   -k (kind) : indicates the kind of installer to generate");
                System.out.println("               default is standard");
                System.out.println("   -o (out)  : indicates the output file name");
                System.out.println("               default is the xml file name\n");
                System.out.println("   When using vm option -DSTACKTRACE=true there is all kind of debug info ");
                System.out.println("");
            } else {
                String filename = args[stdArgsIndex];
                String output = filename.substring(0, filename.length() - 3) + "jar";
                block7: for (int pos = stdArgsIndex + 1; pos < nArgs; ++pos) {
                    if (args[pos].startsWith("-") && args[pos].length() == 2) {
                        switch (args[pos].toLowerCase().charAt(1)) {
                            case 'b': {
                                if (pos + 1 < nArgs) {
                                    base = args[++pos];
                                    continue block7;
                                }
                                throw new Exception("base argument missing");
                            }
                            case 'k': {
                                if (pos + 1 < nArgs) {
                                    kind = args[++pos];
                                    continue block7;
                                }
                                throw new Exception("kind argument missing");
                            }
                            case 'o': {
                                if (pos + 1 < nArgs) {
                                    output = args[++pos];
                                    continue block7;
                                }
                                throw new Exception("output argument missing");
                            }
                            default: {
                                throw new Exception("unknown argument");
                            }
                        }
                    }
                    throw new Exception("bad argument");
                }
                System.out.println("-> Processing : " + filename);
                System.out.println("-> Output     : " + output);
                System.out.println("-> Base path  : " + base);
                System.out.println("-> Kind       : " + kind);
                System.out.println("");
                Compiler compiler = new Compiler(filename, base, kind, output);
                CmdlinePackagerListener listener = new CmdlinePackagerListener();
                compiler.setPackagerListener(listener);
                compiler.compile();
                while (compiler.isAlive()) {
                    Thread.sleep(100L);
                }
                if (compiler.wasSuccessful()) {
                    exitCode = 0;
                }
                System.out.println("Build time: " + new Date());
            }
        }
        catch (Exception err) {
            System.err.println("-> Fatal error :");
            System.err.println("   " + err.getMessage());
            err.printStackTrace();
            System.err.println("");
            System.err.println("(tip : use -? to get the commmand line parameters)");
        }
        System.exit(exitCode);
    }

    private void addCustomListeners(XMLElement data) throws Exception {
        this.compilerListeners = new ArrayList();
        XMLElement root = data.getFirstChildNamed("listeners");
        if (root == null) {
            return;
        }
        Iterator iter = root.getChildrenNamed("listener").iterator();
        while (iter.hasNext()) {
            XMLElement xmlAction = (XMLElement)iter.next();
            Object[] listener = this.getCompilerListenerInstance(xmlAction);
            if (listener != null) {
                this.addCompilerListener((CompilerListener)listener[0]);
            }
            String[] typeNames = new String[]{"installer", "uninstaller"};
            int[] types = new int[]{0, 1};
            for (int i = 0; i < typeNames.length; ++i) {
                String className = xmlAction.getAttribute(typeNames[i]);
                if (className == null) continue;
                String jarPath = "bin/customActions/" + className + ".jar";
                URL url = this.findIzPackResource(jarPath, "CustomAction jar file", xmlAction);
                CustomData ca = new CustomData(this.getFullClassName(url, className), this.getContainedFilePaths(url), OsConstraint.getOsList(xmlAction), types[i]);
                this.packager.addCustomJar(ca, url);
            }
        }
    }

    private List getContainedFilePaths(URL url) throws Exception {
        JarInputStream jis = new JarInputStream(url.openStream());
        ZipEntry zentry = null;
        Object fullName = null;
        ArrayList<String> fullNames = new ArrayList<String>();
        while ((zentry = jis.getNextEntry()) != null) {
            String name = zentry.getName();
            if (zentry.isDirectory()) continue;
            fullNames.add(name);
        }
        jis.close();
        return fullNames;
    }

    private String getFullClassName(URL url, String className) throws Exception {
        JarInputStream jis = new JarInputStream(url.openStream());
        ZipEntry zentry = null;
        Object fullName = null;
        while ((zentry = jis.getNextEntry()) != null) {
            String name = zentry.getName();
            int lastPos = name.lastIndexOf(".class");
            if (lastPos < 0) continue;
            name = name.replace('/', '.');
            int pos = -1;
            if (className != null) {
                pos = name.indexOf(className);
            }
            if (name.length() != pos + className.length() + 6) continue;
            jis.close();
            return name.substring(0, lastPos);
        }
        jis.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getCompilerListenerInstance(XMLElement var) throws Exception {
        String defaultRootPath = "com.izforge.izpack.";
        String defaultCompilerPath = "compiler.";
        String className = var.getAttribute("compiler");
        Class<?> listener = null;
        Object instance = null;
        if (className == null) {
            return null;
        }
        String jarPath = "bin/customActions/" + className + ".jar";
        URL url = this.findIzPackResource(jarPath, "CustomAction jar file", var);
        String fullName = this.getFullClassName(url, className);
        if (url != null) {
            if (this.getClass().getResource("/" + jarPath) != null) {
                InputStream in = null;
                FileOutputStream outFile = null;
                byte[] buffer = new byte[5120];
                File tf = null;
                try {
                    int bytesInBuffer;
                    tf = File.createTempFile("izpj", ".jar");
                    tf.deleteOnExit();
                    outFile = new FileOutputStream(tf);
                    in = this.getClass().getResourceAsStream("/" + jarPath);
                    long bytesCopied = 0L;
                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                        outFile.write(buffer, 0, bytesInBuffer);
                        bytesCopied += (long)bytesInBuffer;
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (outFile != null) {
                        outFile.close();
                    }
                }
                url = tf.toURL();
            }
            URLClassLoader ucl = new URLClassLoader(new URL[]{url}, CompilerListener.class.getClassLoader());
            listener = ucl.loadClass(fullName);
        }
        if (listener != null) {
            instance = listener.newInstance();
        } else {
            this.parseError(var, "Cannot find defined compiler listener " + className);
        }
        if (!CompilerListener.class.isInstance(instance)) {
            this.parseError(var, "'" + className + "' must be implemented " + CompilerListener.class.toString());
        }
        List constraints = OsConstraint.getOsList(var);
        return new Object[]{instance, className, constraints};
    }

    private void addCompilerListener(CompilerListener pe) {
        this.compilerListeners.add(pe);
    }

    private void notifyCompilerListener(String callerName, int state, XMLElement data) throws CompilerException {
        Iterator i = this.compilerListeners.iterator();
        while (i != null && i.hasNext()) {
            ((CompilerListener)i.next()).notify(callerName, state, data, this.packager);
        }
    }

    private Map getAdditionals(XMLElement f) throws CompilerException {
        Iterator i = this.compilerListeners.iterator();
        Map retval = null;
        try {
            while (i != null && i.hasNext()) {
                retval = ((CompilerListener)i.next()).reviseAdditionalDataMap(retval, f);
            }
        }
        catch (CompilerException ce) {
            this.parseError(f, ce.getMessage());
        }
        return retval;
    }

    static class CmdlinePackagerListener
    implements PackagerListener {
        CmdlinePackagerListener() {
        }

        public void packagerMsg(String info) {
            System.out.println(info);
        }

        public void packagerStart() {
            System.out.println("[ Begin ]");
            System.out.println("");
        }

        public void packagerStop() {
            System.out.println("");
            System.out.println("[ End ]");
        }
    }

    private class Edge {
        PackInfo u;
        PackInfo v;

        Edge(PackInfo u, PackInfo v) {
            this.u = u;
            this.v = v;
        }
    }
}

