/* $Id: SampleConfigXMLMapper.java,v 1.2 2005/04/09 03:34:03 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : 
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : Consumer
 * 
 * -----------------------------------------------------------------------
 */


package tsp.consumer.util.configuration;


import org.xml.sax.*;

import tsp.util.xml.objmapper.PositionAction;
import tsp.util.xml.objmapper.PositionNode;
import tsp.util.xml.objmapper.XmlObjMapper;


import javax.xml.parsers.ParserConfigurationException;
import java.io.*;

public class SampleConfigXMLMapper   {
	
	
	private SpecSamplingConfig target;
	
	private XmlObjMapper xmlMapper;
	
	public SampleConfigXMLMapper() throws  SpecException {
		try {
			xmlMapper = new XmlObjMapper();
			createNodeTree(xmlMapper.getRoot());
		} catch (ParserConfigurationException e) {
			throw new SpecException(e);
		} catch (SAXException e) {
			throw new SpecException(e);
		}
		
	}
	
	private void createNodeTree(PositionNode root) {
								
		final String N_TSPSAMPLECONFIG = "TSP_sample_config";
		final String N_TSPCOMMENT = "Comment";
		final String N_TSPPROVIDERLIST = "TSP_providers";
		final String N_TSPPROVIDER = "provider";
		final String N_TSPSAMPLELIST = "TSP_samples";
		final String N_TSPSAMPLE = "sample";
		
		
		
		root.addNode( N_TSPSAMPLECONFIG, new PositionAction(){
			public void start(Attributes attr) {
				target = new SpecSamplingConfig();
				target.setVersion(attr.getValue("version"));
			}			
			public void end(String contents) {
				// do nothing
			}			
			
		});
		
		root.getNode(N_TSPSAMPLECONFIG)
		.addNode( N_TSPCOMMENT, new PositionAction(){
			public void start(Attributes attr) {
				// Do nothing
			}
			public void end(String contents ) {
				target.setComment(contents);
			}
		});
		
		root.getNode(N_TSPSAMPLECONFIG)
		.addNode( N_TSPPROVIDERLIST, new PositionAction(){
			public void start(Attributes attr) throws SAXException{
				SpecProviderList providerList = new SpecProviderList(target);
				providerList.setImplicitProvider(createImplicitProviderEnum(attr.getValue("implicit")));
				target.addLastProviderList(providerList);
			}
			public void end(String contents) {
				// do nothing
			}
		});
		
		
		root.getNode(N_TSPSAMPLECONFIG)
		.getNode(N_TSPPROVIDERLIST)
		.addNode( N_TSPPROVIDER, new PositionAction(){
			public void start(Attributes attr) throws SAXException{
				SpecProvider provider = new SpecProvider(target);
				provider.setName(attr.getValue("name"));
				provider.setUrl(attr.getValue("url"));
				provider.setImplicitPeriod(createInteger(attr.getValue("implicit_period")));
				target.getLastProviderList().addLastProvider(provider);
			}
			
			public void end(String contents ) {
				target.getLastProviderList().getLastProvider().setDescription(contents);
			}
		});
		
		root.getNode(N_TSPSAMPLECONFIG)
		.addNode( N_TSPSAMPLELIST, new PositionAction(){
			public void start(Attributes attr) throws SAXException{
				SpecSampleList sampleList = new SpecSampleList(target);
				sampleList.setImplicitPeriod(createInteger(attr.getValue("implicit_period")));
				target.addLastSampleList(sampleList);
			}
			public void end(String contents) {
				// do nothing
			}
		});
		
		root.getNode(N_TSPSAMPLECONFIG)
		.getNode(N_TSPSAMPLELIST)
		.addNode( N_TSPSAMPLE, new PositionAction(){
			public void start(Attributes attr) throws SAXException{
				SpecSample sample = new SpecSample(target);
				sample.setName(attr.getValue("name"));
				sample.setReNamed(attr.getValue("renamed"));
				sample.setType(createVarTypeEnum(attr.getValue("type")));
				sample.setProviderName(attr.getValue("provider"));
				sample.setOwnPeriod(createInteger(attr.getValue("period")));
				target.getLastSampleList().addLastSample(sample);
			}
			
			public void end(String contents ) {
				target.getLastSampleList().getLastSample().setDescription(contents);
			}
		});
		
		
	}
	
	private static ImplicitProviderEnum createImplicitProviderEnum(String s) throws SAXException {
		try {
			return  (s != null ? ImplicitProviderEnum.getByName(s) : null);
		} catch (SpecException e) {
			throw new SAXException(e);
		}
	}
	
	private static VarTypeEnum createVarTypeEnum(String s) throws SAXException {
		try {
			return  (s != null ? VarTypeEnum.getByName(s) : null);
		} catch (SpecException e) {
			throw new SAXException(e);
		}
	}
	
	
	private static Integer createInteger(String s) throws SAXException {
		try {
			return  (s != null ? new Integer(s) : null);
		} catch (NumberFormatException e) {
			throw new SAXException(e);
		}
	}
	
	
	
	public SpecSamplingConfig createSpecSamplingConfig( String path ) throws SpecException {
		
		try {			
			target = null;
			xmlMapper.startParsingFromFileOrClassPath(path);
			target.consolidate();
			return target;
		} catch (SAXException e) {
			throw new SpecException(e);		
		} catch (IOException e) {
			throw new SpecException(e);		
		}
		
	}
	
	public SpecSamplingConfig createSpecSamplingConfig( InputStream xmlFile ) throws SpecException {
		
		try {			
			target = null;
			xmlMapper.startParsing(xmlFile);
			target.consolidate();
			return target;
		} catch (SAXException e) {
			throw new SpecException(e);		
		} catch (IOException e) {
			throw new SpecException(e);		
		}
		
	}
	
	public SpecSamplingConfig createSpecSamplingConfig(File xmlFile) throws SpecException{
		try {
			
			target = null;
			xmlMapper.startParsing(xmlFile);
			target.consolidate();
			return target;
		} catch (SAXException e) {
			throw new SpecException(e);		
		} catch (IOException e) {
			throw new SpecException(e);		
		}
	}
	
	
	
	
}