/* $Id: AggrSamplingConfigTest.java,v 1.1 2005/04/09 05:13:12 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.configuration.decorator;

import tsp.consumer.util.aggregator.TspAggrURL;
import tsp.consumer.util.configuration.SampleConfigXMLMapper;
import tsp.consumer.util.configuration.SampleConfigXMLMapperTest;
import tsp.consumer.util.configuration.SpecSamplingConfig;
import junit.framework.TestCase;

public class AggrSamplingConfigTest extends TestCase {

		
	private AggrSamplingConfig aggrConfig;
		
	
	public void setUp() throws Exception {
		
		SampleConfigXMLMapper parser = new SampleConfigXMLMapper();		
		SpecSamplingConfig specConfig  = parser.createSpecSamplingConfig(SampleConfigXMLMapperTest.REF_EXPLICITCONFIG_PATH);
		aggrConfig = new AggrSamplingConfig(specConfig);
		
	}
	
	public void testGetAllURL() throws Exception{
		TspAggrURL[] urls = aggrConfig.getAllAggrURL(); 
		assertEquals(3,urls.length);
		assertEquals("Stub1", urls[0].getNamespace());
		assertEquals("rpc://localhost/Stubber:", urls[0].getUrl().toString());
		assertEquals("Stub2", urls[1].getNamespace());
		assertEquals("xmlrpc://localhost/Stubber:", urls[1].getUrl().toString());
		assertEquals("BB1", urls[2].getNamespace());
		assertEquals("rpc://localhost/BB_provider:", urls[2].getUrl().toString());
	}
	
	public void testGetAllRenamedSymbols() throws Exception{
		RenamedSimpleSampleSymbolInfo[] renSi = aggrConfig.getAllRenamedSymbols();
		assertEquals(3,renSi.length);
		assertEquals("Stub2::Symbol3",renSi[1].getInfo().getName());
	}
	
}
