/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import jsynoptic.base.Plugin;
import jsynoptic.builtin.Builtin;
import jsynoptic.ui.AggregateFileFilter;
import jsynoptic.ui.DiagramSelectionPropertiesPanel;
import jsynoptic.ui.FiledDesktopCardPanel;
import jsynoptic.ui.LongAction;
import jsynoptic.ui.PluginLookup;
import jsynoptic.ui.PrintToImage;
import jsynoptic.ui.Run;
import jsynoptic.ui.ShapesContainer;
import jsynoptic.ui.SourcePanel;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.diagram.DiagramClipboard;
import simtools.diagram.DiagramClipboardListener;
import simtools.diagram.DiagramComponent;
import simtools.diagram.DiagramSelection;
import simtools.diagram.DiagramSelectionListener;
import simtools.diagram.undo.UndoHandler;
import simtools.shapes.AbstractShape;
import simtools.ui.ActionComboBox;
import simtools.ui.BasicMessageWriter;
import simtools.ui.DesktopCardPanelListener;
import simtools.ui.MenuResourceBundle;
import simtools.ui.PrintDialog;
import simtools.ui.ResourceFinder;
import simtools.ui.UserProperties;
import simtools.ui.UserPropertiesEditor;

public class JSynoptic
extends JFrame
implements ActionListener,
DesktopCardPanelListener,
DiagramClipboardListener,
DiagramSelectionListener,
PropertyChangeListener {
    public static MenuResourceBundle resources = ResourceFinder.getMenu(class$jsynoptic$ui$JSynoptic == null ? (class$jsynoptic$ui$JSynoptic = JSynoptic.class$("jsynoptic.ui.JSynoptic")) : class$jsynoptic$ui$JSynoptic);
    public static BasicMessageWriter messageWriter = ResourceFinder.getMessages(class$jsynoptic$ui$JSynoptic == null ? (class$jsynoptic$ui$JSynoptic = JSynoptic.class$("jsynoptic.ui.JSynoptic")) : class$jsynoptic$ui$JSynoptic);
    public static JSynoptic gui = null;
    protected UndoHandler.UndoAction undoAction;
    protected UndoHandler.RedoAction redoAction;
    protected FiledDesktopCardPanel desktopCardPanel;
    protected SourcePanel sourcePanel;
    protected Vector plugins;
    protected static UserProperties userProperties = Run.getProperties();
    protected boolean isEditable = System.getProperty("jsynoptic.noEdit", "false").equals("false");
    protected int untitledDocumentNumber;
    protected Action aCut;
    protected Action aCopy;
    protected Action aPaste;
    protected Action aRemove;
    protected Action aFullScreen;
    protected Action aFront;
    protected Action aForward;
    protected Action aBackward;
    protected Action aBack;
    protected JMenu mDepth;
    protected Action aLeft;
    protected Action aRight;
    protected Action aTop;
    protected Action aBottom;
    protected Action aVCenter;
    protected Action aHCenter;
    protected JMenu mAlign;
    protected JFrame aboutFrame;
    protected PrintToImage printImage;
    protected JMenuItem miNew;
    protected JMenuItem miOpen;
    protected JMenuItem miClose;
    protected JMenuItem miSave;
    protected JMenuItem miSaveAs;
    protected JMenuItem miPrint;
    protected JMenuItem miPrintImage;
    protected JMenuItem miExit;
    protected JMenuItem miFindPlugins;
    protected JMenuItem miUndo;
    protected JMenuItem miRedo;
    protected JMenuItem miPreferencesPanel;
    protected JMenuItem miChooseLanguage;
    protected JMenuItem miAbout;
    protected JButton bNew;
    protected JButton bOpen;
    protected JButton bSave;
    protected JButton bPrint;
    protected JButton bPrintImage;
    protected JButton bUndo;
    protected JButton bRedo;
    protected JButton bAdjust;
    protected JButton bAlign;
    protected JToggleButton tbGridDisplay;
    protected JComboBox cbxGrid;
    protected JComboBox cbxZoom;
    protected JComboBox cbxDepth;
    protected JComboBox cbxAlign;
    protected DiagramSelectionPropertiesPanel.SelectionAction aLineColor;
    protected DiagramSelectionPropertiesPanel.SelectionAction aBackgroundColor;
    protected DiagramSelectionPropertiesPanel.SelectionAction aFontColor;
    protected ActionComboBox cbxSelection;
    protected JSplitPane splitPane;
    protected JToolBar toolbar;
    protected JLabel status;
    protected TimerTask cleanStatusTask;
    protected Timer cleanStatusTimer;
    protected long statusDelay;
    protected JFileChooser openFileChooser;
    protected JFileChooser saveFileChooser;
    protected JFileChooser fileChooser;
    protected File currentPath;
    protected FileFilter currentFileFilter;
    public Vector lockedShapes;
    private int fileSaveSemaphoreCounter;
    private int fileOpenSemaphoreCounter;
    private int printSemaphoreCounter;
    protected UserPropertiesEditor propEditor;
    protected static String propW = "jsynoptic.ui.JSynoptic.width";
    protected static String propH = "jsynoptic.ui.JSynoptic.height";
    protected static String propSplit = "jsynoptic.ui.JSynoptic.split";
    protected static String propPath = "jsynoptic.ui.JSynoptic.currentPath";
    protected static int propWDefault = 700;
    protected static int propHDefault = 500;
    protected static int propSplitDefault = propWDefault / 2;
    protected static String propPathDefault = System.getProperty("user.dir");
    ArrowMenu arrow;
    JButton lastChoice;
    static /* synthetic */ Class class$jsynoptic$ui$JSynoptic;

    public JSynoptic(JProgressBar jProgressBar, Vector vector, Vector vector2) {
        super("JSynoptic");
        gui = this;
        this.plugins = vector == null ? new Vector() : vector;
        this.untitledDocumentNumber = 0;
        this.fileSaveSemaphoreCounter = 0;
        this.fileOpenSemaphoreCounter = 0;
        this.printSemaphoreCounter = 0;
        this.openFileChooser = null;
        this.saveFileChooser = null;
        this.currentPath = null;
        this.currentFileFilter = null;
        this.lockedShapes = new Vector();
        this.aboutFrame = null;
        this.init(jProgressBar, vector2);
    }

    protected void init(JProgressBar jProgressBar, Vector vector) {
        Object object;
        int n;
        if (this.isEditable) {
            this.sourcePanel = new SourcePanel(DataSourcePool.global);
            for (n = 0; n < this.plugins.size(); ++n) {
                object = (Plugin)this.plugins.get(n);
                if (object == null) continue;
                try {
                    ((Plugin)object).newSourceComponent(this.sourcePanel);
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.sourcePanel.invalidate();
        } else {
            this.sourcePanel = null;
        }
        if (jProgressBar != null) {
            jProgressBar.setValue(65);
        }
        this.desktopCardPanel = new FiledDesktopCardPanel(true);
        this.createActions();
        this.setMenuBar();
        this.setToolBar();
        if (jProgressBar != null) {
            jProgressBar.setValue(70);
        }
        this.setSelectionEditEnabled(false);
        this.setPasteEnabled(false);
        this.setDiagramComponentSpecificsEnabled(false);
        this.desktopCardPanel.addListener(this);
        if (jProgressBar != null) {
            jProgressBar.setValue(75);
        }
        for (n = 0; n < this.plugins.size(); ++n) {
            object = (Plugin)this.plugins.get(n);
            if (object == null) continue;
            ((Plugin)object).newDesktopComponent(this.desktopCardPanel);
        }
        this.desktopCardPanel.invalidate();
        this.newComponent();
        if (jProgressBar != null) {
            jProgressBar.setValue(80);
        }
        if (this.sourcePanel != null) {
            this.splitPane = new JSplitPane(1, this.sourcePanel, this.desktopCardPanel);
            this.getContentPane().add("Center", this.splitPane);
        } else {
            this.splitPane = null;
            this.getContentPane().add("Center", this.desktopCardPanel);
        }
        this.setIconImage(resources.getIcon("jsynIcon").getImage());
        if (jProgressBar != null) {
            jProgressBar.setValue(85);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.status = new JLabel();
        jPanel.add(this.status);
        this.getContentPane().add("South", jPanel);
        this.cleanStatusTask = null;
        this.cleanStatusTimer = new Timer();
        this.statusDelay = resources.getLongValue("statusDelayMilliSec");
        if (jProgressBar != null) {
            jProgressBar.setValue(90);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JSynoptic.this.exit();
            }
        });
        DiagramClipboard.create();
        DiagramClipboard.get().addListener(this);
        if (jProgressBar != null) {
            jProgressBar.setValue(95);
        }
        this.pack();
        object = new Dimension(this.bPrint.getWidth() * 2, this.bPrint.getHeight());
        this.cbxGrid.setMinimumSize((Dimension)object);
        this.cbxZoom.setMinimumSize((Dimension)object);
        this.cbxDepth.setMinimumSize((Dimension)object);
        this.cbxAlign.setMinimumSize((Dimension)object);
        this.cbxSelection.setMinimumSize((Dimension)object);
        this.validate();
        if (vector.size() > 0) {
            this.status.setText(messageWriter.print0args("processingCommands"));
        } else {
            this.status.setText(messageWriter.print0args("welcomeMessage"));
        }
        this.loadProperties();
        if (jProgressBar != null) {
            jProgressBar.setValue(100);
        }
        if (Run.barFrame != null) {
            Run.barFrame.dispose();
            Run.barFrame = null;
        } else if (jProgressBar != null) {
            jProgressBar.setVisible(false);
        }
        this.show();
        this.processCommands(vector);
        jPanel.setMinimumSize(jPanel.getSize());
        jPanel.setPreferredSize(jPanel.getSize());
        JSynoptic.setStatus(messageWriter.print0args("welcomeMessage"));
    }

    protected void exit() {
        this.cleanStatusTimer.cancel();
        this.saveProperties();
        System.exit(0);
    }

    protected void processCommands(Vector vector) {
        if (vector == null) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.processCommand((String)iterator.next());
        }
    }

    protected void processCommand(String string) {
        if (string.startsWith("load ")) {
            File file = new File(string.substring(5));
            Plugin plugin = this.getPluginToProcessFile(file, 1, null);
            if (plugin == null) {
                return;
            }
            plugin.processFile(file, 1);
            return;
        }
    }

    public synchronized void lockFileSave() {
        if (this.fileSaveSemaphoreCounter++ == 0) {
            this.miSave.setEnabled(false);
            this.bSave.setEnabled(false);
            this.miSaveAs.setEnabled(false);
        }
    }

    public synchronized void unlockFileSave() {
        if (--this.fileSaveSemaphoreCounter == 0) {
            this.miSave.setEnabled(true);
            this.bSave.setEnabled(true);
            this.miSaveAs.setEnabled(true);
        }
    }

    public synchronized boolean canSave() {
        return this.fileSaveSemaphoreCounter == 0;
    }

    public synchronized void lockFileOpen() {
        if (this.fileOpenSemaphoreCounter++ == 0) {
            this.miOpen.setEnabled(false);
            this.bOpen.setEnabled(false);
        }
    }

    public synchronized void unlockFileOpen() {
        if (--this.fileOpenSemaphoreCounter == 0) {
            this.miOpen.setEnabled(true);
            this.bOpen.setEnabled(true);
        }
    }

    public synchronized boolean canOpen() {
        return this.fileOpenSemaphoreCounter == 0;
    }

    public synchronized void lockPrint() {
        if (this.printSemaphoreCounter++ == 0) {
            this.miPrint.setEnabled(false);
            this.bPrint.setEnabled(false);
            this.miPrintImage.setEnabled(false);
            this.bPrintImage.setEnabled(false);
        }
    }

    public synchronized void unlockPrint() {
        if (--this.printSemaphoreCounter == 0) {
            this.miPrint.setEnabled(true);
            this.bPrint.setEnabled(true);
            this.miPrintImage.setEnabled(true);
            this.bPrintImage.setEnabled(true);
        }
    }

    public synchronized boolean canPrint() {
        return this.printSemaphoreCounter == 0;
    }

    protected void saveProperties() {
        UserProperties userProperties = Run.getProperties();
        userProperties.setInt(propW, this.getWidth());
        userProperties.setInt(propH, this.getHeight());
        if (this.splitPane != null) {
            userProperties.setInt(propSplit, this.splitPane.getDividerLocation());
        }
        userProperties.setString(propPath, this.currentPath.getAbsolutePath());
        JSynoptic.userProperties.write();
    }

    protected void loadProperties() {
        UserProperties userProperties = Run.getProperties();
        this.setSize(userProperties.getInt(propW, propWDefault), userProperties.getInt(propH, propHDefault));
        if (this.splitPane != null) {
            this.splitPane.setDividerLocation(userProperties.getInt(propSplit, propSplitDefault));
        }
        this.currentPath = new File(userProperties.getString(propPath, propPathDefault));
        if (!this.currentPath.exists()) {
            this.currentPath = new File(propPathDefault);
        }
        AbstractShape.REFRESH_PERIOD = userProperties.getInt("simtools.shapes.AbstractShape.REFRESH_PERIOD", AbstractShape.REFRESH_PERIOD);
        AbstractShape.ANTI_ALIASING = userProperties.getBoolean("simtools.shapes.AbstractShape.ANTI_ALIASING", AbstractShape.ANTI_ALIASING);
    }

    public void createActions() {
        this.aCut = new AbstractAction(resources.getStringValue("cutAction"), resources.getIcon("cutImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.executeSelectionCut();
                }
            }
        };
        this.aCopy = new AbstractAction(resources.getStringValue("copyAction"), resources.getIcon("copyImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.executeSelectionCopy();
                }
            }
        };
        this.aPaste = new AbstractAction(resources.getStringValue("pasteAction"), resources.getIcon("pasteImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.executeClipboardPaste();
                }
            }
        };
        this.aRemove = new AbstractAction(resources.getStringValue("removeAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.executeSelectionDelete();
                }
            }
        };
        this.aFullScreen = new AbstractAction(resources.getStringValue("fullScreen")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent.isFullScreen()) {
                    diagramComponent.setFullScreen(false);
                } else {
                    diagramComponent.setFullScreen(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
                }
            }
        };
        this.aFullScreen.putValue("AcceleratorKey", resources.getKeyStroke("fullScreenShortcut"));
        this.aFront = new AbstractAction(resources.getStringValue("frontAction"), resources.getIcon("frontImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().bringSelectionToFront();
                }
            }
        };
        this.aForward = new AbstractAction(resources.getStringValue("forwardAction"), resources.getIcon("forwardImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().bringSelectionForward();
                }
            }
        };
        this.aBackward = new AbstractAction(resources.getStringValue("backwardAction"), resources.getIcon("backwardImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().sendSelectionBackward();
                }
            }
        };
        this.aBack = new AbstractAction(resources.getStringValue("backAction"), resources.getIcon("backImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().sendSelectionToBack();
                }
            }
        };
        this.aLeft = new AbstractAction(resources.getStringValue("leftAction"), resources.getIcon("leftImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().alignSelectionToLeft();
                }
            }
        };
        this.aRight = new AbstractAction(resources.getStringValue("rightAction"), resources.getIcon("rightImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().alignSelectionToRight();
                }
            }
        };
        this.aTop = new AbstractAction(resources.getStringValue("topAction"), resources.getIcon("topImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().alignSelectionToTop();
                }
            }
        };
        this.aBottom = new AbstractAction(resources.getStringValue("bottomAction"), resources.getIcon("bottomImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().alignSelectionToBottom();
                }
            }
        };
        this.aVCenter = new AbstractAction(resources.getStringValue("vCenterAction"), resources.getIcon("vCenterImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().alignSelectionVCenter();
                }
            }
        };
        this.aHCenter = new AbstractAction(resources.getStringValue("hCenterAction"), resources.getIcon("hCenterImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.getDiagramSelection().alignSelectionHCenter();
                }
            }
        };
    }

    public void setMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.addFileMenu(jMenuBar);
        this.addEditMenu(jMenuBar);
        this.addToolsMenu(jMenuBar);
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            plugin.setMenu(jMenuBar);
        }
        jMenuBar.add(this.desktopCardPanel.createMenu(null));
        this.addHelpMenu(jMenuBar);
        this.setJMenuBar(jMenuBar);
    }

    public void setToolBar() {
        this.toolbar = new JToolBar();
        this.addFileButtons(this.toolbar);
        this.toolbar.addSeparator();
        this.addEditButtons(this.toolbar);
        this.toolbar.addSeparator();
        this.bUndo = resources.getBox("undo", this);
        this.toolbar.add(this.bUndo);
        this.bRedo = resources.getBox("redo", this);
        this.toolbar.add(this.bRedo);
        this.updateUndoEnabled();
        this.toolbar.addSeparator();
        this.addDepthButtons(this.toolbar);
        this.toolbar.addSeparator();
        this.addAlignButtons(this.toolbar);
        this.toolbar.addSeparator();
        this.addSelectionButtons(this.toolbar);
        this.toolbar.addSeparator();
        this.bAdjust = resources.getBox("adjust", this);
        this.toolbar.add(this.bAdjust);
        this.bAlign = resources.getBox("align", this);
        this.toolbar.add(this.bAlign);
        this.toolbar.addSeparator();
        this.tbGridDisplay = new JToggleButton(resources.getIcon("gridImage"));
        this.tbGridDisplay.setPreferredSize(new Dimension(22, 22));
        this.tbGridDisplay.addActionListener(this);
        this.tbGridDisplay.setToolTipText(resources.getStringValue("gridButtonTip"));
        this.toolbar.add(this.tbGridDisplay);
        this.cbxGrid = new JComboBox();
        this.cbxGrid.addItem("0");
        this.cbxGrid.addItem("5");
        this.cbxGrid.addItem("10");
        this.cbxGrid.addItem("20");
        this.cbxGrid.addItem("40");
        this.cbxGrid.setSelectedItem("0");
        this.cbxGrid.setEditable(true);
        this.cbxGrid.addActionListener(this);
        this.toolbar.add(this.cbxGrid);
        this.cbxZoom = new JComboBox();
        this.cbxZoom.addItem("500%");
        this.cbxZoom.addItem("200%");
        this.cbxZoom.addItem("150%");
        this.cbxZoom.addItem("100%");
        this.cbxZoom.addItem("75%");
        this.cbxZoom.addItem("50%");
        this.cbxZoom.addItem("25%");
        this.cbxZoom.addItem("10%");
        this.cbxZoom.setSelectedItem("100%");
        this.cbxZoom.setEditable(true);
        this.cbxZoom.addActionListener(this);
        this.toolbar.add(this.cbxZoom);
        this.toolbar.addSeparator();
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            plugin.setToolBarItem(this.toolbar);
        }
        this.getContentPane().add("North", this.toolbar);
    }

    public void addFileMenu(JMenuBar jMenuBar) {
        JMenu jMenu = resources.getMenu("file");
        this.miNew = resources.getItem("new", this);
        jMenu.add(this.miNew);
        this.miOpen = resources.getItem("open", this);
        jMenu.add(this.miOpen);
        this.miSave = resources.getItem("save", this);
        jMenu.add(this.miSave);
        this.miSaveAs = resources.getItem("saveAs", this);
        jMenu.add(this.miSaveAs);
        this.miPrint = resources.getItem("print", this);
        jMenu.add(this.miPrint);
        this.miPrintImage = resources.getItem("printToImg", this);
        jMenu.add(this.miPrintImage);
        this.miClose = resources.getItem("close", this);
        jMenu.add(this.miClose);
        this.miExit = resources.getItem("exit", this);
        jMenu.add(this.miExit);
        jMenuBar.add(jMenu);
    }

    public void addEditMenu(JMenuBar jMenuBar) {
        JMenu jMenu = resources.getMenu("edit");
        this.miUndo = resources.getItem("undo", this);
        jMenu.add(this.miUndo);
        KeyStroke keyStroke = resources.getKeyStroke("undoShortcut");
        if (keyStroke != null) {
            this.miUndo.setAccelerator(keyStroke);
        }
        this.miRedo = resources.getItem("redo", this);
        jMenu.add(this.miRedo);
        keyStroke = resources.getKeyStroke("redoShortcut");
        if (keyStroke != null) {
            this.miRedo.setAccelerator(keyStroke);
        }
        JMenuItem jMenuItem = jMenu.add(this.aCut);
        jMenuItem.setIcon(null);
        keyStroke = resources.getKeyStroke("cutShortcut");
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem = jMenu.add(this.aCopy);
        jMenuItem.setIcon(null);
        keyStroke = resources.getKeyStroke("copyShortcut");
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem = jMenu.add(this.aPaste);
        jMenuItem.setIcon(null);
        keyStroke = resources.getKeyStroke("pasteShortcut");
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem = jMenu.add(this.aRemove);
        jMenuItem.setIcon(null);
        keyStroke = resources.getKeyStroke("removeShortcut");
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuBar.add(jMenu);
    }

    public void addFileButtons(JToolBar jToolBar) {
        this.bNew = resources.getBox("new", this);
        jToolBar.add(this.bNew);
        this.bOpen = resources.getBox("open", this);
        jToolBar.add(this.bOpen);
        this.bSave = resources.getBox("save", this);
        jToolBar.add(this.bSave);
        jToolBar.addSeparator();
        this.bPrint = resources.getBox("print", this);
        jToolBar.add(this.bPrint);
        this.bPrintImage = resources.getBox("printToImg", this);
        jToolBar.add(this.bPrintImage);
    }

    public void addEditButtons(JToolBar jToolBar) {
        JButton jButton = jToolBar.add(this.aCut);
        jButton.setPreferredSize(new Dimension(22, 22));
        String string = resources.getStringValue("cutTip");
        if (string != null) {
            jButton.setToolTipText(string);
        }
        jButton = jToolBar.add(this.aCopy);
        jButton.setPreferredSize(new Dimension(22, 22));
        string = resources.getStringValue("copyTip");
        if (string != null) {
            jButton.setToolTipText(string);
        }
        jButton = jToolBar.add(this.aPaste);
        jButton.setPreferredSize(new Dimension(22, 22));
        string = resources.getStringValue("pasteTip");
        if (string != null) {
            jButton.setToolTipText(string);
        }
    }

    public void addDepthButtons(JToolBar jToolBar) {
        Vector<Action> vector = new Vector<Action>();
        Vector<String> vector2 = new Vector<String>();
        vector.add(this.aFront);
        vector2.add(resources.getStringValue("frontTip"));
        vector.add(this.aForward);
        vector2.add(resources.getStringValue("forwardTip"));
        vector.add(this.aBackward);
        vector2.add(resources.getStringValue("backwardTip"));
        vector.add(this.aBack);
        vector2.add(resources.getStringValue("backTip"));
        this.cbxDepth = new ActionComboBox(vector, vector2);
        jToolBar.add(this.cbxDepth);
    }

    public void addSelectionButtons(JToolBar jToolBar) {
        Vector<DiagramSelectionPropertiesPanel.SelectionAction> vector = new Vector<DiagramSelectionPropertiesPanel.SelectionAction>();
        Vector<String> vector2 = new Vector<String>();
        DiagramSelectionPropertiesPanel.ColorEditorPanel colorEditorPanel = new DiagramSelectionPropertiesPanel.LineColorEditorPanel();
        this.aLineColor = colorEditorPanel.getAction();
        vector.add(this.aLineColor);
        vector2.add(colorEditorPanel.getToolTip());
        colorEditorPanel = new DiagramSelectionPropertiesPanel.BackgroundColorEditorPanel();
        this.aBackgroundColor = colorEditorPanel.getAction();
        vector.add(this.aBackgroundColor);
        vector2.add(colorEditorPanel.getToolTip());
        colorEditorPanel = new DiagramSelectionPropertiesPanel.FontColorEditorPanel();
        this.aFontColor = colorEditorPanel.getAction();
        vector.add(this.aFontColor);
        vector2.add(colorEditorPanel.getToolTip());
        this.cbxSelection = new ActionComboBox(vector, vector2);
        this.aLineColor.addPropertyChangeListener(this.cbxSelection);
        this.aBackgroundColor.addPropertyChangeListener(this.cbxSelection);
        this.aFontColor.addPropertyChangeListener(this.cbxSelection);
        jToolBar.add(this.cbxSelection);
    }

    public void addAlignButtons(JToolBar jToolBar) {
        Vector<Action> vector = new Vector<Action>();
        Vector<String> vector2 = new Vector<String>();
        vector.add(this.aLeft);
        vector2.add(resources.getStringValue("leftTip"));
        vector.add(this.aRight);
        vector2.add(resources.getStringValue("rightTip"));
        vector.add(this.aTop);
        vector2.add(resources.getStringValue("topTip"));
        vector.add(this.aBottom);
        vector2.add(resources.getStringValue("bottomTip"));
        vector.add(this.aVCenter);
        vector2.add(resources.getStringValue("vCenterTip"));
        vector.add(this.aHCenter);
        vector2.add(resources.getStringValue("hCenterTip"));
        this.cbxAlign = new ActionComboBox(vector, vector2);
        jToolBar.add(this.cbxAlign);
    }

    public void addEditMenu(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.aCut);
        jMenuItem.setIcon(null);
        jMenuItem = jPopupMenu.add(this.aCopy);
        jMenuItem.setIcon(null);
        jMenuItem = jPopupMenu.add(this.aPaste);
        jMenuItem.setIcon(null);
        jMenuItem = jPopupMenu.add(this.aRemove);
        jMenuItem.setIcon(null);
    }

    public void addDepthMenu(JPopupMenu jPopupMenu) {
        this.mDepth = (JMenu)jPopupMenu.add(resources.getMenu("depth"));
        JMenuItem jMenuItem = this.mDepth.add(this.aFront);
        jMenuItem.setIcon(null);
        jMenuItem = this.mDepth.add(this.aForward);
        jMenuItem.setIcon(null);
        jMenuItem = this.mDepth.add(this.aBackward);
        jMenuItem.setIcon(null);
        jMenuItem = this.mDepth.add(this.aBack);
        jMenuItem.setIcon(null);
    }

    public void addAlignMenu(JPopupMenu jPopupMenu) {
        this.mAlign = (JMenu)jPopupMenu.add(resources.getMenu("galign"));
        JMenuItem jMenuItem = this.mAlign.add(this.aLeft);
        jMenuItem.setIcon(null);
        jMenuItem = this.mAlign.add(this.aRight);
        jMenuItem.setIcon(null);
        jMenuItem = this.mAlign.add(this.aTop);
        jMenuItem.setIcon(null);
        jMenuItem = this.mAlign.add(this.aBottom);
        jMenuItem.setIcon(null);
        jMenuItem = this.mAlign.add(this.aVCenter);
        jMenuItem.setIcon(null);
        jMenuItem = this.mAlign.add(this.aHCenter);
        jMenuItem.setIcon(null);
    }

    public void addToolsMenu(JMenuBar jMenuBar) {
        JMenu jMenu = resources.getMenu("tools");
        this.miFindPlugins = resources.getItem("findPlugins", this);
        jMenu.add(this.miFindPlugins);
        this.miPreferencesPanel = resources.getItem("openPreferences", this);
        jMenu.add(this.miPreferencesPanel);
        this.miChooseLanguage = resources.getItem("chooseLanguage", this);
        jMenu.add(this.miChooseLanguage);
        jMenuBar.add(jMenu);
    }

    public void addHelpMenu(JMenuBar jMenuBar) {
        JMenu jMenu = resources.getMenu("help");
        this.miAbout = resources.getItem("about", this);
        jMenu.add(this.miAbout);
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(jMenu);
    }

    public boolean canEdit() {
        return this.isEditable;
    }

    public SourcePanel getSourcePanel() {
        return this.sourcePanel;
    }

    public Vector getPlugins() {
        return this.plugins;
    }

    public JComponent getActiveComponent() {
        return this.desktopCardPanel.getSelectedComponent();
    }

    public DiagramComponent getActiveDiagram() {
        JComponent jComponent = this.desktopCardPanel.getSelectedComponent();
        if (!(jComponent instanceof DiagramComponent)) {
            return null;
        }
        return (DiagramComponent)jComponent;
    }

    public ShapesContainer getActiveContainer() {
        JComponent jComponent = this.desktopCardPanel.getSelectedComponent();
        if (!(jComponent instanceof ShapesContainer.ShapesComponent)) {
            return null;
        }
        return (ShapesContainer)((ShapesContainer.ShapesComponent)jComponent).getContainer();
    }

    public void addComponent(JComponent jComponent, File file) {
        this.desktopCardPanel.addComponent(jComponent, file);
        this.desktopCardPanel.selectComponent(jComponent);
    }

    public void addComponent(JComponent jComponent) {
        this.addComponent(jComponent, null);
    }

    public void addContainer(ShapesContainer shapesContainer, File file) {
        this.addComponent(shapesContainer.getComponent(), file);
    }

    public void addContainer(ShapesContainer shapesContainer) {
        this.addContainer(shapesContainer, null);
    }

    public void setFile(JComponent jComponent, File file) {
        this.desktopCardPanel.setFile(jComponent, file);
    }

    public FiledDesktopCardPanel getFilePanel() {
        return this.desktopCardPanel;
    }

    public File getFile(JComponent jComponent) {
        return this.desktopCardPanel.getFile(jComponent);
    }

    public void setFile(ShapesContainer shapesContainer, File file) {
        this.setFile(shapesContainer.getComponent(), file);
    }

    public File getFile(ShapesContainer shapesContainer) {
        return this.getFile(shapesContainer.getComponent());
    }

    protected File getFileFromDialog(int n) {
        String string;
        if (n == 2) {
            string = resources.getStringValue("saveDialogText");
            this.fileChooser = this.saveFileChooser;
        } else {
            string = resources.getStringValue("openDialogText");
            this.fileChooser = this.openFileChooser;
        }
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(this.currentPath);
            FileFilter fileFilter = null;
            for (int i = 0; i < this.plugins.size(); ++i) {
                Plugin plugin = (Plugin)this.plugins.get(i);
                FileFilter[] fileFilterArray = plugin.getFileFilters(n);
                if (fileFilterArray == null) continue;
                for (int j = 0; j < fileFilterArray.length; ++j) {
                    this.fileChooser.addChoosableFileFilter(fileFilterArray[j]);
                    if (fileFilter != null) continue;
                    fileFilter = fileFilterArray[j];
                }
            }
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            AggregateFileFilter aggregateFileFilter = null;
            if (n == 1) {
                aggregateFileFilter = new AggregateFileFilter(this.fileChooser.getChoosableFileFilters());
                this.fileChooser.addChoosableFileFilter(aggregateFileFilter);
                this.fileChooser.setAccessory(new FileChooserAccessory());
            }
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            if (fileFilter != null) {
                this.fileChooser.setFileFilter(aggregateFileFilter != null ? aggregateFileFilter : fileFilter);
            }
            if (n == 2) {
                this.saveFileChooser = this.fileChooser;
            } else {
                this.openFileChooser = this.fileChooser;
            }
        }
        this.fileChooser.setCurrentDirectory(this.currentPath);
        int n2 = this.fileChooser.showDialog(this, string);
        if (n2 != 0) {
            return null;
        }
        this.currentPath = this.fileChooser.getCurrentDirectory();
        this.currentFileFilter = this.fileChooser.getFileFilter();
        if (this.currentFileFilter instanceof AggregateFileFilter) {
            this.currentFileFilter = ((AggregateFileFilter)this.currentFileFilter).getFilterForFile(this.fileChooser.getSelectedFile());
            if (this.currentFileFilter == null) {
                return null;
            }
        }
        return this.fileChooser.getSelectedFile();
    }

    protected Plugin getPluginForFilter(int n, FileFilter fileFilter) {
        if (fileFilter == null) {
            return null;
        }
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin = (Plugin)this.plugins.get(i);
            FileFilter[] fileFilterArray = plugin.getFileFilters(n);
            if (fileFilterArray == null) continue;
            for (int j = 0; j < fileFilterArray.length; ++j) {
                if (!fileFilter.equals(fileFilterArray[j])) continue;
                return plugin;
            }
        }
        return null;
    }

    protected Plugin getPluginToProcessFile(File file, int n, FileFilter fileFilter) {
        boolean bl = fileFilter == null ? false : fileFilter.accept(file);
        Plugin plugin = null;
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin2 = (Plugin)this.plugins.get(i);
            FileFilter[] fileFilterArray = plugin2.getFileFilters(n);
            if (fileFilterArray == null) continue;
            for (int j = 0; j < fileFilterArray.length; ++j) {
                if (bl && fileFilterArray[j].equals(fileFilter)) {
                    return plugin2;
                }
                if (plugin != null && !(plugin instanceof Builtin) || !fileFilterArray[j].accept(file)) continue;
                plugin = plugin2;
            }
        }
        if (plugin == null) {
            JOptionPane.showMessageDialog(this, messageWriter.print1args("noPluginForFile", file.getName()), resources.getStringValue("unknownFileType"), 0);
            return null;
        }
        return plugin;
    }

    public void open() {
        File file = this.getFileFromDialog(1);
        this.open(file);
    }

    public void open(File file) {
        if (file == null) {
            return;
        }
        Plugin plugin = this.getPluginToProcessFile(file, 1, this.currentFileFilter);
        if (plugin == null) {
            return;
        }
        plugin.processFile(file, 1);
    }

    protected void saveAs(File file) {
        Plugin plugin;
        if (file == null && (file = this.getFileFromDialog(2)) == null) {
            return;
        }
        if (file.getName().indexOf(".") == -1) {
            file = new File(file.getAbsolutePath() + resources.getStringValue("defaultSaveExtension"));
        }
        if ((plugin = this.getPluginToProcessFile(file, 2, this.currentFileFilter)) == null) {
            return;
        }
        plugin.processFile(file, 2);
    }

    void setSelectionEditEnabled(boolean bl) {
        DiagramComponent diagramComponent;
        if (bl && (diagramComponent = this.getActiveDiagram()) != null) {
            DiagramSelection diagramSelection = diagramComponent.getDiagramSelection();
            for (int i = 0; i < this.lockedShapes.size(); ++i) {
                if (!diagramSelection.isSelected((Shape)this.lockedShapes.get(i))) continue;
                bl = false;
                break;
            }
        }
        this.aCut.setEnabled(bl);
        this.aCopy.setEnabled(bl);
        this.aRemove.setEnabled(bl);
        this.aFront.setEnabled(bl);
        this.aForward.setEnabled(bl);
        this.aBackward.setEnabled(bl);
        this.aBack.setEnabled(bl);
        this.aLeft.setEnabled(bl);
        this.aRight.setEnabled(bl);
        this.aTop.setEnabled(bl);
        this.aBottom.setEnabled(bl);
        this.aVCenter.setEnabled(bl);
        this.aHCenter.setEnabled(bl);
        this.aLineColor.setEnabled(bl);
        this.aFontColor.setEnabled(bl);
        this.aBackgroundColor.setEnabled(bl);
    }

    void setPasteEnabled(boolean bl) {
        this.aPaste.setEnabled(bl);
    }

    void setDiagramComponentSpecificsEnabled(boolean bl) {
        this.miPrint.setEnabled(bl);
        this.miPrintImage.setEnabled(bl);
        this.bPrint.setEnabled(bl);
        this.bAdjust.setEnabled(bl);
        this.tbGridDisplay.setEnabled(bl);
        this.cbxGrid.setEnabled(bl);
        this.cbxZoom.setEnabled(bl);
        this.bAlign.setEnabled(bl);
        if (bl) {
            this.updateUndoEnabled();
        } else {
            this.bUndo.setEnabled(bl);
            this.bRedo.setEnabled(false);
        }
    }

    public void selectionChanged(DiagramSelection diagramSelection) {
        this.setSelectionEditEnabled(!diagramSelection.isEmpty() && this.isEditable);
        Vector vector = diagramSelection.getSelection();
        if (this.aLineColor.isEnabled()) {
            this.aLineColor.setEnabled(this.aLineColor.update(vector));
        }
        if (this.aBackgroundColor.isEnabled()) {
            this.aBackgroundColor.setEnabled(this.aBackgroundColor.update(vector));
        }
        if (this.aFontColor.isEnabled()) {
            this.aFontColor.setEnabled(this.aFontColor.update(vector));
        }
    }

    public void clipboardChanged(DiagramClipboard diagramClipboard) {
        this.setPasteEnabled(!diagramClipboard.isEmpty());
    }

    public void componentSelected(JComponent jComponent) {
        int n;
        if (jComponent == null) {
            return;
        }
        if (!(jComponent instanceof DiagramComponent)) {
            this.setSelectionEditEnabled(false);
            this.setPasteEnabled(false);
            this.setDiagramComponentSpecificsEnabled(false);
            return;
        }
        DiagramComponent diagramComponent = (DiagramComponent)jComponent;
        if (jComponent == null) {
            return;
        }
        DiagramSelection diagramSelection = diagramComponent.getDiagramSelection();
        diagramSelection.addListener(this);
        this.selectionChanged(diagramSelection);
        this.setDiagramComponentSpecificsEnabled(true);
        String string = String.valueOf(diagramComponent.getGrid());
        boolean bl = false;
        for (n = 0; n < this.cbxGrid.getItemCount(); ++n) {
            String string2 = (String)this.cbxGrid.getItemAt(n);
            if (!string.equals(string2)) continue;
            this.cbxGrid.setSelectedIndex(n);
            bl = true;
        }
        if (!bl) {
            this.cbxGrid.getEditor().setItem(string);
        }
        this.tbGridDisplay.setSelected(diagramComponent.getGridDisplay());
        n = (int)(diagramComponent.getZoom() * 100.0);
        string = String.valueOf(n) + "%";
        bl = false;
        for (int i = 0; i < this.cbxZoom.getItemCount(); ++i) {
            String string3 = (String)this.cbxZoom.getItemAt(i);
            if (!string.equals(string3)) continue;
            this.cbxZoom.setSelectedIndex(i);
            bl = true;
        }
        if (!bl) {
            this.cbxZoom.getEditor().setItem(string);
        }
        this.updateUndoActions();
    }

    public void newComponent() {
        String string = messageWriter.print1args("untitledDocNum", new Integer(++this.untitledDocumentNumber));
        ShapesContainer shapesContainer = new ShapesContainer(string);
        this.addContainer(shapesContainer);
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin = (Plugin)this.plugins.get(i);
            if (plugin == null) continue;
            plugin.newComponent(shapesContainer.getComponent());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.miExit) {
            this.exit();
        } else {
            if (actionEvent.getSource() == this.miNew || actionEvent.getSource() == this.bNew) {
                this.newComponent();
                return;
            }
            if (actionEvent.getSource() == this.miSave || actionEvent.getSource() == this.bSave) {
                if (!this.canSave()) {
                    return;
                }
                File file = this.desktopCardPanel.getFile(this.desktopCardPanel.getSelectedIndex());
                this.saveAs(file);
            } else {
                if (actionEvent.getSource() == this.miSaveAs) {
                    if (!this.canSave()) {
                        return;
                    }
                    this.saveAs(null);
                    return;
                }
                if (actionEvent.getSource() == this.miOpen || actionEvent.getSource() == this.bOpen) {
                    if (!this.canOpen()) {
                        return;
                    }
                    this.open();
                    return;
                }
                if (actionEvent.getSource() == this.miClose) {
                    JComponent jComponent = this.desktopCardPanel.getSelectedComponent();
                    if (jComponent == null) {
                        return;
                    }
                    this.desktopCardPanel.removeComponent(jComponent);
                } else if (actionEvent.getSource() == this.bUndo || actionEvent.getSource() == this.miUndo) {
                    this.undoAction.actionPerformed(actionEvent);
                    this.desktopCardPanel.getSelectedComponent().repaint();
                } else if (actionEvent.getSource() == this.bRedo || actionEvent.getSource() == this.miRedo) {
                    this.redoAction.actionPerformed(actionEvent);
                    this.desktopCardPanel.getSelectedComponent().repaint();
                } else {
                    if (actionEvent.getSource() == this.bAdjust) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent != null) {
                            diagramComponent.adjust();
                        }
                        return;
                    }
                    if (actionEvent.getSource() == this.bAlign) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent != null) {
                            diagramComponent.align();
                        }
                        return;
                    }
                    if (actionEvent.getSource() == this.cbxGrid) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent == null) {
                            return;
                        }
                        int n = 0;
                        try {
                            n = Long.decode((String)this.cbxGrid.getSelectedItem()).intValue();
                        }
                        catch (Exception exception) {
                            n = 0;
                        }
                        diagramComponent.setGrid(n);
                        return;
                    }
                    if (actionEvent.getSource() == this.cbxZoom) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent == null) {
                            return;
                        }
                        int n = 0;
                        try {
                            String string = (String)this.cbxZoom.getSelectedItem();
                            if (string.endsWith("%")) {
                                string = string.substring(0, string.length() - 1);
                            }
                            n = Long.decode(string).intValue();
                        }
                        catch (Exception exception) {
                            n = 100;
                        }
                        diagramComponent.setZoom((double)n / 100.0);
                        return;
                    }
                    if (actionEvent.getSource() == this.tbGridDisplay) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent == null) {
                            return;
                        }
                        diagramComponent.setGridDisplay(this.tbGridDisplay.isSelected());
                    } else if (object == this.miPrint || object == this.bPrint) {
                        if (!this.canPrint()) {
                            return;
                        }
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent == null) {
                            return;
                        }
                        PrintDialog printDialog = new PrintDialog(diagramComponent.toString());
                        printDialog.show();
                        if (!printDialog.getResult()) {
                            return;
                        }
                        PrinterJob printerJob = printDialog.getPrinterJob();
                        diagramComponent.setSelectionPrintMode(printDialog.printSelection());
                        printerJob.setPrintable(diagramComponent, printDialog.getPageFormat());
                        JSynoptic.setStatus(messageWriter.print1args("printingTo", printerJob.getPrintService().getName()));
                        try {
                            printerJob.print();
                        }
                        catch (Exception exception) {
                            JSynoptic.setStatus(messageWriter.print1args("printFailed", exception.getMessage()));
                            exception.printStackTrace();
                        }
                    } else if (object == this.miPrintImage || object == this.bPrintImage) {
                        if (!this.canPrint()) {
                            return;
                        }
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent == null) {
                            return;
                        }
                        if (this.printImage == null) {
                            this.printImage = new PrintToImage();
                        }
                        try {
                            this.printImage.print(diagramComponent);
                        }
                        catch (Exception exception) {
                            JSynoptic.setStatus(messageWriter.print1args("printFailed", exception.getMessage()));
                            exception.printStackTrace();
                        }
                    } else if (actionEvent.getSource() == this.miChooseLanguage) {
                        int n;
                        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
                        int n2 = resources.getIntValue("languageNumber");
                        String string = Run.getProperties().getString("jsynoptic.language", "");
                        int n3 = -1;
                        for (int i = 0; i < n2; ++i) {
                            defaultListModel.addElement(resources.getStringValue("languageName" + i));
                            if (!resources.getStringValue("languageCode" + i).equals(string)) continue;
                            n3 = i;
                        }
                        JList jList = new JList(defaultListModel);
                        jList.setSelectionMode(0);
                        if (n3 != -1) {
                            jList.setSelectedIndex(n3);
                        }
                        if ((n = JOptionPane.showConfirmDialog(null, jList, resources.getString("chooseLanguageTitle"), 2, -1)) == 0 && jList.getSelectedIndex() != -1) {
                            String string2 = resources.getStringValue("languageCode" + jList.getSelectedIndex());
                            Run.getProperties().setString("jsynoptic.language", string2 != null ? string2 : "");
                        }
                    } else {
                        if (actionEvent.getSource() == this.miFindPlugins) {
                            JSynoptic.setStatus(messageWriter.print0args("lookingForPlugins"));
                            new LongAction(){

                                protected void doAction() {
                                    String string = "";
                                    PluginLookup.addPluginPaths();
                                    userProperties.setString("jsynoptic.class.path", PluginLookup.getClassPath());
                                    Vector vector = PluginLookup.lookup();
                                    Iterator iterator = vector.iterator();
                                    while (iterator.hasNext()) {
                                        String string2 = (String)iterator.next();
                                        if (!string.equals("")) {
                                            string = string + ",";
                                        }
                                        string = string + string2;
                                    }
                                    if (!string.equals("")) {
                                        userProperties.setString("jsynoptic.plugins", string);
                                    }
                                    vector.add(0, " \n" + messageWriter.print0args("foundPlugins") + "\n ");
                                    vector.add(" \n" + messageWriter.print0args("restartForPlugins") + "\n ");
                                    JOptionPane.showMessageDialog(null, vector.toArray(), messageWriter.print0args("Plugins:"), 1);
                                }
                            }.start();
                            return;
                        }
                        if (actionEvent.getSource() == this.miPreferencesPanel) {
                            if (this.propEditor == null) {
                                this.propEditor = new UserPropertiesEditor(this);
                            }
                            this.propEditor.showAndUpdate(userProperties, true);
                            return;
                        }
                        if (actionEvent.getSource() == this.miAbout) {
                            if (this.aboutFrame == null) {
                                this.aboutFrame = new JFrame(messageWriter.print1args("aboutTitle", Run.productName));
                                String string = messageWriter.print1args("aboutContent", String.valueOf(Run.productVersion));
                                boolean bl = false;
                                Object object2 = this.plugins.iterator();
                                while (object2.hasNext()) {
                                    Plugin plugin = (Plugin)object2.next();
                                    String string3 = plugin.about();
                                    if (string3 == null) continue;
                                    if (!bl) {
                                        string = string + "<p>" + messageWriter.print0args("Plugins:") + "<ul>";
                                        bl = true;
                                    }
                                    string = string + "<li>" + plugin.about() + "</li>";
                                }
                                if (bl) {
                                    string = string + "</ul></p>";
                                }
                                object2 = new JEditorPane("text/html", string);
                                ((JTextComponent)object2).setEditable(false);
                                this.aboutFrame.getContentPane().add((Component)object2);
                                this.aboutFrame.pack();
                                this.aboutFrame.doLayout();
                            }
                            this.aboutFrame.show();
                            return;
                        }
                    }
                }
            }
        }
        this.updateUndoActions();
    }

    void addLongActions(long l, Object object) {
        block16: {
            Object object2;
            int n;
            block18: {
                block17: {
                    if ((l & 1L) != 0L) {
                        this.lockFileOpen();
                    }
                    if ((l & 2L) != 0L) {
                        this.lockFileSave();
                    }
                    if ((l & 4L) != 0L) {
                        this.lockPrint();
                    }
                    if ((l & 0x10L) != 0L) {
                        DiagramSelection diagramSelection;
                        n = 0;
                        object2 = this.getActiveDiagram();
                        DiagramSelection diagramSelection2 = diagramSelection = object2 == null ? null : ((DiagramComponent)object2).getDiagramSelection();
                        if (object != null) {
                            Object object3;
                            if (object instanceof Shape) {
                                this.lockedShapes.add(object);
                                if (diagramSelection != null && diagramSelection.isSelected((Shape)object)) {
                                    n = 1;
                                }
                            } else if (object instanceof Vector) {
                                Iterator iterator = ((Vector)object).iterator();
                                while (iterator.hasNext()) {
                                    object3 = iterator.next();
                                    if (!(object3 instanceof Shape)) continue;
                                    this.lockedShapes.add(object3);
                                    if (diagramSelection == null || !diagramSelection.isSelected((Shape)object3)) continue;
                                    n = 1;
                                }
                            } else if (object instanceof Object[]) {
                                for (int i = 0; i < ((Object[])object).length; ++i) {
                                    object3 = ((Object[])object)[i];
                                    if (!(object3 instanceof Shape)) continue;
                                    this.lockedShapes.add(object3);
                                    if (diagramSelection == null || !diagramSelection.isSelected((Shape)object3)) continue;
                                    n = 1;
                                }
                            }
                        }
                        if (n != 0) {
                            this.selectionChanged(diagramSelection);
                        }
                    }
                    if ((l & 8L) == 0L || object == null) break block16;
                    if (!(object instanceof DataSource) && !(object instanceof DataSourceCollection)) break block17;
                    this.sourcePanel.getSourceTree().lock(object);
                    break block16;
                }
                if (!(object instanceof Vector)) break block18;
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    if (!(object2 instanceof DataSource) && !(object2 instanceof DataSourceCollection)) continue;
                    this.sourcePanel.getSourceTree().lock(object2);
                }
                break block16;
            }
            if (!(object instanceof Object[])) break block16;
            for (n = 0; n < ((Object[])object).length; ++n) {
                object2 = ((Object[])object)[n];
                if (!(object2 instanceof DataSource) && !(object2 instanceof DataSourceCollection)) continue;
                this.sourcePanel.getSourceTree().lock(object2);
            }
        }
    }

    void removeLongActions(long l, Object object) {
        block16: {
            Object object2;
            int n;
            block18: {
                block17: {
                    if ((l & 1L) != 0L) {
                        this.unlockFileOpen();
                    }
                    if ((l & 2L) != 0L) {
                        this.unlockFileSave();
                    }
                    if ((l & 4L) != 0L) {
                        this.unlockPrint();
                    }
                    if ((l & 0x10L) != 0L) {
                        DiagramSelection diagramSelection;
                        n = 0;
                        object2 = this.getActiveDiagram();
                        DiagramSelection diagramSelection2 = diagramSelection = object2 == null ? null : ((DiagramComponent)object2).getDiagramSelection();
                        if (object != null) {
                            Object object3;
                            if (object instanceof Shape) {
                                this.lockedShapes.remove(object);
                                if (diagramSelection != null && diagramSelection.isSelected((Shape)object)) {
                                    n = 1;
                                }
                            } else if (object instanceof Vector) {
                                Iterator iterator = ((Vector)object).iterator();
                                while (iterator.hasNext()) {
                                    object3 = iterator.next();
                                    if (!(object3 instanceof Shape)) continue;
                                    this.lockedShapes.remove(object3);
                                    if (diagramSelection == null || !diagramSelection.isSelected((Shape)object3)) continue;
                                    n = 1;
                                }
                            } else if (object instanceof Object[]) {
                                for (int i = 0; i < ((Object[])object).length; ++i) {
                                    object3 = ((Object[])object)[i];
                                    if (!(object3 instanceof Shape)) continue;
                                    this.lockedShapes.remove(object3);
                                    if (diagramSelection == null || !diagramSelection.isSelected((Shape)object3)) continue;
                                    n = 1;
                                }
                            }
                        }
                        if (n != 0) {
                            this.selectionChanged(diagramSelection);
                        }
                    }
                    if ((l & 8L) == 0L || object == null) break block16;
                    if (!(object instanceof DataSource) && !(object instanceof DataSourceCollection)) break block17;
                    this.sourcePanel.getSourceTree().unlock(object);
                    break block16;
                }
                if (!(object instanceof Vector)) break block18;
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    if (!(object2 instanceof DataSource) && !(object2 instanceof DataSourceCollection)) continue;
                    this.sourcePanel.getSourceTree().unlock(object2);
                }
                break block16;
            }
            if (!(object instanceof Object[])) break block16;
            for (n = 0; n < ((Object[])object).length; ++n) {
                object2 = ((Object[])object)[n];
                if (!(object2 instanceof DataSource) && !(object2 instanceof DataSourceCollection)) continue;
                this.sourcePanel.getSourceTree().unlock(object2);
            }
        }
    }

    public void setPath(File file) {
        if (file.isDirectory()) {
            this.currentPath = file;
            return;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return;
        }
        this.currentPath = file2;
    }

    public File getPath() {
        return this.currentPath;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public static void setStatus(String string) {
        if (gui == null || JSynoptic.gui.status == null) {
            return;
        }
        if (string == null) {
            string = "";
        }
        if (JSynoptic.gui.cleanStatusTask != null) {
            JSynoptic.gui.cleanStatusTask.cancel();
        }
        JSynoptic.gui.status.setText(string);
        JSynoptic.gui.cleanStatusTask = new TimerTask(){

            public void run() {
                JSynoptic.gui.status.setText("");
                JSynoptic.gui.cleanStatusTask.cancel();
                JSynoptic.gui.cleanStatusTask = null;
            }
        };
        JSynoptic.gui.cleanStatusTimer.schedule(JSynoptic.gui.cleanStatusTask, JSynoptic.gui.statusDelay);
    }

    protected void updateUndoActions() {
        ShapesContainer.ShapesComponent shapesComponent = (ShapesContainer.ShapesComponent)this.desktopCardPanel.getSelectedComponent();
        if (shapesComponent != null) {
            int n;
            this.undoAction = shapesComponent.getUndoHandler().getUndoAction();
            this.redoAction = shapesComponent.getUndoHandler().getRedoAction();
            PropertyChangeListener[] propertyChangeListenerArray = this.undoAction.getPropertyChangeListeners();
            boolean bl = false;
            for (n = this.undoAction.getPropertyChangeListeners().length; n > 0 && !bl; --n) {
                bl = propertyChangeListenerArray[n - 1] == this;
            }
            if (!bl) {
                this.undoAction.addPropertyChangeListener(this);
            }
            propertyChangeListenerArray = this.redoAction.getPropertyChangeListeners();
            bl = false;
            for (n = propertyChangeListenerArray.length; n > 0 && !bl; --n) {
                bl = propertyChangeListenerArray[n - 1] == this;
            }
            if (!bl) {
                this.redoAction.addPropertyChangeListener(this);
            }
        } else {
            this.undoAction = null;
            this.redoAction = null;
        }
        this.updateUndoEnabled();
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateUndoEnabled();
    }

    protected void updateUndoEnabled() {
        if (this.toolbar != null) {
            if (this.undoAction != null && this.redoAction != null) {
                this.bUndo.setEnabled(this.undoAction.isEnabled());
                this.miUndo.setEnabled(this.undoAction.isEnabled());
                this.bRedo.setEnabled(this.redoAction.isEnabled());
                this.miRedo.setEnabled(this.redoAction.isEnabled());
            } else {
                this.bUndo.setEnabled(false);
                this.miUndo.setEnabled(false);
                this.bRedo.setEnabled(false);
                this.miRedo.setEnabled(false);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class FileChooserAccessory
    extends JPanel
    implements PropertyChangeListener {
        public FileChooserAccessory() {
            JSynoptic.this.fileChooser.addPropertyChangeListener("fileFilterChanged", this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Plugin plugin;
            if ("fileFilterChanged".equals(propertyChangeEvent.getPropertyName()) && (plugin = JSynoptic.this.getPluginForFilter(1, JSynoptic.this.fileChooser.getFileFilter())) != null) {
                this.removeAll();
                JComponent jComponent = plugin.getOptionPanelForFilter(JSynoptic.this.fileChooser.getFileFilter());
                if (jComponent != null) {
                    this.add(jComponent);
                    jComponent.setVisible(true);
                }
                this.revalidate();
            }
        }
    }

    class ArrowMenu
    extends JMenu {
        ArrowMenu(String string) {
            super(string);
        }

        public boolean isTopLevelMenu() {
            return false;
        }

        public void select() {
            System.out.println("fire");
            this.setSelected(true);
        }
    }
}

