/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import jsynoptic.ui.JSynoptic;
import simtools.diagram.DiagramComponent;

public class PrintToImage {
    protected static HashMap formatsMap = new HashMap();
    protected JFileChooser printFileChooser;

    public PrintToImage() {
        String string = System.getProperty("user.dir");
        if (JSynoptic.gui != null) {
            string = JSynoptic.gui.getPath().getAbsolutePath();
        }
        this.printFileChooser = new JFileChooser(string);
        Iterator iterator = formatsMap.keySet().iterator();
        ImageWriterFileFilter imageWriterFileFilter = null;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            ImageWriterFileFilter imageWriterFileFilter2 = new ImageWriterFileFilter(string2);
            if (string2.equals("png")) {
                imageWriterFileFilter = imageWriterFileFilter2;
            }
            this.printFileChooser.addChoosableFileFilter(imageWriterFileFilter2);
        }
        if (imageWriterFileFilter != null) {
            this.printFileChooser.setFileFilter(imageWriterFileFilter);
        }
        this.printFileChooser.setAcceptAllFileFilterUsed(false);
    }

    public void print(DiagramComponent diagramComponent) throws IOException {
        String string;
        this.printFileChooser.setDialogTitle(diagramComponent.getName());
        FileFilter fileFilter = this.printFileChooser.getFileFilter();
        if (fileFilter == null) {
            return;
        }
        String string2 = "." + ((ImageWriterFileFilter)this.printFileChooser.getFileFilter()).suffix;
        File file = new File(this.printFileChooser.getCurrentDirectory(), diagramComponent.getName() + string2);
        this.printFileChooser.setSelectedFile(file);
        int n = this.printFileChooser.showSaveDialog(JSynoptic.gui);
        if (n != 0) {
            return;
        }
        String string3 = ((ImageWriterFileFilter)this.printFileChooser.getFileFilter()).suffix;
        file = this.printFileChooser.getSelectedFile();
        if (!file.getName().endsWith("." + string3)) {
            file = new File(file.getParentFile(), file.getName() + "." + string3);
        }
        if ((string = (String)formatsMap.get(string3)) == null) {
            return;
        }
        Rectangle rectangle = diagramComponent.getBounds();
        rectangle.width = (int)((double)rectangle.width / diagramComponent.getZoom());
        rectangle.height = (int)((double)rectangle.height / diagramComponent.getZoom());
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        diagramComponent.printDiagram(graphics2D);
        ImageIO.write((RenderedImage)bufferedImage, string, file);
    }

    static {
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(stringArray[i]);
            ImageWriter imageWriter = iterator.next();
            String[] stringArray2 = imageWriter.getOriginatingProvider().getFileSuffixes();
            for (int j = 0; j < stringArray2.length; ++j) {
                if (formatsMap.containsKey(stringArray2[j])) continue;
                formatsMap.put(stringArray2[j], stringArray[i]);
            }
        }
    }

    public class ImageWriterFileFilter
    extends FileFilter {
        String suffix;

        public ImageWriterFileFilter(String string) {
            this.suffix = string;
        }

        public boolean accept(File file) {
            return file.getName().endsWith("." + this.suffix);
        }

        public String getDescription() {
            return this.suffix;
        }
    }
}

