/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.shapes.ShapeListener;

public class CompoundShape
extends AbstractShape
implements Serializable,
Cloneable,
Resizable,
ShapeListener {
    static final long serialVersionUID = -7949581832604213737L;
    protected Vector _shapes = new Vector();

    public CompoundShape() {
        super(0, 0);
    }

    protected AbstractShape cloneShape() {
        CompoundShape compoundShape = null;
        try {
            compoundShape = (CompoundShape)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        compoundShape._shapes = new Vector();
        Iterator iterator = this._shapes.iterator();
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            ShapeAndSize shapeAndSize2 = new ShapeAndSize(shapeAndSize.shape.cloneShape());
            shapeAndSize2.shape.addListener(compoundShape);
            compoundShape._shapes.add(shapeAndSize2);
        }
        return compoundShape;
    }

    public int size() {
        return this._shapes.size();
    }

    public boolean contains(AbstractShape abstractShape) {
        Iterator iterator = this._shapes.iterator();
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            if (shapeAndSize.shape != abstractShape) continue;
            return true;
        }
        return false;
    }

    public AbstractShape getShape(int n) {
        ShapeAndSize shapeAndSize = (ShapeAndSize)this._shapes.elementAt(n);
        return shapeAndSize.shape;
    }

    public void addShape(AbstractShape abstractShape) {
        if (this._shapes.size() == 0) {
            this.setAnchor(abstractShape.getAnchor());
        }
        this._shapes.add(new ShapeAndSize(abstractShape));
        abstractShape.addListener(this);
        this.computeBounds();
        this.synchroSizes();
    }

    public void addShapes(Vector vector) {
        AbstractShape abstractShape;
        if (vector.size() == 0) {
            return;
        }
        if (this._shapes.size() == 0) {
            abstractShape = (AbstractShape)vector.elementAt(0);
            this.setAnchor(abstractShape.getAnchor());
        }
        for (int i = 0; i < vector.size(); ++i) {
            abstractShape = (AbstractShape)vector.elementAt(i);
            abstractShape.addListener(this);
            this._shapes.add(new ShapeAndSize(abstractShape));
        }
        this.computeBounds();
        this.synchroSizes();
    }

    public void removeShape(AbstractShape abstractShape) {
        Iterator iterator = this._shapes.iterator();
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            if (shapeAndSize.shape != abstractShape) continue;
            this._shapes.remove(shapeAndSize);
            abstractShape.removeListener(this);
            this.computeAnchor();
            this.computeBounds();
            this.synchroSizes();
            return;
        }
    }

    public void removeShapes(Vector vector) {
        boolean bl = false;
        Iterator iterator = this._shapes.iterator();
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            if (!vector.contains(shapeAndSize.shape)) continue;
            shapeAndSize.shape.removeListener(this);
            iterator.remove();
            bl = true;
        }
        if (bl) {
            this.computeAnchor();
            this.computeBounds();
            this.synchroSizes();
        }
    }

    public void retainShapes(Vector vector) {
        boolean bl = false;
        Iterator iterator = this._shapes.iterator();
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            if (vector.contains(shapeAndSize.shape)) continue;
            iterator.remove();
            shapeAndSize.shape.removeListener(this);
            bl = true;
        }
        if (bl) {
            this.computeAnchor();
            this.computeBounds();
            this.synchroSizes();
        }
    }

    public void resize(int n, int n2) {
        Iterator iterator = this._shapes.iterator();
        float f = n;
        float f2 = n2;
        float f3 = this._w;
        float f4 = this._h;
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            AbstractShape abstractShape = shapeAndSize.shape;
            shapeAndSize.w += shapeAndSize.w / f3 * f;
            shapeAndSize.h += shapeAndSize.h / f4 * f2;
            int n3 = (int)(shapeAndSize.w - (float)abstractShape._w);
            int n4 = (int)(shapeAndSize.h - (float)abstractShape._h);
            shapeAndSize.x += shapeAndSize.x / f3 * f;
            shapeAndSize.y += shapeAndSize.y / f4 * f2;
            int n5 = (int)(shapeAndSize.x - shapeAndSize.getX());
            int n6 = (int)(shapeAndSize.y - shapeAndSize.getY());
            if (!(abstractShape instanceof Resizable)) continue;
            ((Resizable)((Object)abstractShape)).resize(n3, n4);
            abstractShape.translate(n5, n6);
        }
        this.computeBounds();
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        Iterator iterator = this._shapes.iterator();
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            shapeAndSize.shape.translate(n, n2);
        }
    }

    public void draw(Graphics2D graphics2D) {
        Iterator iterator = this._shapes.iterator();
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            shapeAndSize.shape.draw(graphics2D);
        }
    }

    public void synchroSizes() {
        Iterator iterator = this._shapes.iterator();
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            shapeAndSize.setSize();
        }
    }

    protected void computeBounds() {
        Rectangle rectangle = null;
        Iterator iterator = this._shapes.iterator();
        while (iterator.hasNext()) {
            ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
            if (rectangle == null) {
                rectangle = shapeAndSize.shape.getBounds();
                continue;
            }
            rectangle.add(shapeAndSize.shape.getBounds());
        }
        this._w = rectangle.width;
        this._h = rectangle.height;
        this._x = rectangle.x - this._ox;
        this._y = rectangle.y + this._h - this._oy;
    }

    protected void computeAnchor() {
        if (this._shapes.size() > 0) {
            Iterator iterator = this._shapes.iterator();
            AbstractShape abstractShape = null;
            double d = 0.0;
            while (iterator.hasNext()) {
                ShapeAndSize shapeAndSize = (ShapeAndSize)iterator.next();
                AbstractShape abstractShape2 = shapeAndSize.shape;
                if (abstractShape == null) {
                    abstractShape = abstractShape2;
                    d = this.getAnchor().distance(abstractShape2.getAnchor());
                    continue;
                }
                double d2 = this.getAnchor().distance(abstractShape2.getAnchor());
                if (!(d2 < d)) continue;
                abstractShape = abstractShape2;
                d = d2;
            }
            this.setAnchor(abstractShape.getAnchor());
        } else {
            this.setAnchor(new Point(0, 0));
        }
    }

    public void shapeChanged(AbstractShape abstractShape, Rectangle rectangle) {
        this.notifyChange(rectangle);
    }

    public class ShapeAndSize {
        AbstractShape shape;
        float x;
        float y;
        float w;
        float h;

        public ShapeAndSize(AbstractShape abstractShape) {
            this.shape = abstractShape;
            this.setSize();
        }

        public void setSize() {
            this.x = this.getX();
            this.y = this.getY();
            this.w = this.shape._w;
            this.h = this.shape._h;
        }

        public float getX() {
            return this.shape._ox + this.shape._x - (CompoundShape.this._ox + CompoundShape.this._x);
        }

        public float getY() {
            return this.shape._oy + this.shape._y - this.shape._h - (CompoundShape.this._oy + CompoundShape.this._y - CompoundShape.this._h);
        }

        public String toString() {
            return "(" + this.getX() + "," + this.getY() + " " + this.shape._w + "," + this.shape._h + ") -> (" + this.x + "," + this.y + " " + this.w + "," + this.h + ")";
        }
    }
}

