/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import processing.app.Base;
import processing.app.Editor;

public class FindReplace
extends JFrame
implements ActionListener {
    static final int BIG = 13;
    static final int SMALL = 6;
    Editor editor;
    JTextField findField;
    JTextField replaceField;
    static String findString;
    static String replaceString;
    JButton replaceButton;
    JButton replaceAllButton;
    JButton replaceFindButton;
    JButton findButton;
    JCheckBox ignoreCaseBox;
    static boolean ignoreCase;
    boolean found;

    public FindReplace(Editor editor) {
        super("Find");
        this.setResizable(false);
        this.editor = editor;
        Container container = this.getContentPane();
        container.setLayout(null);
        JLabel jLabel = new JLabel("Find:");
        Dimension dimension = jLabel.getPreferredSize();
        JLabel jLabel2 = new JLabel("Replace with:");
        Dimension dimension2 = jLabel2.getPreferredSize();
        container.add(jLabel);
        container.add(jLabel2);
        this.findField = new JTextField(20);
        container.add(this.findField);
        this.replaceField = new JTextField(20);
        container.add(this.replaceField);
        Dimension dimension3 = this.findField.getPreferredSize();
        if (findString != null) {
            this.findField.setText(findString);
        }
        if (replaceString != null) {
            this.replaceField.setText(replaceString);
        }
        int n = (1 + dimension3.height - dimension2.height) / 2;
        jLabel.setBounds(13 + (dimension2.width - dimension.width) + n, 13, dimension2.width, dimension2.height);
        jLabel2.setBounds(13, 13 + dimension3.height + 6 + n, dimension2.width, dimension2.height);
        this.ignoreCaseBox = new JCheckBox("Ignore Case");
        this.ignoreCaseBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ignoreCase = FindReplace.this.ignoreCaseBox.isSelected();
            }
        });
        this.ignoreCaseBox.setSelected(ignoreCase);
        container.add(this.ignoreCaseBox);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        if (Base.isMacOS()) {
            this.replaceAllButton = new JButton("Replace All");
            jPanel.add(this.replaceAllButton);
            this.replaceButton = new JButton("Replace");
            jPanel.add(this.replaceButton);
            this.replaceFindButton = new JButton("Replace & Find");
            jPanel.add(this.replaceFindButton);
            this.findButton = new JButton("Find");
            jPanel.add(this.findButton);
        } else {
            this.findButton = new JButton("Find");
            jPanel.add(this.findButton);
            this.replaceFindButton = new JButton("Replace & Find");
            jPanel.add(this.replaceFindButton);
            this.replaceButton = new JButton("Replace");
            jPanel.add(this.replaceButton);
            this.replaceAllButton = new JButton("Replace All");
            jPanel.add(this.replaceAllButton);
        }
        container.add(jPanel);
        if (Base.isMacOS()) {
            jPanel.setBorder(null);
        }
        Dimension dimension4 = jPanel.getPreferredSize();
        jPanel.setBounds(13, 13 + dimension3.height * 3 + 12 + 13, dimension4.width, dimension4.height);
        this.findField.setBounds(13 + dimension2.width + 6, 13, dimension4.width - (dimension2.width + 6), dimension3.height);
        this.replaceField.setBounds(13 + dimension2.width + 6, 13 + dimension3.height + 6, dimension4.width - (dimension2.width + 6), dimension3.height);
        this.ignoreCaseBox.setBounds(13 + dimension2.width + 6, 13 + dimension3.height * 2 + 12, dimension4.width, dimension3.height);
        this.replaceButton.addActionListener(this);
        this.replaceAllButton.addActionListener(this);
        this.replaceFindButton.addActionListener(this);
        this.findButton.addActionListener(this);
        this.replaceButton.setEnabled(false);
        this.replaceFindButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.findButton);
        Dimension dimension5 = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = dimension4.width + 26;
        Rectangle rectangle = jPanel.getBounds();
        int n3 = rectangle.y + rectangle.height + 26 + 6;
        this.setBounds((dimension5.width - n2) / 2, (dimension5.height - n3) / 2, n2, n3);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FindReplace.this.handleClose();
            }
        });
        Base.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplace.this.handleClose();
            }
        });
        Base.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                FindReplace.this.findField.requestFocusInWindow();
                FindReplace.this.findField.selectAll();
            }
        });
    }

    public void handleClose() {
        findString = this.findField.getText();
        replaceString = this.replaceField.getText();
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.findButton) {
            this.find(true);
        } else if (object == this.replaceFindButton) {
            this.replace();
            this.find(true);
        } else if (object == this.replaceButton) {
            this.replace();
        } else if (object == this.replaceAllButton) {
            this.replaceAll();
        }
    }

    public void find(boolean bl) {
        int n;
        int n2;
        this.found = false;
        String string = this.findField.getText();
        if (string.length() == 0) {
            return;
        }
        String string2 = this.editor.getText();
        if (ignoreCase) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if ((n2 = string2.indexOf(string, n = this.editor.getSelectionStop())) == -1) {
            if (bl) {
                n2 = string2.indexOf(string, 0);
            }
            if (n2 == -1) {
                this.found = false;
                this.replaceButton.setEnabled(false);
                this.replaceFindButton.setEnabled(false);
                return;
            }
        }
        this.found = true;
        this.replaceButton.setEnabled(true);
        this.replaceFindButton.setEnabled(true);
        this.editor.setSelection(n2, n2 + string.length());
    }

    public void replace() {
        if (!this.found) {
            return;
        }
        String string = this.editor.getSelectedText();
        if (string.equals(this.replaceField.getText())) {
            this.found = false;
            this.replaceButton.setEnabled(false);
            this.replaceFindButton.setEnabled(false);
            return;
        }
        this.editor.setSelectedText(this.replaceField.getText());
        this.editor.getSketch().setModified(true);
        this.replaceButton.setEnabled(false);
        this.replaceFindButton.setEnabled(false);
    }

    public void replaceAll() {
        this.editor.setSelection(0, 0);
        do {
            this.find(false);
            this.replace();
        } while (this.found);
    }

    static {
        ignoreCase = true;
    }
}

