/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.CodeSigner;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import sun.misc.BASE64Decoder;
import sun.security.jca.Providers;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.TimestampToken;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;

public class SignatureFileVerifier {
    private static final Debug debug = Debug.getInstance("jar");
    private ArrayList signerCache;
    private static final String ATTR_DIGEST = "-DIGEST-Manifest-Main-Attributes".toUpperCase(Locale.ENGLISH);
    private PKCS7 block;
    private byte[] sfBytes;
    private String name;
    private ManifestDigester md;
    private HashMap createdDigests;
    private boolean workaround = false;
    private CertificateFactory certificateFactory = null;
    private static final char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureFileVerifier(ArrayList arrayList, ManifestDigester manifestDigester, String string, byte[] byArray) throws IOException, CertificateException {
        Object object = null;
        try {
            object = Providers.startJarVerification();
            this.block = new PKCS7(byArray);
            this.sfBytes = this.block.getContentInfo().getData();
            this.certificateFactory = CertificateFactory.getInstance("X509");
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Providers.stopJarVerification(object);
            throw throwable;
        }
        Providers.stopJarVerification(object);
        this.name = string.substring(0, string.lastIndexOf(".")).toUpperCase(Locale.ENGLISH);
        this.md = manifestDigester;
        this.signerCache = arrayList;
    }

    public boolean needSignatureFileBytes() {
        return this.sfBytes == null;
    }

    public boolean needSignatureFile(String string) {
        return this.name.equalsIgnoreCase(string);
    }

    public void setSignatureFile(byte[] byArray) {
        this.sfBytes = byArray;
    }

    public static boolean isBlockOrSF(String string) {
        return string.endsWith(".SF") || string.endsWith(".DSA") || string.endsWith(".RSA");
    }

    private MessageDigest getDigest(String string) {
        MessageDigest messageDigest;
        if (this.createdDigests == null) {
            this.createdDigests = new HashMap();
        }
        if ((messageDigest = (MessageDigest)this.createdDigests.get(string)) == null) {
            try {
                messageDigest = MessageDigest.getInstance(string);
                this.createdDigests.put(string, messageDigest);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Hashtable hashtable) throws IOException, SignatureException, NoSuchAlgorithmException, JarException, CertificateException {
        Object object = null;
        try {
            object = Providers.startJarVerification();
            this.processImpl(hashtable);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Providers.stopJarVerification(object);
            throw throwable;
        }
        Providers.stopJarVerification(object);
    }

    private void processImpl(Hashtable hashtable) throws IOException, SignatureException, NoSuchAlgorithmException, JarException, CertificateException {
        Manifest manifest = new Manifest();
        manifest.read(new ByteArrayInputStream(this.sfBytes));
        String string = manifest.getMainAttributes().getValue(Attributes.Name.SIGNATURE_VERSION);
        if (string == null || !string.equalsIgnoreCase("1.0")) {
            return;
        }
        SignerInfo[] signerInfoArray = this.block.verify(this.sfBytes);
        if (signerInfoArray == null) {
            throw new SecurityException("cannot verify signature block file " + this.name);
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        CodeSigner[] codeSignerArray = this.getSigners(signerInfoArray, this.block);
        if (codeSignerArray == null) {
            return;
        }
        Iterator<Map.Entry<String, Attributes>> iterator = manifest.getEntries().entrySet().iterator();
        boolean bl = this.verifyManifestHash(manifest, this.md, bASE64Decoder);
        if (!bl && !this.verifyManifestMainAttrs(manifest, this.md, bASE64Decoder)) {
            throw new SecurityException("Invalid signature file digest for Manifest main attributes");
        }
        while (iterator.hasNext()) {
            Map.Entry<String, Attributes> entry = iterator.next();
            String string2 = entry.getKey();
            if (bl || this.verifySection(entry.getValue(), string2, this.md, bASE64Decoder)) {
                if (string2.startsWith("./")) {
                    string2 = string2.substring(2);
                }
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                this.updateSigners(codeSignerArray, hashtable, string2);
                if (debug == null) continue;
                debug.println("processSignature signed name = " + string2);
                continue;
            }
            if (debug == null) continue;
            debug.println("processSignature unsigned name = " + string2);
        }
    }

    private boolean verifyManifestHash(Manifest manifest, ManifestDigester manifestDigester, BASE64Decoder bASE64Decoder) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        boolean bl = false;
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string;
            MessageDigest messageDigest;
            String string2 = entry.getKey().toString();
            if (!string2.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST-MANIFEST") || (messageDigest = this.getDigest(string = string2.substring(0, string2.length() - 16))) == null) continue;
            byte[] byArray = manifestDigester.manifestDigest(messageDigest);
            byte[] byArray2 = bASE64Decoder.decodeBuffer((String)entry.getValue());
            if (debug != null) {
                debug.println("Signature File: Manifest digest " + messageDigest.getAlgorithm());
                debug.println("  sigfile  " + SignatureFileVerifier.toHex(byArray2));
                debug.println("  computed " + SignatureFileVerifier.toHex(byArray));
                debug.println();
            }
            if (!MessageDigest.isEqual(byArray, byArray2)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean verifyManifestMainAttrs(Manifest manifest, ManifestDigester manifestDigester, BASE64Decoder bASE64Decoder) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        boolean bl = true;
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string;
            MessageDigest messageDigest;
            String string2 = entry.getKey().toString();
            if (!string2.toUpperCase(Locale.ENGLISH).endsWith(ATTR_DIGEST) || (messageDigest = this.getDigest(string = string2.substring(0, string2.length() - ATTR_DIGEST.length()))) == null) continue;
            ManifestDigester.Entry entry2 = manifestDigester.get("Manifest-Main-Attributes", false);
            byte[] byArray = entry2.digest(messageDigest);
            byte[] byArray2 = bASE64Decoder.decodeBuffer((String)entry.getValue());
            if (debug != null) {
                debug.println("Signature File: Manifest Main Attributes digest " + messageDigest.getAlgorithm());
                debug.println("  sigfile  " + SignatureFileVerifier.toHex(byArray2));
                debug.println("  computed " + SignatureFileVerifier.toHex(byArray));
                debug.println();
            }
            if (MessageDigest.isEqual(byArray, byArray2)) continue;
            bl = false;
            if (debug == null) break;
            debug.println("Verification of Manifest main attributes failed");
            debug.println();
            break;
        }
        return bl;
    }

    private boolean verifySection(Attributes attributes, String string, ManifestDigester manifestDigester, BASE64Decoder bASE64Decoder) throws IOException {
        boolean bl = false;
        ManifestDigester.Entry entry = manifestDigester.get(string, this.block.isOldStyle());
        if (entry == null) {
            throw new SecurityException("no manifiest section for signature file entry " + string);
        }
        if (attributes != null) {
            for (Map.Entry<Object, Object> entry2 : attributes.entrySet()) {
                String string2;
                MessageDigest messageDigest;
                String string3 = entry2.getKey().toString();
                if (!string3.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST") || (messageDigest = this.getDigest(string2 = string3.substring(0, string3.length() - 7))) == null) continue;
                boolean bl2 = false;
                byte[] byArray = bASE64Decoder.decodeBuffer((String)entry2.getValue());
                byte[] byArray2 = this.workaround ? entry.digestWorkaround(messageDigest) : entry.digest(messageDigest);
                if (debug != null) {
                    debug.println("Signature Block File: " + string + " digest=" + messageDigest.getAlgorithm());
                    debug.println("  expected " + SignatureFileVerifier.toHex(byArray));
                    debug.println("  computed " + SignatureFileVerifier.toHex(byArray2));
                    debug.println();
                }
                if (MessageDigest.isEqual(byArray2, byArray)) {
                    bl = true;
                    bl2 = true;
                } else if (!this.workaround && MessageDigest.isEqual(byArray2 = entry.digestWorkaround(messageDigest), byArray)) {
                    if (debug != null) {
                        debug.println("  re-computed " + SignatureFileVerifier.toHex(byArray2));
                        debug.println();
                    }
                    this.workaround = true;
                    bl = true;
                    bl2 = true;
                }
                if (bl2) continue;
                throw new SecurityException("invalid " + messageDigest.getAlgorithm() + " signature file digest for " + string);
            }
        }
        return bl;
    }

    private CodeSigner[] getSigners(SignerInfo[] signerInfoArray, PKCS7 pKCS7) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        ArrayList<CodeSigner> arrayList = null;
        for (int i = 0; i < signerInfoArray.length; ++i) {
            SignerInfo signerInfo = signerInfoArray[i];
            ArrayList arrayList2 = signerInfo.getCertificateChain(pKCS7);
            CertPath certPath = this.certificateFactory.generateCertPath(arrayList2);
            if (arrayList == null) {
                arrayList = new ArrayList<CodeSigner>();
            }
            arrayList.add(new CodeSigner(certPath, this.getTimestamp(signerInfo)));
            if (debug == null) continue;
            debug.println("Signature Block Certificate: " + (X509Certificate)arrayList2.get(0));
        }
        if (arrayList != null) {
            return arrayList.toArray(new CodeSigner[arrayList.size()]);
        }
        return null;
    }

    private Timestamp getTimestamp(SignerInfo signerInfo) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        PKCS9Attribute pKCS9Attribute;
        Timestamp timestamp = null;
        PKCS9Attributes pKCS9Attributes = signerInfo.getUnauthenticatedAttributes();
        if (pKCS9Attributes != null && (pKCS9Attribute = pKCS9Attributes.getAttribute("signatureTimestampToken")) != null) {
            PKCS7 pKCS7 = new PKCS7((byte[])pKCS9Attribute.getValue());
            byte[] byArray = pKCS7.getContentInfo().getData();
            SignerInfo[] signerInfoArray = pKCS7.verify(byArray);
            ArrayList arrayList = signerInfoArray[0].getCertificateChain(pKCS7);
            CertPath certPath = this.certificateFactory.generateCertPath(arrayList);
            TimestampToken timestampToken = new TimestampToken(byArray);
            timestamp = new Timestamp(timestampToken.getDate(), certPath);
        }
        return timestamp;
    }

    static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexc[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexc[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    static boolean contains(CodeSigner[] codeSignerArray, CodeSigner codeSigner) {
        for (int i = 0; i < codeSignerArray.length; ++i) {
            if (!codeSignerArray[i].equals(codeSigner)) continue;
            return true;
        }
        return false;
    }

    static boolean isSubSet(CodeSigner[] codeSignerArray, CodeSigner[] codeSignerArray2) {
        if (codeSignerArray2 == codeSignerArray) {
            return true;
        }
        for (int i = 0; i < codeSignerArray.length; ++i) {
            if (SignatureFileVerifier.contains(codeSignerArray2, codeSignerArray[i])) continue;
            return false;
        }
        return true;
    }

    static boolean matches(CodeSigner[] codeSignerArray, CodeSigner[] codeSignerArray2, CodeSigner[] codeSignerArray3) {
        if (codeSignerArray2 == null && codeSignerArray == codeSignerArray3) {
            return true;
        }
        if (codeSignerArray2 != null && !SignatureFileVerifier.isSubSet(codeSignerArray2, codeSignerArray)) {
            return false;
        }
        if (!SignatureFileVerifier.isSubSet(codeSignerArray3, codeSignerArray)) {
            return false;
        }
        for (int i = 0; i < codeSignerArray.length; ++i) {
            boolean bl;
            boolean bl2 = bl = codeSignerArray2 != null && SignatureFileVerifier.contains(codeSignerArray2, codeSignerArray[i]) || SignatureFileVerifier.contains(codeSignerArray3, codeSignerArray[i]);
            if (bl) continue;
            return false;
        }
        return true;
    }

    void updateSigners(CodeSigner[] codeSignerArray, Hashtable hashtable, String string) {
        CodeSigner[] codeSignerArray2;
        CodeSigner[] codeSignerArray3 = (CodeSigner[])hashtable.get(string);
        for (int i = this.signerCache.size() - 1; i != -1; --i) {
            codeSignerArray2 = (CodeSigner[])this.signerCache.get(i);
            if (!SignatureFileVerifier.matches(codeSignerArray2, codeSignerArray3, codeSignerArray)) continue;
            hashtable.put(string, codeSignerArray2);
            return;
        }
        if (codeSignerArray3 == null) {
            codeSignerArray2 = codeSignerArray;
        } else {
            codeSignerArray2 = new CodeSigner[codeSignerArray3.length + codeSignerArray.length];
            System.arraycopy(codeSignerArray3, 0, codeSignerArray2, 0, codeSignerArray3.length);
            System.arraycopy(codeSignerArray, 0, codeSignerArray2, codeSignerArray3.length, codeSignerArray.length);
        }
        this.signerCache.add(codeSignerArray2);
        hashtable.put(string, codeSignerArray2);
    }
}

