#ifndef HardwareRadio_h
#define HardwareRadio_h

#include <string.h>
#include "radio.h"
#include "board.h"

typedef struct radio_buffer
{
    struct radio_buffer *next;
    uint8_t len;
    uint8_t frm[127];
    uint8_t idx;
}
radio_buffer_t;

#define DATA_INT (0x81)
#define DATA_DOUBLE (0x82)
#define DATA_BLOCK (0x83)

# ifdef __cplusplus
    class HardwareRadio
    {
        private:
            uint8_t txseq;
            void txbuffer_init(radio_buffer_t *pbuf);

        public:
            /* user reads from this buffer */
            radio_buffer_t *prdbuf;
            /* user writes to this buffer */
            radio_buffer_t *pwrbuf;
            /* buffer which is currently transmited */
            radio_buffer_t *txbuf;
            /* buffer which is currently used for reception */
            radio_buffer_t *rxbuf;

            volatile uint8_t tx_in_progress;


            node_config_t nc;

            /* constructors */
            HardwareRadio(void);


            /* methods */
            void begin(void);
            void begin(uint8_t channel, uint8_t idlestate);

            void write(uint8_t byte);
            void write(char * str);

            void put(int16_t value);
            void get_int(int16_t& value);

            void flush(void);

            int available(void);
            int read(void);
            radio_buffer_t * alloc_buffer(void);
            void free_buffer(radio_buffer_t * pbuf);

   };
#  ifndef HARDWARERADIO_CPP
    extern HardwareRadio Radio;
#  endif
# endif
#endif /*#ifndef HardwareRadio_h*/
