/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.debug.RunnerException;
import processing.app.debug.Uploader;

public class AvrdudeUploader
extends Uploader {
    public boolean uploadUsingPreferences(String string, String string2) throws RunnerException {
        String string3 = Preferences.get("boards." + Preferences.get("board") + ".upload.using");
        if (string3 == null) {
            string3 = Preferences.get("upload.using");
        }
        if (string3.equals("bootloader")) {
            return this.uploadViaBootloader(string, string2);
        }
        Collection collection = this.getProgrammerCommands(string3);
        collection.add("-Uflash:w:" + string + File.separator + string2 + ".hex:i");
        return this.avrdude(collection);
    }

    private boolean uploadViaBootloader(String string, String string2) throws RunnerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = Preferences.get("boards." + Preferences.get("board") + ".upload.protocol");
        if (string3.equals("stk500")) {
            string3 = "stk500v1";
        }
        arrayList.add("-c" + string3);
        arrayList.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
        arrayList.add("-b" + Preferences.getInteger("boards." + Preferences.get("board") + ".upload.speed"));
        arrayList.add("-D");
        arrayList.add("-Uflash:w:" + string + File.separator + string2 + ".hex:i");
        if (Preferences.get("boards." + Preferences.get("board") + ".upload.disable_flushing") == null || !Preferences.getBoolean("boards." + Preferences.get("board") + ".upload.disable_flushing")) {
            this.flushSerialBuffer();
        }
        return this.avrdude(arrayList);
    }

    public boolean burnBootloader(String string) throws RunnerException {
        return this.burnBootloader(this.getProgrammerCommands(string));
    }

    private Collection getProgrammerCommands(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-c" + Preferences.get("programmers." + string + ".protocol"));
        if ("usb".equals(Preferences.get("programmers." + string + ".communication"))) {
            arrayList.add("-Pusb");
        } else if ("serial".equals(Preferences.get("programmers." + string + ".communication"))) {
            arrayList.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
        }
        if (Preferences.get("programmers." + string + ".force") != null && Preferences.getBoolean("programmers." + string + ".force")) {
            arrayList.add("-F");
        }
        if (Preferences.get("programmers." + string + ".delay") != null) {
            arrayList.add("-i" + Preferences.get("programmers." + string + ".delay"));
        }
        return arrayList;
    }

    protected boolean burnBootloader(Collection collection) throws RunnerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-e");
        arrayList.add("-Ulock:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.unlock_bits") + ":m");
        if (Preferences.get("boards." + Preferences.get("board") + ".bootloader.extended_fuses") != null) {
            arrayList.add("-Uefuse:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.extended_fuses") + ":m");
        }
        arrayList.add("-Uhfuse:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.high_fuses") + ":m");
        arrayList.add("-Ulfuse:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.low_fuses") + ":m");
        if (!this.avrdude(collection, arrayList)) {
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("-Uflash:w:" + Base.getHardwarePath() + File.separator + "bootloaders" + File.separator + Preferences.get("boards." + Preferences.get("board") + ".bootloader.path") + File.separator + Preferences.get("boards." + Preferences.get("board") + ".bootloader.file") + ":i");
        arrayList2.add("-Ulock:w:" + Preferences.get("boards." + Preferences.get("board") + ".bootloader.lock_bits") + ":m");
        return this.avrdude(collection, arrayList2);
    }

    public boolean avrdude(Collection collection, Collection collection2) throws RunnerException {
        ArrayList arrayList = new ArrayList(collection);
        arrayList.addAll(collection2);
        return this.avrdude(arrayList);
    }

    public boolean avrdude(Collection collection) throws RunnerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("avrdude");
        if (Base.isLinux()) {
            arrayList.add("-C" + Base.getHardwarePath() + "/tools/avrdude.conf");
        } else {
            arrayList.add("-C" + Base.getHardwarePath() + "/tools/avr/etc/avrdude.conf");
        }
        if (Preferences.getBoolean("upload.verbose")) {
            arrayList.add("-v");
            arrayList.add("-v");
            arrayList.add("-v");
            arrayList.add("-v");
        } else {
            arrayList.add("-q");
            arrayList.add("-q");
        }
        arrayList.add("-pm" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu").substring(6));
        arrayList.addAll(collection);
        return this.executeUploadCommand(arrayList);
    }
}

