/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.ExceptionEvent;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.debug.EventThread;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;
import processing.app.debug.RunnerListener;
import processing.app.debug.StreamRedirectThread;
import processing.core.PApplet;

public class Runner
implements MessageConsumer {
    private boolean presenting;
    private RunnerListener listener;
    private VirtualMachine vm;
    private Thread errThread = null;
    private Thread outThread = null;
    private int debugTraceMode = 0;
    private boolean watchFields = false;
    private String[] excludes = new String[]{"java.*", "javax.*", "sun.*", "com.sun.*", "apple.*", "processing.*"};
    private RunnerException exception;
    private Editor editor;
    private Sketch sketch;
    private String appletClassName;

    public Runner(Sketch sketch, String string, boolean bl, RunnerListener runnerListener) {
        this.sketch = sketch;
        this.appletClassName = string;
        this.presenting = bl;
        this.listener = runnerListener;
        if (runnerListener instanceof Editor) {
            this.editor = (Editor)runnerListener;
        }
    }

    public void launch() {
        String[] stringArray = this.getMachineParams();
        String[] stringArray2 = this.getSketchParams();
        this.vm = this.launchVirtualMachine(stringArray, stringArray2);
        if (this.vm != null) {
            this.generateTrace(null);
        }
    }

    protected String[] getMachineParams() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = Preferences.get("run.options");
        if (string.length() > 0) {
            stringArray = PApplet.split((String)string, (char)' ');
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
            }
        }
        if (Preferences.getBoolean("run.options.memory")) {
            arrayList.add("-Xms" + Preferences.get("run.options.memory.initial") + "m");
            arrayList.add("-Xmx" + Preferences.get("run.options.memory.maximum") + "m");
        }
        if (Base.isMacOS()) {
            arrayList.add("-Xdock:name=" + this.appletClassName);
        }
        arrayList.add("-Djava.library.path=" + this.sketch.getLibraryPath() + File.pathSeparator + System.getProperty("java.library.path"));
        arrayList.add("-cp");
        arrayList.add(this.sketch.getClassPath());
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    protected String[] getSketchParams() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("processing.core.PApplet");
        if (this.editor != null) {
            Point point = this.editor.getSketchLocation();
            if (point != null) {
                arrayList.add("--location=" + point.x + "," + point.y);
            } else {
                Point point2 = this.editor.getLocation();
                arrayList.add("--editor-location=" + point2.x + "," + point2.y);
            }
            arrayList.add("--external");
        }
        arrayList.add("--display=" + Preferences.get("run.display"));
        arrayList.add("--sketch-path=" + this.sketch.getFolder().getAbsolutePath());
        if (this.presenting) {
            arrayList.add("--present");
            if (Preferences.getBoolean("run.present.exclusive")) {
                arrayList.add("--exclusive");
            }
            arrayList.add("--stop-color=" + Preferences.get("run.present.stop.color"));
            arrayList.add("--bgcolor=" + Preferences.get("run.present.bgcolor"));
        }
        arrayList.add(this.appletClassName);
        return arrayList.toArray(new String[0]);
    }

    protected VirtualMachine launchVirtualMachine(String[] stringArray, String[] stringArray2) {
        int n;
        LaunchingConnector launchingConnector = this.findLaunchingConnector("com.sun.jdi.RawCommandLineLaunch");
        Map<String, Connector.Argument> map = launchingConnector.defaultArguments();
        Connector.Argument argument = map.get("command");
        String string = "127.0.0.1:" + (8000 + (int)(Math.random() * 1000.0));
        String string2 = Base.isWindows() ? "java -Xrunjdwp:transport=dt_shmem,address=" + string + ",suspend=y " : "java -Xrunjdwp:transport=dt_socket,address=" + string + ",suspend=y ";
        for (n = 0; n < stringArray.length; ++n) {
            string2 = Runner.addArgument(string2, stringArray[n], ' ');
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                string2 = Runner.addArgument(string2, stringArray2[n], ' ');
            }
        }
        argument.setValue(string2);
        Connector.Argument argument2 = map.get("address");
        argument2.setValue(string);
        try {
            return launchingConnector.launch(map);
        }
        catch (IOException iOException) {
            throw new Error("Unable to launch target VM: " + iOException);
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            throw new Error("Internal error: " + illegalConnectorArgumentsException);
        }
        catch (VMStartException vMStartException) {
            Process process = vMStartException.process();
            String[] stringArray3 = PApplet.loadStrings((InputStream)process.getErrorStream());
            PApplet.loadStrings((InputStream)process.getInputStream());
            if (stringArray3 != null && stringArray3.length > 1) {
                if (stringArray3[0].indexOf("Invalid maximum heap size") != -1) {
                    Base.showWarning("Way Too High", "Please lower the value for \u201cmaximum available memory\u201d in the\nPreferences window. For more information, read Help \u2192 Troubleshooting.", vMStartException);
                } else {
                    PApplet.println((Object)stringArray3);
                    System.err.println("Using startup command:");
                    PApplet.println(map);
                }
            } else {
                vMStartException.printStackTrace();
                System.err.println("Could not run the sketch (Target VM failed to initialize).");
                if (Preferences.getBoolean("run.options.memory")) {
                    System.err.println("Make sure that you haven't set the maximum available memory too high.");
                }
                System.err.println("For more information, read revisions.txt and Help \u2192 Troubleshooting.");
            }
            if (this.editor != null) {
                this.listener.statusError("Could not run the sketch.");
            }
            return null;
        }
    }

    private static boolean hasWhitespace(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String addArgument(String string, String string2, char c) {
        if (Runner.hasWhitespace(string2) || string2.indexOf(44) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('\"');
            for (int i = 0; i < string2.length(); ++i) {
                char c2 = string2.charAt(i);
                if (c2 == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
            }
            stringBuffer.append('\"');
            stringBuffer.append(c);
            return stringBuffer.toString();
        }
        return string + string2 + String.valueOf(c);
    }

    void generateTrace(PrintWriter printWriter) {
        this.vm.setDebugTraceMode(this.debugTraceMode);
        EventThread eventThread = null;
        eventThread = new EventThread(this, this.vm, this.excludes, printWriter);
        eventThread.setEventRequests(this.watchFields);
        eventThread.start();
        Process process = this.vm.process();
        MessageSiphon messageSiphon = new MessageSiphon(process.getErrorStream(), this);
        this.errThread = messageSiphon.thread;
        this.outThread = new StreamRedirectThread("output reader", process.getInputStream(), System.out);
        this.errThread.start();
        this.outThread.start();
        this.vm.resume();
        try {
            if (eventThread != null) {
                eventThread.join();
            }
            this.errThread.join();
            this.outThread.join();
            if (this.editor != null) {
                this.editor.internalRunnerClosed();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (printWriter != null) {
            printWriter.close();
        }
    }

    LaunchingConnector findLaunchingConnector(String string) {
        List<Connector> list = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector connector : list) {
            if (!connector.name().equals(string)) continue;
            return (LaunchingConnector)connector;
        }
        throw new Error("No launching connector");
    }

    public void exception(ExceptionEvent exceptionEvent) {
        ObjectReference objectReference = exceptionEvent.exception();
        ReferenceType referenceType = objectReference.referenceType();
        String string = referenceType.name();
        Field field = referenceType.fieldByName("detailMessage");
        Value value = objectReference.getValue(field);
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        if (value != null) {
            String string3 = value.toString();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            string2 = string2 + ": " + string3;
        }
        if (string.equals("java.lang.OutOfMemoryError")) {
            this.listener.statusError("OutOfMemoryError: You may need to increase the memory setting in Preferences.");
            System.err.println("An OutOfMemoryError means that your code is either using up too much memory");
            System.err.println("because of a bug (e.g. creating an array that's too large, or unintentionally");
            System.err.println("loading thousands of images), or that your sketch may need more memory to run.");
            System.err.println("If your sketch uses a lot of memory (for instance if it loads a lot of data files)");
            System.err.println("you can increase the memory available to your sketch using the Preferences window.");
        } else if (string.equals("java.lang.StackOverflowError")) {
            this.listener.statusError("StackOverflowError: This sketch is attempting too much recursion.");
            System.err.println("A StackOverflowError means that you have a bug that's causing a function");
            System.err.println("to be called recursively (it's calling itself and going in circles),");
            System.err.println("or you're intentionally calling a recursive function too much,");
            System.err.println("and your code should be rewritten in a more efficient manner.");
        } else if (string.equals("java.lang.UnsupportedClassVersionError")) {
            this.listener.statusError("UnsupportedClassVersionError: A library is using code compiled with an unsupported version of Java.");
            System.err.println("This version of Processing only supports libraries and JAR files compiled for Java 1.5.");
            System.err.println("A library used by this sketch was compiled for Java 1.6 or later, ");
            System.err.println("and needs to be recompiled to be compatible with Java 1.5.");
        } else if (string.equals("java.lang.NoSuchMethodError") || string.equals("java.lang.NoSuchFieldError")) {
            this.listener.statusError(string.substring(10) + ": You're probably using a library that's incompatible with this version of Processing.");
        } else if (string2.equals("ClassNotFoundException: quicktime.std.StdQTException")) {
            this.listener.statusError("Could not find QuickTime, please reinstall QuickTime 7 or later.");
        } else {
            this.reportException(string2, exceptionEvent.thread());
        }
        this.editor.internalRunnerClosed();
    }

    protected void reportException(String string, ThreadReference threadReference) {
        try {
            int n = -1;
            int n2 = -1;
            List<StackFrame> list = threadReference.frames();
            for (StackFrame stackFrame : list) {
                Location location = stackFrame.location();
                String string2 = null;
                string2 = location.sourceName();
                n2 = location.lineNumber();
                String string3 = this.appletClassName + ".java";
                SketchCode sketchCode = null;
                if (string2.equals(string3)) {
                    for (SketchCode sketchCode2 : this.sketch.getCode()) {
                        if (!sketchCode2.isExtension("pde") || n2 < sketchCode2.getPreprocOffset()) continue;
                        sketchCode = sketchCode2;
                    }
                } else {
                    for (SketchCode sketchCode2 : this.sketch.getCode()) {
                        if (!sketchCode2.isExtension("java") || !string2.equals(sketchCode2.getFileName())) continue;
                        sketchCode = sketchCode2;
                    }
                }
                if ((n = this.sketch.getCodeIndex(sketchCode)) == -1) continue;
                n2 -= this.sketch.getCode(n).getPreprocOffset();
                this.exception = new RunnerException(string, n, --n2, -1);
                this.exception.hideStackTrace();
                this.listener.statusError(this.exception);
                return;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            this.exception = new RunnerException(string);
            this.exception.hideStackTrace();
            this.listener.statusError(this.exception);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            incompatibleThreadStateException.printStackTrace();
        }
    }

    public void close() {
        if (this.vm != null) {
            try {
                this.vm.exit(0);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            this.vm = null;
        }
    }

    public synchronized void message(String string) {
        if (string.indexOf("__STOP__") == 0) {
            this.editor.internalCloseRunner();
            return;
        }
        if (string.indexOf("__MOVE__") == 0) {
            String string2 = string.substring(string.indexOf(32) + 1).trim();
            int n = string2.indexOf(32);
            int n2 = Integer.parseInt(string2.substring(0, n));
            int n3 = Integer.parseInt(string2.substring(n + 1));
            this.editor.setSketchLocation(new Point(n2, n3));
            return;
        }
        System.err.print(string);
        System.err.flush();
    }

    class SystemOutSiphon
    implements Runnable {
        InputStream input;
        Thread thread;

        public SystemOutSiphon(InputStream inputStream) {
            this.input = inputStream;
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void run() {
            byte[] byArray = new byte[256];
            while (Thread.currentThread() == this.thread) {
                try {
                    int n = this.input.read(byArray, 0, byArray.length);
                    if (n == -1) {
                        this.thread = null;
                        continue;
                    }
                    System.out.print(new String(byArray, 0, n));
                }
                catch (IOException iOException) {
                    this.thread = null;
                }
                catch (Exception exception) {
                    this.thread = null;
                }
            }
        }
    }
}

