/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.HttpConstants;
import processing.app.WebServer;

class WebServerWorker
implements HttpConstants,
Runnable {
    ZipFile zip;
    HashMap<String, ZipEntry> entries;
    static final int BUF_SIZE = 2048;
    static final byte[] EOL = new byte[]{13, 10};
    byte[] buf;
    private Socket s;
    static Hashtable map = new Hashtable();

    WebServerWorker(ZipFile zipFile, HashMap hashMap) {
        this.entries = hashMap;
        this.zip = zipFile;
        this.buf = new byte[2048];
        this.s = null;
    }

    synchronized void setSocket(Socket socket) {
        this.s = socket;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            Vector vector;
            if (this.s == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            try {
                this.handleClient();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.s = null;
            Vector vector2 = vector = WebServer.threads;
            synchronized (vector2) {
                if (vector.size() >= WebServer.workers) {
                    return;
                }
                vector.addElement(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClient() throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.s.getInputStream());
        PrintStream printStream = new PrintStream(this.s.getOutputStream());
        this.s.setSoTimeout(WebServer.timeout);
        this.s.setTcpNoDelay(true);
        for (n = 0; n < 2048; ++n) {
            this.buf[n] = 0;
        }
        try {
            int n2;
            int n3;
            n = 0;
            int n4 = 0;
            block6: while (n < 2048) {
                n4 = ((InputStream)bufferedInputStream).read(this.buf, n, 2048 - n);
                if (n4 == -1) {
                    return;
                }
                n3 = n;
                n += n4;
                while (n3 < n) {
                    if (this.buf[n3] == 10 || this.buf[n3] == 13) break block6;
                    ++n3;
                }
            }
            if (this.buf[0] == 71 && this.buf[1] == 69 && this.buf[2] == 84 && this.buf[3] == 32) {
                n3 = 1;
                n2 = 4;
            } else if (this.buf[0] == 72 && this.buf[1] == 69 && this.buf[2] == 65 && this.buf[3] == 68 && this.buf[4] == 32) {
                n3 = 0;
                n2 = 5;
            } else {
                printStream.print("HTTP/1.0 405 unsupported method type: ");
                printStream.write(this.buf, 0, 5);
                printStream.write(EOL);
                printStream.flush();
                this.s.close();
                return;
            }
            int n5 = 0;
            for (n5 = n2; n5 < n && this.buf[n5] != 32; ++n5) {
            }
            String string = new String(this.buf, n2, n5 - n2);
            ZipEntry zipEntry = this.entries.get(string.substring(1));
            boolean bl = this.printHeaders(zipEntry, printStream);
            if (zipEntry != null) {
                InputStream inputStream = this.zip.getInputStream(zipEntry);
                if (n3 != 0 && bl) {
                    this.sendFile(inputStream, printStream);
                }
            } else {
                this.send404(printStream);
            }
        }
        finally {
            this.s.close();
        }
    }

    boolean printHeaders(ZipEntry zipEntry, PrintStream printStream) throws IOException {
        boolean bl = false;
        int n = 0;
        if (zipEntry == null) {
            n = 404;
            printStream.print("HTTP/1.0 404 Not Found");
            printStream.write(EOL);
            bl = false;
        } else {
            n = 200;
            printStream.print("HTTP/1.0 200 OK");
            printStream.write(EOL);
            bl = true;
        }
        if (zipEntry != null) {
            WebServer.log("From " + this.s.getInetAddress().getHostAddress() + ": GET " + zipEntry.getName() + " --> " + n);
        }
        printStream.print("Server: Processing Documentation Server");
        printStream.write(EOL);
        printStream.print("Date: " + new Date());
        printStream.write(EOL);
        if (bl) {
            if (!zipEntry.isDirectory()) {
                printStream.print("Content-length: " + zipEntry.getSize());
                printStream.write(EOL);
                printStream.print("Last Modified: " + new Date(zipEntry.getTime()));
                printStream.write(EOL);
                String string = zipEntry.getName();
                int n2 = string.lastIndexOf(46);
                String string2 = null;
                if (n2 > 0) {
                    string2 = (String)map.get(string.substring(n2));
                }
                if (string2 == null) {
                    string2 = "application/x-unknown-content-type";
                }
                printStream.print("Content-type: " + string2);
                printStream.write(EOL);
            } else {
                printStream.print("Content-type: text/html");
                printStream.write(EOL);
            }
        }
        printStream.write(EOL);
        return bl;
    }

    boolean printHeaders(File file, PrintStream printStream) throws IOException {
        boolean bl = false;
        int n = 0;
        if (!file.exists()) {
            n = 404;
            printStream.print("HTTP/1.0 404 Not Found");
            printStream.write(EOL);
            bl = false;
        } else {
            n = 200;
            printStream.print("HTTP/1.0 200 OK");
            printStream.write(EOL);
            bl = true;
        }
        WebServer.log("From " + this.s.getInetAddress().getHostAddress() + ": GET " + file.getAbsolutePath() + "-->" + n);
        printStream.print("Server: Simple java");
        printStream.write(EOL);
        printStream.print("Date: " + new Date());
        printStream.write(EOL);
        if (bl) {
            if (!file.isDirectory()) {
                printStream.print("Content-length: " + file.length());
                printStream.write(EOL);
                printStream.print("Last Modified: " + new Date(file.lastModified()));
                printStream.write(EOL);
                String string = file.getName();
                int n2 = string.lastIndexOf(46);
                String string2 = null;
                if (n2 > 0) {
                    string2 = (String)map.get(string.substring(n2));
                }
                if (string2 == null) {
                    string2 = "unknown/unknown";
                }
                printStream.print("Content-type: " + string2);
                printStream.write(EOL);
            } else {
                printStream.print("Content-type: text/html");
                printStream.write(EOL);
            }
        }
        return bl;
    }

    void send404(PrintStream printStream) throws IOException {
        printStream.write(EOL);
        printStream.write(EOL);
        printStream.print("<html><body><h1>404 Not Found</h1>The requested resource was not found.</body></html>");
        printStream.write(EOL);
        printStream.write(EOL);
    }

    void sendFile(File file, PrintStream printStream) throws IOException {
        FileInputStream fileInputStream = null;
        printStream.write(EOL);
        if (file.isDirectory()) {
            this.listDirectory(file, printStream);
            return;
        }
        fileInputStream = new FileInputStream(file.getAbsolutePath());
        this.sendFile(fileInputStream, printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendFile(InputStream inputStream, PrintStream printStream) throws IOException {
        try {
            int n;
            while ((n = inputStream.read(this.buf)) > 0) {
                printStream.write(this.buf, 0, n);
            }
        }
        finally {
            inputStream.close();
        }
    }

    static void setSuffix(String string, String string2) {
        map.put(string, string2);
    }

    static void fillMap() {
        WebServerWorker.setSuffix("", "content/unknown");
        WebServerWorker.setSuffix(".uu", "application/octet-stream");
        WebServerWorker.setSuffix(".exe", "application/octet-stream");
        WebServerWorker.setSuffix(".ps", "application/postscript");
        WebServerWorker.setSuffix(".zip", "application/zip");
        WebServerWorker.setSuffix(".sh", "application/x-shar");
        WebServerWorker.setSuffix(".tar", "application/x-tar");
        WebServerWorker.setSuffix(".snd", "audio/basic");
        WebServerWorker.setSuffix(".au", "audio/basic");
        WebServerWorker.setSuffix(".wav", "audio/x-wav");
        WebServerWorker.setSuffix(".gif", "image/gif");
        WebServerWorker.setSuffix(".jpg", "image/jpeg");
        WebServerWorker.setSuffix(".jpeg", "image/jpeg");
        WebServerWorker.setSuffix(".htm", "text/html");
        WebServerWorker.setSuffix(".html", "text/html");
        WebServerWorker.setSuffix(".css", "text/css");
        WebServerWorker.setSuffix(".java", "text/javascript");
        WebServerWorker.setSuffix(".txt", "text/plain");
        WebServerWorker.setSuffix(".java", "text/plain");
        WebServerWorker.setSuffix(".c", "text/plain");
        WebServerWorker.setSuffix(".cc", "text/plain");
        WebServerWorker.setSuffix(".c++", "text/plain");
        WebServerWorker.setSuffix(".h", "text/plain");
        WebServerWorker.setSuffix(".pl", "text/plain");
    }

    void listDirectory(File file, PrintStream printStream) throws IOException {
        printStream.println("<TITLE>Directory listing</TITLE><P>\n");
        printStream.println("<A HREF=\"..\">Parent Directory</A><BR>\n");
        String[] stringArray = file.list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                printStream.println("<A HREF=\"" + stringArray[i] + "/\">" + stringArray[i] + "/</A><BR>");
                continue;
            }
            printStream.println("<A HREF=\"" + stringArray[i] + "\">" + stringArray[i] + "</A><BR");
        }
        printStream.println("<P><HR><BR><I>" + new Date() + "</I>");
    }

    static {
        WebServerWorker.fillMap();
    }
}

