/* Copyright (c) 2011 Axel Wachtler, Daniel Thiele
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

#ifndef ROSE_H
#define ROSE_H

/* === includes ============================================================ */
#include "sensorproto.h"
#include "sensors.h"
#include "reg_bmp085.h"

/* === macros ============================================================== */

/* === types =============================================================== */

typedef enum {
	ROSE_APPMODE_SLOW,		/**< slow sending + Rx slot */
	ROSE_APPMODE_FAST,		/**< fast streaming without Rx */
	ROSE_APPMODE_FAST_FLASH,	/**< as FAST mode + storing to local flash */
	ROSE_APPMODE_READFLASH,	/**< read sampled data from flash */
}rose_appmode_t;

typedef struct{
	uint16_t tstamp;
	sensors_xyz_result_t acc;
	sensors_xyz_result_t comp;
	uint16_t pressure;
	uint16_t temperature;
}rose_measresult_t;

/* variant of rose_measresult_t without field "temperature"
 * Structure sizes to 16 Bytes
 */
typedef struct{
	uint16_t tstamp;
	sensors_xyz_result_t acc;
	sensors_xyz_result_t comp;
	uint16_t pressure;
}rose_flashchunk_t;

typedef struct{
	sensorproto_hdr_t hdr;
	rose_measresult_t data; /**< measured sensor data */
	uint16_t vbat_mv;		/**< Battery voltage [mV] */
	uint8_t bmp085prom[BMP085_PROM_DATA_LEN];	/**< calibration data of BMP085 */
	uint8_t version_maj; /**< version number major */
	uint8_t version_min; /**< version number minor */
	sensorproto_ftr_t ftr;
}rose_slowframe_t;

typedef struct{
	sensorproto_hdr_t hdr;
	rose_measresult_t data; /**< measured data */
	sensorproto_ftr_t ftr;
}rose_fastframe_t;

typedef struct{
	sensorproto_hdr_t hdr;
	rose_appmode_t appmode;		/**< application mode */
	sensorproto_ftr_t ftr;
}rose_cfgframe_t;

/* === prototypes ========================================================== */
#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif  /* #ifndef ROSE_H */
