/* Copyright (c) 2007 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: const.h,v 1.23 2009/06/25 20:45:44 awachtler Exp $ */
/**
 * @file
 * @brief Definitions for @ref grpConst.
 *
 */
/*====================================================================*/
#ifndef CONST_H
#define CONST_H

/**
 * @addtogroup grpConst
 * @{
 */
/*=== board constants ================================================*/
/*raven boards */
#define  RZ_USB230       (1) /**< Board description see @ref grpRZxxx . */
#define  RAV_RF230       (2) /**< Board description see @ref grpRZxxx . */
#define  RAV_LCD         (3) /**< Board description see @ref grpRZxxx . */

/* Atmel/Dresden Elektonic boards */
#define  PSK_230         (10) /**< Board description see @ref grpSTK541 . */
#define  PSK_230B        (11) /**< Board description see @ref grpSTK541 . */
#define  PSK_231         (12) /**< Board description see @ref grpSTK541 . */
#define  PSK_212         (13) /**< Board description see @ref grpSTK541 . */

#define  RDK_230         (15) /**< Board description see @ref grpRDK230 . */
#define  RDK_231         (17) /**< Board description see @ref grpRDK230 . */
#define  RDK_212         (18) /**< Board description see @ref grpRDK230 . */

#define  STB_230         (20) /**< Board description see @ref grpSTB2xx . */
#define  STB_230B        (21) /**< Board description see @ref grpSTB2xx . */
#define  STB_231         (22) /**< Board description see @ref grpSTB2xx . */
#define  STB_212         (23) /**< Board description see @ref grpSTB2xx . */

#define  RCB_BB_230      (25) /**< Board description see @ref grpRBB2xx . */
#define  RCB_BB_230B     (26) /**< Board description see @ref grpRBB2xx . */
#define  RCB_BB_231      (27) /**< Board description see @ref grpRBB2xx . */
#define  RCB_BB_212      (28) /**< Board description see @ref grpRBB2xx . */

/* Meshnetics boards */
#define  WDB_A1281       (30) /**< Board description see @ref grpWdba1281 . */
#define  MNB_900         (31) /**< Board description see @ref grpWdba1281 . */
/* in-cirquit */
//#define  IC_MEGA8_8    (40) /**< Board description see @ref grpICM8 . */
#define  ICT_RF230       (41) /**< Board description see @ref grpICT230 . */
#define  ICSTICK_RF230   (42)
#define  ICMODULE_RF230  (43)

/* ATZGB modules */
#define  ZGB_LINK_230    (50) /**< Board description see @ref grpZgbLink . */
#define  ZGB_LINK_231    (51) /**< Board description see @ref grpZgbLink . */
#define  ZGB_LINK_212    (52) /**< Board description see @ref grpZgbLink . */

/* DIY and wirewrap projects */
#define  TINY_230        (90) /**< Board description see @ref grpTINY230 . */
#define  STK500_MEGA8    (91) /**< Board description see @ref grpSTKM8 . */
#define  STK500_MEGA16   (92) /**< Board description see @ref grpSTKM16 . */
#define  STK500_TINY26   (93) /**< Board description see @ref grpSTKT26 . */
#define  LITTLE_GEE_231  (94) /**< Board description see @ref grpLGEE231 */

/*=== cpu constants ==================================================*/
#define  CPU_M8          (1) /**< Identifier for CPU ATmega8 */
#define  CPU_M16         (2) /**< Identifier for CPU ATmega16 */
#define  CPU_M1281       (3) /**< Identifier for CPU ATmega1281 */
#define  CPU_T26         (4) /**< Identifier for CPU ATtiny26 */
#define  CPU_T44         (5) /**< Identifier for CPU ATtiny44 */
#define  CPU_M1287       (6) /**< Identifier for CPU ATmega1287 */
#define  CPU_M1284       (7) /**< Identifier for CPU ATmega1284 */
#define  CPU_M88         (8) /**< Identifier for CPU ATmega88 */

/*=== radio constants ================================================*/
#define  RADIO_AT86RF230 (1) /**< Identifier for radio AT86RF230 */
#define  RADIO_AT86RF230A (RADIO_AT86RF230) /**< Identifier for radio AT86RF230 Rev A */
#define  RADIO_AT86RF230B (2) /**< Identifier for radio AT86RF230 Rev B */
#define  RADIO_AT86RF231 (3) /**< Identifier for radio AT86RF231 */
#define  RADIO_AT86RF212 (4) /**< Identifier for radio AT86RF212 */



#define RADIO_BAND_700 (1)
#define RADIO_BAND_800 (2)
#define RADIO_BAND_900 (3)
#define RADIO_BAND_2400 (4)

/*=== HIF type constants =============================================*/
#define  HIF_NONE     (0)  /**< Identifier for no host interface */


#define  HIF_UART_0   (10) /**< Identifier for HIF type UART 0 */
#define  HIF_UART_1   (11) /**< Identifier for HIF type UART 1 */
#define  HIF_FT245    (20) /**< Identifier for HIF type USB/FT245*/
#define  HIF_AT90USB  (21) /**< Identifier for HIF type USB/ATmega1287 */

/*=== USB constants ==================================================*/
/**
 * uracoli USB Vendor ID Device ID
 *
 * The pair of the uracoli vendor id, device id are obtained by
 *
 *  - http://www.voti.nl/pids/
 *  - http://www.frank-buss.de/pid.txt
 */
#define USB_VID_URACOLI (5824)
/**
 * uracoli USB Product ID
 * see also @ref USB_VID_URACOLI
 */
#define USB_PID_URACOLI (2183)

/*=== spi constants ==================================================*/
#define SPI_RATE_1_2      (4) /**< SPI clock running is 0.5 (1/2) of cpu clock */
#define SPI_RATE_1_4      (0) /**< SPI clock running is 0.25 (1/4) of cpu clock */
#define SPI_RATE_1_8      (5) /**< SPI clock running is 0.125 (1/8) of cpu clock */
#define SPI_RATE_1_16     (1) /**< SPI clock running is 0.0635 (1/16) of cpu clock */
#define SPI_RATE_1_32     (6) /**< SPI clock running is 0.03125 (1/32)of cpu clock */
#define SPI_RATE_1_64     (2) /**< SPI clock running is 0.015625 (1/64)of cpu clock */
#define SPI_RATE_1_128    (3) /**< SPI clock running is 0.0078125 (1/128) of cpuclock */

/*=== modulation schemes =============================================*/
#define MOD_BPSK_20    (0) /**< PHY modulation BPSK, 20 kbit/s */
#define MOD_BPSK_40    (1) /**< PHY modulation BPSK, 40 kbit/s */
#define MOD_OQPSK_100  (2) /**< PHY modulation O-QPSK, 100 kbit/s */
#define MOD_OQPSK_200  (3) /**< PHY modulation O-QPSK, 200 kbit/s */
#define MOD_OQPSK_250  (4) /**< PHY modulation O-QPSK, 250 kbit/s */
#define MOD_OQPSK_400  (5) /**< PHY modulation O-QPSK, 400 kbit/s */
#define MOD_OQPSK_500  (6) /**< PHY modulation O-QPSK, 500 kbit/s */
#define MOD_OQPSK_1000 (7) /**< PHY modulation O-QPSK, 1000 kbit/s */
#define MOD_OQPSK_2000 (8) /**< PHY modulation O-QPSK, 2000 kbit/s */

#if defined (DOXYGEN)
/** macro that forces an enumeration to use 8 bit instead of 16 bit integers. */
#define SHORTENUM
#else
#define SHORTENUM  __attribute__((packed))
#endif

/** @} */
#endif  /* #ifndef CONST_H */
