/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import processing.app.Base;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;

public class Sizer
implements MessageConsumer {
    private String buildPath;
    private String sketchName;
    private String firstLine;
    private long size;
    private RunnerException exception;

    public Sizer(String string, String string2) {
        this.buildPath = string;
        this.sketchName = string2;
    }

    public long computeSize() throws RunnerException {
        String string = Base.getAvrBasePath();
        String[] stringArray = new String[]{string + "avr-size", " "};
        stringArray[1] = this.buildPath + File.separator + this.sketchName + ".hex";
        int n = 0;
        try {
            this.exception = null;
            this.size = -1L;
            this.firstLine = null;
            Process process = Runtime.getRuntime().exec(stringArray);
            MessageSiphon messageSiphon = new MessageSiphon(process.getInputStream(), this);
            MessageSiphon messageSiphon2 = new MessageSiphon(process.getErrorStream(), this);
            boolean bl = true;
            while (bl) {
                try {
                    if (messageSiphon.thread != null) {
                        messageSiphon.thread.join();
                    }
                    if (messageSiphon2.thread != null) {
                        messageSiphon2.thread.join();
                    }
                    n = process.waitFor();
                    bl = false;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            this.exception = new RunnerException(exception.toString() == null ? exception.getClass().getName() + n : exception.toString() + n);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.size == -1L) {
            throw new RunnerException(this.firstLine);
        }
        return this.size;
    }

    public void message(String string) {
        if (this.firstLine == null) {
            this.firstLine = string;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            try {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                this.size = new Integer(stringTokenizer.nextToken().trim()).longValue();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.exception = new RunnerException(noSuchElementException.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.exception = new RunnerException(numberFormatException.toString());
            }
        }
    }
}

