/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import processing.app.Base;
import processing.app.EditorConsole;
import processing.app.EditorHeader;
import processing.app.EditorLineStatus;
import processing.app.EditorListener;
import processing.app.EditorStatus;
import processing.app.EditorToolbar;
import processing.app.FindReplace;
import processing.app.Preferences;
import processing.app.SerialMonitor;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Theme;
import processing.app.debug.AvrdudeUploader;
import processing.app.debug.Runner;
import processing.app.debug.RunnerException;
import processing.app.debug.RunnerListener;
import processing.app.debug.Target;
import processing.app.debug.Uploader;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.TextAreaPainter;
import processing.app.tools.DiscourseFormat;
import processing.app.tools.Tool;
import processing.core.PApplet;

public class Editor
extends JFrame
implements RunnerListener {
    Base base;
    protected static final String EMPTY = "                                                                                                                                                                                                               ";
    static final int SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    static final KeyStroke WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, SHORTCUT_KEY_MASK);
    static final int SHORTCUT_ALT_KEY_MASK = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    boolean untitled;
    PageFormat pageFormat;
    PrinterJob printerJob;
    JMenu fileMenu;
    JMenu sketchMenu;
    JMenu toolsMenu;
    int numTools = 0;
    EditorToolbar toolbar;
    static JMenu toolbarMenu;
    static JMenu sketchbookMenu;
    static JMenu examplesMenu;
    static JMenu importMenu;
    static JMenu boardsMenu;
    static JMenu serialMenu;
    static SerialMenuListener serialMenuListener;
    static SerialMonitor serialMonitor;
    EditorHeader header;
    EditorStatus status;
    EditorConsole console;
    JSplitPane splitPane;
    JPanel consolePanel;
    JLabel lineNumberComponent;
    Sketch sketch;
    EditorLineStatus lineStatus;
    JEditTextArea textarea;
    EditorListener listener;
    Point sketchWindowLocation;
    Runner runtime;
    JMenuItem exportAppItem;
    JMenuItem saveMenuItem;
    JMenuItem saveAsMenuItem;
    boolean running;
    boolean presenting;
    boolean uploading;
    JMenuItem undoItem;
    JMenuItem redoItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    UndoManager undo;
    CompoundEdit compoundEdit;
    FindReplace find;

    public Editor(Base base, String string, int[] nArray) {
        super("Arduino");
        this.base = base;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Editor.this.base.handleClose(Editor.this);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                Editor.this.base.handleActivated(Editor.this);
                Editor.this.fileMenu.insert(sketchbookMenu, 2);
                Editor.this.fileMenu.insert(examplesMenu, 3);
                Editor.this.sketchMenu.insert(importMenu, 4);
                Editor.this.toolsMenu.insert(boardsMenu, Editor.this.numTools);
                Editor.this.toolsMenu.insert(serialMenu, Editor.this.numTools + 1);
            }
        });
        if (serialMonitor == null) {
            serialMonitor = new SerialMonitor(Preferences.get("serial.port"));
        }
        this.buildMenuBar();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        Box box = Box.createVerticalBox();
        Box box2 = Box.createVerticalBox();
        if (toolbarMenu == null) {
            toolbarMenu = new JMenu();
            this.base.rebuildToolbarMenu(toolbarMenu);
        }
        this.toolbar = new EditorToolbar(this, toolbarMenu);
        box2.add(this.toolbar);
        this.header = new EditorHeader(this);
        box2.add(this.header);
        this.textarea = new JEditTextArea(new PdeTextAreaDefaults());
        this.textarea.setRightClickPopup(new TextAreaPopup());
        this.textarea.setHorizontalOffset(6);
        this.consolePanel = new JPanel();
        this.consolePanel.setLayout(new BorderLayout());
        this.status = new EditorStatus(this);
        this.consolePanel.add((Component)this.status, "North");
        this.console = new EditorConsole(this);
        this.console.setBorder(null);
        this.consolePanel.add((Component)this.console, "Center");
        this.lineStatus = new EditorLineStatus(this.textarea);
        this.consolePanel.add((Component)this.lineStatus, "South");
        box2.add(this.textarea);
        this.splitPane = new JSplitPane(0, box2, this.consolePanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        int n = Preferences.getInteger("editor.divider.size");
        if (n != 0) {
            this.splitPane.setDividerSize(n);
        }
        this.splitPane.setMinimumSize(new Dimension(600, 400));
        box.add(this.splitPane);
        this.listener = new EditorListener(this, this.textarea);
        jPanel.add(box);
        jPanel.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                return true;
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                int n = 0;
                try {
                    DataFlavor dataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        for (int i = 0; i < list.size(); ++i) {
                            File file = (File)list.get(i);
                            if (!Editor.this.sketch.addFile(file)) continue;
                            ++n;
                        }
                    } else if (transferable.isDataFlavorSupported(dataFlavor)) {
                        String string = (String)transferable.getTransferData(dataFlavor);
                        String[] stringArray = PApplet.splitTokens((String)string, (String)"\r\n");
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].startsWith("#")) continue;
                            String string2 = null;
                            if (stringArray[i].startsWith("file:///")) {
                                string2 = stringArray[i].substring(7);
                            } else if (stringArray[i].startsWith("file:/")) {
                                string2 = stringArray[i].substring(5);
                            }
                            if (!Editor.this.sketch.addFile(new File(string2))) continue;
                            ++n;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
                if (n == 0) {
                    Editor.this.statusError("No files were added to the sketch.");
                } else if (n == 1) {
                    Editor.this.statusNotice("One file added to the sketch.");
                } else {
                    Editor.this.statusNotice(n + " files added to the sketch.");
                }
                return true;
            }
        });
        this.pack();
        this.setPlacement(nArray);
        this.applyPreferences();
        boolean bl = this.handleOpenInternal(string);
        if (!bl) {
            this.sketch = null;
        }
    }

    protected void setPlacement(int[] nArray) {
        this.setBounds(nArray[0], nArray[1], nArray[2], nArray[3]);
        if (nArray[4] != 0) {
            this.splitPane.setDividerLocation(nArray[4]);
        }
    }

    protected int[] getPlacement() {
        int[] nArray = new int[5];
        Rectangle rectangle = this.getBounds();
        nArray[0] = rectangle.x;
        nArray[1] = rectangle.y;
        nArray[2] = rectangle.width;
        nArray[3] = rectangle.height;
        nArray[4] = this.splitPane.getDividerLocation();
        return nArray;
    }

    public Dimension getMinimumSize() {
        return new Dimension(500, 550);
    }

    protected void applyPreferences() {
        boolean bl = Preferences.getBoolean("editor.external");
        this.textarea.setEditable(!bl);
        this.saveMenuItem.setEnabled(!bl);
        this.saveAsMenuItem.setEnabled(!bl);
        TextAreaPainter textAreaPainter = this.textarea.getPainter();
        if (bl) {
            Color color = Theme.getColor("editor.external.bgcolor");
            textAreaPainter.setBackground(color);
            textAreaPainter.setLineHighlightEnabled(false);
            this.textarea.setCaretVisible(false);
        } else {
            Color color = Theme.getColor("editor.bgcolor");
            textAreaPainter.setBackground(color);
            boolean bl2 = Preferences.getBoolean("editor.linehighlight");
            textAreaPainter.setLineHighlightEnabled(bl2);
            this.textarea.setCaretVisible(true);
        }
        textAreaPainter.setFont(Preferences.getFont("editor.font"));
        this.listener.applyPreferences();
    }

    protected void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        jMenuBar.add(this.buildEditMenu());
        jMenuBar.add(this.buildSketchMenu());
        jMenuBar.add(this.buildToolsMenu());
        jMenuBar.add(this.buildHelpMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu buildFileMenu() {
        this.fileMenu = new JMenu("File");
        JMenuItem jMenuItem = Editor.newJMenuItem("New", 78);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.base.handleNew();
            }
        });
        this.fileMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Open...", 79);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.base.handleOpenPrompt();
            }
        });
        this.fileMenu.add(jMenuItem);
        if (sketchbookMenu == null) {
            sketchbookMenu = new JMenu("Sketchbook");
            this.base.rebuildSketchbookMenu(sketchbookMenu);
        }
        this.fileMenu.add(sketchbookMenu);
        if (examplesMenu == null) {
            examplesMenu = new JMenu("Examples");
            this.base.rebuildExamplesMenu(examplesMenu);
        }
        this.fileMenu.add(examplesMenu);
        jMenuItem = Editor.newJMenuItem("Close", 87);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.base.handleClose(Editor.this);
            }
        });
        this.fileMenu.add(jMenuItem);
        this.saveMenuItem = Editor.newJMenuItem("Save", 83);
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleSave(false);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem = Editor.newJMenuItemShift("Save As...", 83);
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleSaveAs();
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        jMenuItem = Editor.newJMenuItem("Upload to I/O Board", 85);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleExport();
            }
        });
        this.fileMenu.add(jMenuItem);
        this.fileMenu.addSeparator();
        jMenuItem = Editor.newJMenuItemShift("Page Setup", 80);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handlePageSetup();
            }
        });
        this.fileMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Print", 80);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handlePrint();
            }
        });
        this.fileMenu.add(jMenuItem);
        if (!Base.isMacOS()) {
            this.fileMenu.addSeparator();
            jMenuItem = Editor.newJMenuItem("Preferences", 44);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.base.handlePrefs();
                }
            });
            this.fileMenu.add(jMenuItem);
            this.fileMenu.addSeparator();
            jMenuItem = Editor.newJMenuItem("Quit", 81);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.base.handleQuit();
                }
            });
            this.fileMenu.add(jMenuItem);
        }
        return this.fileMenu;
    }

    protected JMenu buildSketchMenu() {
        this.sketchMenu = new JMenu("Sketch");
        JMenuItem jMenuItem = Editor.newJMenuItem("Verify / Compile", 82);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleRun(false);
            }
        });
        this.sketchMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Stop");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleStop();
            }
        });
        this.sketchMenu.add(jMenuItem);
        this.sketchMenu.addSeparator();
        if (importMenu == null) {
            importMenu = new JMenu("Import Library...");
            this.base.rebuildImportMenu(importMenu);
        }
        this.sketchMenu.add(importMenu);
        jMenuItem = Editor.newJMenuItem("Show Sketch Folder", 75);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.openFolder(Editor.this.sketch.getFolder());
            }
        });
        this.sketchMenu.add(jMenuItem);
        jMenuItem.setEnabled(Base.openFolderAvailable());
        jMenuItem = new JMenuItem("Add File...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.sketch.handleAddFile();
            }
        });
        this.sketchMenu.add(jMenuItem);
        return this.sketchMenu;
    }

    protected JMenu buildToolsMenu() {
        JMenuItem jMenuItem;
        AbstractAction abstractAction;
        String string;
        Iterator iterator;
        Serializable serializable;
        JMenu jMenu = this.toolsMenu = new JMenu("Tools");
        this.addInternalTools(jMenu);
        this.addTools(jMenu, Base.getToolsFolder());
        File file = new File(Base.getSketchbookFolder(), "tools");
        this.addTools(jMenu, file);
        jMenu.addSeparator();
        this.numTools = jMenu.getItemCount();
        if (boardsMenu == null) {
            boardsMenu = new JMenu("Board");
            serializable = new ButtonGroup();
            iterator = Preferences.getSubKeys("boards");
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                abstractAction = new BoardMenuAction(string);
                jMenuItem = new JRadioButtonMenuItem(abstractAction);
                if (string.equals(Preferences.get("board"))) {
                    jMenuItem.setSelected(true);
                }
                ((ButtonGroup)serializable).add(jMenuItem);
                boardsMenu.add(jMenuItem);
            }
        }
        jMenu.add(boardsMenu);
        if (serialMenuListener == null) {
            serialMenuListener = new SerialMenuListener();
        }
        if (serialMenu == null) {
            serialMenu = new JMenu("Serial Port");
        }
        this.populateSerialMenu();
        jMenu.add(serialMenu);
        jMenu.addSeparator();
        serializable = new JMenu("Burn Bootloader");
        iterator = Preferences.getSubKeys("programmers");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            abstractAction = new BootloaderMenuAction(string);
            jMenuItem = new JMenuItem(abstractAction);
            ((JMenu)serializable).add(jMenuItem);
        }
        jMenu.add((JMenuItem)serializable);
        jMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                Editor.this.populateSerialMenu();
            }
        });
        return jMenu;
    }

    protected void addTools(JMenu jMenu, File file) {
        HashMap<String, JMenuItem> hashMap = new HashMap<String, JMenuItem>();
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    File file2 = new File(file, "tool");
                    return file2.exists();
                }
                return false;
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = new File(fileArray[i], "tool");
            try {
                Object object = file2.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".zip");
                    }
                });
                URL[] uRLArray = new URL[((File[])object).length];
                for (int j = 0; j < uRLArray.length; ++j) {
                    uRLArray[j] = object[j].toURL();
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                String string = null;
                for (int j = 0; j < ((File[])object).length && (string = this.findClassInZipFile(fileArray[i].getName(), object[j])) == null; ++j) {
                }
                if (string == null) continue;
                Class<?> clazz = Class.forName(string, true, uRLClassLoader);
                final Tool tool = (Tool)clazz.newInstance();
                tool.init(this);
                String string2 = tool.getMenuTitle();
                JMenuItem jMenuItem = new JMenuItem(string2);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(tool);
                    }
                });
                hashMap.put(string2, jMenuItem);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        if (arrayList.size() == 0) {
            return;
        }
        jMenu.addSeparator();
        Collections.sort(arrayList);
        for (Object object : arrayList) {
            jMenu.add((JMenuItem)hashMap.get(object));
        }
    }

    protected String findClassInZipFile(String string, File file) {
        String string2 = "/" + string + ".class";
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string3;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !(string3 = zipEntry.getName()).endsWith(string2)) continue;
                return string3.substring(0, string3.length() - 6).replace('/', '.');
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    protected JMenuItem createToolMenuItem(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            final Tool tool = (Tool)clazz.newInstance();
            JMenuItem jMenuItem = new JMenuItem(tool.getMenuTitle());
            tool.init(this);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(tool);
                }
            });
            return jMenuItem;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected JMenu addInternalTools(JMenu jMenu) {
        JMenuItem jMenuItem = this.createToolMenuItem("processing.app.tools.AutoFormat");
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, n));
        jMenu.add(jMenuItem);
        jMenu.add(this.createToolMenuItem("processing.app.tools.Archiver"));
        jMenu.add(this.createToolMenuItem("processing.app.tools.FixEncoding"));
        return jMenu;
    }

    protected void populateSerialMenu() {
        serialMenu.removeAll();
        boolean bl = true;
        try {
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commPortIdentifier.getPortType() != 1) continue;
                String string = commPortIdentifier.getName();
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, string.equals(Preferences.get("serial.port")));
                jCheckBoxMenuItem.addActionListener(serialMenuListener);
                serialMenu.add(jCheckBoxMenuItem);
                bl = false;
            }
            if (!bl) {
                serialMenu.setEnabled(true);
            }
        }
        catch (Exception exception) {
            System.out.println("error retrieving port list");
            exception.printStackTrace();
        }
        if (serialMenu.getItemCount() == 0) {
            serialMenu.setEnabled(false);
        }
    }

    protected JMenu buildHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("Getting Started");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.showGettingStarted();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Environment");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.showEnvironment();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Troubleshooting");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.showTroubleshooting();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reference");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.showReference();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItemShift("Find in Reference", 70);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.textarea.isSelectionActive()) {
                    Editor.this.handleFindReference();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Frequently Asked Questions");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.showFAQ();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Visit Arduino.cc");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.openURL("http://arduino.cc/");
            }
        });
        jMenu.add(jMenuItem);
        if (!Base.isMacOS()) {
            jMenu.addSeparator();
            jMenuItem = new JMenuItem("About Arduino");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.base.handleAbout();
                }
            });
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    protected JMenu buildEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        this.undoItem = Editor.newJMenuItem("Undo", 90);
        this.undoAction = new UndoAction();
        this.undoItem.addActionListener(this.undoAction);
        jMenu.add(this.undoItem);
        this.redoItem = Editor.newJMenuItem("Redo", 89);
        this.redoAction = new RedoAction();
        this.redoItem.addActionListener(this.redoAction);
        jMenu.add(this.redoItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem = Editor.newJMenuItem("Cut", 88);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleCut();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Copy", 67);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textarea.copy();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItemShift("Copy for Forum", 67);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new DiscourseFormat(Editor.this, false).show();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItemAlt("Copy as HTML", 67);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new DiscourseFormat(Editor.this, true).show();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Paste", 86);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textarea.paste();
                Editor.this.sketch.setModified(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Select All", 65);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.textarea.selectAll();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = Editor.newJMenuItem("Comment/Uncomment", 47);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleCommentUncomment();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Increase Indent", 93);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleIndentOutdent(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Decrease Indent", 91);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.handleIndentOutdent(false);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = Editor.newJMenuItem("Find...", 70);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                Editor.this.find.setVisible(true);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Editor.newJMenuItem("Find Next", 71);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Editor.this.find != null) {
                    Editor.this.find.find(true);
                }
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenuItem newJMenuItem(String string, int n) {
        JMenuItem jMenuItem = new JMenuItem(string);
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
        return jMenuItem;
    }

    public static JMenuItem newJMenuItemShift(String string, int n) {
        JMenuItem jMenuItem = new JMenuItem(string);
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2 |= 1));
        return jMenuItem;
    }

    public static JMenuItem newJMenuItemAlt(String string, int n) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, SHORTCUT_ALT_KEY_MASK));
        return jMenuItem;
    }

    public Sketch getSketch() {
        return this.sketch;
    }

    public JEditTextArea getTextArea() {
        return this.textarea;
    }

    public String getText() {
        return this.textarea.getText();
    }

    public String getText(int n, int n2) {
        return this.textarea.getText(n, n2 - n);
    }

    public void setText(String string) {
        this.startCompoundEdit();
        this.textarea.setText(string);
        this.stopCompoundEdit();
    }

    public void insertText(String string) {
        this.startCompoundEdit();
        int n = this.getCaretOffset();
        this.setSelection(n, n);
        this.textarea.setSelectedText(string);
        this.stopCompoundEdit();
    }

    public String getSelectedText() {
        return this.textarea.getSelectedText();
    }

    public void setSelectedText(String string) {
        this.textarea.setSelectedText(string);
    }

    public void setSelection(int n, int n2) {
        n = PApplet.constrain((int)n, (int)0, (int)this.textarea.getDocumentLength());
        n2 = PApplet.constrain((int)n2, (int)0, (int)this.textarea.getDocumentLength());
        this.textarea.select(n, n2);
    }

    public int getCaretOffset() {
        return this.textarea.getCaretPosition();
    }

    public boolean isSelectionActive() {
        return this.textarea.isSelectionActive();
    }

    public int getSelectionStart() {
        return this.textarea.getSelectionStart();
    }

    public int getSelectionStop() {
        return this.textarea.getSelectionStop();
    }

    public String getLineText(int n) {
        return this.textarea.getLineText(n);
    }

    public void setLineText(int n, String string) {
        this.startCompoundEdit();
        this.textarea.select(this.getLineStartOffset(n), this.getLineStopOffset(n));
        this.textarea.setSelectedText(string);
        this.stopCompoundEdit();
    }

    public int getLineStartOffset(int n) {
        return this.textarea.getLineStartOffset(n);
    }

    public int getLineStopOffset(int n) {
        return this.textarea.getLineStopOffset(n);
    }

    public int getLineCount() {
        return this.textarea.getLineCount();
    }

    public void startCompoundEdit() {
        this.compoundEdit = new CompoundEdit();
    }

    public void stopCompoundEdit() {
        this.compoundEdit.end();
        this.undo.addEdit(this.compoundEdit);
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        this.compoundEdit = null;
    }

    public int getScrollPosition() {
        return this.textarea.getScrollPosition();
    }

    protected void setCode(SketchCode sketchCode) {
        SyntaxDocument syntaxDocument = (SyntaxDocument)sketchCode.getDocument();
        if (syntaxDocument == null) {
            syntaxDocument = new SyntaxDocument();
            sketchCode.setDocument(syntaxDocument);
            syntaxDocument.setTokenMarker(new PdeKeywords());
            try {
                syntaxDocument.insertString(0, sketchCode.getProgram(), null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            syntaxDocument.addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    if (Editor.this.compoundEdit != null) {
                        Editor.this.compoundEdit.addEdit(undoableEditEvent.getEdit());
                    } else if (Editor.this.undo != null) {
                        Editor.this.undo.addEdit(undoableEditEvent.getEdit());
                        Editor.this.undoAction.updateUndoState();
                        Editor.this.redoAction.updateRedoState();
                    }
                }
            });
        }
        this.textarea.setDocument(syntaxDocument, sketchCode.getSelectionStart(), sketchCode.getSelectionStop(), sketchCode.getScrollPosition());
        this.textarea.requestFocus();
        this.undo = sketchCode.getUndo();
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    public void handleCut() {
        this.textarea.cut();
        this.sketch.setModified(true);
    }

    public void handleCopy() {
        this.textarea.copy();
    }

    protected void handleDiscourseCopy() {
        new DiscourseFormat(this, false).show();
    }

    protected void handleHTMLCopy() {
        new DiscourseFormat(this, true).show();
    }

    public void handlePaste() {
        this.textarea.paste();
        this.sketch.setModified(true);
    }

    public void handleSelectAll() {
        this.textarea.selectAll();
    }

    protected void handleCommentUncomment() {
        int n;
        int n2;
        this.startCompoundEdit();
        int n3 = this.textarea.getSelectionStartLine();
        int n4 = this.textarea.getSelectionStopLine();
        int n5 = this.textarea.getLineStartOffset(n4);
        int n6 = this.textarea.getSelectionStop();
        if (n6 == n5 && this.textarea.isSelectionActive()) {
            --n4;
        }
        int n7 = this.textarea.getDocumentLength();
        boolean bl = true;
        for (n2 = n3; bl && n2 <= n4; ++n2) {
            n = this.textarea.getLineStartOffset(n2);
            if (n + 2 > n7) {
                bl = false;
                continue;
            }
            String string = this.textarea.getText(n, 2);
            bl = string.equals("//");
        }
        for (n2 = n3; n2 <= n4; ++n2) {
            n = this.textarea.getLineStartOffset(n2);
            if (bl) {
                this.textarea.select(n, n + 2);
                if (!this.textarea.getSelectedText().equals("//")) continue;
                this.textarea.setSelectedText("");
                continue;
            }
            this.textarea.select(n, n);
            this.textarea.setSelectedText("//");
        }
        this.textarea.select(this.textarea.getLineStartOffset(n3), this.textarea.getLineStopOffset(n4) - 1);
        this.stopCompoundEdit();
    }

    protected void handleIndentOutdent(boolean bl) {
        int n = Preferences.getInteger("editor.tabs.size");
        String string = EMPTY.substring(0, n);
        this.startCompoundEdit();
        int n2 = this.textarea.getSelectionStartLine();
        int n3 = this.textarea.getSelectionStopLine();
        int n4 = this.textarea.getLineStartOffset(n3);
        int n5 = this.textarea.getSelectionStop();
        if (n5 == n4 && this.textarea.isSelectionActive()) {
            --n3;
        }
        for (int i = n2; i <= n3; ++i) {
            int n6 = this.textarea.getLineStartOffset(i);
            if (bl) {
                this.textarea.select(n6, n6);
                this.textarea.setSelectedText(string);
                continue;
            }
            this.textarea.select(n6, n6 + n);
            if (!this.textarea.getSelectedText().equals(string)) continue;
            this.textarea.setSelectedText("");
        }
        this.textarea.select(this.textarea.getLineStartOffset(n2), this.textarea.getLineStopOffset(n3) - 1);
        this.stopCompoundEdit();
    }

    protected void handleFindReference() {
        String string = this.textarea.getSelectedText().trim();
        if (string.length() == 0) {
            this.statusNotice("First select a word to find in the reference.");
        } else {
            String string2 = PdeKeywords.getReference(string);
            if (string2 == null) {
                this.statusNotice("No reference available for \"" + string + "\"");
            } else {
                Base.showReference(string2 + ".html");
            }
        }
    }

    public void handleRun(boolean bl) {
        this.internalCloseRunner();
        this.running = true;
        this.toolbar.activate(0);
        this.statusNotice("Compiling...");
        for (int i = 0; i < 10; ++i) {
            System.out.println();
        }
        if (Preferences.getBoolean("console.auto_clear")) {
            this.console.clear();
        }
        this.presenting = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Editor.this.sketch.compile(new Target(Base.getHardwarePath() + File.separator + "cores", Preferences.get("boards." + Preferences.get("board") + ".build.core")));
                    Editor.this.statusNotice("Done compiling.");
                }
                catch (RunnerException runnerException) {
                    Editor.this.statusError(runnerException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Editor.this.toolbar.deactivate(0);
            }
        });
    }

    public void setSketchLocation(Point point) {
        this.sketchWindowLocation = point;
    }

    public Point getSketchLocation() {
        return this.sketchWindowLocation;
    }

    public void handleStop() {
        this.toolbar.activate(1);
        this.internalCloseRunner();
        this.toolbar.deactivate(0);
        this.toolbar.deactivate(1);
        this.toFront();
    }

    public void internalRunnerClosed() {
        this.running = false;
        this.toolbar.deactivate(0);
    }

    public void internalCloseRunner() {
        this.running = false;
        try {
            if (this.runtime != null) {
                this.runtime.close();
                this.runtime = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sketch.cleanup();
    }

    protected boolean checkModified(boolean bl) {
        if (!this.sketch.isModified()) {
            return true;
        }
        String string = "Save changes to " + this.sketch.getName() + "?  ";
        if (!Base.isMacOS()) {
            int n = JOptionPane.showConfirmDialog(this, string, "Close", 1, 3);
            if (n == 0) {
                return this.handleSave(bl);
            }
            if (n == 1) {
                return true;
            }
            if (n == 2) {
                return false;
            }
            throw new IllegalStateException();
        }
        JOptionPane jOptionPane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
        Object[] objectArray = new String[]{"Save", "Cancel", "Don't Save"};
        jOptionPane.setOptions(objectArray);
        jOptionPane.setInitialValue(objectArray[0]);
        jOptionPane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog jDialog = jOptionPane.createDialog(this, null);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object == objectArray[0]) {
            return this.handleSave(bl);
        }
        return object == objectArray[2];
    }

    protected void handleOpenUnchecked(String string, int n, int n2, int n3, int n4) {
        this.internalCloseRunner();
        this.handleOpenInternal(string);
        this.untitled = false;
        this.sketch.setCurrentCode(n);
        this.textarea.select(n2, n3);
        this.textarea.setScrollPosition(n4);
    }

    protected boolean handleOpenInternal(String string) {
        File file = new File(string);
        File file2 = new File(file.getParent());
        String string2 = file2.getName();
        String string3 = string2 + ".pde";
        File file3 = new File(file.getParent(), string3);
        if (!string3.equals(file.getName())) {
            if (file3.exists()) {
                string = file3.getAbsolutePath();
            } else {
                if (!string.endsWith(".pde")) {
                    Base.showWarning("Bad file selected", "Processing can only open its own sketches\nand other files ending in .pde", null);
                    return false;
                }
                String string4 = file.getName().substring(0, file.getName().length() - 4);
                Object[] objectArray = new Object[]{"OK", "Cancel"};
                String string5 = "The file \"" + file.getName() + "\" needs to be inside\n" + "a sketch folder named \"" + string4 + "\".\n" + "Create this folder, move the file, and continue?";
                int n = JOptionPane.showOptionDialog(this, string5, "Moving", 0, 3, null, objectArray, objectArray[0]);
                if (n == 0) {
                    File file4 = new File(file.getParent(), string4);
                    if (file4.exists()) {
                        Base.showWarning("Error", "A folder named \"" + string4 + "\" " + "already exists. Can't open sketch.", null);
                        return false;
                    }
                    if (!file4.mkdirs()) {
                        Base.showWarning("Error", "Could not create the sketch folder.", null);
                        return false;
                    }
                    File file5 = new File(file4, file.getName());
                    File file6 = new File(string);
                    try {
                        Base.copyFile(file6, file5);
                    }
                    catch (IOException iOException) {
                        Base.showWarning("Error", "Could not copy to a proper location.", iOException);
                        return false;
                    }
                    file6.delete();
                    string = file5.getAbsolutePath();
                } else if (n == 1) {
                    return false;
                }
            }
        }
        try {
            this.sketch = new Sketch(this, string);
        }
        catch (IOException iOException) {
            Base.showWarning("Error", "Could not create the sketch.", iOException);
            return false;
        }
        this.header.rebuild();
        this.setTitle(this.sketch.getName() + " | Arduino " + Base.VERSION_NAME);
        this.untitled = false;
        this.base.storeSketches();
        Preferences.save();
        return true;
    }

    public boolean handleSave(boolean bl) {
        this.handleStop();
        if (this.untitled) {
            return this.handleSaveAs();
        }
        if (bl) {
            this.handleSave2();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Editor.this.handleSave2();
                }
            });
        }
        return true;
    }

    protected void handleSave2() {
        this.toolbar.activate(4);
        this.statusNotice("Saving...");
        try {
            if (this.sketch.save()) {
                this.statusNotice("Done Saving.");
            } else {
                this.statusEmpty();
            }
        }
        catch (Exception exception) {
            this.statusError(exception);
        }
        this.toolbar.deactivate(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSaveAs() {
        block6: {
            this.handleStop();
            this.toolbar.activate(4);
            this.statusNotice("Saving...");
            try {
                if (this.sketch.saveAs()) {
                    this.statusNotice("Done Saving.");
                    break block6;
                }
                this.statusNotice("Save Canceled.");
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                this.statusError(exception);
            }
            finally {
                this.toolbar.deactivate(4);
            }
        }
        return true;
    }

    public synchronized void handleExport() {
        this.toolbar.activate(5);
        this.console.clear();
        this.statusNotice("Uploading to I/O Board...");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    serialMonitor.closeSerialPort();
                    serialMonitor.setVisible(false);
                    Editor.this.uploading = true;
                    boolean bl = Editor.this.sketch.exportApplet(new Target(Base.getHardwarePath() + File.separator + "cores", Preferences.get("boards." + Preferences.get("board") + ".build.core")));
                    if (bl) {
                        Editor.this.statusNotice("Done uploading.");
                    }
                }
                catch (RunnerException runnerException) {
                    Editor.this.statusError(runnerException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Editor.this.uploading = false;
                Editor.this.toolbar.deactivate(5);
            }
        });
        thread.start();
    }

    protected boolean handleExportCheckModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        Object[] objectArray = new Object[]{"OK", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "Save changes before export?", "Save", 2, 3, null, objectArray, objectArray[0]);
        if (n != 0) {
            this.statusNotice("Export canceled, changes must first be saved.");
            return false;
        }
        this.handleSave(true);
        return true;
    }

    public void handleSerial() {
        if (this.uploading) {
            return;
        }
        serialMonitor.setVisible(true);
        serialMonitor.openSerialPort();
    }

    protected void handleBurnBootloader(final String string) {
        this.console.clear();
        this.statusNotice("Burning bootloader to I/O Board (this may take a minute)...");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    AvrdudeUploader avrdudeUploader = new AvrdudeUploader();
                    if (((Uploader)avrdudeUploader).burnBootloader(string)) {
                        Editor.this.statusNotice("Done burning bootloader.");
                    } else {
                        Editor.this.statusError("Error while burning bootloader.");
                    }
                }
                catch (RunnerException runnerException) {
                    Editor.this.statusError("Error while burning bootloader.");
                    runnerException.printStackTrace();
                }
                catch (Exception exception) {
                    Editor.this.statusError("Error while burning bootloader.");
                    exception.printStackTrace();
                }
            }
        });
    }

    public void handlePageSetup() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void handlePrint() {
        this.statusNotice("Printing...");
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat != null) {
            this.printerJob.setPrintable(this.textarea.getPainter(), this.pageFormat);
        } else {
            this.printerJob.setPrintable(this.textarea.getPainter());
        }
        this.printerJob.setJobName(this.sketch.getCurrentCode().getPrettyName());
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
                this.statusNotice("Done printing.");
            }
            catch (PrinterException printerException) {
                this.statusError("Error while printing.");
                printerException.printStackTrace();
            }
        } else {
            this.statusNotice("Printing canceled.");
        }
    }

    public void statusError(String string) {
        this.status.error(string);
        this.toolbar.deactivate(0);
    }

    public void statusError(Exception exception) {
        Object object;
        exception.printStackTrace();
        if (exception instanceof RunnerException) {
            object = (RunnerException)exception;
            if (((RunnerException)object).hasCodeIndex()) {
                this.sketch.setCurrentCode(((RunnerException)object).getCodeIndex());
            }
            if (((RunnerException)object).hasCodeLine()) {
                int n = ((RunnerException)object).getCodeLine();
                if (n >= this.textarea.getLineCount() && this.textarea.getLineText(n = this.textarea.getLineCount() - 1).length() == 0) {
                    --n;
                }
                if (n < 0 || n >= this.textarea.getLineCount()) {
                    System.err.println("Bad error line: " + n);
                } else {
                    this.textarea.select(this.textarea.getLineStartOffset(n), this.textarea.getLineStopOffset(n) - 1);
                }
            }
        }
        if ((object = exception.getMessage()) != null) {
            String string;
            String string2 = "java.lang.";
            if (((String)object).indexOf(string2) == 0) {
                object = ((String)object).substring(string2.length());
            }
            if (((String)object).indexOf(string = "RuntimeException: ") == 0) {
                object = ((String)object).substring(string.length());
            }
            this.statusError((String)object);
        }
        exception.printStackTrace();
    }

    public void statusNotice(String string) {
        this.status.notice(string);
    }

    public void statusEmpty() {
        this.statusNotice(EMPTY);
    }

    class TextAreaPopup
    extends JPopupMenu {
        String referenceFile = null;
        JMenuItem cutItem = new JMenuItem("Cut");
        JMenuItem copyItem;
        JMenuItem discourseItem;
        JMenuItem referenceItem;

        public TextAreaPopup() {
            this.cutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleCut();
                }
            });
            this.add(this.cutItem);
            this.copyItem = new JMenuItem("Copy");
            this.copyItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleCopy();
                }
            });
            this.add(this.copyItem);
            this.discourseItem = new JMenuItem("Copy for Forum");
            this.discourseItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleDiscourseCopy();
                }
            });
            this.add(this.discourseItem);
            this.discourseItem = new JMenuItem("Copy as HTML");
            this.discourseItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleHTMLCopy();
                }
            });
            this.add(this.discourseItem);
            JMenuItem jMenuItem = new JMenuItem("Paste");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handlePaste();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Select All");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleSelectAll();
                }
            });
            this.add(jMenuItem);
            this.addSeparator();
            jMenuItem = new JMenuItem("Comment/Uncomment");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleCommentUncomment();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Increase Indent");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleIndentOutdent(true);
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Decrease Indent");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleIndentOutdent(false);
                }
            });
            this.add(jMenuItem);
            this.addSeparator();
            this.referenceItem = new JMenuItem("Find in Reference");
            this.referenceItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.handleFindReference();
                }
            });
            this.add(this.referenceItem);
        }

        public void show(Component component, int n, int n2) {
            if (Editor.this.textarea.isSelectionActive()) {
                this.cutItem.setEnabled(true);
                this.copyItem.setEnabled(true);
                this.discourseItem.setEnabled(true);
                String string = Editor.this.textarea.getSelectedText().trim();
                this.referenceFile = PdeKeywords.getReference(string);
                this.referenceItem.setEnabled(this.referenceFile != null);
            } else {
                this.cutItem.setEnabled(false);
                this.copyItem.setEnabled(false);
                this.discourseItem.setEnabled(false);
                this.referenceItem.setEnabled(false);
            }
            super.show(component, n, n2);
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.updateRedoState();
            Editor.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (Editor.this.undo.canRedo()) {
                Editor.this.redoItem.setEnabled(true);
                Editor.this.redoItem.setText(Editor.this.undo.getRedoPresentationName());
                this.putValue("Name", Editor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                Editor.this.redoItem.setEnabled(false);
                Editor.this.redoItem.setText("Redo");
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.updateUndoState();
            Editor.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (Editor.this.undo.canUndo()) {
                this.setEnabled(true);
                Editor.this.undoItem.setEnabled(true);
                Editor.this.undoItem.setText(Editor.this.undo.getUndoPresentationName());
                this.putValue("Name", Editor.this.undo.getUndoPresentationName());
                if (Editor.this.sketch != null) {
                    Editor.this.sketch.setModified(true);
                }
            } else {
                this.setEnabled(false);
                Editor.this.undoItem.setEnabled(false);
                Editor.this.undoItem.setText("Undo");
                this.putValue("Name", "Undo");
                if (Editor.this.sketch != null) {
                    Editor.this.sketch.setModified(false);
                }
            }
        }
    }

    class BootloaderMenuAction
    extends AbstractAction {
        private String programmer;

        public BootloaderMenuAction(String string) {
            super("w/ " + Preferences.get("programmers." + string + ".name"));
            this.programmer = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.handleBurnBootloader(this.programmer);
        }
    }

    class BoardMenuAction
    extends AbstractAction {
        private String board;

        public BoardMenuAction(String string) {
            super(Preferences.get("boards." + string + ".name"));
            this.board = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Preferences.set("board", this.board);
        }
    }

    class SerialMenuListener
    implements ActionListener {
        SerialMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (serialMenu == null) {
                System.out.println("serialMenu is null");
                return;
            }
            int n = serialMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                ((JCheckBoxMenuItem)serialMenu.getItem(i)).setState(false);
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            jCheckBoxMenuItem.setState(true);
            String string = jCheckBoxMenuItem.getText();
            Preferences.set("serial.port", string);
            serialMonitor.closeSerialPort();
            serialMonitor.setVisible(false);
            serialMonitor = new SerialMonitor(Preferences.get("serial.port"));
        }
    }
}

