/*
 * lgee.h
 *
 * $Id: muse.h,v 1.2 2011/01/17 22:32:42 dath Exp $
 */

#ifndef MUSE_H_
#define MUSE_H_

#include <stdint.h>

/* Frame that is received by littleGee from Host
 *
 * Configure the node and its sensors
 */
typedef struct{

/* start of 802.15.4 conform MAC header */
	uint16_t FCF;			/**< Frame control field acc. to 802.15.4 */
	uint8_t seqnumber;		/**< sequence number */
	uint16_t destpanid;		/**< PAN ID of destination */
	uint16_t destaddr;		/**< Short address of destination */
	uint16_t srcpanid;		/**< PAN ID of source */
	uint16_t srcaddr;		/**< Short address of source */
/* end of 802.15.4 conform MAC header */

	uint8_t acc_smprate;	/**< sample rate 1..250 [Hz] */
	uint8_t acc_gmode;		/**< g-mode of MMA7455 (2,4,8) */
	uint16_t crc;
}muse_cfgframe_t;

/* Frame structure that is sent from littleGee to Host containing the sensor data
 *
 */
typedef struct{

/* start of 802.15.4 conform MAC header */
	uint16_t FCF;			/**< Frame control field acc. to 802.15.4 */
	uint8_t seqnumber;		/**< sequence number */
	uint16_t destpanid;		/**< PAN ID of destination */
	uint16_t destaddr;		/**< Short address of destination */
	uint16_t srcpanid;		/**< PAN ID of source */
	uint16_t srcaddr;		/**< Short address of source */
/* end of 802.15.4 conform MAC header */

	int8_t acc_x;				/**< x-axis */
	int8_t acc_y;				/**< y-axis */
	int8_t acc_z;				/**< z-axis */
	uint16_t sht21_humidity_raw;	/**< raw data output */
	uint16_t sht21_temperature_raw;	/**< raw data output */
	uint16_t avr_voltage;		/**< AVR voltage [mV] */
	int8_t avr_temperature;		/**< [degC] */
	uint8_t led;				/**< light sensor */
	uint16_t crc;
}muse_dataframe_t;

#endif /* MUSE_H_ */
