/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.syntax.JEditTextArea;

public class EditorListener {
    private Editor editor;
    private JEditTextArea textarea;
    private boolean externalEditor;
    private boolean tabsExpand;
    private boolean tabsIndent;
    private int tabSize;
    private String tabString;
    private boolean autoIndent;
    static final int CTRL_ALT = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public EditorListener(Editor editor, JEditTextArea jEditTextArea) {
        this.editor = editor;
        this.textarea = jEditTextArea;
        jEditTextArea.editorListener = this;
        this.applyPreferences();
    }

    public void applyPreferences() {
        this.tabsExpand = Preferences.getBoolean("editor.tabs.expand");
        this.tabSize = Preferences.getInteger("editor.tabs.size");
        this.tabString = "                                                                                                                                                                                                               ".substring(0, this.tabSize);
        this.autoIndent = Preferences.getBoolean("editor.indent");
        this.externalEditor = Preferences.getBoolean("editor.external");
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.externalEditor) {
            return false;
        }
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        Sketch sketch = this.editor.getSketch();
        if ((keyEvent.getModifiers() & CTRL_ALT) == CTRL_ALT) {
            if (n == 37) {
                sketch.handlePrevCode();
                return true;
            }
            if (n == 39) {
                sketch.handleNextCode();
                return true;
            }
        }
        if ((keyEvent.getModifiers() & 4) != 0) {
            return false;
        }
        if (!this.editor.getSketch().isModified() && (n == 8 || n == 9 || n == 10 || c >= ' ' && c < '\u0080')) {
            sketch.setModified(true);
        }
        if (n == 38 && (keyEvent.getModifiers() & 2) != 0) {
            char[] cArray = this.textarea.getText().toCharArray();
            int n2 = this.textarea.getCaretPosition();
            int n3 = this.calcLineStart(n2 - 1, cArray);
            n3 -= 2;
            boolean bl = true;
            while (n3 > 0) {
                if (cArray[n3] == '\n') {
                    if (bl) {
                        ++n3;
                        break;
                    }
                    bl = true;
                } else if (cArray[n3] != ' ') {
                    bl = false;
                }
                --n3;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if ((keyEvent.getModifiers() & 1) != 0) {
                this.textarea.setSelectionStart(n2);
                this.textarea.setSelectionEnd(n3);
            } else {
                this.textarea.setCaretPosition(n3);
            }
            keyEvent.consume();
            return true;
        }
        if (n == 40 && (keyEvent.getModifiers() & 2) != 0) {
            int n4;
            int n5;
            char[] cArray = this.textarea.getText().toCharArray();
            int n6 = 0;
            boolean bl = false;
            for (n5 = n4 = this.textarea.getCaretPosition(); n5 < cArray.length; ++n5) {
                if (cArray[n5] == '\n') {
                    if (bl) {
                        n5 = n6;
                        break;
                    }
                    n6 = n5 + 1;
                    bl = true;
                    continue;
                }
                if (cArray[n5] == ' ') continue;
                bl = false;
            }
            if ((keyEvent.getModifiers() & 1) != 0) {
                this.textarea.setSelectionStart(n4);
                this.textarea.setSelectionEnd(n5);
            } else {
                this.textarea.setCaretPosition(n5);
            }
            keyEvent.consume();
            return true;
        }
        switch (c) {
            case '\t': {
                int n7;
                int n8;
                if (this.textarea.isSelectionActive()) {
                    boolean bl = (keyEvent.getModifiers() & 1) != 0;
                    this.editor.handleIndentOutdent(!bl);
                    break;
                }
                if (this.tabsExpand) {
                    this.textarea.setSelectedText(this.tabString);
                    keyEvent.consume();
                    return true;
                }
                if (!this.tabsIndent) break;
                char[] cArray = this.textarea.getText().toCharArray();
                int n9 = this.textarea.getCaretPosition() - 1;
                for (n8 = n7 = this.calcLineStart(n9, cArray); n8 < cArray.length - 1 && cArray[n8] != '\n'; ++n8) {
                }
                int n10 = 0;
                for (int i = n7; i < cArray.length && cArray[i] != '\n'; ++i) {
                    if (cArray[i] == '{') {
                        ++n10;
                        continue;
                    }
                    if (cArray[i] != '}') continue;
                    --n10;
                }
                int n11 = n10 > 0 ? n7 : n8;
                int n12 = this.calcBraceIndent(n11, cArray);
                n12 = n12 == -1 ? 0 : (n12 += this.tabSize);
                int n13 = this.calcSpaceCount(n9, cArray);
                this.textarea.setSelectionStart(n7);
                this.textarea.setSelectionEnd(n7 + n13);
                this.textarea.setSelectedText("                                                                                                                                                                                                               ".substring(0, n12));
                keyEvent.consume();
                return true;
            }
            case '\n': 
            case '\r': {
                if (this.autoIndent) {
                    int n14;
                    int n15;
                    int n16;
                    char[] cArray = this.textarea.getText().toCharArray();
                    int n17 = this.textarea.getCaretPosition() - 1;
                    int n18 = this.calcSpaceCount(n17, cArray);
                    for (n16 = n17; n16 >= 0 && Character.isWhitespace(cArray[n16]); --n16) {
                    }
                    if (n16 != -1 && cArray[n16] == '{') {
                        n18 = this.calcSpaceCount(n16, cArray);
                        n18 += this.tabSize;
                    }
                    int n19 = 0;
                    for (n15 = n17 + 1; n15 < cArray.length && cArray[n15] == ' '; ++n15) {
                        ++n19;
                    }
                    int n20 = 0;
                    while (n15 < cArray.length && cArray[n15] != '\n') {
                        if (cArray[n15] == '}') {
                            ++n20;
                        }
                        ++n15;
                    }
                    if ((n18 -= n19) < 0) {
                        this.textarea.setSelectionEnd(this.textarea.getSelectionStop() - n18);
                        this.textarea.setSelectedText("\n");
                    } else {
                        String string = "\n" + "                                                                                                                                                                                                               ".substring(0, n18);
                        this.textarea.setSelectedText(string);
                    }
                    if (n20 > 0 && (n14 = this.textarea.getSelectionStart()) - this.tabSize >= 0) {
                        this.textarea.select(n14 - this.tabSize, n14);
                        String string = "                                                                                                                                                                                                               ".substring(0, this.tabSize);
                        if (this.textarea.getSelectedText().equals(string)) {
                            this.textarea.setSelectedText("");
                        } else {
                            this.textarea.select(n14, n14);
                        }
                    }
                } else {
                    this.textarea.setSelectedText(String.valueOf(c));
                }
                keyEvent.consume();
                return true;
            }
            case '}': {
                int n21;
                if (!this.autoIndent) break;
                if (this.textarea.getSelectionStart() != this.textarea.getSelectionStop()) {
                    this.textarea.setSelectedText("");
                }
                char[] cArray = this.textarea.getText().toCharArray();
                int n22 = n21 = this.textarea.getCaretPosition() - 1;
                boolean bl = false;
                while (n22 != -1 && !bl) {
                    if (cArray[n22] == '\n') {
                        bl = true;
                        ++n22;
                        continue;
                    }
                    if (cArray[n22] != ' ') {
                        return false;
                    }
                    --n22;
                }
                if (!bl) {
                    return false;
                }
                int n23 = n22;
                int n24 = this.calcBraceIndent(n21, cArray);
                if (n24 == -1) {
                    return false;
                }
                this.textarea.setSelectionStart(n23);
                this.textarea.setSelectedText("                                                                                                                                                                                                               ".substring(0, n24));
                keyEvent.consume();
                return true;
            }
        }
        return false;
    }

    public boolean keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if ((keyEvent.getModifiers() & 2) != 0 && c == ',') {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    protected int calcLineStart(int n, char[] cArray) {
        boolean bl = false;
        while (n != -1 && !bl) {
            if (cArray[n] == '\n' || cArray[n] == '\r') {
                bl = true;
                continue;
            }
            --n;
        }
        return n + 1;
    }

    protected int calcSpaceCount(int n, char[] cArray) {
        n = this.calcLineStart(n, cArray);
        int n2 = 0;
        while (n < cArray.length && n >= 0 && cArray[n++] == ' ') {
            ++n2;
        }
        return n2;
    }

    protected int calcBraceIndent(int n, char[] cArray) {
        int n2 = 1;
        boolean bl = false;
        while (n != -1 && !bl) {
            if (cArray[n] == '}') {
                ++n2;
                --n;
                continue;
            }
            if (cArray[n] == '{') {
                if (--n2 == 0) {
                    bl = true;
                }
                --n;
                continue;
            }
            --n;
        }
        if (!bl) {
            return -1;
        }
        return this.calcSpaceCount(n, cArray);
    }

    protected char[] getCleanedContents() {
        char[] cArray = this.textarea.getText().toCharArray();
        int n = 0;
        while (n < cArray.length - 1) {
            if (cArray[n] == '/' && cArray[n + 1] == '*') {
                cArray[n++] = '\u0000';
                cArray[n++] = '\u0000';
                while (n < cArray.length - 1 && (cArray[n] != '*' || cArray[n + 1] != '/')) {
                    cArray[n++] = '\u0000';
                }
                continue;
            }
            if (cArray[n] != '/' || cArray[n + 1] != '/') continue;
            while (n < cArray.length && cArray[n] != '\n') {
                cArray[n++] = '\u0000';
            }
            if (n == cArray.length) continue;
            ++n;
        }
        return cArray;
    }
}

