/*
 * Decompiled with CFR 0.152.
 */
package processing.app.preproc;

import antlr.collections.AST;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.debug.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdePreprocessor {
    static final int JDK11 = 0;
    static final int JDK13 = 1;
    static final int JDK14 = 2;
    ArrayList<String> programImports;
    public static final int STATIC = 0;
    public static final int ACTIVE = 1;
    public static final int JAVA = 2;
    public static int programType = -1;
    Reader programReader;
    String buildPath;
    public int prototypeCount = 0;
    public int headerCount = 1;
    static String advClassName = "";

    public int firstStatement(String string) {
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        Pattern pattern = null;
        try {
            pattern = perl5Compiler.compile("\\s+|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)|(//.*?$)|(#(?:\\\\\\n|.)*)", 8);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new RuntimeException("Internal error in firstStatement()", malformedPatternException);
        }
        int n = 0;
        while (perl5Matcher.matchesPrefix(patternMatcherInput, pattern)) {
            n = perl5Matcher.getMatch().endOffset(0);
            patternMatcherInput.setCurrentOffset(n);
        }
        return n;
    }

    public String strip(String string) throws MalformedPatternException {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        Pattern pattern = perl5Compiler.compile("('.')|(\"(?:[^\"\\\\]|\\\\.)*\")|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)|(//.*?$)|(^\\s*#.*?$)", 8);
        while (perl5Matcher.contains(string, pattern)) {
            MatchResult matchResult = perl5Matcher.getMatch();
            string = string.substring(0, matchResult.beginOffset(0)) + " " + string.substring(matchResult.endOffset(0));
        }
        return string;
    }

    private String collapseBraces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '{') {
                if (n == 0) {
                    stringBuffer.append(string.substring(n2, i + 1));
                }
                ++n;
            }
            if (string.charAt(i) != '}' || --n != 0) continue;
            n2 = i;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public List prototypes(String string) throws MalformedPatternException {
        string = this.collapseBraces(this.strip(string));
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        Pattern pattern = perl5Compiler.compile("[\\w\\[\\]\\*]+\\s+[\\[\\]\\*\\w\\s]+\\([,\\[\\]\\*\\w\\s]*\\)(?=\\s*\\{)");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (perl5Matcher.contains(patternMatcherInput, pattern)) {
            arrayList.add(perl5Matcher.getMatch().group(0) + ";");
        }
        return arrayList;
    }

    public String write(String string, String string2, String string3, String[] stringArray, Target target) throws Exception {
        Object object;
        Object object2;
        Object object3;
        string = string + "\n";
        Sketch.scrubComments(string);
        if (Preferences.getBoolean("preproc.substitute_unicode")) {
            int n;
            object3 = string.toCharArray();
            int n2 = 0;
            for (n = 0; n < ((char[])object3).length; ++n) {
                if (object3[n] <= '\u007f') continue;
                ++n2;
            }
            if (n2 != 0) {
                n = 0;
                object2 = new char[((char[])object3).length + n2 * 5];
                for (int i = 0; i < ((char[])object3).length; ++i) {
                    if (object3[i] < '\u0080') {
                        object2[n++] = (Pattern)object3[i];
                        continue;
                    }
                    if (object3[i] == '\u00a0') {
                        object2[n++] = (Pattern)32;
                        continue;
                    }
                    char c = object3[i];
                    object2[n++] = (Pattern)92;
                    object2[n++] = (Pattern)117;
                    object = Integer.toHexString(c).toCharArray();
                    for (int j = 0; j < 4 - ((char[])object).length; ++j) {
                        object2[n++] = (Pattern)48;
                    }
                    System.arraycopy(object, 0, object2, n, ((char[])object).length);
                    n += ((char[])object).length;
                }
                string = new String((char[])object2, 0, n);
            }
        }
        object3 = new Perl5Matcher();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        String string4 = "^\\s*#include\\s+[<\"](\\S+)[\">]";
        this.programImports = new ArrayList();
        object2 = null;
        try {
            object2 = perl5Compiler.compile(string4);
        }
        catch (MalformedPatternException malformedPatternException) {
            malformedPatternException.printStackTrace();
            return null;
        }
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        while (object3.contains(patternMatcherInput, object2)) {
            this.programImports.add(object3.getMatch().group(1));
        }
        this.programReader = new StringReader(string);
        this.buildPath = string2;
        List list = this.prototypes(string);
        this.prototypeCount = list.size();
        if (string3 == null) {
            return null;
        }
        object = new File(string2, string3 + ".cpp");
        PrintStream printStream = new PrintStream(new FileOutputStream((File)object));
        this.writeHeader(printStream);
        this.writeProgram(printStream, string, list);
        this.writeFooter(printStream, target);
        printStream.close();
        return string3;
    }

    void writeProgram(PrintStream printStream, String string, List list) {
        int n = this.firstStatement(string);
        printStream.print(string.substring(0, n));
        printStream.print("#include \"WProgram.h\"\n");
        for (int i = 0; i < list.size(); ++i) {
            printStream.print(list.get(i) + "\n");
        }
        printStream.print(string.substring(n));
    }

    void writeHeader(PrintStream printStream) throws IOException {
    }

    void writeFooter(PrintStream printStream, Target target) throws Exception {
        String string;
        String string2 = target.getPath() + File.separator + "main.cxx";
        FileReader fileReader = null;
        fileReader = new FileReader(string2);
        LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
        while ((string = lineNumberReader.readLine()) != null) {
            printStream.print(string + "\n");
        }
        lineNumberReader.close();
    }

    public ArrayList<String> getExtraImports() {
        return this.programImports;
    }

    String getFirstClassName(AST aST) {
        String string = advClassName;
        advClassName = "";
        return string;
    }
}

