<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/_admin/pages_delete.php - Admin frontend Page Delete */

if(!file_exists('../index.php')) {
        die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your
installation may be corrupt.'); }
define("westgen", true);
include("../index.php");

function delete_files($target, $exceptions, $output=true)
{
	$sourcedir = opendir($target);
	while(false != ($filename = readdir($sourcedir))) {
		if(!in_array($filename, $exceptions)) {
			if($output) {
				echo " Remove <i>" . $filename . "</i><br>\n"; }
			if(is_dir($target . "/" . $filename)) {
				delete_files($target . "/" . $filename, $exceptions); }
			elseif(is_file($target . "/" . $filename)) {
				unlink($target . "/" . $filename); }
		}
	}
	closedir($sourcedir);
	if(rmdir($target)) {
		return true;
	} else {
		return false; }
}

include("thumbnail.inc.php");

include("header_light.php");

echo("<table width=\"100%\" class=\"blend\"><tr><td><b>Delete Files and Directories</b></tr></td></table>\n");

echo("<table width=\"100%\"><tr><td>");

// Check if file is real
if(!file_exists($_GET['file'])) {
	die("<b>Error:</b> File or directory not found or permission was denied! <a href=\"javascript:window.close()\">Close</a>\n"); }
// Is this the first time?
if($_GET['areyousure'] != "Yes") {
	?>
<form method="GET" action="<?=$_SERVER['PHP_SELF']?>">
	Are you sure you want to delete <i><?=basename($_GET['file'])?></i>?<br />
	<input type="hidden" name="file" value="<?=$_GET['file']?>" />
	<input type="hidden" name="mode" value="<?=$_GET['mode']?>" />
	<input type="submit" name="areyousure" value="Yes" />
	<a href="javascript:window.close()">Close</a>
</form>
	<?
} else {
// They are sure!
	// Check if it is a directory we are removing...
	if(is_dir($_GET['file'])) {
		$exceptions = array(".", "..");
		if(delete_files($_GET['file'], $exceptions, true)) {
			echo("Removed directory <i>" . basename($_GET['file']) . "</i> and unlinked files inside it.<br>\n");
		} else {
			echo("<b>Error:</b> Failed while trying to remove directory " . basename($_GET['file']) . "!<br>\n"); }
	}
	// Else it is a file
	elseif (is_file($_GET['file'])) {
		echo("Unlinking <i>" . basename($_GET['file']) . "</i>... ");
		if(!unlink($_GET['file'])) {
			echo("<font color=\"red\">Failure</font><br>\n");
		} else {
			echo("OK<br>\n"); }
		echo("Unlinking <i>" . basename($_GET['file'] . ".title") . "</i>... ");
		if(file_exists($_GET['file'] . ".title")) {
			if(!unlink($_GET['file'] . ".title")) {
				echo("<font color=\"red\">Failure</font><br />\n");
			} else {
				echo("OK<br>\n"); }
		} else {
			echo("Skipped<br>\n");
		}
		if($_GET['mode'] == "pictures") {
			$thumbnail = thumbnail_name($_GET['file']);
			if(file_exists($thumbnail)) {
				echo("Unlinking thumbnail... ");
				if(!unlink($thumbnail)) {
					echo("<font color=\"red\">Failure</font><br />\n");
				} else {
					echo("OK<br />\n");
				}
			} // end thumbnail handling
		} // end pictures mode
	}
	echo("<br><a href=\"javascript:window.close()\">Close</a>\n");
}

?>
</td></tr></table><?

include("footer_light.php");

?>