<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/_admin/pages_duplicate.php - Admin frontend Page Duplicate */

if(!file_exists('../index.php')) {
        die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your
installation may be corrupt.'); }
define("westgen", true);
include("../index.php");

include("header_light.php");

function dircopy($basePath, $source, $dest, $overwrite = false) {
	if(!is_dir($basePath . $dest))
	mkdir($basePath . $dest);
	if($handle = opendir($basePath . $source)) {
		while(false != ($file = readdir($handle))) {
			if($file != '.' && $file != '..') {
				$path = $source . '/' . $file;
				if(is_file($basePath . $path)) {
					if(!is_file($basePath . $dest . '/' . $file) || $overwrite)
						if(!@copy($basePath . $path, $basePath . $dest . '/' . $file)) {
							echo '<font color="red">File ('.$path.') could not be copied, likely a permission problem.</font>';
						}
				} elseif(is_dir($basePath . $path)) {
					if(!is_dir($basePath . $dest . '/' . $file))
						mkdir($basePath . $dest . '/' . $file);
						dircopy($basePath, $path, $dest . '/' . $file, $overwrite);
				}
			}
		}
	closedir($handle);
	}
}

echo("<table width=\"100%\" class=\"blend\"><tr><td><b>Duplicate Files and Directories</b></tr></td></table>\n");

echo("<table width=\"100%\"><tr><td>");

// Check if file is real
if(!file_exists($_GET['file'])) {
	die("<b>Error:</b> File or directory not found or permission was denied! <a href=\"javascript:window.close()\">Close</a>\n"); }

$dirname = dirname($_GET['file']) . "/";
// Is it dir?
if(is_dir($_GET['file'])) {
	echo("Duplicating directory <i>" . basename($_GET['file']) ."</i>... ");
	$number = 1;
	// Pick a new name
	while(file_exists($_GET['file'] . "_" . $number)) {
		if($number > 999) {
			die("<font color=\"red\">Counter error</font><br><a href=\"javascript:window.close()\">Close</a>\n"); }
		$number++;
	}
	$full_newname = $_GET['file'] . "_" . $number;
	dircopy($dirname, basename($_GET['file']), basename($full_newname));
	if(!is_dir($full_newname)) {
		echo("<font color=\"red\">Failure</font><br>\n");
	} else {
		echo("OK<br>\n"); }
	echo("<br><a href=\"javascript:window.close()\">Close</a>\n");
} else {
// Or it is a file.
	echo("Duplicating file <i>" . basename($_GET['file']) . "</i>... ");
	$file_info = pathinfo($_GET['file']);
	$ext = "." . $file_info['extension'];
	$barename = basename(basename($_GET['file']), $ext);
	$number = 1;
	// Pick a new name
	while(file_exists($dirname . $barename . "_" . $number . $ext)) {
		if($number > 999) {
			die("<font color=\"red\">Counter error</font><br><a href=\"javascript:window.close()\">Close</a>\n"); }
		$number++;
	}
	$full_newname = $dirname . $barename . "_" . $number . $ext;
	// Copy file
	if(!copy($_GET['file'], $full_newname)) {
		die("<font color=\"red\">Copy error</font><br><a href=\"javascript:window.close()\">Close</a>\n");
	} else {
		echo("OK<br>\n"); }
	// Copy title
	echo("Duplicating file <i>" . basename($_GET['file']) . ".title</i>... ");
	if(file_exists($_GET['file'] . ".title")) {
		if(!copy($_GET['file'] . ".title", $full_newname . ".title")) {
			die("<font color=\"red\">Copy error</font><br><a href=\"javascript:window.close()\">Close</a>\n");
			} else {
				echo("OK<br>\n"); }
	} else {
		echo("Skipped<br>\n");
	}
	// Copy thumbnail (if we're in pictures mode)
	if($_GET['mode'] == "pictures") {
		// Generate filename
		$thumb_newname = $dirname . "thumb-" . $barename . "_" . $number . $ext;
		$thumb_oldname = $dirname . "thumb-" . $barename . $ext;
		if(file_exists($thumb_oldname)) {
			echo("Copying thumbnail... ");
			if(!copy($thumb_oldname, $thumb_newname)) {
				echo ("<font color=\"red\">Copy error</font><br />\n");
			} else {
					echo("OK<br />\n");
			}
		} // end thumbnail handling
	} // end pictures mode
	echo("<br><a href=\"javascript:window.close()\">Close</a>\n");
}

?>
</td></tr></table><?

include("footer_light.php");

?>