<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/_admin/thumbnail.inc.php - Functions for generating image thumbnails */

// Uses ImageMagick 'convert' to generate a 200*150 (max) thumbnail ("thumb-img.jpg" for "img.jpg") in same directory when given full path
// This will overwrite any already-existing thumbnail
// Returns true on success and false on failure
function thumbnail($image) {
	// Is this a real file?
	if(!file_exists($image)) {
		return false;
	}
	// Look around for ImageMagick's 'convert' utility...
	$im_convert_path = find_convert();
	if($im_convert_path == FALSE) {
		return false;
	}
	// What shall we call the thumbnail?
	$thumbnail = thumbnail_name($image);
	// Call ImageMagick now to build the thumbnail
	system($im_convert_path . " '" . $image . "' -resize 200x150 '" . $thumbnail . "'");
	// Check if the thumbnail is real now and finish
	if(!file_exists($thumbnail)) {
		return false;
	} else {
		return true;
	}
}

// Uses ImageMagick 'convert' to rotate an image 90 degrees in the given direction
// Retuns true on success and false on failure
function rotate($direction, $image) {
	// Is this a real file?
	if(!file_exists($image)) {
		return false;
	}
	// Left or right?
	if($direction == "right") {
		$rotate = " -rotate 90 ";
	} elseif ($direction == "left") {
		$rotate = " -rotate 270 ";
	} else {
		// Invalid direction
		return false;
	}
	// Look around for ImageMagick's 'convert' utility...
	$im_convert_path = find_convert();
	if($im_convert_path == FALSE) {
		return false;
	}
	// Call ImageMagick now to rotate the image
	system($im_convert_path . $rotate . "'" . $image . "' '" . $image . "'");
	// Check if the image is still real and exit
	if(!file_exists($image)) {
		return false;
	} else {
		return true;
	}
}

// Searches common locations for the path to ImageMagick's 'convert' utility
// Retuns string on success, false on failure
function find_convert() {
	if($_GET['im_convert_path'] != "" || $_POST['im_convert_path'] != "") {
		// Do not allow outside variables to possibly contaminate our path
		$im_convert_path = "";
	}
	if($im_convert_path == "") {
		// Check typical locations
		if(file_exists("/usr/bin/convert")) {
			return("/usr/bin/convert");
		} elseif (file_exists("/usr/local/bin/convert")) {
			return("/usr/local/bin/convert");
		} elseif (file_exists("/sw/bin/convert")) {
			return("/sw/bin/convert");
		}
	} elseif (file_exists($im_convert_path)) {
		// The user gave us a valid path
		return $im_convert_path;
	} else {
		// Otherwise the user didn't give us a valid path
		return false;
	}
}

// Returns a path with the filename prepended "thumb-" for use in thumbnail()
function thumbnail_name($image) {
	$file = basename($image);
	$directory = substr($image, 0, (0-strlen($file)));
	return($directory. "thumb-" . $file);
}

?>