<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/_admin/upload.php - Admin frontend Upload Files */

if(!file_exists('../index.php')) {
        die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your
installation may be corrupt.'); }
define("westgen", true);
include("../index.php");

include("header_light.php");

echo("<table width=\"100%\" class=\"blend\"><tr><td><b>Upload Files</b></tr></td></table>\n");

echo("<table width=\"100%\"><tr><td>");

// Verify that our mode is valid
if($_GET['mode'] != "") {
	$theMode = $_GET['mode'];
} elseif ($_POST['mode'] != "") {
	$theMode = $_POST['mode'];
}
if($theMode != "content" && $theMode != "audio" && $theMode != "embed" && $theMode != "pictures") {
	die("<b>Fatal error:</b> Invalid mode selected."); }

// Make necessary includes
include("thumbnail.inc.php");

// Get the subdir
if($_GET['subdir'] != "") {
	$theSubdir = $_GET['subdir'];
} elseif ($_POST['subdir'] != "") {
	$theSubdir = $_POST['subdir'];
}

// Verify that the directory has no invalid characters
// If not, set $dir to the full path
if(strstr($theSubdir, '..') != "") {
        die('<b>Fatal error:</b> Directory name can not have ".." in it.'); }
if($theSubdir != "") {
	$dir = $wg_phtml . "/" . $theMode . "/" . $theSubdir . "/";
} else {
	$dir = $wg_phtml . "/" . $theMode . "/"; }

if($_POST['next'] != "yes") {
	if($theSubdir != "") {
		echo("Upload files to: <i>" . $theSubdir . "</i>\n");
	} else {
		echo("Upload files to: <i>/</i>\n");
	}
	// Determine the max filesize supported based on global php settings
	$maxsize = ini_get('upload_max_filesize');
	if (!is_numeric($maxsize)) {
	   if (strpos($maxsize, 'M') !== false)
	       $maxsize = intval($maxsize)*1024*1024;
	   elseif (strpos($maxsize, 'K') !== false)
	       $maxsize = intval($maxsize)*1024;
	   elseif (strpos($maxsize, 'G') !== false)
	       $maxsize = intval($maxsize)*1024*1024*1024;
	}
	// Display the upload dialog
	echo('<form enctype="multipart/form-data" action="' . $_SERVER['PHP_SELF'] .'" method="POST">
	<input type="hidden" name="MAX_FILE_SIZE" value="'. $maxsize .'" />
	Path: <input name="userfile" type="file" /><br />
	Title: <input name="title" type="text" /><br />
	<input type="hidden" name="next" value="yes" />
	<input type="hidden" name="mode" value="' . $theMode . '" />
	<input type="hidden" name="subdir" value="' . $theSubdir . '" />
	<input type="submit" value="Upload" />
	</form>');
} else {
	// Looks like we've got ourselves some files!
	echo("Processing uploaded data... ");
	$newPath = $dir . basename($_FILES['userfile']['name']);
	$file_info = pathinfo(basename($_FILES['userfile']['name']));
	$ext = $file_info['extension'];
	$thumbStrPos = strpos(basename($_FILES['userfile']['name']), 'thumb-');
	if(($theMode == "pictures") && ($ext == "jpg" || $ext == "jpeg" || $ext == "gif" || $ext == "bmp" || $ext == "png" || $ext == "JPG" || $ext == "JPEG" || $ext == "GIF" || $ext == "BMP" || $ext == "PNG") && ($file != "_prepend.php" && $file != "_append.php" && $file != ".." && $file != "." && $ext != "title") && ($thumbStrPos != 0 || $thumbStrPos === FALSE)) {
		// File doesn't already exist...
		if(!file_exists($newPath)) {
			// Move the uploaded file
			if(move_uploaded_file($_FILES['userfile']['tmp_name'], $newPath)) {
				echo ("OK");
			} else {
				echo ("<font color=\"red\">Failure</font>");
			}
			echo ("<br />\n");
			// create title stub
			echo ("Creating title descriptor... ");
			if(!$handle = fopen($newPath . ".title", 'w')) {
				echo("<font color=\"red\">Failure</font><br />\n<b>Error:</b> <i>" . basename($newPath) . ".title </i> could not be created!");
			} else {
				// Write title descriptor if not left blank
				if($_POST['title'] != "") {
					if(fwrite($handle, htmlspecialchars($_POST['title'])) == FALSE) {
						echo("<font color=\"red\">Failure</font><br />\n<b>Error:</b> <i>" . basename($newPath) . ".title </i> could not be opened for writing!");
					} else {
						echo ("OK");
					} // end fwrite
				} else {
					echo ("None specified");
				}
				fclose($handle);
				echo ("<br />\n");
				// Generate thumbnail if we are in the "pictures" mode
				if ($theMode == "pictures") {
					echo ("Generating thumbnail... ");
					if(thumbnail($newPath)) {
						echo ("OK");
					} else {
						echo ("<font color=\"red\">Failure</font>");
					}
				} // end thumbnail clause
			} // end title descriptor creation
		} else {
			// Same filename present
			echo ("<font color=\"red\">Failure</font><br />\nSame filename already present.<br />\n");
		} // end exist check
	} else {
		echo("<font color=\"red\">Failure</font><br />\n<b>Error:</b> Invalid filetype (supports only JPG, JPEG, GIF, BMP, PNG).");
	} // end filetype check
	echo("<br />\n");
}

?>
<a href="javascript:window.close()">Close</a>
</td></tr></table><?

include("footer_light.php");

?>