<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/$wg_theme/$page_layout/gallery.php - Theme/layout Gallery file */

// Make sure we are being loaded properly, and if so, define our style
if($page_layout != 'gallery') {
	die($page_layout . ' layout should not load this file!'); }

// Open directory
if($handle = opendir($selected_file)) {
	// Should be first make a back button?
	if($_GET['showback'] == "yes") {
		echo('<a href="javascript:history.back(1)" title="Go back">Go back</a>' . "\n");
	}
	while(false !== ($file = readdir($handle))) {
		// Is this a file or folder?
		if(is_dir($selected_file . '/' . $file)) {
			if($file != ".." && $file != ".") {
				// It is a sub-gallery, so build our link
				$file_link = $wg_public . '/pictures.php/' . $_SERVER['PATH_INFO'] . '/' . $file;
				// Now determine the title
				if(file_exists($wg_phtml . '/' . $selected_file . '/' . $file . '/.dir.title')) {
					$file_title = stripslashes(file_get_contents($wg_phtml . '/' . $selected_file . '/' . $file . '/.dir.title'));
				} else {
					$file_title = $file;
				}
				// Draw it to the screen
				echo('<a href="' . $file_link . '?showback=yes" title="' . $file_title . '">' . $file_title . '</a>' . "\n");
			}
		} else {
			// Check if the selected file has a valid type
			$ext = pathinfo($file);
			$ext = $ext['extension'];
			if($ext == "jpg" || $ext == "jpeg" || $ext == "gif" || $ext == "bmp" || $ext == "png" || $ext == "JPG" || $ext == "JPEG" || $ext == "GIF" || $ext == "BMP" || $ext == "PNG") {
				// Filter out files that begin with 'thumb-'
				$thumbStrPos = strpos($file, 'thumb-');
				if($thumbStrPos != 0 || $thumbStrPos === FALSE) {
					// Concatenate the locations of the image
					$file_path = $wg_phtml . '/' . $selected_file . '/' . $file;
					$file_url = $wg_public . '/' . $selected_file . '/' . $file;
					$thumb_url = $wg_public . '/' . $selected_file . '/thumb-' . $file;
					// Grab any user-defined title, otherwise show the filename
					if(file_exists($file_path . '.title')) {
						$file_title = stripslashes(file_get_contents($file_path . '.title'));
					} else {
						$file_title = basename($file_path, '.' . $ext);
					}
					// Draw it to the screen
					echo('<a href="' . $file_url . '" title="' . $file_title . '" rel="lightbox[gallery]"><img src="' . $thumb_url . '" alt="' . $file_title . '" /></a>' . "\n");					
				} // End thumbnail check
			} // End extension check
		} // End file/folder switch
	} // End loop
	closedir($handle);
} // End open dir

?>