/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.conv;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import junit.framework.TestCase;
import org.x4o.xml.conv.DefaultObjectConverterProvider;
import org.x4o.xml.conv.ObjectConverter;
import org.x4o.xml.conv.ObjectConverterException;
import org.x4o.xml.conv.text.ClassConverter;
import org.x4o.xml.conv.text.EnumConverter;
import org.x4o.xml.conv.text.URLConverter;
import org.x4o.xml.lang.phase.X4OPhaseType;

public class DefaultObjectConverterProviderTest
extends TestCase {
    Locale locale = Locale.getDefault();

    public void testConverterClone() throws Exception {
        DefaultObjectConverterProvider p = new DefaultObjectConverterProvider(true);
        for (ObjectConverter conv : p.getObjectConverters()) {
            DefaultObjectConverterProviderTest.assertNotNull((Object)conv);
            ObjectConverter clone = conv.clone();
            DefaultObjectConverterProviderTest.assertNotNull((Object)clone);
        }
    }

    public void testConverterBoolean() throws Exception {
        DefaultObjectConverterProvider p = new DefaultObjectConverterProvider(true);
        ObjectConverter conv = p.getObjectConverterForClass(Boolean.class);
        DefaultObjectConverterProviderTest.assertNotNull((Object)conv);
        Object result = conv.convertTo((Object)"true", this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)result);
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not Boolean.class", Boolean.class, result.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not true", (Object)true, (Object)result);
        Object resultBack = conv.convertBack(result, this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)resultBack);
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not String.class", String.class, resultBack.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not true", (Object)"true", (Object)resultBack);
    }

    public void testConverterInteger() throws Exception {
        DefaultObjectConverterProvider p = new DefaultObjectConverterProvider(true);
        ObjectConverter conv = p.getObjectConverterForClass(Integer.class);
        DefaultObjectConverterProviderTest.assertNotNull((Object)conv);
        Object result = conv.convertTo((Object)"123", this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)result);
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not Integer.class", Integer.class, result.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not 123", (Object)123, (Object)result);
        Object resultBack = conv.convertBack(result, this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)resultBack);
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not String.class", String.class, resultBack.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not 123", (Object)"123", (Object)resultBack);
    }

    public void testConverterFloat() throws Exception {
        DefaultObjectConverterProvider p = new DefaultObjectConverterProvider(true);
        ObjectConverter conv = p.getObjectConverterForClass(Float.class);
        DefaultObjectConverterProviderTest.assertNotNull((Object)conv);
        Object result = conv.convertTo((Object)"123.23", this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)result);
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not Float.class", Float.class, result.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not 123.23", (Object)Float.valueOf(123.23f), (Object)result);
        Object resultBack = conv.convertBack(result, this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)resultBack);
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not String.class", String.class, resultBack.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not 123.23", (Object)"123.23", (Object)resultBack);
    }

    public void testConverterLong() throws Exception {
        DefaultObjectConverterProvider p = new DefaultObjectConverterProvider(true);
        ObjectConverter conv = p.getObjectConverterForClass(Long.class);
        DefaultObjectConverterProviderTest.assertNotNull((Object)conv);
        Object result = conv.convertTo((Object)"12323", this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)result);
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not Long.class", Long.class, result.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not 12323", (Object)12323L, (Object)result);
        Object resultBack = conv.convertBack(result, this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)resultBack);
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not String.class", String.class, resultBack.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not 12323", (Object)"12323", (Object)resultBack);
    }

    public void testConverterDouble() throws Exception {
        DefaultObjectConverterProvider p = new DefaultObjectConverterProvider(true);
        ObjectConverter conv = p.getObjectConverterForClass(Double.class);
        DefaultObjectConverterProviderTest.assertNotNull((Object)conv);
        Object result = conv.convertTo((Object)"1232.3", this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)result);
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not Double.class", Double.class, result.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not 1232.3", (Object)1232.3, (Object)result);
        Object resultBack = conv.convertBack(result, this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)resultBack);
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not String.class", String.class, resultBack.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not 1232.3", (Object)"1232.3", (Object)resultBack);
    }

    public void testConverterUrl() throws Exception {
        DefaultObjectConverterProvider p = new DefaultObjectConverterProvider(true);
        ObjectConverter conv = p.getObjectConverterForClass(URL.class);
        DefaultObjectConverterProviderTest.assertNotNull((Object)conv);
        Object result = conv.convertTo((Object)"http://www.x4o.org", this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)result);
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not Url.class", URL.class, result.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"Result is not http://www.x4o.org", (Object)new URL("http://www.x4o.org"), (Object)result);
        Object resultBack = conv.convertBack(result, this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)resultBack);
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not String.class", String.class, resultBack.getClass());
        DefaultObjectConverterProviderTest.assertEquals((String)"resultBack is not http://www.x4o.org", (Object)"http://www.x4o.org", (Object)resultBack);
    }

    public void testConverterUrlException() throws Exception {
        URLConverter conv = new URLConverter();
        Exception e = null;
        try {
            conv.convertStringTo("error2::s/sdf//sd!@#$%#", this.locale);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        DefaultObjectConverterProviderTest.assertNotNull((Object)e);
        DefaultObjectConverterProviderTest.assertNotNull((Object)e.getCause());
        DefaultObjectConverterProviderTest.assertEquals(ObjectConverterException.class, e.getClass());
        DefaultObjectConverterProviderTest.assertEquals(MalformedURLException.class, e.getCause().getClass());
        DefaultObjectConverterProviderTest.assertTrue((String)"Error message string is missing error", (boolean)e.getMessage().contains("error"));
    }

    public void testConverterEnum() throws Exception {
        EnumConverter convOrg = new EnumConverter();
        convOrg.setEnumClass(X4OPhaseType.class.getName());
        ObjectConverter conv = convOrg.clone();
        Object result = conv.convertTo((Object)"XML_READ", this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)result);
        DefaultObjectConverterProviderTest.assertEquals((String)"XML_READ", (String)result.toString());
        Object resultBack = conv.convertBack(result, this.locale);
        DefaultObjectConverterProviderTest.assertEquals((String)"XML_READ", (String)resultBack.toString());
    }

    public void testConverterEnumError() throws Exception {
        EnumConverter convOrg = new EnumConverter();
        convOrg.setEnumClass(X4OPhaseType.class.getName());
        ObjectConverter conv = convOrg.clone();
        Exception e = null;
        try {
            conv.convertTo((Object)"nonEnumError", this.locale);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        DefaultObjectConverterProviderTest.assertNotNull((Object)e);
        DefaultObjectConverterProviderTest.assertEquals(ObjectConverterException.class, e.getClass());
        DefaultObjectConverterProviderTest.assertTrue((boolean)e.getMessage().contains("EnumError"));
    }

    public void testConverterEnumNullError() throws Exception {
        EnumConverter conv = new EnumConverter();
        Exception e = null;
        try {
            conv.convertTo((Object)"nonEnumError", this.locale);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        DefaultObjectConverterProviderTest.assertNotNull((Object)e);
        DefaultObjectConverterProviderTest.assertEquals(ObjectConverterException.class, e.getClass());
        DefaultObjectConverterProviderTest.assertTrue((boolean)e.getMessage().contains("enumClass"));
    }

    public void testConverterClass() throws Exception {
        ClassConverter classOrg = new ClassConverter();
        ObjectConverter conv = classOrg.clone();
        Object result = conv.convertTo((Object)"java.lang.Object", this.locale);
        DefaultObjectConverterProviderTest.assertNotNull((Object)result);
        DefaultObjectConverterProviderTest.assertEquals(Object.class, (Object)result);
        Object resultBack = conv.convertBack(result, this.locale);
        DefaultObjectConverterProviderTest.assertEquals((String)"java.lang.Object", (String)resultBack.toString());
    }

    public void testConverterClassError() throws Exception {
        ClassConverter classOrg = new ClassConverter();
        ObjectConverter conv = classOrg.clone();
        Exception e = null;
        try {
            conv.convertTo((Object)"java.lang.ObjectError", this.locale);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        DefaultObjectConverterProviderTest.assertNotNull((Object)e);
        DefaultObjectConverterProviderTest.assertEquals(ObjectConverterException.class, e.getClass());
        DefaultObjectConverterProviderTest.assertTrue((boolean)e.getMessage().contains("ObjectError"));
    }
}

