/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.core;

import java.io.IOException;
import junit.framework.TestCase;
import org.x4o.xml.eld.CelDriver;
import org.x4o.xml.io.sax.X4OEntityResolver;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.x4o.xml.test.TestDriver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class X4OEntityResolverTest
extends TestCase {
    public void testElementLangugeNull() throws Exception {
        Exception e = null;
        try {
            new X4OEntityResolver(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OEntityResolverTest.assertNotNull((Object)e);
        X4OEntityResolverTest.assertEquals(NullPointerException.class, e.getClass());
        X4OEntityResolverTest.assertTrue((boolean)e.getMessage().contains("null"));
    }

    public void testResolve() throws Exception {
        CelDriver driver = new CelDriver();
        X4OEntityResolver resolver = new X4OEntityResolver(driver.createLanguageContext());
        InputSource input = resolver.resolveEntity("", "http://cel.x4o.org/xml/ns/cel-root-1.0.xsd");
        X4OEntityResolverTest.assertNotNull((Object)input);
    }

    public void testResolveMissing() throws Exception {
        TestDriver driver = new TestDriver();
        X4OEntityResolver resolver = new X4OEntityResolver(driver.createLanguageContext());
        Exception e = null;
        try {
            resolver.resolveEntity("", "http://cel.x4o.org/xml/ns/cel-root-1.0.xsd-missing-resource");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OEntityResolverTest.assertNotNull((Object)e);
        X4OEntityResolverTest.assertEquals(SAXException.class, e.getClass());
        X4OEntityResolverTest.assertTrue((boolean)e.getMessage().contains("missing-resource"));
    }

    public void testResolveProperty() throws Exception {
        TestDriver driver = new TestDriver();
        X4OLanguageContext language = driver.createLanguageContext();
        language.setLanguageProperty(X4OLanguageProperty.READER_ENTITY_RESOLVER, (Object)new TestEntityResolver());
        X4OEntityResolver resolver = new X4OEntityResolver(language);
        Exception e = null;
        InputSource input = null;
        try {
            input = resolver.resolveEntity("", "http://cel.x4o.org/xml/ns/cel-root-1.0.xsd");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OEntityResolverTest.assertNull((Object)e);
        X4OEntityResolverTest.assertNotNull((Object)input);
    }

    public void testResolvePropertyNull() throws Exception {
        TestDriver driver = new TestDriver();
        X4OLanguageContext language = driver.createLanguageContext();
        language.setLanguageProperty(X4OLanguageProperty.READER_ENTITY_RESOLVER, (Object)new TestEntityResolver());
        X4OEntityResolver resolver = new X4OEntityResolver(language);
        Exception e = null;
        try {
            resolver.resolveEntity("", "http://cel.x4o.org/xml/ns/cel-root-1.0.xsd-null");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OEntityResolverTest.assertNotNull((Object)e);
        X4OEntityResolverTest.assertEquals(SAXException.class, e.getClass());
        X4OEntityResolverTest.assertTrue((boolean)e.getMessage().contains("null"));
    }

    public class TestEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.contains("null")) {
                return null;
            }
            return new InputSource();
        }
    }
}

