/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.conv.text;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.x4o.xml.conv.AbstractStringObjectConverter;
import org.x4o.xml.conv.ObjectConverter;
import org.x4o.xml.conv.ObjectConverterException;
import org.x4o.xml.conv.text.StringSplitConverterStep;
import org.x4o.xml.lang.X4OLanguageClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSplitConverter
extends AbstractStringObjectConverter {
    private static final long serialVersionUID = 418588893457634317L;
    private Class<?> classTo = null;
    private String split = null;
    private Integer splitSize = null;
    private String singleToMethod = null;
    private Boolean useNativeType = null;
    private List<StringSplitConverterStep> stringSplitConverterSteps = new ArrayList<StringSplitConverterStep>(10);

    @Override
    public Class<?> getObjectClassTo() {
        return this.classTo;
    }

    @Override
    public Object convertStringTo(String str, Locale locale) throws ObjectConverterException {
        if (this.split == null) {
            throw new ObjectConverterException(this, "split is not set.");
        }
        if (this.splitSize == null) {
            throw new ObjectConverterException(this, "splitSize is not set.");
        }
        if (this.classTo == null) {
            throw new ObjectConverterException(this, "classTo is not set.");
        }
        String[] strSplit = str.split(this.split);
        if (strSplit.length != this.splitSize) {
            throw new ObjectConverterException(this, "Split size is wrong; " + strSplit.length + " need: " + this.splitSize);
        }
        List<StringSplitConverterStep> steps = this.getOrderedSteps(true);
        if (steps.size() != this.splitSize.intValue()) {
            throw new ObjectConverterException(this, "Step size is wrong; " + steps.size() + " need: " + this.splitSize);
        }
        try {
            Object[] singleMethodValues = new Object[this.splitSize.intValue()];
            Object object = X4OLanguageClassLoader.newInstance(this.classTo);
            for (int i = 0; i < steps.size(); ++i) {
                StringSplitConverterStep step = steps.get(i);
                String stepObject = strSplit[i];
                Object stepValue = step.getObjectConverter().convertTo(stepObject, locale);
                if (this.singleToMethod == null) {
                    Method m = this.classTo.getMethod(step.getToMethod(), stepValue.getClass());
                    m.invoke(object, stepValue);
                    continue;
                }
                singleMethodValues[i] = stepValue;
            }
            if (this.singleToMethod != null) {
                List<Class> arguClass = new ArrayList<Class>(singleMethodValues.length);
                for (int i = 0; i < singleMethodValues.length; ++i) {
                    arguClass.add(singleMethodValues[i].getClass());
                }
                if (this.useNativeType != null && this.useNativeType.booleanValue()) {
                    arguClass = this.convertToNative(arguClass);
                }
                Class[] arguArray = new Class[arguClass.size()];
                arguArray = arguClass.toArray(arguArray);
                Method m = this.classTo.getMethod(this.singleToMethod, arguArray);
                ArrayList<Object> arguValue = new ArrayList<Object>(singleMethodValues.length);
                for (int i = 0; i < singleMethodValues.length; ++i) {
                    arguValue.add(singleMethodValues[i]);
                }
                Object[] valueArray = new Object[arguValue.size()];
                valueArray = arguValue.toArray(valueArray);
                m.invoke(object, valueArray);
            }
            return object;
        }
        catch (Exception e) {
            throw new ObjectConverterException(this, e.getMessage(), e);
        }
    }

    @Override
    public String convertStringBack(Object object, Locale locale) throws ObjectConverterException {
        List<StringSplitConverterStep> steps = this.getOrderedSteps(false);
        if (steps.size() != this.splitSize.intValue()) {
            throw new ObjectConverterException(this, "Step size is wrong; " + steps.size() + " need: " + this.splitSize);
        }
        try {
            StringBuffer buf = new StringBuffer(200);
            for (int i = 0; i < steps.size(); ++i) {
                StringSplitConverterStep step = steps.get(i);
                Method m = this.classTo.getMethod(step.getFromMethod(), new Class[0]);
                Object stepValue = m.invoke(object, new Object[0]);
                Object stepString = step.getObjectConverter().convertBack(stepValue, locale);
                buf.append(stepString.toString());
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new ObjectConverterException(this, e.getMessage(), e);
        }
    }

    @Override
    public ObjectConverter clone() throws CloneNotSupportedException {
        StringSplitConverter result = new StringSplitConverter();
        result.converters = this.cloneConverters();
        return result;
    }

    private List<StringSplitConverterStep> getOrderedSteps(boolean isTo) {
        ArrayList<StringSplitConverterStep> result = new ArrayList<StringSplitConverterStep>(this.stringSplitConverterSteps.size());
        result.addAll(this.stringSplitConverterSteps);
        Collections.sort(this.stringSplitConverterSteps, new StringSplitConverterStepComparator(isTo));
        return result;
    }

    private List<Class> convertToNative(List<Class> types) throws ObjectConverterException {
        ArrayList<Class> result = new ArrayList<Class>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            Class clazz = types.get(i);
            if (clazz.isAssignableFrom(Integer.class)) {
                result.add(Integer.TYPE);
                continue;
            }
            if (clazz.isAssignableFrom(Long.class)) {
                result.add(Long.TYPE);
                continue;
            }
            if (clazz.isAssignableFrom(Float.class)) {
                result.add(Float.TYPE);
                continue;
            }
            if (clazz.isAssignableFrom(Double.class)) {
                result.add(Double.TYPE);
                continue;
            }
            if (clazz.isAssignableFrom(Boolean.class)) {
                result.add(Boolean.TYPE);
                continue;
            }
            throw new ObjectConverterException(this, "Can't convert type to native; " + clazz);
        }
        return result;
    }

    public Class<?> getClassTo() {
        return this.classTo;
    }

    public void setClassTo(Class<?> classTo) {
        this.classTo = classTo;
    }

    public String getSplit() {
        return this.split;
    }

    public void setSplit(String split) {
        this.split = split;
    }

    public Integer getSplitSize() {
        return this.splitSize;
    }

    public void setSplitSize(Integer splitSize) {
        this.splitSize = splitSize;
    }

    public String getSingleToMethod() {
        return this.singleToMethod;
    }

    public void setSingleToMethod(String singleToMethod) {
        this.singleToMethod = singleToMethod;
    }

    public Boolean getUseNativeType() {
        return this.useNativeType;
    }

    public void setUseNativeType(Boolean useNativeType) {
        this.useNativeType = useNativeType;
    }

    public void addStringSplitConverterStep(StringSplitConverterStep stringSplitConverterStep) {
        this.stringSplitConverterSteps.add(stringSplitConverterStep);
    }

    public void removeStringSplitConverterStep(StringSplitConverterStep stringSplitConverterStep) {
        this.stringSplitConverterSteps.remove(stringSplitConverterStep);
    }

    public List<StringSplitConverterStep> getStringSplitConverterSteps() {
        return this.stringSplitConverterSteps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StringSplitConverterStepComparator
    implements Comparator<StringSplitConverterStep> {
        boolean isTo = true;

        public StringSplitConverterStepComparator(boolean isTo) {
            this.isTo = isTo;
        }

        @Override
        public int compare(StringSplitConverterStep e1, StringSplitConverterStep e2) {
            if (this.isTo) {
                return e1.getToOrder().compareTo(e2.getToOrder());
            }
            return e1.getFromOrder().compareTo(e2.getFromOrder());
        }
    }
}

