/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.lang;

import java.util.Map;
import org.x4o.xml.element.AbstractElementBindingHandler;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementAttributeHandler;
import org.x4o.xml.element.ElementBindingHandler;
import org.x4o.xml.element.ElementBindingHandlerException;
import org.x4o.xml.element.ElementConfiguratorGlobal;
import org.x4o.xml.element.ElementInterface;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.element.ElementNamespaceInstanceProvider;
import org.x4o.xml.element.ElementNamespaceInstanceProviderException;
import org.x4o.xml.lang.X4OLanguage;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementModuleBindingHandler
extends AbstractElementBindingHandler<X4OLanguageModule> {
    private static final Class<?>[] CLASSES_CHILD = new Class[]{ElementInterface.class, ElementNamespaceContext.class, ElementBindingHandler.class, ElementAttributeHandler.class, ElementConfiguratorGlobal.class};

    @Override
    public Class<?> getBindParentClass() {
        return X4OLanguageModule.class;
    }

    @Override
    public Class<?>[] getBindChildClasses() {
        return CLASSES_CHILD;
    }

    @Override
    public void bindChild(Element childElement, X4OLanguageModule languageModule, Object childObject) throws ElementBindingHandlerException {
        Map m = (Map)childElement.getLanguageContext().getLanguageProperty(X4OLanguageProperty.EL_BEAN_INSTANCE_MAP);
        if (m == null) {
            return;
        }
        X4OLanguage x4oParsingContext = (X4OLanguage)m.get("parentLanguage");
        if (x4oParsingContext == null) {
            return;
        }
        if (languageModule == null) {
            return;
        }
        if (childObject instanceof ElementInterface) {
            ElementInterface elementInterface = (ElementInterface)childObject;
            languageModule.addElementInterface(elementInterface);
            return;
        }
        if (childObject instanceof ElementNamespaceContext) {
            ElementNamespaceContext elementNamespaceContext = (ElementNamespaceContext)childObject;
            if (elementNamespaceContext.getId() == null) {
                throw new NullPointerException("Can add ElementNamespaceContext without id.");
            }
            if (elementNamespaceContext.getId() != null) {
                StringBuffer buf = new StringBuffer(30);
                for (char c : elementNamespaceContext.getId().toLowerCase().toCharArray()) {
                    if (Character.isLetter(c)) {
                        buf.append(c);
                    }
                    if (Character.isDigit(c)) {
                        buf.append(c);
                    }
                    if ('-' != c) continue;
                    buf.append(c);
                }
                String id = buf.toString();
                elementNamespaceContext.setId(id);
            }
            if (elementNamespaceContext.getUri() == null) {
                elementNamespaceContext.setUri("http://" + languageModule.getProviderHost() + "/xml/ns/" + x4oParsingContext.getLanguageName() + "-" + elementNamespaceContext.getId());
            }
            if (elementNamespaceContext.getSchemaUri() == null) {
                elementNamespaceContext.setSchemaUri("http://" + languageModule.getProviderHost() + "/xml/ns/" + x4oParsingContext.getLanguageName() + "-" + elementNamespaceContext.getId() + "-" + x4oParsingContext.getLanguageVersion() + ".xsd");
            }
            if (elementNamespaceContext.getSchemaResource() == null) {
                elementNamespaceContext.setSchemaResource(x4oParsingContext.getLanguageName() + "-" + elementNamespaceContext.getId() + "-" + x4oParsingContext.getLanguageVersion() + ".xsd");
            }
            if (elementNamespaceContext.getSchemaPrefix() == null) {
                elementNamespaceContext.setSchemaPrefix(elementNamespaceContext.getId());
            }
            try {
                elementNamespaceContext.setElementNamespaceInstanceProvider((ElementNamespaceInstanceProvider)X4OLanguageClassLoader.newInstance(childElement.getLanguageContext().getLanguage().getLanguageConfiguration().getDefaultElementNamespaceInstanceProvider()));
            }
            catch (Exception e) {
                throw new ElementBindingHandlerException("Error loading: " + e.getMessage(), e);
            }
            try {
                elementNamespaceContext.getElementNamespaceInstanceProvider().start(x4oParsingContext, elementNamespaceContext);
            }
            catch (ElementNamespaceInstanceProviderException e) {
                throw new ElementBindingHandlerException("Error starting: " + e.getMessage(), e);
            }
            languageModule.addElementNamespaceContext(elementNamespaceContext);
            return;
        }
        if (childObject instanceof ElementBindingHandler) {
            ElementBindingHandler elementBindingHandler = (ElementBindingHandler)childObject;
            languageModule.addElementBindingHandler(elementBindingHandler);
            return;
        }
        if (childObject instanceof ElementAttributeHandler) {
            ElementAttributeHandler elementAttributeHandler = (ElementAttributeHandler)childObject;
            languageModule.addElementAttributeHandler(elementAttributeHandler);
            return;
        }
        if (childObject instanceof ElementConfiguratorGlobal) {
            ElementConfiguratorGlobal elementConfigurator = (ElementConfiguratorGlobal)childObject;
            languageModule.addElementConfiguratorGlobal(elementConfigurator);
            return;
        }
    }

    @Override
    public void createChilderen(Element parentElement, X4OLanguageModule parent) throws ElementBindingHandlerException {
        for (ElementInterface elementInterface : parent.getElementInterfaces()) {
            this.createChild(parentElement, elementInterface);
        }
        for (ElementNamespaceContext elementNamespaceContext : parent.getElementNamespaceContexts()) {
            this.createChild(parentElement, elementNamespaceContext);
        }
        for (ElementBindingHandler elementBindingHandler : parent.getElementBindingHandlers()) {
            this.createChild(parentElement, elementBindingHandler);
        }
        for (ElementAttributeHandler elementAttributeHandler : parent.getElementAttributeHandlers()) {
            this.createChild(parentElement, elementAttributeHandler);
        }
        for (ElementConfiguratorGlobal elementConfiguratorGlobal : parent.getElementConfiguratorGlobals()) {
            this.createChild(parentElement, elementConfiguratorGlobal);
        }
    }
}

