/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.x4o.xml.io.AbstractX4OConnection;
import org.x4o.xml.io.X4OConnectionException;
import org.x4o.xml.io.X4OWriterContext;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractX4OWriterContext<T>
extends AbstractX4OConnection
implements X4OWriterContext<T> {
    public AbstractX4OWriterContext(X4OLanguageContext elementLanguage) {
        super(elementLanguage);
    }

    @Override
    public void writeFileContext(X4OLanguageContext context, String fileName) throws X4OConnectionException, SAXException, IOException {
        if (fileName == null) {
            throw new NullPointerException("Can't convert null fileName to file object.");
        }
        this.writeFileContext(context, new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFileContext(X4OLanguageContext context, File file) throws X4OConnectionException, SAXException, IOException {
        if (file == null) {
            throw new NullPointerException("Can't read null file.");
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            this.writeContext(context, outputStream);
        }
        finally {
            ((OutputStream)outputStream).close();
        }
    }

    @Override
    public String writeStringContext(X4OLanguageContext context) throws X4OConnectionException, SAXException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        this.writeContext(context, out);
        String encoding = context.getLanguagePropertyString(X4OLanguageProperty.WRITER_OUTPUT_ENCODING);
        return out.toString(encoding);
    }
}

