/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax.ext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeMap<K, V>
implements Map<K, V> {
    private Attributes attributes = null;
    private String uri = null;

    public AttributeMap(Attributes attributes) {
        this.setAttributes(attributes);
    }

    public AttributeMap(Attributes attributes, String uri) {
        this.setAttributes(attributes);
        this.setNameSpace(uri);
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setNameSpace(String uri) {
        this.uri = uri;
    }

    public String getNameSpace() {
        return this.uri;
    }

    private String getName(int index) {
        if (this.uri == null) {
            return this.attributes.getLocalName(index);
        }
        return this.attributes.getQName(index);
    }

    private String getValue(String name) {
        if (name == null) {
            return null;
        }
        if (this.uri != null) {
            return this.attributes.getValue(this.uri, name);
        }
        return this.attributes.getValue(name);
    }

    private String getValue(Object key) {
        if (key == null) {
            return null;
        }
        return this.getValue(key.toString());
    }

    @Override
    public int size() {
        return this.attributes.getLength();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getValue(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.attributes.getValue(i).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return (V)this.getValue(key);
    }

    @Override
    public V put(K key, V value) {
        return null;
    }

    @Override
    public V remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map t) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<K> keySet() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.getName(i));
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.attributes.getValue(i));
        }
        return result;
    }

    @Override
    public Set entrySet() {
        HashSet<AttributeMapEntry> result = new HashSet<AttributeMapEntry>();
        for (int i = 0; i < this.size(); ++i) {
            AttributeMapEntry mapEntry = new AttributeMapEntry(this.getName(i));
            mapEntry.setValue(this.attributes.getValue(i));
            result.add(mapEntry);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return this.attributes.equals(o);
    }

    @Override
    public int hashCode() {
        return this.attributes.hashCode();
    }

    class AttributeMapEntry
    implements Map.Entry {
        private Object key = null;
        private Object value = null;

        protected AttributeMapEntry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object value) {
            Object result = this.value;
            this.value = value;
            return result;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            Map.Entry mapEntry;
            return o instanceof Map.Entry && (mapEntry = (Map.Entry)o).getKey().equals(this.key) & mapEntry.getValue().equals(this.value);
        }
    }
}

