/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang.phase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.x4o.xml.element.Element;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageContextLocal;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.x4o.xml.lang.phase.X4OPhase;
import org.x4o.xml.lang.phase.X4OPhaseException;
import org.x4o.xml.lang.phase.X4OPhaseListener;
import org.x4o.xml.lang.phase.X4OPhaseManager;
import org.x4o.xml.lang.phase.X4OPhaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultX4OPhaseManager
implements X4OPhaseManager {
    private List<X4OPhase> x4oPhases = new ArrayList<X4OPhase>(25);

    @Override
    public X4OPhase getPhase(String phaseName) {
        for (X4OPhase phase : this.x4oPhases) {
            if (!phase.getId().equals(phaseName)) continue;
            return phase;
        }
        return null;
    }

    public void addX4OPhase(X4OPhase phase) {
        if (phase == null) {
            throw new NullPointerException("Can't add null phase handler.");
        }
        this.x4oPhases.add(phase);
    }

    public List<X4OPhase> getAllPhases() {
        return new ArrayList<X4OPhase>(this.x4oPhases);
    }

    @Override
    public List<X4OPhase> getOrderedPhases(X4OPhaseType type) {
        ArrayList<X4OPhase> result = new ArrayList<X4OPhase>(this.x4oPhases.size());
        for (X4OPhase p : this.x4oPhases) {
            if (p.getType().equals((Object)type)) {
                result.add(p);
            }
            if (X4OPhaseType.XML_READ.equals((Object)type) && X4OPhaseType.XML_RW.equals((Object)p.getType())) {
                result.add(p);
            }
            if (!X4OPhaseType.XML_WRITE.equals((Object)type) || !X4OPhaseType.XML_RW.equals((Object)p.getType())) continue;
            result.add(p);
        }
        Collections.sort(result, new X4OPhaseComparator());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runPhases(X4OLanguageContext languageContext, X4OPhaseType type) throws X4OPhaseException {
        List<X4OPhase> x4oPhasesOrder = this.getOrderedPhases(type);
        if (languageContext.getX4ODebugWriter() != null) {
            languageContext.getX4ODebugWriter().debugPhaseOrder(this.x4oPhases);
        }
        boolean skipReleasePhase = languageContext.getLanguagePropertyBoolean(X4OLanguageProperty.PHASE_SKIP_RELEASE);
        boolean skipRunPhase = languageContext.getLanguagePropertyBoolean(X4OLanguageProperty.PHASE_SKIP_RUN);
        String stopPhase = languageContext.getLanguagePropertyString(X4OLanguageProperty.PHASE_STOP_AFTER);
        for (X4OPhase phase : x4oPhasesOrder) {
            if (skipReleasePhase && phase.getId().equals("X4O_RELEASE") || skipRunPhase && phase.getId().equals("READ_RUN")) continue;
            ((X4OLanguageContextLocal)languageContext).setCurrentPhase(phase);
            for (X4OPhaseListener l : phase.getPhaseListeners()) {
                l.preRunPhase(phase, languageContext);
            }
            try {
                phase.runPhase(languageContext);
                this.executePhaseRoot(languageContext, phase);
            }
            finally {
                for (X4OPhaseListener l : phase.getPhaseListeners()) {
                    l.endRunPhase(phase, languageContext);
                }
            }
            if (stopPhase == null || !stopPhase.equals(phase.getId())) continue;
            return;
        }
    }

    @Override
    public void runPhasesForElement(Element e, X4OPhaseType type, X4OPhase p) throws X4OPhaseException {
        X4OLanguageContext languageContext = e.getLanguageContext();
        boolean skipRunPhase = languageContext.getLanguagePropertyBoolean(X4OLanguageProperty.PHASE_SKIP_RUN);
        String stopPhase = languageContext.getLanguagePropertyString(X4OLanguageProperty.PHASE_STOP_AFTER);
        List<X4OPhase> x4oPhasesOrder = this.getOrderedPhases(type);
        for (X4OPhase phase : x4oPhasesOrder) {
            if (!phase.getId().equals(p.getId()) || phase.getId().equals("RELEASE") || skipRunPhase && phase.getId().equals("READ_RUN")) continue;
            ((X4OLanguageContextLocal)languageContext).setCurrentPhase(phase);
            phase.runPhase(languageContext);
            this.executePhaseRoot(languageContext, phase);
            if (stopPhase == null || !stopPhase.equals(phase.getId())) continue;
            return;
        }
    }

    @Override
    public void doReleasePhaseManual(X4OLanguageContext languageContext) throws X4OPhaseException {
        boolean skipReleasePhase = languageContext.getLanguagePropertyBoolean(X4OLanguageProperty.PHASE_SKIP_RELEASE);
        if (!skipReleasePhase) {
            throw new IllegalStateException("No manual release requested.");
        }
        if (languageContext.getRootElement() == null) {
            return;
        }
        if (languageContext.getRootElement().getElementClass() == null) {
            throw new IllegalStateException("Release phase has already been runned.");
        }
        X4OPhase h = null;
        for (X4OPhase phase : this.x4oPhases) {
            if (!phase.getId().equals("X4O_RELEASE")) continue;
            h = phase;
            break;
        }
        if (h == null) {
            throw new IllegalStateException("No release phase found in manager to run.");
        }
        ((X4OLanguageContextLocal)languageContext).setCurrentPhase(h);
        h.runPhase(languageContext);
        this.executePhaseRoot(languageContext, h);
    }

    private void executePhaseRoot(X4OLanguageContext elementLanguage, X4OPhase phase) throws X4OPhaseException {
        if (elementLanguage.getRootElement() == null) {
            return;
        }
        this.executePhaseTree(elementLanguage.getRootElement(), phase);
    }

    private void executePhaseTree(Element element, X4OPhase phase) throws X4OPhaseException {
        if (element.getElementClass() != null && !element.getElementClass().getSkipPhases().contains(phase.getId())) {
            phase.runElementPhase(element);
        }
        for (Element e : element.getChilderen()) {
            this.executePhaseTree(e, phase);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class X4OPhaseComparator
    implements Comparator<X4OPhase> {
        X4OPhaseComparator() {
        }

        @Override
        public int compare(X4OPhase e1, X4OPhase e2) {
            String pid = e1.getId();
            String[] dpids = e2.getPhaseDependencies();
            for (int i = 0; i < dpids.length; ++i) {
                String dpid = dpids[i];
                if (!pid.equals(dpid)) continue;
                return -1;
            }
            return 0;
        }
    }
}

