/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang.phase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import org.x4o.xml.conv.ObjectConverterException;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementAttributeHandler;
import org.x4o.xml.element.ElementAttributeValueParser;
import org.x4o.xml.element.ElementBindingHandler;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementClassAttribute;
import org.x4o.xml.element.ElementConfigurator;
import org.x4o.xml.element.ElementConfiguratorGlobal;
import org.x4o.xml.element.ElementException;
import org.x4o.xml.element.ElementInterface;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.io.sax.X4OContentParser;
import org.x4o.xml.io.sax.ext.ContentWriter;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.x4o.xml.lang.phase.AbstractX4OPhase;
import org.x4o.xml.lang.phase.DefaultX4OPhaseManager;
import org.x4o.xml.lang.phase.X4OPhase;
import org.x4o.xml.lang.phase.X4OPhaseException;
import org.x4o.xml.lang.phase.X4OPhaseListener;
import org.x4o.xml.lang.phase.X4OPhaseManager;
import org.x4o.xml.lang.phase.X4OPhaseType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class X4OPhaseLanguageRead {
    private Logger logger = Logger.getLogger(X4OPhaseLanguageRead.class.getName());

    public void createPhases(DefaultX4OPhaseManager manager) {
        manager.addX4OPhase(new X4OPhaseReadStart());
        manager.addX4OPhase(new X4OPhaseReadXml());
        manager.addX4OPhase(new X4OPhaseReadConfigELBeans());
        X4OPhaseReadRunConfigurator runConf = new X4OPhaseReadRunConfigurator();
        manager.addX4OPhase(new X4OPhaseReadConfigElement(runConf));
        manager.addX4OPhase(new X4OPhaseReadConfigElementInterface(runConf));
        manager.addX4OPhase(new X4OPhaseReadConfigGlobalElement(runConf));
        manager.addX4OPhase(new X4OPhaseReadConfigGlobalAttribute(runConf));
        manager.addX4OPhase(new X4OPhaseReadRunAttribute());
        manager.addX4OPhase(new X4OPhaseReadFillTemplate());
        manager.addX4OPhase(new X4OPhaseReadTransform());
        manager.addX4OPhase(new X4OPhaseReadRunDirty(manager));
        manager.addX4OPhase(new X4OPhaseReadBindElement());
        manager.addX4OPhase(new X4OPhaseReadRun());
        manager.addX4OPhase(runConf);
        manager.addX4OPhase(new X4OPhaseReadRunDirtyLast(manager));
        manager.addX4OPhase(new X4OPhaseReadEnd());
        manager.addX4OPhase(this.releasePhase());
    }

    private void debugPhaseMessage(String message, X4OPhase phaseHandler, X4OLanguageContext languageContext) throws X4OPhaseException {
        if (languageContext.hasX4ODebugWriter()) {
            try {
                languageContext.getX4ODebugWriter().debugPhaseMessage(message, phaseHandler.getClass());
            }
            catch (ElementException ee) {
                throw new X4OPhaseException(phaseHandler, ee);
            }
        }
    }

    public X4OPhase releasePhase() {
        class ReleasePhaseListener
        implements X4OPhaseListener {
            private int elementsReleased = 0;

            ReleasePhaseListener() {
            }

            public void preRunPhase(X4OPhase phase, X4OLanguageContext languageContext) throws X4OPhaseException {
                this.elementsReleased = 0;
            }

            public void endRunPhase(X4OPhase phase, X4OLanguageContext languageContext) throws X4OPhaseException {
                if (!languageContext.hasX4ODebugWriter()) {
                    return;
                }
                try {
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "elements", "", "", this.elementsReleased + "");
                    languageContext.getX4ODebugWriter().getContentWriter().startElement("http://language.x4o.org/xml/ns/debug-output", "executeReleases", "", atts);
                    languageContext.getX4ODebugWriter().getContentWriter().endElement("http://language.x4o.org/xml/ns/debug-output", "executeReleases", "");
                }
                catch (SAXException e) {
                    throw new X4OPhaseException(phase, e);
                }
            }

            public void addReleasedElement() {
                ++this.elementsReleased;
            }
        }
        final ReleasePhaseListener releaseCounter = new ReleasePhaseListener();
        AbstractX4OPhase result = new AbstractX4OPhase(){
            {
            }

            public X4OPhaseType getType() {
                return X4OPhaseType.XML_RW;
            }

            public String getId() {
                return "X4O_RELEASE";
            }

            public String[] getPhaseDependencies() {
                return new String[]{"READ_END"};
            }

            public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            }

            public void runElementPhase(Element element) throws X4OPhaseException {
                try {
                    element.release();
                }
                catch (ElementException e) {
                    throw new X4OPhaseException((X4OPhase)this, e);
                }
                finally {
                    releaseCounter.addReleasedElement();
                }
            }
        };
        result.addPhaseListener(releaseCounter);
        return result;
    }

    public X4OPhase debugPhase(final X4OPhase afterPhase) {
        AbstractX4OPhase result = new AbstractX4OPhase(){
            List<String> startedPrefix = new ArrayList<String>(10);

            public X4OPhaseType getType() {
                return X4OPhaseType.XML_RW;
            }

            public String getId() {
                return "X4O_DEBUG_" + afterPhase.getId();
            }

            public String[] getPhaseDependencies() {
                return new String[]{afterPhase.getId()};
            }

            public boolean isElementPhase() {
                return false;
            }

            public void runElementPhase(Element element) throws X4OPhaseException {
            }

            public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
                if (!languageContext.hasX4ODebugWriter()) {
                    throw new X4OPhaseException((X4OPhase)this, "Use debugPhase only when X4OParser.debugWriter is filled.");
                }
                try {
                    AttributesImpl atts = new AttributesImpl();
                    languageContext.getX4ODebugWriter().getContentWriter().startElement("http://language.x4o.org/xml/ns/debug-output", "printElementTree", "", atts);
                    this.startedPrefix.clear();
                    this.printXML(languageContext.getRootElement());
                    for (String prefix : this.startedPrefix) {
                        languageContext.getX4ODebugWriter().getContentWriter().endPrefixMapping(prefix);
                    }
                    languageContext.getX4ODebugWriter().getContentWriter().endElement("http://language.x4o.org/xml/ns/debug-output", "printElementTree", "");
                    languageContext.getX4ODebugWriter().debugLanguageContext(languageContext);
                }
                catch (SAXException e) {
                    throw new X4OPhaseException((X4OPhase)this, e);
                }
            }

            private String getNamespaceForElement(Element e) {
                for (X4OLanguageModule mod : e.getLanguageContext().getLanguage().getLanguageModules()) {
                    for (ElementNamespaceContext enc : mod.getElementNamespaceContexts()) {
                        List<ElementClass> l = enc.getElementClasses();
                        if (!l.contains(e.getElementClass())) continue;
                        return enc.getUri();
                    }
                }
                return null;
            }

            private void printXML(Element element) throws SAXException {
                if (element == null) {
                    throw new SAXException("Can't print debug xml of null element.");
                }
                ContentWriter handler = element.getLanguageContext().getX4ODebugWriter().getContentWriter();
                if (element.getElementType().equals((Object)Element.ElementType.comment)) {
                    handler.comment((String)element.getElementObject());
                    return;
                }
                if (element.getElementType().equals((Object)Element.ElementType.characters)) {
                    handler.characters((String)element.getElementObject());
                    return;
                }
                if (element.getElementClass() == null) {
                    throw new SAXException("Element without ElementClass is not valid: " + element + " obj: " + element.getElementObject());
                }
                AttributesImpl atts = new AttributesImpl();
                for (String key : element.getAttributes().keySet()) {
                    String value = element.getAttributes().get(key);
                    atts.addAttribute("", key, "", "", value);
                }
                String nameSpace = this.getNamespaceForElement(element);
                String prefix = element.getLanguageContext().getLanguage().findElementNamespaceContext(nameSpace).getPrefixMapping();
                if (!this.startedPrefix.contains(prefix)) {
                    handler.startPrefixMapping(prefix, nameSpace);
                    this.startedPrefix.add(prefix);
                }
                handler.startElement(nameSpace, element.getElementClass().getId(), "", atts);
                for (Element e : element.getAllChilderen()) {
                    this.printXML(e);
                }
                handler.endElement(nameSpace, element.getElementClass().getId(), "");
            }
        };
        return result;
    }

    class X4OPhaseReadEnd
    extends AbstractX4OPhase {
        X4OPhaseReadEnd() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_END";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_RUN_CONFIGURATOR"};
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            if (languageContext.hasX4ODebugWriter()) {
                try {
                    languageContext.getX4ODebugWriter().debugLanguageProperties(languageContext);
                    languageContext.getX4ODebugWriter().debugLanguageDefaultClasses(languageContext);
                }
                catch (ElementException e) {
                    throw new X4OPhaseException((X4OPhase)this, e);
                }
            }
        }
    }

    class X4OPhaseReadRunConfigurator
    extends AbstractX4OPhase {
        private List<RunConfigurator> runConf = new ArrayList<RunConfigurator>(10);

        protected X4OPhaseReadRunConfigurator() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_RUN_CONFIGURATOR";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_RUN"};
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            for (RunConfigurator conf : this.runConf) {
                try {
                    if (languageContext.hasX4ODebugWriter()) {
                        languageContext.getX4ODebugWriter().debugElementConfigurator(conf.elementConfigurator, conf.element);
                    }
                    conf.elementConfigurator.doConfigElement(conf.element);
                }
                catch (ElementException e) {
                    throw new X4OPhaseException((X4OPhase)this, e);
                }
            }
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runElementConfigurator(ElementConfigurator ec, Element e, X4OPhase phase) throws X4OPhaseException {
            if (ec.isConfigAction()) {
                this.runConf.add(new RunConfigurator(e, ec));
                return;
            }
            try {
                if (e.getLanguageContext().hasX4ODebugWriter()) {
                    e.getLanguageContext().getX4ODebugWriter().debugElementConfigurator(ec, e);
                }
                ec.doConfigElement(e);
                if (ec.isConfigAction()) {
                    this.runConf.add(new RunConfigurator(e, ec));
                }
            }
            catch (ElementException ee) {
                throw new X4OPhaseException(phase, ee);
            }
        }

        class RunConfigurator {
            Element element;
            ElementConfigurator elementConfigurator;

            RunConfigurator(Element element, ElementConfigurator elementConfigurator) {
                this.element = element;
                this.elementConfigurator = elementConfigurator;
            }
        }
    }

    class X4OPhaseReadRun
    extends AbstractX4OPhase {
        X4OPhaseReadRun() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_RUN";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_BIND_ELEMENT"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            if (element.isTransformingTree()) {
                return;
            }
            try {
                element.doElementRun();
            }
            catch (ElementException e) {
                throw new X4OPhaseException((X4OPhase)this, e);
            }
        }
    }

    class X4OPhaseReadBindElement
    extends AbstractX4OPhase {
        X4OPhaseReadBindElement() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_BIND_ELEMENT";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_RUN_DIRTY"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            Element parentElement = element.getParent();
            if (parentElement == null) {
                X4OPhaseLanguageRead.this.logger.finest("No parent element, so no binding needed.");
                return;
            }
            Object parentObject = parentElement.getElementObject();
            if (parentObject == null) {
                X4OPhaseLanguageRead.this.logger.finest("No parent object, so no binding needed.");
                return;
            }
            Object childObject = element.getElementObject();
            if (childObject == null) {
                X4OPhaseLanguageRead.this.logger.finest("No child object, so no binding needed.");
                return;
            }
            List<ElementBindingHandler> binds = element.getLanguageContext().getLanguage().findElementBindingHandlers(parentObject, childObject);
            X4OPhaseLanguageRead.this.logger.finest("Calling bindings handlers; " + binds.size());
            try {
                for (ElementBindingHandler binding : binds) {
                    if (element.getLanguageContext().hasX4ODebugWriter()) {
                        element.getLanguageContext().getX4ODebugWriter().debugElementBindingHandler(binding, element);
                    }
                    binding.bindChild(element);
                }
            }
            catch (ElementException e) {
                throw new X4OPhaseException(this, "Error while binding", e);
            }
        }
    }

    class X4OPhaseReadRunDirtyLast
    extends AbstractX4OPhase {
        private X4OPhaseManager phaseManager = null;

        public X4OPhaseReadRunDirtyLast(X4OPhaseManager phaseManager) {
            this.phaseManager = phaseManager;
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_RUN_DIRTY_LAST";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_RUN"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            Map<Element, X4OPhase> dirtyElements = element.getLanguageContext().getDirtyElements();
            if (dirtyElements.isEmpty()) {
                return;
            }
            X4OPhaseLanguageRead.this.debugPhaseMessage("Dirty elements last: " + dirtyElements.size(), this, element.getLanguageContext());
            for (Element e : dirtyElements.keySet()) {
                X4OPhase p = dirtyElements.get(e);
                this.phaseManager.runPhasesForElement(e, this.getType(), p);
            }
            element.getLanguageContext().getDirtyElements().clear();
        }
    }

    class X4OPhaseReadRunDirty
    extends AbstractX4OPhase {
        private X4OPhaseManager phaseManager = null;

        public X4OPhaseReadRunDirty(X4OPhaseManager phaseManager) {
            this.phaseManager = phaseManager;
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_RUN_DIRTY";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_TRANSFORM"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            Map<Element, X4OPhase> dirtyElements = element.getLanguageContext().getDirtyElements();
            if (dirtyElements.isEmpty()) {
                return;
            }
            X4OPhaseLanguageRead.this.debugPhaseMessage("Dirty elements: " + dirtyElements.size(), this, element.getLanguageContext());
            for (Element e : dirtyElements.keySet()) {
                X4OPhase p = dirtyElements.get(e);
                this.phaseManager.runPhasesForElement(e, this.getType(), p);
            }
            element.getLanguageContext().getDirtyElements().clear();
        }
    }

    class X4OPhaseReadTransform
    extends AbstractX4OPhase {
        X4OPhaseReadTransform() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_TRANSFORM";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_FILL_TEMPLATE"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            if (!element.isTransformingTree()) {
                return;
            }
            try {
                if (element.getLanguageContext().hasX4ODebugWriter()) {
                    element.getLanguageContext().getX4ODebugWriter().debugElement(element);
                }
                element.doElementRun();
            }
            catch (ElementException e) {
                throw new X4OPhaseException((X4OPhase)this, e);
            }
        }
    }

    class X4OPhaseReadFillTemplate
    extends AbstractX4OPhase {
        X4OPhaseReadFillTemplate() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_FILL_TEMPLATE";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_RUN_ATTRIBUTE"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }
    }

    class X4OPhaseReadRunAttribute
    extends AbstractX4OPhase {
        X4OPhaseReadRunAttribute() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_RUN_ATTRIBUTE";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_CONFIG_GLOBAL_ATTRIBUTE"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            if (element.getElementObject() == null) {
                return;
            }
            Map<String, String> attr = element.getAttributes();
            ElementAttributeValueParser attrParser = element.getLanguageContext().getElementAttributeValueParser();
            Boolean autoAttributes = element.getElementClass().getAutoAttributes();
            if (autoAttributes == null) {
                autoAttributes = true;
            }
            try {
                for (String name : attr.keySet()) {
                    String valueString = attr.get(name);
                    if (valueString == null) continue;
                    Object value = valueString;
                    ElementClassAttribute attrClass = element.getElementClass().getElementClassAttributeByName(name);
                    if (attrClass != null) {
                        if (attrClass.getRunResolveEL() == null || attrClass.getRunResolveEL().booleanValue() && attrParser.isELParameter(name, valueString, element)) {
                            value = attrParser.getELParameterValue(valueString, element);
                        }
                        if (attrClass.getRunConverters() == null || attrClass.getRunConverters().booleanValue()) {
                            value = attrParser.getConvertedParameterValue(name, value, element);
                        }
                        if (attrClass.getRunBeanValue() != null && !attrClass.getRunBeanValue().booleanValue()) continue;
                        element.getLanguageContext().getElementObjectPropertyValue().setProperty(element.getElementObject(), name, value);
                        continue;
                    }
                    if (!autoAttributes.booleanValue()) continue;
                    value = attrParser.getParameterValue(name, valueString, element);
                    element.getLanguageContext().getElementObjectPropertyValue().setProperty(element.getElementObject(), name, value);
                }
                for (ElementClassAttribute attrClass : element.getElementClass().getElementClassAttributes()) {
                    if (attrClass.getDefaultValue() == null || attr.containsKey(attrClass.getId())) continue;
                    Object value = null;
                    value = attrClass.getDefaultValue() instanceof String ? attrParser.getParameterValue(attrClass.getId(), (String)attrClass.getDefaultValue(), element) : attrClass.getDefaultValue();
                    if (attrClass.getRunBeanValue() != null && !attrClass.getRunBeanValue().booleanValue()) continue;
                    element.getLanguageContext().getElementObjectPropertyValue().setProperty(element.getElementObject(), attrClass.getId(), value);
                }
            }
            catch (ObjectConverterException oce) {
                throw new X4OPhaseException(this, "Error while converting parameters: " + oce.getMessage(), oce);
            }
            catch (ElementException e) {
                throw new X4OPhaseException(this, "Error while setting parameters: " + e.getMessage(), e);
            }
        }
    }

    class X4OPhaseReadConfigGlobalAttribute
    extends AbstractX4OPhase {
        Comparator<ElementAttributeHandler> elementAttributeHandlerComparator = null;
        private X4OPhaseReadRunConfigurator runConf = null;

        public X4OPhaseReadConfigGlobalAttribute(X4OPhaseReadRunConfigurator runConf) {
            this.runConf = runConf;
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_CONFIG_GLOBAL_ATTRIBUTE";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_CONFIG_GLOBAL_ELEMENT"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            if (this.elementAttributeHandlerComparator == null) {
                try {
                    this.elementAttributeHandlerComparator = (Comparator)X4OLanguageClassLoader.newInstance(element.getLanguageContext().getLanguage().getLanguageConfiguration().getDefaultElementAttributeHandlerComparator());
                }
                catch (Exception e) {
                    throw new X4OPhaseException((X4OPhase)this, e);
                }
            }
            X4OPhaseLanguageRead.this.logger.finest("Do Element Global AttributeHandlers.");
            ArrayList<ElementAttributeHandler> handlers = new ArrayList<ElementAttributeHandler>();
            for (X4OLanguageModule mod : element.getLanguageContext().getLanguage().getLanguageModules()) {
                for (ElementAttributeHandler global : mod.getElementAttributeHandlers()) {
                    String attribute = element.getAttributes().get(global.getAttributeName());
                    if (attribute == null) continue;
                    handlers.add(global);
                }
            }
            Collections.sort(handlers, this.elementAttributeHandlerComparator);
            ArrayList<ElementAttributeHandler> handlers2 = new ArrayList<ElementAttributeHandler>(handlers.size());
            handlers2.addAll(handlers);
            for (ElementConfigurator elementConfigurator : handlers) {
                this.runConf.runElementConfigurator(elementConfigurator, element, this);
            }
        }
    }

    class X4OPhaseReadConfigGlobalElement
    extends AbstractX4OPhase {
        private X4OPhaseReadRunConfigurator runConf = null;

        public X4OPhaseReadConfigGlobalElement(X4OPhaseReadRunConfigurator runConf) {
            this.runConf = runConf;
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_CONFIG_GLOBAL_ELEMENT";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_CONFIG_ELEMENT", "READ_CONFIG_ELEMENT_INTERFACE"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            for (X4OLanguageModule mod : element.getLanguageContext().getLanguage().getLanguageModules()) {
                X4OPhaseLanguageRead.this.logger.finest("Do Element Config Global Configurators: " + mod.getElementConfiguratorGlobals().size());
                for (ElementConfiguratorGlobal ec : mod.getElementConfiguratorGlobals()) {
                    this.runConf.runElementConfigurator(ec, element, this);
                }
            }
        }
    }

    class X4OPhaseReadConfigElementInterface
    extends AbstractX4OPhase {
        private X4OPhaseReadRunConfigurator runConf = null;

        public X4OPhaseReadConfigElementInterface(X4OPhaseReadRunConfigurator runConf) {
            this.runConf = runConf;
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_CONFIG_ELEMENT_INTERFACE";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_CONFIG_EL_BEANS"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            if (element.getElementObject() == null) {
                X4OPhaseLanguageRead.this.logger.finest("Null elementObject skipping, interfaces");
                return;
            }
            for (ElementInterface ei : element.getLanguageContext().getLanguage().findElementInterfaces(element.getElementObject())) {
                X4OPhaseLanguageRead.this.logger.finest("Do ElementInterface Config Configurators: " + ei.getElementConfigurators().size());
                for (ElementConfigurator ec : ei.getElementConfigurators()) {
                    this.runConf.runElementConfigurator(ec, element, this);
                }
            }
        }
    }

    class X4OPhaseReadConfigElement
    extends AbstractX4OPhase {
        private X4OPhaseReadRunConfigurator runConf = null;

        public X4OPhaseReadConfigElement(X4OPhaseReadRunConfigurator runConf) {
            this.runConf = runConf;
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_CONFIG_ELEMENT";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_CONFIG_EL_BEANS"};
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
            for (ElementClassAttribute eca : element.getElementClass().getElementClassAttributes()) {
                List<String> aliases = eca.getAttributeAliases();
                if (aliases.isEmpty()) continue;
                for (String alias : aliases) {
                    if (!element.getAttributes().containsKey(alias)) continue;
                    String attributeValue = element.getAttributes().get(alias);
                    element.getAttributes().put(eca.getId(), attributeValue);
                    element.getAttributes().remove(alias);
                }
            }
            X4OPhaseLanguageRead.this.logger.finest("Do ElementClass Config Configurators: " + element.getElementClass().getElementConfigurators().size());
            for (ElementConfigurator ec : element.getElementClass().getElementConfigurators()) {
                this.runConf.runElementConfigurator(ec, element, this);
            }
        }
    }

    class X4OPhaseReadConfigELBeans
    extends AbstractX4OPhase {
        X4OPhaseReadConfigELBeans() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_RW;
        }

        public String getId() {
            return "READ_CONFIG_EL_BEANS";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_XML"};
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            try {
                Map beanMap = (Map)languageContext.getLanguageProperty(X4OLanguageProperty.EL_BEAN_INSTANCE_MAP);
                if (beanMap == null) {
                    return;
                }
                for (Object elName : beanMap.keySet()) {
                    Object o = beanMap.get(elName);
                    ValueExpression ve = languageContext.getExpressionLanguageFactory().createValueExpression(languageContext.getExpressionLanguageContext(), "${" + elName + "}", o.getClass());
                    ve.setValue(languageContext.getExpressionLanguageContext(), o);
                    X4OPhaseLanguageRead.this.debugPhaseMessage("Setting el bean: ${" + elName + "} to: " + o.getClass().getName(), this, languageContext);
                }
            }
            catch (Exception e) {
                throw new X4OPhaseException((X4OPhase)this, e);
            }
        }
    }

    class X4OPhaseReadXml
    extends AbstractX4OPhase {
        X4OPhaseReadXml() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_XML";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"READ_START"};
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            try {
                X4OContentParser parser = new X4OContentParser();
                parser.parse(languageContext);
            }
            catch (Exception e) {
                throw new X4OPhaseException((X4OPhase)this, e);
            }
        }
    }

    class X4OPhaseReadStart
    extends AbstractX4OPhase {
        X4OPhaseReadStart() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_READ;
        }

        public String getId() {
            return "READ_START";
        }

        public String[] getPhaseDependencies() {
            return new String[0];
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            if (languageContext.hasX4ODebugWriter()) {
                try {
                    languageContext.getX4ODebugWriter().debugLanguageProperties(languageContext);
                    languageContext.getX4ODebugWriter().debugLanguageDefaultClasses(languageContext);
                }
                catch (ElementException e) {
                    throw new X4OPhaseException((X4OPhase)this, e);
                }
            }
        }
    }
}

