/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/*  This program will report CICS status to Xymon.
    It collects data retrieved from CICS. The current task number,
    previous cycles task number, and the DSA storage info are kept in
    a VSAM file that is read by this program and put in the client
    data stream.
 
    Rich Smrcina: Original V1.2 release 09/21/2007
    Rich Smrcina: Changed project name to Xymon 02/10/2009
                                                                      */
parse arg lib cfgmode .
if cfgmode='CLIENT' then
  call init_local_vars
call do_read_in_file
if cfgmode='SERVER' then
  call write_client_data
else
  call send_client_data
return
 
do_read_in_file:
'vsamio read filename hobbit records * close stem hobvsam.'
j=0
basetime=time('M')
do i=1 to hobvsam.0      /* Loop through CICS data       */
  j=j+1
  parse var hobvsam.i appid.j date.j time.j otaskn.j ntaskn.j ,
                      dsalim.j edsalim.j cdsa.j rdsa.j sdsa.j udsa.j ,
                      ecdsa.j erdsa.j esdsa.j eudsa.j .
  parse var time.j hh ':' mm ':' ss
  nm=(60 * hh) + mm
  dm=basetime-nm
  if dm>5  then do
    ntaskn.j=-1
    'vsamio delete filename hobbit startkey' appid.j 'close'
    if rc<>0 then
      say 'RC=0 deleting 'appid.j' from Hobbit'.
    end
  end
appid.0=j
return
 
write_client_data:
queue '[cics]'
do j=1 to appid.0
  if ntaskn.j=-1 then
    count=ntaskn.j
  else
    count=ntaskn.j-otaskn.j
  totuseddsa=cdsa.j+rdsa.j+sdsa.j+udsa.j
  totusededsa=ecdsa.j+erdsa.j+esdsa.j+eudsa.j
  if totuseddsa=0 then
    pctuseddsa=0.0
  else
    pctuseddsa=format((totuseddsa/dsalim.j)*100,3,1)
  if totusededsa=0 then
    pctusededsa=0.0
  else
    pctusededsa=format((totusededsa/edsalim.j)*100,3,1)
  queue left(appid.j,8) date.j time.j count pctuseddsa pctusededsa
  end
queue ''
'execio * diskw' lib'.hobvseci.data (finis'
return
 
send_client_data:
call init_open_socket         /* Initialize and open the socket  */
ciout=''
call send_to_bb
call close_term_socket
return
 
send_to_bb:
status='status' fqdn'.cics' color date() time() cr||ciout
status=toascii(status)
ret=Socket('Send',sid,status)
parse var ret rc .
if rc<>0 then
  say 'Send:' ret
return
 
toascii:
parse arg buffer
buffer=translate(buffer,asc,ebc)
return buffer
 
init_open_socket:
ret=socket('Initialize','hobvse')
parse var ret rc .
if rc<>0 then
  say 'Initialize:' ret
ret=socket('Socket','AF_INET','Sock_Stream',0)
parse var ret rc .
if rc<>0 then
  say 'Socket:' ret
parse var ret rc sid .
if init='0' then do
  init='1'
  call init_values
  end
name='AF_INET' bbport bbdisplay
ret=socket('Connect',sid,name)
parse var ret rc .
if rc<>0 then
  say 'Connect:' ret
return
 
close_term_socket:
ret=Socket('Close',sid)
parse var ret rc .
if rc<>0 then
  say 'Close:' ret
ret=Socket('Terminate')
parse var ret rc .
if rc<>0 then
  say 'Terminate:' ret
return
 
init_values:
ebc=' !"#$%&'||'7D'X||'()*+,-./012' ,
    '3456789:;<=>?@ABCDE' ,
    'FGHIJKLMNOPQRSTUVWX' ,
    'YZ
\Y_`abcdefghijk' ,
    'lmnopqrstuvwxyz{|}~'
asc='202122232425262728292A2B2C2D2E2F303132'x ,
    '333435363738393A3B3C3D3E3F404142434445'x ,
    '464748494A4B4C4D4E4F505152535455565758'x ,
    '595A5B5C5D5E5F606162636465666768696A6B'x ,
    '6C6D6E6F707172737475767778797A7B7C7D7E'x
if hostname='' then do
  ret=socket('Gethostname')
  parse var ret rc hostname .
  if rc<>0 then
    say 'Gethostname:' ret
  hostname=lower(hostname)
  end
if domainname='' then
  fqdn=hostname
else
  fqdn=hostname||'.'||domainname
/*  Change periods to commas  */
fqdn=translate(fqdn,',','.')
return
 
init_local_vars:
init='0'             /*  Init flag  */
cr='0a'x             /*  Carriage return   */
/*  Retrieve options member from library                         */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
/*  Init local variables first  */
bbdisplay=''
bbport=''
domainname=''
hostname=''
/*  Go through options table to fill values to run the client    */
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw value
  value=strip(value,'B')
  select
    when kw='bbdisplay' then
      bbdisplay=value
    when kw='bbport' then
      bbport=value
    when kw='domainname' then
      domainname=value
    when kw='hostname' then
      hostname=value
    when kw='CICS' then
      cicsapps=value
    otherwise
      nop
    end
  end
return
 
/*  Convert parameter to lower case.  */
lower:
arg string
lc_chars='abcdefghijklmnopqrstuvwxyz'
uc_chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
string=translate(string,lc_chars,uc_chars)
return string
